package com.ustadmobile.core.db.dao

import com.google.gson.Gson
import com.ustadmobile.door.DoorDatabase
import com.ustadmobile.door.ext.unwrappedDbOnCall
import io.ktor.application.call
import io.ktor.http.HttpStatusCode
import io.ktor.response.respond
import io.ktor.routing.Route
import io.ktor.routing.`get`
import io.ktor.routing.route
import kotlin.String
import kotlin.Unit
import org.kodein.di.instance
import org.kodein.di.ktor.closestDI
import org.kodein.type.TypeToken

public fun <T : DoorDatabase> Route.ClazzDao_KtorRoute(_typeToken: TypeToken<T>, _daoFn: (T) ->
    ClazzDao): Unit {
  route("ClazzDao") {
    `get`("findByClazzCodeFromWeb") {
      val _di = closestDI()
      val _db : T = unwrappedDbOnCall(_typeToken)
      val _dao = _daoFn(_db)
      val _gson: Gson by _di.instance()
      val __code : String = call.request.queryParameters["code"] ?: ""
      val _result = _dao.findByClazzCodeFromWeb(__code)
      if(_result != null) {
        call.respond(_result)
      } else {
        call.respond(HttpStatusCode.NoContent, "")
      }
    }
  }
}
