/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.africanbooks;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.util.UMFileUtil;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.ShrinkerUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.africanbooks.AfricanBooksResponse;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.lang3.StringEscapeUtils;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.DataNode;
import org.jsoup.nodes.Element;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001f2\u00020\u0001:\u0001\u001fB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u0016\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004J\u0016\u0010\u0011\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0004J\u0018\u0010\u0012\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0018\u0010\u0013\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\u000e2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0006\u0010\u0015\u001a\u00020\u000eJ\u0010\u0010\u0016\u001a\u00020\u00042\b\u0010\u0010\u001a\u0004\u0018\u00010\u0004J\u0016\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\u0006\u0010\u001a\u001a\u00020\u001bH\u0004J\u0016\u0010\u001c\u001a\u00020\t2\u0006\u0010\u001d\u001a\u00020\u00192\u0006\u0010\u001e\u001a\u00020\u000bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u00048F\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Lcom/ustadmobile/lib/contentscrapers/africanbooks/AsbScraper;", "", "()V", "COVER_URL", "", "africanStoryBookUrl", "getAfricanStoryBookUrl", "()Ljava/lang/String;", "findContent", "", "destinationDir", "Ljava/io/File;", "containerDir", "generateEPubUrl", "Ljava/net/URL;", "africanBooksUrl", "bookId", "generateMakeUrl", "generatePublishUrl", "generateReaderUrl", "url", "generateURL", "getCoverUrl", "parseBooklist", "", "Lcom/ustadmobile/lib/contentscrapers/africanbooks/AfricanBooksResponse;", "booklistIn", "Ljava/io/InputStream;", "updateAsbEpub", "booklistEntry", "epubFile", "Companion", "lib-content-scrapers"})
public final class AsbScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String COVER_URL;
    @NotNull
    private static final String AFRICAN_STORY_BOOKS = "African Story Books";

    public AsbScraper() {
        this.COVER_URL = "https://www.africanstorybook.org/illustrations/covers/";
    }

    @NotNull
    public final String getAfricanStoryBookUrl() {
        return "https://www.africanstorybook.org/";
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    public final void findContent(@NotNull File destinationDir, @NotNull File containerDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        africanBooksUrl = this.generateURL();
        db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        repository = null;
        contentEntryDao = repository.getContentEntryDao();
        contentParentChildJoinDao = repository.getContentEntryParentChildJoinDao();
        categorySchemeDao = repository.getContentCategorySchemaDao();
        categoryDao = repository.getContentCategoryDao();
        contentCategoryJoinDao = repository.getContentEntryContentCategoryJoinDao();
        languageDao = repository.getLanguageDao();
        variantDao = repository.getLanguageVariantDao();
        relatedEntryJoinDao = repository.getContentEntryRelatedEntryJoinDao();
        containerDao = repository.getContainerDao();
        url = this.getAfricanStoryBookUrl();
        html = Jsoup.connect((String)url).get();
        langMap = new HashMap<K, V>();
        scriptList = html.getElementsByTag("script");
        for (Element script : scriptList) {
            for (DataNode node : script.dataNodes()) {
                var23_23 = node.getWholeData();
                Intrinsics.checkNotNullExpressionValue((Object)var23_23, (String)"node.wholeData");
                if (!StringsKt.contains$default((CharSequence)var23_23, (CharSequence)"<option", (boolean)false, (int)2, null)) continue;
                data = node.getWholeData();
                Intrinsics.checkNotNullExpressionValue((Object)data, (String)"data");
                var28_29 = data.substring(StringsKt.indexOf$default((CharSequence)data, (String)"<option ", (int)0, (boolean)false, (int)6, null), StringsKt.lastIndexOf$default((CharSequence)data, (String)"</option>", (int)0, (boolean)false, (int)6, null) + 8);
                Intrinsics.checkNotNullExpressionValue((Object)var28_29, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                langDoc = Jsoup.parse((String)var28_29);
                langList = langDoc.getElementsByTag("option");
                for (Element lang : langList) {
                    id = lang.attr("value");
                    var30_32 = lang.text();
                    Intrinsics.checkNotNullExpressionValue((Object)var30_32, (String)"lang.text()");
                    var31_33 = var30_32.toLowerCase();
                    Intrinsics.checkNotNullExpressionValue((Object)var31_33, (String)"this as java.lang.String).toLowerCase()");
                    value = StringUtils.capitalize((String)var31_33);
                    variant = "";
                    langValue = value;
                    Intrinsics.checkNotNullExpressionValue((Object)value, (String)"value");
                    if (StringsKt.contains$default((CharSequence)value, (CharSequence)"(", (boolean)false, (int)2, null)) {
                        var36_45 = value.substring(StringsKt.indexOf$default((CharSequence)value, (String)"(", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)value, (String)")", (int)0, (boolean)false, (int)6, null));
                        Intrinsics.checkNotNullExpressionValue((Object)var36_45, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        var32_34 = StringUtils.capitalize((String)var36_45);
                        Intrinsics.checkNotNullExpressionValue((Object)var32_34, (String)"capitalize(value.substri\u2026+ 1, value.indexOf(\")\")))");
                        variant = var32_34;
                        var35_39 = value.substring(0, StringsKt.indexOf$default((CharSequence)value, (String)"(", (int)0, (boolean)false, (int)6, null));
                        Intrinsics.checkNotNullExpressionValue((Object)var35_39, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        var32_34 = var35_39;
                        $i$f$trim = false;
                        $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                        $i$f$trim = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            $i$a$-trim-AsbScraper$findContent$1 = false;
                            v0 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        langValue = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString();
                    }
                    v1 = langMap;
                    Intrinsics.checkNotNullExpressionValue((Object)id, (String)"id");
                    $this$trim$iv$iv = langValue;
                    Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv$iv, (String)"langValue");
                    v1.put(id, $this$trim$iv$iv);
                    $i$f$trim = langValue;
                    Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim, (String)"langValue");
                    langEntity = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, $i$f$trim);
                    if (((CharSequence)variant).length() == 0) continue;
                    ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(variantDao, variant, langEntity);
                }
            }
        }
        v2 = englishLang = languageDao.findByTwoCode("en");
        Intrinsics.checkNotNull((Object)v2);
        masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, v2.getLangUid(), null, "", false, "", "", "", "", 0, contentEntryDao);
        asbParentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://www.africanstorybook.org/", "African Story Books", "https://www.africanstorybook.org/", "African Story Books", 1, englishLang.getLangUid(), null, "Open access to picture storybooks in the languages of Africa. \n For children's literacy, enjoyment and imagination.", false, "", "https://www.africanstorybook.org/img/asb120.png", "", "", 0, contentEntryDao);
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentParentChildJoinDao, masterRootParent, asbParentEntry, 0);
        inputStreamOfBooks = africanBooksUrl.openStream();
        Intrinsics.checkNotNullExpressionValue((Object)inputStreamOfBooks, (String)"inputStreamOfBooks");
        africanBooksList = this.parseBooklist(inputStreamOfBooks);
        bookObj = null;
        ContentScraperUtil.INSTANCE.setChromeDriverLocation();
        driver = ContentScraperUtil.INSTANCE.setupChrome(true);
        waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        retry = 0;
        i = 0;
        while (i < africanBooksList.size()) {
            bookObj = africanBooksList.get(i);
            bookId = bookObj.getId();
            ePubFile = new File(destinationDir, "asb" + bookId + ".epub");
            v3 = bookId;
            Intrinsics.checkNotNull((Object)v3);
            epubUrl = this.generateEPubUrl(africanBooksUrl, v3);
            publishUrl = this.generatePublishUrl(africanBooksUrl, bookId);
            makeUrl = this.generateMakeUrl(africanBooksUrl, bookId);
            modifiedFile = new File(destinationDir, Intrinsics.stringPlus((String)bookId, (Object)"last-modified.txt"));
            UMLogUtil.INSTANCE.logTrace(Intrinsics.stringPlus((String)"Started with book id ", (Object)bookId));
            try {
                driver.get(publishUrl.toString());
                ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
                driver.get(makeUrl.toString());
                ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
                v4 = bookObj.getLang();
                Intrinsics.checkNotNull((Object)v4);
                if (StringsKt.contains$default((CharSequence)v4, (CharSequence)",", (boolean)false, (int)2, null)) {
                    v5 = bookObj.getLang();
                    Intrinsics.checkNotNull((Object)v5);
                    $i$f$trim = v5;
                    startIndex$iv$iv = new Regex(",");
                    endIndex$iv$iv = 0;
                    $i$f$trim = startIndex$iv$iv.split((CharSequence)$i$f$trim, endIndex$iv$iv);
                    var63_114 = bookObj;
                    $i$f$dropLastWhile = false;
                    if (!$this$dropLastWhile$iv.isEmpty()) {
                        iterator$iv = $this$dropLastWhile$iv.listIterator($this$dropLastWhile$iv.size());
                        while (iterator$iv.hasPrevious()) {
                            it = (String)iterator$iv.previous();
                            $i$a$-dropLastWhile-AsbScraper$findContent$2 = false;
                            if (((CharSequence)it).length() == 0) continue;
                            v6 = CollectionsKt.take((Iterable)$this$dropLastWhile$iv, (int)(iterator$iv.nextIndex() + 1));
                            break;
                        }
                    } else {
                        v6 = CollectionsKt.emptyList();
                    }
                    $this$dropLastWhile$iv = v6;
                    $i$f$toTypedArray = false;
                    thisCollection$iv = $this$toTypedArray$iv;
                    v7 = thisCollection$iv.toArray(new String[0]);
                    if (v7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
                    }
                    var63_114.setLang(v7[0]);
                }
                v8 = bookObj.getLang();
                Intrinsics.checkNotNull((Object)v8);
                langName = (String)langMap.get(v8);
                variant = "";
                langValue = langName;
                if (langName != null && StringsKt.contains$default((CharSequence)langName, (CharSequence)"(", (boolean)false, (int)2, null)) {
                    var42_71 = langName.substring(StringsKt.indexOf$default((CharSequence)langName, (String)"(", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)langName, (String)")", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)var42_71, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    it = StringUtils.capitalize((String)var42_71);
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"capitalize(langName!!.su\u2026langName!!.indexOf(\")\")))");
                    variant = it;
                    $i$a$-trim-AsbScraper$findContent$1 = langName.substring(0, StringsKt.indexOf$default((CharSequence)langName, (String)"(", (int)0, (boolean)false, (int)6, null));
                    Intrinsics.checkNotNullExpressionValue((Object)$i$a$-trim-AsbScraper$findContent$1, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                    it = $i$a$-trim-AsbScraper$findContent$1;
                    $i$f$trim = false;
                    $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                    $i$f$trim = false;
                    startIndex$iv$iv = 0;
                    endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                        it = $this$trim$iv$iv.charAt(index$iv$iv);
                        $i$a$-trim-AsbScraper$findContent$3 = false;
                        v9 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    langValue = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString();
                }
                v10 = langValue;
                Intrinsics.checkNotNull((Object)v10);
                language = languageDao.findByName(v10);
                languageVariant = null;
                if (language != null && ((CharSequence)variant).length() > 0) {
                    languageVariant = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(variantDao, variant, language);
                }
                v11 = epubUrl.getPath();
                if (epubUrl.getQuery() == null) ** GOTO lbl-1000
                $i$f$trim = epubUrl.getQuery();
                Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim, (String)"epubUrl.query");
                if (((CharSequence)$i$f$trim).length() > 0) {
                    v12 = Intrinsics.stringPlus((String)"?", (Object)epubUrl.getQuery());
                } else lbl-1000:
                // 2 sources

                {
                    v12 = "";
                }
                sourceUrl = Intrinsics.stringPlus((String)v11, (Object)v12);
                v13 = languageVariant;
                childEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(sourceUrl, bookObj.getTitle(), sourceUrl, "African Story Books", 1, language != null ? language.getLangUid() : 0L, v13 == null ? null : Long.valueOf(v13.getLangVariantUid()), bookObj.getSummary(), true, bookObj.getAuthor(), this.getCoverUrl(bookId), "", "", 0, contentEntryDao);
                readerDoc = Jsoup.connect((String)this.generateReaderUrl(africanBooksUrl, bookId)).get();
                langList = readerDoc.select("li#accordianRelatedStories div.accordion-item-content a");
                originalEntry = childEntry;
                relatedEntries = new ArrayList<ContentEntry>();
                for (Element element : langList) {
                    lang = "";
                    try {
                        var50_91 = id = element.attr("onclickss");
                        Intrinsics.checkNotNullExpressionValue((Object)var50_91, (String)"id");
                        var51_93 = id;
                        Intrinsics.checkNotNullExpressionValue((Object)var51_93, (String)"id");
                        v14 = StringsKt.indexOf$default((CharSequence)var51_93, (String)"(", (int)0, (boolean)false, (int)6, null) + 1;
                        var52_94 = id;
                        Intrinsics.checkNotNullExpressionValue((Object)var52_94, (String)"id");
                        var53_96 = var50_91.substring(v14, StringsKt.lastIndexOf$default((CharSequence)var52_94, (String)")", (int)0, (boolean)false, (int)6, null));
                        Intrinsics.checkNotNullExpressionValue((Object)var53_96, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                        id = var53_96;
                        v15 = element.selectFirst("span");
                        value /* !! */  = v15 == null ? null : v15.text();
                        v16 = value /* !! */ ;
                        if (v16 == null) {
                            v16 = "";
                        }
                        lang = v16;
                        var51_93 = StringUtils.remove((String)lang, (String)"(Original)");
                        Intrinsics.checkNotNullExpressionValue((Object)var51_93, (String)"remove(lang, \"(Original)\")");
                        lang = var51_93;
                        var51_93 = StringUtils.remove((String)lang, (String)"(Adaptation)");
                        Intrinsics.checkNotNullExpressionValue((Object)var51_93, (String)"remove(lang, \"(Adaptation)\")");
                        lang = var51_93;
                        var51_93 = StringUtils.remove((String)lang, (String)"(Translation)");
                        Intrinsics.checkNotNullExpressionValue((Object)var51_93, (String)"remove(lang, \"(Translation)\")");
                        $this$trim$iv = var51_93;
                        $i$f$trim = false;
                        $this$trim$iv$iv = $this$trim$iv;
                        $i$f$trim = false;
                        startIndex$iv$iv = 0;
                        endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                        startFound$iv$iv = false;
                        while (startIndex$iv$iv <= endIndex$iv$iv) {
                            index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                            it = $this$trim$iv$iv.charAt(index$iv$iv);
                            $i$a$-trim-AsbScraper$findContent$4 = false;
                            v17 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                            if (!startFound$iv$iv) {
                                if (!match$iv$iv) {
                                    startFound$iv$iv = true;
                                    continue;
                                }
                                ++startIndex$iv$iv;
                                continue;
                            }
                            if (!match$iv$iv) break;
                            --endIndex$iv$iv;
                        }
                        $i$f$trim = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString().toLowerCase();
                        Intrinsics.checkNotNullExpressionValue((Object)$i$f$trim, (String)"this as java.lang.String).toLowerCase()");
                        lang = $i$f$trim;
                        $this$trim$iv = StringUtils.capitalize((String)lang);
                        Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv, (String)"capitalize(lang)");
                        lang = $this$trim$iv;
                        relatedVariant /* !! */  = "";
                        relatedLangValue = lang;
                        if (StringsKt.contains$default((CharSequence)lang, (CharSequence)"(", (boolean)false, (int)2, null)) {
                            startFound$iv$iv = lang.substring(StringsKt.indexOf$default((CharSequence)lang, (String)"(", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)lang, (String)")", (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)startFound$iv$iv, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            $this$trim$iv$iv = StringUtils.capitalize((String)startFound$iv$iv);
                            Intrinsics.checkNotNullExpressionValue((Object)$this$trim$iv$iv, (String)"capitalize(lang.substrin\u2026 + 1, lang.indexOf(\")\")))");
                            relatedVariant /* !! */  = $this$trim$iv$iv;
                            endIndex$iv$iv = lang.substring(0, StringsKt.indexOf$default((CharSequence)lang, (String)"(", (int)0, (boolean)false, (int)6, null));
                            Intrinsics.checkNotNullExpressionValue((Object)endIndex$iv$iv, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                            $this$trim$iv$iv = endIndex$iv$iv;
                            $i$f$trim = false;
                            $this$trim$iv$iv = (CharSequence)$this$trim$iv;
                            $i$f$trim = false;
                            startIndex$iv$iv = 0;
                            endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                            startFound$iv$iv = false;
                            while (startIndex$iv$iv <= endIndex$iv$iv) {
                                index$iv$iv = startFound$iv$iv == false ? startIndex$iv$iv : endIndex$iv$iv;
                                it = $this$trim$iv$iv.charAt(index$iv$iv);
                                $i$a$-trim-AsbScraper$findContent$5 = false;
                                v18 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                                if (!startFound$iv$iv) {
                                    if (!match$iv$iv) {
                                        startFound$iv$iv = true;
                                        continue;
                                    }
                                    ++startIndex$iv$iv;
                                    continue;
                                }
                                if (!match$iv$iv) break;
                                --endIndex$iv$iv;
                            }
                            relatedLangValue = $this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1).toString();
                        }
                        if ((relatedLanguage = languageDao.findByName(relatedLangValue)) == null) {
                            relatedLanguage = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, lang);
                        }
                        relatedLanguageVariant = null;
                        if (!(((CharSequence)variant).length() == 0)) {
                            relatedLanguageVariant = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(variantDao, relatedVariant /* !! */ , relatedLanguage);
                        }
                        content = this.generateEPubUrl(africanBooksUrl, id);
                        v19 = content.getPath();
                        if (content.getQuery() == null) ** GOTO lbl-1000
                        startIndex$iv$iv = content.getQuery();
                        Intrinsics.checkNotNullExpressionValue((Object)startIndex$iv$iv, (String)"content.getQuery()");
                        if (!(((CharSequence)startIndex$iv$iv).length() == 0)) {
                            v20 = Intrinsics.stringPlus((String)"?", (Object)content.getQuery());
                        } else lbl-1000:
                        // 2 sources

                        {
                            v20 = "";
                        }
                        relatedSourceUrl = Intrinsics.stringPlus((String)v19, (Object)v20);
                        contentEntry = contentEntryDao.findBySourceUrl(relatedSourceUrl);
                        if (contentEntry == null) {
                            contentEntry = new ContentEntry();
                            contentEntry.setSourceUrl(relatedSourceUrl);
                            v21 = relatedLanguage;
                            Intrinsics.checkNotNull((Object)v21);
                            contentEntry.setPrimaryLanguageUid(v21.getLangUid());
                            if (relatedLanguageVariant != null) {
                                contentEntry.setLanguageVariantUid(relatedLanguageVariant.getLangVariantUid());
                            }
                            contentEntry.setLeaf(true);
                            contentEntry.setContentEntryUid(contentEntryDao.insert((Object)contentEntry));
                        }
                        relatedEntries.add(contentEntry);
                        v22 = value /* !! */ ;
                        if (!(v22 == null ? false : StringsKt.contains$default((CharSequence)v22, (CharSequence)"Original", (boolean)false, (int)2, null) == true)) continue;
                        originalEntry = contentEntry;
                    }
                    catch (NullPointerException e) {
                        UMLogUtil.INSTANCE.logError("A translated book could not be parsed " + lang + "for book " + bookObj.getTitle());
                    }
                }
                for (ContentEntry entry : relatedEntries) {
                    Intrinsics.checkNotNullExpressionValue((Object)entry, (String)"entry");
                    ContentScraperUtil.INSTANCE.insertOrUpdateRelatedContentJoin(relatedEntryJoinDao, entry, originalEntry, 1);
                }
                ContentScraperUtil.INSTANCE.insertOrUpdateRelatedContentJoin(relatedEntryJoinDao, childEntry, originalEntry, 1);
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentParentChildJoinDao, asbParentEntry, childEntry, i);
                schema = ContentScraperUtil.INSTANCE.insertOrUpdateSchema(categorySchemeDao, "African Storybooks Reading Level", "africanstorybooks/reading/");
                v23 = bookObj.getLevel();
                Intrinsics.checkNotNull((Object)v23);
                category = ContentScraperUtil.INSTANCE.insertOrUpdateCategoryContent(categoryDao, schema, Intrinsics.stringPlus((String)"Reading Level ", (Object)v23));
                ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleCategoriesJoin(contentCategoryJoinDao, category, childEntry);
                v24 = bookObj.getDate();
                Intrinsics.checkNotNull((Object)v24);
                isUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, v24);
                if (!isUpdated) {
                    e = i;
                    i = e + 1;
                    continue;
                }
                value /* !! */  = ePubFile.getName();
                Intrinsics.checkNotNullExpressionValue((Object)value /* !! */ , (String)"ePubFile.name");
                tmpFolder = new File(UMFileUtil.INSTANCE.stripExtensionIfPresent(value /* !! */ ));
                if (ContentScraperUtil.INSTANCE.fileHasContent(tmpFolder)) {
                    FileUtils.deleteDirectory((File)tmpFolder);
                }
                FileUtils.copyURLToFile((URL)epubUrl, (File)ePubFile);
                UMLogUtil.INSTANCE.logTrace("Got the epub");
                if (ePubFile.length() == 0L) {
                    ContentScraperUtil.INSTANCE.deleteFile(modifiedFile);
                    value = retry;
                    retry = value + 1;
                    if (retry == 3) {
                        retry = 0;
                        UMLogUtil.INSTANCE.logError(ePubFile.getName() + " size 0 bytes after 3rd try: failed! for title " + bookObj.getTitle());
                        value = i;
                        i = value + 1;
                        continue;
                    }
                    value = i;
                    i = value + -1;
                    driver.manage().deleteAllCookies();
                    value = i;
                    i = value + 1;
                    continue;
                }
                retry = 0;
                if (ContentScraperUtil.INSTANCE.fileHasContent(ePubFile)) {
                    this.updateAsbEpub(bookObj, ePubFile);
                }
                options = new ShrinkerUtil.EpubShrinkerOptions();
                options.setLinkHelper((Function0<String>)((Function0)new Function0<String>(this){
                    final /* synthetic */ AsbScraper this$0;
                    {
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final String invoke() {
                        String string = IOUtils.toString((InputStream)this.this$0.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/asb/cssHelper.css"), (String)"UTF-8");
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(javaClass.getRe\u2026SS_HELPER), UTF_ENCODING)");
                        return string;
                    }
                }));
                tmpDir = ShrinkerUtil.INSTANCE.shrinkEpub(ePubFile, options);
                UMLogUtil.INSTANCE.logTrace("Shrunk Epub");
                v25 = ePubFile.lastModified();
                v26 = db;
                if (v26 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                    v26 = null;
                }
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, childEntry, true, "application/epub+zip", v25, tmpDir, v26, repository, containerDir);
                UMLogUtil.INSTANCE.logTrace("Completed: Created Container");
                ContentScraperUtil.INSTANCE.deleteFile(ePubFile);
            }
            catch (Exception e) {
                ContentScraperUtil.INSTANCE.deleteFile(modifiedFile);
                var36_49 = retry;
                retry = var36_49 + 1;
                if (retry == 3) {
                    retry = 0;
                    UMLogUtil.INSTANCE.logError("Exception downloading/checking after 3rd try : " + ePubFile.getName() + " with title " + bookObj.getTitle());
                    var36_49 = i;
                    i = var36_49 + 1;
                    continue;
                }
                var36_49 = i;
                i = var36_49 + -1;
                driver.manage().deleteAllCookies();
            }
            var35_43 = i;
            i = var35_43 + 1;
        }
        driver.close();
        driver.quit();
    }

    @NotNull
    public final String generateReaderUrl(@NotNull URL url, @Nullable String bookId) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        String string = bookId;
        Intrinsics.checkNotNull((Object)string);
        String string2 = new URL(url, Intrinsics.stringPlus((String)"/reader.php?id=", (Object)string)).toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URL(url, \"/reader.php?id=\" + bookId!!).toString()");
        return string2;
    }

    @NotNull
    public final String getCoverUrl(@Nullable String bookId) {
        return this.COVER_URL + bookId + ".png";
    }

    @NotNull
    public final URL generatePublishUrl(@NotNull URL africanBooksUrl, @Nullable String bookId) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)africanBooksUrl, (String)"africanBooksUrl");
        return new URL(africanBooksUrl, Intrinsics.stringPlus((String)"/myspace/publish/epub.php?id=", (Object)bookId));
    }

    @NotNull
    public final URL generateMakeUrl(@NotNull URL africanBooksUrl, @NotNull String bookId) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)africanBooksUrl, (String)"africanBooksUrl");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return new URL(africanBooksUrl, Intrinsics.stringPlus((String)"/make/publish/epub.php?id=", (Object)bookId));
    }

    @NotNull
    public final URL generateEPubUrl(@NotNull URL africanBooksUrl, @NotNull String bookId) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)africanBooksUrl, (String)"africanBooksUrl");
        Intrinsics.checkNotNullParameter((Object)bookId, (String)"bookId");
        return new URL(africanBooksUrl, Intrinsics.stringPlus((String)"/read/downloadepub.php?id=", (Object)bookId));
    }

    @NotNull
    public final URL generateURL() throws MalformedURLException {
        return new URL("https://www.africanstorybook.org/booklist.php");
    }

    @NotNull
    protected final List<AfricanBooksResponse> parseBooklist(@NotNull InputStream booklistIn) throws IOException {
        Intrinsics.checkNotNullParameter((Object)booklistIn, (String)"booklistIn");
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        BufferedReader reader = new BufferedReader(new InputStreamReader(booklistIn, "UTF-8"));
        ArrayList<Object> retVal = new ArrayList<Object>();
        boolean inList = false;
        Object currentObj = null;
        int parsedCounter = 0;
        int failCounter = 0;
        Sequence $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)reader);
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            String string;
            String it = (String)element$iv;
            boolean bl = false;
            if (!inList && !StringsKt.startsWith$default((String)it, (String)"<script>", (boolean)false, (int)2, null)) continue;
            String line = it;
            if (StringsKt.startsWith$default((String)line, (String)"<script>", (boolean)false, (int)2, null)) {
                string = line.substring("<script>".length());
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
                line = string;
                inList = true;
            }
            if (!StringsKt.startsWith$default((String)line, (String)"parent.bookItems", (boolean)false, (int)2, null)) continue;
            String string2 = StringEscapeUtils.unescapeHtml4((String)line);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"unescapeHtml4(line)");
            line = string2;
            String string3 = line.substring(StringsKt.indexOf$default((CharSequence)line, (String)"({", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.indexOf$default((CharSequence)line, (String)"})", (int)0, (boolean)false, (int)6, null) + 1);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String jsonStr = string3;
            jsonStr = StringsKt.replace$default((String)jsonStr, (String)"\n", (String)" ", (boolean)false, (int)4, null);
            jsonStr = StringsKt.replace$default((String)jsonStr, (String)"\r", (String)" ", (boolean)false, (int)4, null);
            try {
                Object object = gson.fromJson(jsonStr, AfricanBooksResponse.class);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"gson.fromJson(jsonStr, A\u2026ooksResponse::class.java)");
                currentObj = object;
                retVal.add(currentObj);
                int n = parsedCounter;
                parsedCounter = n + 1;
            }
            catch (Exception e) {
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to parse: ", (Object)line));
                string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                int n = failCounter;
                failCounter = n + 1;
            }
        }
        UMLogUtil.INSTANCE.logInfo("Parsed " + parsedCounter + " / failed " + failCounter + " items from booklist.php");
        reader.close();
        booklistIn.close();
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public final void updateAsbEpub(@NotNull AfricanBooksResponse booklistEntry, @NotNull File epubFile) {
        block24: {
            Intrinsics.checkNotNullParameter((Object)booklistEntry, (String)"booklistEntry");
            Intrinsics.checkNotNullParameter((Object)epubFile, (String)"epubFile");
            zipFs = null;
            opfReader = null;
            v0 = zipFs = FileSystems.newFileSystem(epubFile.toPath(), ClassLoader.getSystemClassLoader());
            Intrinsics.checkNotNull((Object)v0);
            opfReader = new BufferedReader(new InputStreamReader(Files.newInputStream(v0.getPath("content.opf", new String[0]), new OpenOption[0]), "UTF-8"));
            opfModBuffer = new StringBuffer();
            modified = false;
            hasDescription = false;
            descTag = "<dc:description>" + StringEscapeUtils.escapeXml((String)booklistEntry.getSummary()) + "</dc:description>";
            $this$forEach$iv = TextStreamsKt.lineSequence((BufferedReader)opfReader);
            $i$f$forEach = false;
            for (E element$iv : $this$forEach$iv) {
                it = (String)element$iv;
                $i$a$-forEach-AsbScraper$updateAsbEpub$1 = false;
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"dc:description", (boolean)false, (int)2, null)) {
                    opfModBuffer.append(descTag).append('\n');
                    hasDescription = true;
                    modified = true;
                    continue;
                }
                if (!hasDescription && StringsKt.contains$default((CharSequence)it, (CharSequence)"</metadata>", (boolean)false, (int)2, null)) {
                    opfModBuffer.append(descTag).append("\n</metadata>\n");
                    modified = true;
                    continue;
                }
                if (StringsKt.contains$default((CharSequence)it, (CharSequence)"<item id=\"cover-image\"", (boolean)false, (int)2, null) && !StringsKt.contains$default((CharSequence)it, (CharSequence)"properties=\"cover-image\"", (boolean)false, (int)2, null)) {
                    opfModBuffer.append(" <item id=\"cover-image\" href=\"images/cover.png\"  media-type=\"image/png\" properties=\"cover-image\"/>\n");
                    continue;
                }
                opfModBuffer.append(it).append('\n');
            }
            opfReader.close();
            if (modified) {
                v1 = zipFs.getPath("content.opf", new String[0]);
                var9_22 = opfModBuffer.toString();
                Intrinsics.checkNotNullExpressionValue((Object)var9_22, (String)"opfModBuffer.toString()");
                var11_24 = Charset.forName("UTF-8");
                Intrinsics.checkNotNullExpressionValue((Object)var11_24, (String)"forName(charsetName)");
                var11_24 = var9_22.getBytes((Charset)var11_24);
                Intrinsics.checkNotNullExpressionValue((Object)var11_24, (String)"this as java.lang.String).getBytes(charset)");
                var9_22 = new OpenOption[]{StandardOpenOption.TRUNCATE_EXISTING};
                Files.write(v1, (byte[])var11_24, var9_22);
            }
            ** try [egrp 1[TRYBLOCK] [0 : 422->431)] { 
lbl-1000:
            // 1 sources

            {
                opfReader.close();
            }
lbl54:
            // 1 sources

            catch (IOException e) {
                modified = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(modified);
            }
            try {
                zipFs.close();
            }
            catch (IOException e) {
                modified = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(modified);
            }
            break block24;
            catch (Exception e) {
                modified = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(modified);
                break block24;
            }
            finally {
                if (opfReader != null) {
                    try {
                        opfReader.close();
                    }
                    catch (IOException e) {
                        modified = ExceptionUtils.getStackTrace((Throwable)e);
                        Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"getStackTrace(e)");
                        UMLogUtil.INSTANCE.logError(modified);
                    }
                }
                if (zipFs != null) {
                    try {
                        zipFs.close();
                    }
                    catch (IOException e) {
                        modified = ExceptionUtils.getStackTrace((Throwable)e);
                        Intrinsics.checkNotNullExpressionValue((Object)modified, (String)"getStackTrace(e)");
                        UMLogUtil.INSTANCE.logError(modified);
                    }
                }
            }
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/lib/contentscrapers/africanbooks/AsbScraper$Companion;", "", "()V", "AFRICAN_STORY_BOOKS", "", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 2) {
                System.err.println("Usage: <file destination><file container destination><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            try {
                new AsbScraper().findContent(new File(args[0]), new File(args[1]));
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logFatal("Exception running findContent AsbScraper");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

