/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.abztract.HarIndexer;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.khanacademy.FullMenuResponse;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstants;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstantsKt;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanFullIndexer;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanLang;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.net.URL;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import net.lightbody.bmp.core.har.HarEntry;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanFullIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/HarIndexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "indexUrl", "", "sourceUrl", "", "lib-content-scrapers"})
public final class KhanFullIndexer
extends HarIndexer {
    public KhanFullIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        ContentEntry khanEntry = KhanConstantsKt.getKhanEntry(this.getEnglishLang(), this.getRepo().getContentEntryDao());
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), this.getParentContentEntry(), khanEntry, 12);
        String lang = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)sourceUrl, (String)".khan", null, (int)2, null), (String)"://", null, (int)2, null);
        KhanLang khanLang = KhanConstants.INSTANCE.getKhanFullMap().get(lang);
        if (khanLang == null) {
            throw new ScraperException(0, Intrinsics.stringPlus((String)"Do not have support for language: ", (Object)lang));
        }
        KhanLang khanLang2 = khanLang;
        ContentEntry parentLangEntry = KhanConstantsKt.createKangLangEntry(Intrinsics.areEqual((Object)lang, (Object)"www") ? "en" : lang, khanLang2.getTitle(), khanLang2.getUrl(), this.getDb());
        this.hideContentEntry(parentLangEntry.getContentEntryUid());
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), khanEntry, parentLangEntry, 0);
        List harEntryList = null;
        harEntryList = HarIndexer.startHarIndexer$default(this, sourceUrl, CollectionsKt.listOf((Object)new Regex("learnMenuTopicsQuery")), null, indexUrl.1.INSTANCE, 4, null);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        FullMenuResponse response = (FullMenuResponse)gson.fromJson(((HarEntry)harEntryList.get(0)).getResponse().getContent().getText(), FullMenuResponse.class);
        FullMenuResponse.Data data = response.getData();
        if (data != null) {
            List<FullMenuResponse.Data.Topic> list = data.getLearnMenuTopics();
            if (list != null) {
                Iterable $this$forEachIndexed$iv = list;
                boolean $i$f$forEachIndexed = false;
                int index$iv = 0;
                for (Object item$iv : $this$forEachIndexed$iv) {
                    void topic;
                    int n = index$iv;
                    index$iv = n + 1;
                    if (n < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    FullMenuResponse.Data.Topic topic2 = (FullMenuResponse.Data.Topic)item$iv;
                    int topicCount = n;
                    boolean bl = false;
                    URL topicUrl = new URL(new URL(sourceUrl), topic.getHref());
                    String string = topic.getSlug();
                    Intrinsics.checkNotNull((Object)string);
                    String string2 = topic.getTranslatedTitle();
                    String string3 = topicUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"topicUrl.toString()");
                    ContentEntry topicEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, string2, string3, "Khan Academy", 4, parentLangEntry.getPrimaryLanguageUid(), parentLangEntry.getLanguageVariantUid(), "", false, "", "", "", "", 0, this.getRepo().getContentEntryDao());
                    ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), parentLangEntry, topicEntry, topicCount);
                    Indexer indexer = this;
                    string3 = topicUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"topicUrl.toString()");
                    Indexer.createQueueItem$default(indexer, string3, topicEntry, "khanTopicIndexer", 1, parentLangEntry.getContentEntryUid(), 0, 32, null);
                    if (!Intrinsics.areEqual((Object)lang, (Object)"hi")) continue;
                    List<FullMenuResponse.Data.Topic> list2 = topic.getChildren();
                    if (list2 == null) continue;
                    Iterable $this$forEachIndexed$iv2 = list2;
                    boolean $i$f$forEachIndexed2 = false;
                    int index$iv2 = 0;
                    for (Object item$iv2 : $this$forEachIndexed$iv2) {
                        void childTopic;
                        int n2 = index$iv2;
                        index$iv2 = n2 + 1;
                        if (n2 < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        FullMenuResponse.Data.Topic topic3 = (FullMenuResponse.Data.Topic)item$iv2;
                        int childTopicCount = n2;
                        boolean bl2 = false;
                        URL childTopicUrl = new URL(new URL(sourceUrl), childTopic.getHref());
                        String string4 = childTopic.getSlug();
                        Intrinsics.checkNotNull((Object)string4);
                        String string5 = childTopic.getTranslatedTitle();
                        String string6 = childTopicUrl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"childTopicUrl.toString()");
                        ContentEntry childTopicEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string4, string5, string6, "Khan Academy", 4, topicEntry.getPrimaryLanguageUid(), topicEntry.getLanguageVariantUid(), "", false, "", "", "", "", 0, this.getRepo().getContentEntryDao());
                        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), topicEntry, childTopicEntry, childTopicCount);
                        Indexer indexer2 = this;
                        string6 = childTopicUrl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"childTopicUrl.toString()");
                        Indexer.createQueueItem$default(indexer2, string6, childTopicEntry, "khanTopicIndexer", 1, topicEntry.getContentEntryUid(), 0, 32, null);
                    }
                }
            }
        }
        this.setIndexerDone(true, 0);
    }
}

