/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.abztract.SeleniumIndexer;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstants;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstantsKt;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanLang;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanLiteIndexer;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.net.URL;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kodein.di.DI;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanLiteIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/SeleniumIndexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "close", "", "indexUrl", "sourceUrl", "", "lib-content-scrapers"})
public final class KhanLiteIndexer
extends SeleniumIndexer {
    public KhanLiteIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        ContentEntry khanEntry = KhanConstantsKt.getKhanEntry(this.getEnglishLang(), this.getRepo().getContentEntryDao());
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), this.getParentContentEntry(), khanEntry, 12);
        String lang = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)sourceUrl, (String)".khan", null, (int)2, null), (String)"://", null, (int)2, null);
        KhanLang khanLang = KhanConstants.INSTANCE.getKhanLiteMap().get(lang);
        if (khanLang == null) {
            throw new ScraperException(0, Intrinsics.stringPlus((String)"Do not have support for lite language: ", (Object)lang));
        }
        KhanLang khanLang2 = khanLang;
        ContentEntry parentEntry = KhanConstantsKt.createKangLangEntry(Intrinsics.areEqual((Object)lang, (Object)"www") ? "en" : lang, khanLang2.getTitle(), khanLang2.getUrl(), this.getDb());
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), khanEntry, parentEntry, 0);
        Document document2 = null;
        document2 = this.startSeleniumIndexer(sourceUrl, (Function1<? super WebDriverWait, Unit>)((Function1)indexUrl.1.INSTANCE));
        Elements fullList = document2.select("div#library-content-main div[data-role=page]");
        Intrinsics.checkNotNullExpressionValue((Object)fullList, (String)"fullList");
        Iterable $this$forEachIndexed$iv = (Iterable)fullList;
        boolean $i$f$forEachIndexed = false;
        int index$iv = 0;
        for (Object item$iv : $this$forEachIndexed$iv) {
            String string;
            String header;
            String string2;
            void element;
            int n = index$iv;
            index$iv = n + 1;
            if (n < 0) {
                CollectionsKt.throwIndexOverflow();
            }
            Element element2 = (Element)item$iv;
            int count = n;
            boolean bl = false;
            Element element3 = element.selectFirst("div.library-content-header h2");
            if (element3 == null) {
                string2 = "";
            } else {
                string2 = element3.text();
                if (string2 == null) {
                    string2 = header = "";
                }
            }
            if (((CharSequence)header).length() == 0) {
                UMLogUtil.INSTANCE.logError("page had a missing header text for count " + count + " for url " + sourceUrl);
                continue;
            }
            Elements elements = element.select("div.library-content-list p.topic-desc");
            if (elements == null) {
                string = "";
            } else {
                string = elements.text();
                if (string == null) {
                    string = "";
                }
            }
            String description = string;
            ContentEntry headerEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(header, header, header, "Khan Academy", 4, parentEntry.getPrimaryLanguageUid(), parentEntry.getLanguageVariantUid(), description, false, "", "", "", "", 0, this.getRepo().getContentEntryDao());
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), parentEntry, headerEntry, count);
            Elements contentList = element.select("div.library-content-list li.subjects-row-first td a.subject-link");
            Intrinsics.checkNotNullExpressionValue((Object)contentList, (String)"contentList");
            Iterable $this$forEachIndexed$iv2 = (Iterable)contentList;
            boolean $i$f$forEachIndexed2 = false;
            int index$iv2 = 0;
            for (Object item$iv2 : $this$forEachIndexed$iv2) {
                void contentElement;
                int n2 = index$iv2;
                index$iv2 = n2 + 1;
                if (n2 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                Element element4 = (Element)item$iv2;
                int contentCount = n2;
                boolean bl2 = false;
                String href = contentElement.attr("href");
                String title = contentElement.text();
                URL contentUrl = new URL(new URL(sourceUrl), href);
                CharSequence charSequence = contentUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"contentUrl.toString()");
                String contentId = StringsKt.substringAfter$default((String)charSequence, (String)"v=", null, (int)2, null);
                charSequence = contentId;
                if (charSequence == null || charSequence.length() == 0) {
                    UMLogUtil.INSTANCE.logError("no Content Id found for element " + title + "  with href " + href + " in heading " + header + " on url " + sourceUrl);
                    continue;
                }
                ContentEntry entry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(contentId, title, Intrinsics.stringPlus((String)"khan-id://", (Object)contentId), "Khan Academy", 4, parentEntry.getPrimaryLanguageUid(), parentEntry.getLanguageVariantUid(), "", true, "", "", "", "", 4, this.getRepo().getContentEntryDao());
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(this.getRepo().getContentEntryParentChildJoinDao(), headerEntry, entry, contentCount);
                Indexer indexer = this;
                String string3 = contentUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"contentUrl.toString()");
                Indexer.createQueueItem$default(indexer, string3, entry, "khanLiteVideoScraper", 2, headerEntry.getContentEntryUid(), 0, 32, null);
            }
        }
        this.setIndexerDone(true, 0);
    }

    @Override
    public void close() {
    }
}

