/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.ddl;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.ddl.IndexDdlContent;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.kodein.di.DI;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016\u00a8\u0006\u0012"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ddl/DdlListIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentEntryUid", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "close", "", "indexUrl", "sourceUrl", "", "lib-content-scrapers"})
public final class DdlListIndexer
extends Indexer {
    public DdlListIndexer(long parentEntryUid, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentEntryUid, runUid, sqiUid, contentEntryUid, endpoint, di);
    }

    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Document document2 = Jsoup.connect((String)sourceUrl).header("X-Requested-With", "XMLHttpRequest").get();
        LanguageDao languageDao = this.getDb().getLanguageDao();
        ContentEntry contentEntry = this.getParentContentEntry();
        Long l = contentEntry == null ? null : Long.valueOf(contentEntry.getPrimaryLanguageUid());
        Intrinsics.checkNotNull((Object)l);
        Language language = languageDao.findByUid(l.longValue());
        String langCode = language == null ? null : language.getIso_639_1_standard();
        Elements resourceList = document2.select("article a[href]");
        int counter = (Integer.parseInt(StringsKt.substringAfter$default((String)sourceUrl, (String)"page=", null, (int)2, null)) - 1) * 32 + 500;
        for (Element resource : resourceList) {
            String string;
            String href = resource.attr("href");
            Intrinsics.checkNotNullExpressionValue((Object)href, (String)"href");
            if (!StringsKt.contains$default((CharSequence)href, (CharSequence)"resource/", (boolean)false, (int)2, null)) continue;
            int index = StringsKt.indexOf$default((CharSequence)href, (String)"af/", (int)0, (boolean)false, (int)6, null);
            if (StringsKt.indexOf$default((CharSequence)href, (String)"af/", (int)0, (boolean)false, (int)6, null) == -1) {
                UMLogUtil.INSTANCE.logError(IndexDdlContent.Companion.getDDL$lib_content_scrapers() + " did not give full url as expected for href " + href);
                continue;
            }
            String string2 = new StringBuilder(href).insert(index + 3, Intrinsics.stringPlus((String)langCode, (Object)"/")).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"StringBuilder(href).inse\u2026 \"$langCode/\").toString()");
            String url = string2;
            Element element = resource.selectFirst("div.resource-title");
            if (element == null) {
                string = "";
            } else {
                string = element.text();
                if (string == null) {
                    string = "";
                }
            }
            String title = string;
            ContentEntryDao contentEntryDao = this.getRepo().getContentEntryDao();
            ContentEntry contentEntry2 = this.getParentContentEntry();
            Intrinsics.checkNotNull((Object)contentEntry2);
            ContentEntry entry = ContentScraperUtil.INSTANCE.insertTempContentEntry(contentEntryDao, url, contentEntry2.getPrimaryLanguageUid(), title);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.getRepo().getContentEntryParentChildJoinDao();
            ContentEntry contentEntry3 = this.getParentContentEntry();
            Intrinsics.checkNotNull((Object)contentEntry3);
            int n = counter;
            counter = n + 1;
            ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(contentEntryParentChildJoinDao, contentEntry3, entry, n);
            Indexer.createQueueItem$default(this, url, entry, "ddlArticleScraper", 2, this.getParentContentEntryUid(), 0, 32, null);
        }
        this.setIndexerDone(true, 0);
    }

    @Override
    public void close() {
    }
}

