/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.edraakK12;

import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.util.LiveDataWorkQueue;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.edraakK12.ContentResponse;
import com.ustadmobile.lib.contentscrapers.edraakK12.IndexEdraakK12Content;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.ScrapeQueueItem;
import com.ustadmobile.lib.staging.contentscrapers.edraakK12.EdraakK12ContentScraper;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.List;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\u0018\u0000 &2\u00020\u0001:\u0001&B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000f2\u0006\u0010\u0018\u001a\u00020\u0019H\u0002J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J\u001e\u0010\u001e\u001a\u00020\u00162\u0006\u0010\u001f\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010!\u001a\u00020\u001bJ&\u0010\"\u001a\u00020\u00162\u0006\u0010#\u001a\u00020\u001d2\u0006\u0010$\u001a\u00020\u00062\u0006\u0010 \u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u001bR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00120\u0011X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006'"}, d2={"Lcom/ustadmobile/lib/contentscrapers/edraakK12/IndexEdraakK12Content;", "", "()V", "arabicLang", "Lcom/ustadmobile/lib/db/entities/Language;", "containerDirectory", "Ljava/io/File;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "destinationDirectory", "queueDao", "Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao;", "response", "Lcom/ustadmobile/lib/contentscrapers/edraakK12/ContentResponse;", "scrapeWorkQueue", "Lcom/ustadmobile/core/util/LiveDataWorkQueue;", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItem;", "url", "Ljava/net/URL;", "findImportedComponent", "", "parentContent", "parentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "getLicenseType", "", "license", "", "scrapeFromRoot", "dest", "containerDir", "runId", "startScrape", "scrapeUrl", "destinationDir", "runIdscrape", "Companion", "lib-content-scrapers"})
public final class IndexEdraakK12Content {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private URL url;
    @Nullable
    private File destinationDirectory;
    @Nullable
    private ContentResponse response;
    private ContentEntryDao contentEntryDao;
    private ContentEntryParentChildJoinDao contentParentChildJoinDao;
    private Language arabicLang;
    private ScrapeQueueItemDao queueDao;
    private LiveDataWorkQueue<ScrapeQueueItem> scrapeWorkQueue;
    private File containerDirectory;
    private static int runId;
    @NotNull
    private static final String ROOT_URL = "https://programs.edraak.org/api/component/5a6087f46380a6049b33fc19/?states_program_id=41";
    @NotNull
    public static final String EDRAAK = "Edraak";

    public final void scrapeFromRoot(@NotNull File dest, @NotNull File containerDir, int runId) throws IOException {
        Intrinsics.checkNotNullParameter((Object)dest, (String)"dest");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        this.startScrape(ROOT_URL, dest, containerDir, runId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void startScrape(@NotNull String scrapeUrl2, @NotNull File destinationDir, @NotNull File containerDir, int runIdscrape) throws IOException {
        String description;
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        try {
            this.url = new URL(scrapeUrl2);
        }
        catch (MalformedURLException e) {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"url from main is Malformed = ", (Object)scrapeUrl2));
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Malformed url", (Object)scrapeUrl2), e);
        }
        destinationDir.mkdirs();
        containerDir.mkdirs();
        this.containerDirectory = containerDir;
        this.destinationDirectory = destinationDir;
        runId = runIdscrape;
        Object db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        Object repository = null;
        this.contentEntryDao = repository.getContentEntryDao();
        this.contentParentChildJoinDao = repository.getContentEntryParentChildJoinDao();
        LanguageDao languageDao = repository.getLanguageDao();
        this.queueDao = db.getScrapeQueueItemDao();
        this.arabicLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, "Arabic");
        HttpURLConnection connection = null;
        try {
            URL uRL = this.url;
            Intrinsics.checkNotNull((Object)uRL);
            URLConnection uRLConnection = uRL.openConnection();
            if (uRLConnection == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
            }
            connection = (HttpURLConnection)uRLConnection;
            connection.setRequestProperty("Accept", "application/json, text/javascript, */*; q=0.01");
            this.response = (ContentResponse)new GsonBuilder().disableHtmlEscaping().create().fromJson(IOUtils.toString((InputStream)connection.getInputStream(), (String)"UTF-8"), ContentResponse.class);
            HttpURLConnection httpURLConnection = connection;
            httpURLConnection.disconnect();
        }
        catch (IOException e) {
            try {
                throw new IllegalArgumentException("JSON INVALID", e.getCause());
                catch (JsonSyntaxException e2) {
                    throw new IllegalArgumentException("JSON INVALID", e2.getCause());
                }
            }
            catch (Throwable e2) {
                HttpURLConnection httpURLConnection = connection;
                if (httpURLConnection == null) {
                    throw e2;
                }
                httpURLConnection.disconnect();
                throw e2;
            }
        }
        Language language = this.arabicLang;
        if (language == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"arabicLang");
            language = null;
        }
        long l = language.getLangUid();
        ContentEntryDao contentEntryDao = this.contentEntryDao;
        if (contentEntryDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
            contentEntryDao = null;
        }
        ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
        String string = description = "\u062a\u0639\u0644\u064a\u0645 \u0645\u062c\u0627\u0646\u064a\u0651\n\u0625\u0644\u0643\u062a\u0631\u0648\u0646\u064a\u0651 \u0628\u0627\u0644\u0644\u063a\u0629 \u0627\u0644\u0639\u0631\u0628\u064a\u0651\u0629!\n Free Online \nEducation, In Arabic!";
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        Charset charset = Charset.defaultCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"defaultCharset()");
        description = new String(byArray, charset);
        Language language2 = this.arabicLang;
        if (language2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"arabicLang");
            language2 = null;
        }
        long l2 = language2.getLangUid();
        ContentEntryDao contentEntryDao2 = this.contentEntryDao;
        if (contentEntryDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
            contentEntryDao2 = null;
        }
        ContentEntry edraakParentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://www.edraak.org/k12/", "Edraak K12", "https://www.edraak.org/k12/", EDRAAK, 5, l2, null, description, false, "", "https://www.edraak.org/static/images/logo-dark-ar.fa1399e8d134.png", "", "", 0, contentEntryDao2);
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
        if (contentEntryParentChildJoinDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
            contentEntryParentChildJoinDao = null;
        }
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, masterRootParent, edraakParentEntry, 4);
        int scrapePrecessor = 1;
        ScrapeQueueItemDao scrapeQueueItemDao = this.queueDao;
        if (scrapeQueueItemDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao = null;
        }
        this.scrapeWorkQueue = new LiveDataWorkQueue(scrapeQueueItemDao.findNextQueueItems(2), (Function2)startScrape.1.INSTANCE, scrapePrecessor, null, null, null, null, null, (Function2)new Function2<ScrapeQueueItem, Continuation<? super Unit>, Object>(this, containerDir, null){
            int label;
            /* synthetic */ Object L$0;
            final /* synthetic */ IndexEdraakK12Content this$0;
            final /* synthetic */ File $containerDir;
            {
                this.this$0 = $receiver;
                this.$containerDir = $containerDir;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        it = (ScrapeQueueItem)this.L$0;
                        v0 = IndexEdraakK12Content.access$getQueueDao$p(this.this$0);
                        if (v0 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                            v0 = null;
                        }
                        v0.updateSetStatusById(it.getSqiUid(), 2, 0);
                        v1 = IndexEdraakK12Content.access$getContentEntryDao$p(this.this$0);
                        if (v1 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                            v1 = null;
                        }
                        this.L$0 = it;
                        this.label = 1;
                        v2 = v1.findByUidAsync(it.getSqiContentEntryParentUid(), (Continuation)this);
                        if (v2 == var6_2) {
                            return var6_2;
                        }
                        ** GOTO lbl25
                    }
                    case 1: {
                        it = (ScrapeQueueItem)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v2 = $result;
lbl25:
                        // 2 sources

                        parent = (ContentEntry)v2;
                        try {
                            v3 = it.getScrapeUrl();
                            Intrinsics.checkNotNull((Object)v3);
                            scrapeContentUrl = new URL(v3);
                            v4 = it.getDestDir();
                            Intrinsics.checkNotNull((Object)v4);
                            v5 = new File(v4);
                            v6 = parent;
                            Intrinsics.checkNotNull((Object)v6);
                            new EdraakK12ContentScraper(scrapeContentUrl, v5, this.$containerDir, v6, it.getSqiUid()).run();
                        }
                        catch (IOException var5_6) {
                            v7 = it.getScrapeUrl();
                            Intrinsics.checkNotNull((Object)v7);
                            throw new RuntimeException(Intrinsics.stringPlus((String)"SEVERE: invalid URL to scrape: should not be in queue:", (Object)v7));
                        }
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                Function2<ScrapeQueueItem, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                function2.L$0 = value;
                return (Continuation)function2;
            }

            @Nullable
            public final Object invoke(@NotNull ScrapeQueueItem p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }, 248, null);
        ContentResponse contentResponse = this.response;
        Intrinsics.checkNotNull((Object)contentResponse);
        this.findImportedComponent(contentResponse, edraakParentEntry);
        BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
            int label;
            final /* synthetic */ IndexEdraakK12Content this$0;
            {
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * WARNING - void declaration
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object object) {
                Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)object);
                        LiveDataWorkQueue liveDataWorkQueue = IndexEdraakK12Content.access$getScrapeWorkQueue$p(this.this$0);
                        if (liveDataWorkQueue == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"scrapeWorkQueue");
                            liveDataWorkQueue = null;
                        }
                        this.label = 1;
                        Object object3 = liveDataWorkQueue.start((Continuation)this);
                        if (object3 != object2) return Unit.INSTANCE;
                        return object2;
                    }
                    case 1: {
                        void $result;
                        ResultKt.throwOnFailure((Object)$result);
                        Object object3 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)3, null);
    }

    private final void findImportedComponent(ContentResponse parentContent, ContentEntry parentEntry) throws MalformedURLException {
        String string = parentContent.getComponent_type();
        Intrinsics.checkNotNull((Object)string);
        if (ContentScraperUtil.INSTANCE.isImportedComponent(string)) {
            int n;
            String string2;
            StringBuilder stringBuilder = new StringBuilder();
            URL uRL = this.url;
            Intrinsics.checkNotNull((Object)uRL);
            StringBuilder stringBuilder2 = stringBuilder.append(uRL.getProtocol()).append("://");
            URL uRL2 = this.url;
            Intrinsics.checkNotNull((Object)uRL2);
            StringBuilder stringBuilder3 = stringBuilder2.append((Object)uRL2.getHost());
            URL uRL3 = this.url;
            Intrinsics.checkNotNull((Object)uRL3);
            if (uRL3.getPort() > 0) {
                URL uRL4 = this.url;
                Intrinsics.checkNotNull((Object)uRL4);
                string2 = Intrinsics.stringPlus((String)":", (Object)uRL4.getPort());
            } else {
                string2 = "";
            }
            String string3 = stringBuilder3.append(string2).append("/api/").toString();
            String string4 = parentContent.getId();
            Intrinsics.checkNotNull((Object)string4);
            if (parentContent.getProgram() == 0) {
                ContentResponse contentResponse = this.response;
                Intrinsics.checkNotNull((Object)contentResponse);
                n = contentResponse.getProgram();
            } else {
                n = parentContent.getProgram();
            }
            String scrapeUrl2 = EdraakK12ContentScraper.Companion.generateUrl(string3, string4, n);
            ScrapeQueueItemDao scrapeQueueItemDao = this.queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            URL uRL5 = new URL(scrapeUrl2);
            String string5 = parentContent.getId();
            Intrinsics.checkNotNull((Object)string5);
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, uRL5, parentEntry, new File(this.destinationDirectory, string5), "", runId, 2);
        } else {
            List<ContentResponse> list = parentContent.getChildren();
            Intrinsics.checkNotNull(list);
            for (ContentResponse children : list) {
                String sourceUrl = children.getId();
                String string6 = children.getComponent_type();
                Intrinsics.checkNotNull((Object)string6);
                boolean isLeaf = ContentScraperUtil.INSTANCE.isImportedComponent(string6);
                String string7 = children.getId();
                Intrinsics.checkNotNull((Object)string7);
                String string8 = children.getTitle();
                String string9 = sourceUrl;
                Intrinsics.checkNotNull((Object)string9);
                String string10 = children.getLicense();
                Intrinsics.checkNotNull((Object)string10);
                int n = this.getLicenseType(string10);
                Language language = this.arabicLang;
                if (language == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"arabicLang");
                    language = null;
                }
                long l = language.getLangUid();
                ContentEntryDao contentEntryDao = this.contentEntryDao;
                if (contentEntryDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                    contentEntryDao = null;
                }
                ContentEntry childEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string7, string8, string9, EDRAAK, n, l, null, "", isLeaf, "", "", "", "", 0, contentEntryDao);
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
                if (contentEntryParentChildJoinDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                    contentEntryParentChildJoinDao = null;
                }
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, parentEntry, childEntry, children.getChild_index());
                this.findImportedComponent(children, childEntry);
            }
        }
    }

    private final int getLicenseType(String license) {
        String string = license.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"cc-by-nc-sa", (boolean)false, (int)2, null)) {
            return 6;
        }
        string = license.toLowerCase();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).toLowerCase()");
        if (StringsKt.contains$default((CharSequence)string, (CharSequence)"all_rights_reserved", (boolean)false, (int)2, null)) {
            return 5;
        }
        UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"License type not matched for license: ", (Object)license));
        return 5;
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    public static final /* synthetic */ ScrapeQueueItemDao access$getQueueDao$p(IndexEdraakK12Content $this) {
        return $this.queueDao;
    }

    public static final /* synthetic */ ContentEntryDao access$getContentEntryDao$p(IndexEdraakK12Content $this) {
        return $this.contentEntryDao;
    }

    public static final /* synthetic */ LiveDataWorkQueue access$getScrapeWorkQueue$p(IndexEdraakK12Content $this) {
        return $this.scrapeWorkQueue;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\f\u001a\u00020\r2\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00040\u000fH\u0007\u00a2\u0006\u0002\u0010\u0010R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000b\u00a8\u0006\u0011"}, d2={"Lcom/ustadmobile/lib/contentscrapers/edraakK12/IndexEdraakK12Content$Companion;", "", "()V", "EDRAAK", "", "ROOT_URL", "runId", "", "getRunId", "()I", "setRunId", "(I)V", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        public final int getRunId() {
            return runId;
        }

        public final void setRunId(int n) {
            runId = n;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 2) {
                System.err.println("Usage: <file destination><file container><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            ContentScraperUtil.INSTANCE.checkIfPathsToDriversExist();
            try {
                Object runDao = null;
                IndexEdraakK12Content index = new IndexEdraakK12Content();
                index.scrapeFromRoot(new File(args[0]), new File(args[1]), this.getRunId());
            }
            catch (Exception e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logError("Main method exception catch khan");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

