/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.phetsimulation;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryRelatedEntryJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.phetsimulation.PhetContentScraper;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 #2\u00020\u0001:\u0001#B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u001e\u0010\u001f\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010\u0005\u001a\u00020\u0006R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0006X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u001aX\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/ustadmobile/lib/contentscrapers/phetsimulation/IndexPhetContentScraper;", "", "()V", "containerDao", "Lcom/ustadmobile/core/db/dao/ContainerDao;", "containerDir", "Ljava/io/File;", "contentEntryCategoryJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryContentCategoryJoinDao;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentEntryRelatedJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryRelatedEntryJoinDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "destinationDirectory", "englishLang", "Lcom/ustadmobile/lib/db/entities/Language;", "languageDao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "languageVariantDao", "Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "repository", "url", "Ljava/net/URL;", "browseCategory", "", "document", "Lorg/jsoup/nodes/Document;", "findContent", "urlString", "", "destinationDir", "Companion", "lib-content-scrapers"})
public final class IndexPhetContentScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private File destinationDirectory;
    private URL url;
    private ContentEntryDao contentEntryDao;
    private ContentEntryParentChildJoinDao contentParentChildJoinDao;
    private ContentEntryContentCategoryJoinDao contentEntryCategoryJoinDao;
    private ContentEntryRelatedEntryJoinDao contentEntryRelatedJoinDao;
    private LanguageDao languageDao;
    private Language englishLang;
    private LanguageVariantDao languageVariantDao;
    private ContainerDao containerDao;
    private UmAppDatabase db;
    private UmAppDatabase repository;
    private File containerDir;
    @NotNull
    private static final String PHET = "Phet";

    public final void findContent(@NotNull String urlString, @NotNull File destinationDir, @NotNull File containerDir) throws IOException {
        UmAppDatabase umAppDatabase;
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Index Malformed url", (Object)urlString));
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Malformed url", (Object)urlString), e);
        }
        destinationDir.mkdirs();
        this.destinationDirectory = destinationDir;
        containerDir.mkdirs();
        this.containerDir = destinationDir;
        UmAppDatabase umAppDatabase2 = this.db;
        if (umAppDatabase2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
            umAppDatabase2 = null;
        }
        if ((umAppDatabase = (this.repository = umAppDatabase2)) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase = null;
        }
        this.contentEntryDao = umAppDatabase.getContentEntryDao();
        UmAppDatabase umAppDatabase3 = this.repository;
        if (umAppDatabase3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase3 = null;
        }
        this.contentParentChildJoinDao = umAppDatabase3.getContentEntryParentChildJoinDao();
        UmAppDatabase umAppDatabase4 = this.repository;
        if (umAppDatabase4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase4 = null;
        }
        this.contentEntryCategoryJoinDao = umAppDatabase4.getContentEntryContentCategoryJoinDao();
        UmAppDatabase umAppDatabase5 = this.repository;
        if (umAppDatabase5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase5 = null;
        }
        this.contentEntryRelatedJoinDao = umAppDatabase5.getContentEntryRelatedEntryJoinDao();
        UmAppDatabase umAppDatabase6 = this.repository;
        if (umAppDatabase6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase6 = null;
        }
        this.containerDao = umAppDatabase6.getContainerDao();
        UmAppDatabase umAppDatabase7 = this.repository;
        if (umAppDatabase7 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase7 = null;
        }
        this.languageDao = umAppDatabase7.getLanguageDao();
        UmAppDatabase umAppDatabase8 = this.repository;
        if (umAppDatabase8 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
            umAppDatabase8 = null;
        }
        this.languageVariantDao = umAppDatabase8.getLanguageVariantDao();
        Document document2 = Jsoup.connect((String)urlString).get();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
        this.browseCategory(document2);
    }

    private final void browseCategory(Document document2) throws IOException {
        Language language;
        Elements simulationList = document2.select("td.simulation-list-item span.sim-badge-html");
        LanguageDao languageDao = this.languageDao;
        if (languageDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageDao");
            languageDao = null;
        }
        if ((language = (this.englishLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, "English"))) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
            language = null;
        }
        long l = language.getLangUid();
        ContentEntryDao contentEntryDao = this.contentEntryDao;
        if (contentEntryDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
            contentEntryDao = null;
        }
        ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
        Language language2 = this.englishLang;
        if (language2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
            language2 = null;
        }
        long l2 = language2.getLangUid();
        ContentEntryDao contentEntryDao2 = this.contentEntryDao;
        if (contentEntryDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
            contentEntryDao2 = null;
        }
        ContentEntry phetParentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://phet.colorado.edu/", "Phet Interactive Simulations", "https://phet.colorado.edu/", PHET, 1, l2, null, "INTERACTIVE SIMULATIONS\nFOR SCIENCE AND MATH", false, "", "https://phet.colorado.edu/images/phet-social-media-logo.png", "", "", 0, contentEntryDao2);
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
        if (contentEntryParentChildJoinDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
            contentEntryParentChildJoinDao = null;
        }
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, masterRootParent, phetParentEntry, 14);
        for (Element simulation : simulationList) {
            File file;
            File file2;
            String thumbnail;
            String string;
            String simulationUrl;
            Element element = simulation.parent();
            String path = element == null ? null : element.attr("href");
            URL uRL = this.url;
            if (uRL == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"url");
                uRL = null;
            }
            String string2 = new URL(uRL, path).toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"URL(url, path).toString()");
            String string3 = simulationUrl = string2;
            int n = StringsKt.lastIndexOf$default((CharSequence)simulationUrl, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
            String string4 = string3.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            String title = string4;
            Element element2 = simulation.parent();
            if (element2 == null) {
                string = null;
            } else {
                Element element3 = element2.selectFirst("img");
                string = thumbnail = element3 == null ? null : element3.attr("src");
            }
            if ((file2 = this.destinationDirectory) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDirectory");
                file2 = null;
            }
            if ((file = this.containerDir) == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"containerDir");
                file = null;
            }
            PhetContentScraper scraper = new PhetContentScraper(simulationUrl, file2, file);
            try {
                LanguageVariantDao languageVariantDao;
                LanguageDao languageDao2;
                String string5;
                ContentEntryDao contentEntryDao3;
                Language language3;
                ContentEntryDao contentEntryDao4;
                scraper.scrapeContent();
                Language language4 = this.englishLang;
                if (language4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                    language4 = null;
                }
                long l3 = language4.getLangUid();
                String string6 = scraper.getAboutDescription();
                ContentEntryDao contentEntryDao5 = this.contentEntryDao;
                if (contentEntryDao5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                    contentEntryDao5 = null;
                }
                ContentEntry englishSimContentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(path, title, simulationUrl, PHET, 1, l3, null, string6, true, "", thumbnail, "", "", 0, contentEntryDao5);
                Boolean isEnglishUpdated = scraper.getLanguageUpdatedMap().get("en");
                File file3 = this.destinationDirectory;
                if (file3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDirectory");
                    file3 = null;
                }
                File enLangLocation = new File(file3, "en");
                File englishContentFile = new File(enLangLocation, title);
                Boolean bl = isEnglishUpdated;
                Intrinsics.checkNotNull((Object)bl);
                if (bl.booleanValue()) {
                    File file4;
                    UmAppDatabase umAppDatabase;
                    ContainerDao containerDao = this.containerDao;
                    if (containerDao == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"containerDao");
                        containerDao = null;
                    }
                    long l4 = englishContentFile.lastModified();
                    UmAppDatabase umAppDatabase2 = this.db;
                    if (umAppDatabase2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                        umAppDatabase2 = null;
                    }
                    if ((umAppDatabase = this.repository) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                        umAppDatabase = null;
                    }
                    if ((file4 = this.containerDir) == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"containerDir");
                        file4 = null;
                    }
                    ContentScraperUtil.INSTANCE.insertContainer(containerDao, englishSimContentEntry, true, "application/tincan+zip", l4, englishContentFile, umAppDatabase2, umAppDatabase, file4);
                    FileUtils.deleteDirectory((File)englishContentFile);
                }
                if ((contentEntryDao4 = this.contentEntryDao) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                    contentEntryDao4 = null;
                }
                if ((language3 = this.englishLang) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                    language3 = null;
                }
                ArrayList<ContentEntry> categoryList = scraper.getCategoryRelations(contentEntryDao4, language3);
                File file5 = this.destinationDirectory;
                if (file5 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDirectory");
                    file5 = null;
                }
                if ((contentEntryDao3 = this.contentEntryDao) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                    contentEntryDao3 = null;
                }
                if ((string5 = thumbnail) == null) {
                    string5 = "";
                }
                if ((languageDao2 = this.languageDao) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"languageDao");
                    languageDao2 = null;
                }
                if ((languageVariantDao = this.languageVariantDao) == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"languageVariantDao");
                    languageVariantDao = null;
                }
                ArrayList<ContentEntry> translationList = scraper.getTranslations(file5, contentEntryDao3, string5, languageDao2, languageVariantDao);
                int categoryCount = 0;
                for (ContentEntry category : categoryList) {
                    ContentEntryParentChildJoinDao contentEntryParentChildJoinDao2 = this.contentParentChildJoinDao;
                    if (contentEntryParentChildJoinDao2 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                        contentEntryParentChildJoinDao2 = null;
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)category, (String)"category");
                    int n2 = categoryCount;
                    categoryCount = n2 + 1;
                    ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao2, phetParentEntry, category, n2);
                    ContentEntryParentChildJoinDao contentEntryParentChildJoinDao3 = this.contentParentChildJoinDao;
                    if (contentEntryParentChildJoinDao3 == null) {
                        Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                        contentEntryParentChildJoinDao3 = null;
                    }
                    ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(contentEntryParentChildJoinDao3, category, englishSimContentEntry, 0);
                    int translationsCount = 1;
                    for (ContentEntry translation : translationList) {
                        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao4;
                        ContentEntryRelatedEntryJoinDao contentEntryRelatedEntryJoinDao = this.contentEntryRelatedJoinDao;
                        if (contentEntryRelatedEntryJoinDao == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryRelatedJoinDao");
                            contentEntryRelatedEntryJoinDao = null;
                        }
                        Intrinsics.checkNotNullExpressionValue((Object)translation, (String)"translation");
                        ContentScraperUtil.INSTANCE.insertOrUpdateRelatedContentJoin(contentEntryRelatedEntryJoinDao, translation, englishSimContentEntry, 1);
                        Map<Long, String> map = scraper.getContentEntryLangMap();
                        Intrinsics.checkNotNull(map);
                        String langCode = map.get(translation.getContentEntryUid());
                        File file6 = this.destinationDirectory;
                        if (file6 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"destinationDirectory");
                            file6 = null;
                        }
                        File langLocation = new File(file6, langCode);
                        File content = new File(langLocation, Intrinsics.stringPlus((String)title, (Object)".zip"));
                        Boolean bl2 = scraper.getLanguageUpdatedMap().get(langCode);
                        Intrinsics.checkNotNull((Object)bl2);
                        if (bl2.booleanValue()) {
                            File file7;
                            UmAppDatabase umAppDatabase;
                            ContainerDao containerDao = this.containerDao;
                            if (containerDao == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"containerDao");
                                containerDao = null;
                            }
                            long l5 = content.lastModified();
                            UmAppDatabase umAppDatabase3 = this.db;
                            if (umAppDatabase3 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                                umAppDatabase3 = null;
                            }
                            if ((umAppDatabase = this.repository) == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"repository");
                                umAppDatabase = null;
                            }
                            if ((file7 = this.containerDir) == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"containerDir");
                                file7 = null;
                            }
                            ContentScraperUtil.INSTANCE.insertContainer(containerDao, translation, true, "application/tincan+zip", l5, content, umAppDatabase3, umAppDatabase, file7);
                        }
                        if ((contentEntryParentChildJoinDao4 = this.contentParentChildJoinDao) == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                            contentEntryParentChildJoinDao4 = null;
                        }
                        int n3 = translationsCount;
                        translationsCount = n3 + 1;
                        ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(contentEntryParentChildJoinDao4, category, translation, n3);
                    }
                }
            }
            catch (Exception e) {
                String string7 = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string7);
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Failed to scrape Phet Content for url", (Object)simulationUrl));
            }
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0007\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/lib/contentscrapers/phetsimulation/IndexPhetContentScraper$Companion;", "", "()V", "PHET", "", "getPHET", "()Ljava/lang/String;", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPHET() {
            return PHET;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 3) {
                System.err.println("Usage: <phet html url> <file destination><file container><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 4 ? args[3] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            UMLogUtil.INSTANCE.logInfo(args[1]);
            try {
                new IndexPhetContentScraper().findContent(args[0], new File(args[1]), new File(args[2]));
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logFatal("Exception running findContent phet");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

