/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.phetsimulation;

import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.phetsimulation.IndexPhetContentScraper;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import java.io.File;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010$\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0010%\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u0000 32\u00020\u0001:\u00013B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\"\u0010!\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\"\u001a\u00020\u00032\b\u0010#\u001a\u0004\u0018\u00010\u0005H\u0002J\u001c\u0010$\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010&\u001a\u00020'2\u0006\u0010(\u001a\u00020)J\u0012\u0010*\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u000eJ4\u0010+\u001a\b\u0012\u0004\u0012\u00020%0\u001a2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010&\u001a\u00020'2\u0006\u0010,\u001a\u00020\u00032\u0006\u0010-\u001a\u00020.2\u0006\u0010/\u001a\u000200J\u0006\u00101\u001a\u000202R\"\u0010\t\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0010\u0010\f\u001a\u0004\u0018\u00010\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001f\u0010\r\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u0003\u0018\u00010\u0013X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00150\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0011R\u001a\u0010\u0018\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00030\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\u001cX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001d\u001a\u00020\u001eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u001f\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u000bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lcom/ustadmobile/lib/contentscrapers/phetsimulation/PhetContentScraper;", "", "url", "", "destinationDirectory", "Ljava/io/File;", "containerDir", "(Ljava/lang/String;Ljava/io/File;Ljava/io/File;)V", "<set-?>", "aboutDescription", "getAboutDescription", "()Ljava/lang/String;", "aboutText", "contentEntryLangMap", "", "", "getContentEntryLangMap", "()Ljava/util/Map;", "langIdMap", "", "languageMapUpdate", "", "languageUpdatedMap", "getLanguageUpdatedMap", "languageUrlMap", "langugageList", "Ljava/util/ArrayList;", "simulationDoc", "Lorg/jsoup/nodes/Document;", "simulationUrl", "Ljava/net/URL;", "title", "getTitle", "downloadContent", "hrefLink", "languageLocation", "getCategoryRelations", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "language", "Lcom/ustadmobile/lib/db/entities/Language;", "getLanguageUrlMap", "getTranslations", "thumbnailUrl", "languageDao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "languageVariantDao", "Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "scrapeContent", "", "Companion", "lib-content-scrapers"})
public final class PhetContentScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String url;
    @NotNull
    private final File destinationDirectory;
    @NotNull
    private final File containerDir;
    @NotNull
    private final String title;
    private Document simulationDoc;
    @Nullable
    private String aboutText;
    @NotNull
    private final ArrayList<String> langugageList;
    @NotNull
    private final Map<String, Boolean> languageMapUpdate;
    @NotNull
    private final Map<String, String> languageUrlMap;
    @Nullable
    private Map<Long, String> langIdMap;
    @Nullable
    private String aboutDescription;
    private URL simulationUrl;
    @NotNull
    private static final String[] CATEGORY;

    public PhetContentScraper(@NotNull String url, @NotNull File destinationDirectory, @NotNull File containerDir) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        this.url = url;
        this.destinationDirectory = destinationDirectory;
        this.containerDir = containerDir;
        this.langugageList = new ArrayList();
        this.languageMapUpdate = new HashMap();
        this.languageUrlMap = new HashMap();
        String string = this.url.substring(StringsKt.lastIndexOf$default((CharSequence)this.url, (String)"/", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        this.title = string;
    }

    @NotNull
    public final String getTitle() {
        return this.title;
    }

    @Nullable
    public final String getAboutDescription() {
        return this.aboutDescription;
    }

    @NotNull
    public final Map<String, Boolean> getLanguageUpdatedMap() {
        return this.languageMapUpdate;
    }

    @Nullable
    public final Map<Long, String> getContentEntryLangMap() {
        return this.langIdMap;
    }

    public final void scrapeContent() throws IOException {
        this.simulationUrl = new URL(this.url);
        this.destinationDirectory.mkdirs();
        Document document2 = Jsoup.connect((String)this.url).get();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"connect(url).get()");
        this.simulationDoc = document2;
        Document document3 = this.simulationDoc;
        if (document3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
            document3 = null;
        }
        if (!document3.select("div.simulation-main-image-panel a span").hasClass("html-badge")) {
            URL uRL = this.simulationUrl;
            if (uRL == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                uRL = null;
            }
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"File Type not supported for url ", (Object)uRL));
        }
        Document document4 = this.simulationDoc;
        if (document4 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
            document4 = null;
        }
        Element element = document4.getElementById("about");
        String string = this.aboutText = element == null ? null : element.html();
        Intrinsics.checkNotNull((Object)string);
        this.aboutDescription = Jsoup.parse((String)string).select("p.simulation-panel-indent").text();
        boolean contentUpdated = false;
        Document document5 = this.simulationDoc;
        if (document5 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
            document5 = null;
        }
        for (Element englishLink : document5.select("div.simulation-main-image-panel a.phet-button[href]")) {
            String hrefLink = englishLink.attr("href");
            File englishLocation = new File(this.destinationDirectory, "en");
            englishLocation.mkdirs();
            Intrinsics.checkNotNullExpressionValue((Object)hrefLink, (String)"hrefLink");
            if (!StringsKt.contains$default((CharSequence)hrefLink, (CharSequence)"download", (boolean)false, (int)2, null)) continue;
            URL uRL = this.simulationUrl;
            if (uRL == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                uRL = null;
            }
            contentUpdated = this.downloadContent(uRL, hrefLink, englishLocation);
            Map<String, Object> map = this.languageMapUpdate;
            String string2 = englishLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"englishLocation.name");
            Object object = contentUpdated;
            map.put(string2, (Boolean)object);
            map = this.languageUrlMap;
            string2 = englishLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"englishLocation.name");
            object = hrefLink;
            map.put(string2, (Boolean)object);
            break;
        }
        File languageLocation = null;
        Document document6 = this.simulationDoc;
        if (document6 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
            document6 = null;
        }
        block1: for (Element translations : document6.select("table.phet-table tr")) {
            Object object;
            Map<String, String> map;
            String hrefLink;
            for (Element langs : translations.select("td.list-highlight-background a[href]")) {
                hrefLink = langs.attr("href");
                Intrinsics.checkNotNullExpressionValue((Object)hrefLink, (String)"hrefLink");
                if (!StringsKt.contains$default((CharSequence)hrefLink, (CharSequence)"translated", (boolean)false, (int)2, null)) continue;
                map = hrefLink;
                int n = StringsKt.lastIndexOf$default((CharSequence)hrefLink, (String)"/", (int)0, (boolean)false, (int)6, null) + 1;
                object = ((String)((Object)map)).substring(n);
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String).substring(startIndex)");
                String langCode = object;
                this.langugageList.add(langCode);
                languageLocation = new File(this.destinationDirectory, langCode);
                languageLocation.mkdirs();
                break;
            }
            for (Element links : translations.select("td.img-container a[href]")) {
                hrefLink = links.attr("href");
                Intrinsics.checkNotNullExpressionValue((Object)hrefLink, (String)"hrefLink");
                if (!StringsKt.contains$default((CharSequence)hrefLink, (CharSequence)"download", (boolean)false, (int)2, null)) continue;
                URL uRL = this.simulationUrl;
                if (uRL == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                    uRL = null;
                }
                boolean isLanguageUpdated = this.downloadContent(uRL, hrefLink, languageLocation);
                map = this.languageMapUpdate;
                File file = languageLocation;
                Intrinsics.checkNotNull(file);
                String string3 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"languageLocation!!.name");
                object = isLanguageUpdated;
                map.put(string3, (String)object);
                map = this.languageUrlMap;
                string3 = languageLocation.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"languageLocation.name");
                object = hrefLink;
                map.put(string3, (String)object);
                continue block1;
            }
        }
    }

    @NotNull
    public final Map<String, String> getLanguageUrlMap() {
        return this.languageUrlMap;
    }

    @NotNull
    public final ArrayList<ContentEntry> getCategoryRelations(@NotNull ContentEntryDao contentEntryDao, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        Document document2 = this.simulationDoc;
        if (document2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
            document2 = null;
        }
        Elements selected = document2.select("ul.nav-ul div.link-holder span.selected");
        ArrayList<ContentEntry> categoryRelations = new ArrayList<ContentEntry>();
        for (Element category : selected) {
            if (!((Stream)Arrays.stream(CATEGORY).parallel()).noneMatch(arg_0 -> PhetContentScraper.getCategoryRelations$lambda-0(category, arg_0))) continue;
            try {
                String categoryName = category.text();
                Element element = category.parent();
                String path = element == null ? null : element.attr("href");
                URL uRL = this.simulationUrl;
                if (uRL == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                    uRL = null;
                }
                String string = new URL(uRL, path).toString();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URL(simulationUrl, path).toString()");
                ContentEntry categoryContentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(path, categoryName, string, IndexPhetContentScraper.Companion.getPHET(), 1, language.getLangUid(), null, "", false, "", "", "", "", 0, contentEntryDao);
                categoryRelations.add(categoryContentEntry);
            }
            catch (IOException ie) {
                StringBuilder stringBuilder = new StringBuilder().append("Error creating category entry").append((Object)category.text()).append(" for url");
                URL uRL = this.simulationUrl;
                if (uRL == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                    uRL = null;
                }
                UMLogUtil.INSTANCE.logError(stringBuilder.append(uRL).toString());
            }
        }
        return categoryRelations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean downloadContent(URL simulationUrl, String hrefLink, File languageLocation) {
        block14: {
            Object link;
            HttpURLConnection conn = null;
            String fileName = null;
            try {
                link = new URL(simulationUrl, hrefLink);
                File simulationLocation = new File(languageLocation, this.title);
                simulationLocation.mkdirs();
                URLConnection uRLConnection = ((URL)link).openConnection();
                if (uRLConnection == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.net.HttpURLConnection");
                }
                conn = (HttpURLConnection)uRLConnection;
                conn.setRequestMethod("HEAD");
                Object object = hrefLink.substring(StringsKt.lastIndexOf$default((CharSequence)hrefLink, (String)"/", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)hrefLink, (String)"?", (int)0, (boolean)false, (int)6, null));
                Intrinsics.checkNotNullExpressionValue((Object)object, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
                fileName = object;
                File simulationFile = new File(simulationLocation, fileName);
                URLConnection uRLConnection2 = conn;
                File file = languageLocation;
                Intrinsics.checkNotNull((Object)file);
                boolean isUpdated = ContentScraperUtil.INSTANCE.isFileModified(uRLConnection2, file, fileName);
                if (!isUpdated) {
                    boolean bl = false;
                    object = conn;
                    ((HttpURLConnection)object).disconnect();
                    return bl;
                }
                if (ContentScraperUtil.INSTANCE.fileHasContent(simulationLocation)) {
                    FileUtils.deleteDirectory((File)simulationLocation);
                    simulationLocation.mkdirs();
                }
                FileUtils.writeStringToFile((File)new File(simulationLocation, "about.txt"), (String)this.aboutText, (String)"UTF-8");
                FileUtils.copyURLToFile((URL)link, (File)simulationFile);
                String simulationTitle = Jsoup.parse((File)simulationFile, (String)"UTF-8").title();
                try {
                    Intrinsics.checkNotNullExpressionValue((Object)simulationTitle, (String)"simulationTitle");
                    object = languageLocation.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)object, (String)"languageLocation!!.name");
                    String string = languageLocation.getName() + '\\' + this.title;
                    String string2 = this.aboutDescription;
                    Intrinsics.checkNotNull((Object)string2);
                    ContentScraperUtil.INSTANCE.generateTinCanXMLFile(simulationLocation, simulationTitle, (String)object, fileName, "http://adlnet.gov/expapi/activities/simulation", string, string2, "en");
                }
                catch (ParserConfigurationException e) {
                    String string = ExceptionUtils.getStackTrace((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                    UMLogUtil.INSTANCE.logError(string);
                    UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Tin can file not created for ", (Object)link));
                }
                catch (TransformerException e) {
                    String string = ExceptionUtils.getStackTrace((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                    UMLogUtil.INSTANCE.logError(string);
                    UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Tin can file not created for ", (Object)link));
                }
                link = conn;
            }
            catch (Exception e) {
                UMLogUtil.INSTANCE.logError("Error download content for url " + simulationUrl + " with href " + hrefLink);
                if (fileName != null) {
                    File file = languageLocation;
                    Intrinsics.checkNotNull((Object)file);
                    ContentScraperUtil.INSTANCE.deleteETagOrModified(file, fileName);
                }
                break block14;
            }
            finally {
                HttpURLConnection httpURLConnection = conn;
                if (httpURLConnection != null) {
                    httpURLConnection.disconnect();
                }
            }
            ((HttpURLConnection)link).disconnect();
        }
        return true;
    }

    @NotNull
    public final ArrayList<ContentEntry> getTranslations(@NotNull File destinationDirectory, @NotNull ContentEntryDao contentEntryDao, @NotNull String thumbnailUrl, @NotNull LanguageDao languageDao, @NotNull LanguageVariantDao languageVariantDao) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
        Intrinsics.checkNotNullParameter((Object)thumbnailUrl, (String)"thumbnailUrl");
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)languageVariantDao, (String)"languageVariantDao");
        ArrayList<ContentEntry> translationsEntry = new ArrayList<ContentEntry>();
        this.langIdMap = new HashMap();
        File[] fileArray = destinationDirectory.listFiles();
        Intrinsics.checkNotNull((Object)fileArray);
        File[] fileArray2 = fileArray;
        int n = 0;
        int n2 = fileArray2.length;
        while (n < n2) {
            File[] fileArray3;
            String langCode;
            File translationDir = fileArray2[n];
            ++n;
            if (!translationDir.isDirectory() || !this.langugageList.contains(langCode = translationDir.getName())) continue;
            Intrinsics.checkNotNull((Object)translationDir.listFiles());
            int n3 = 0;
            int n4 = fileArray3.length;
            block3: while (n3 < n4) {
                File[] fileArray4;
                File contentDirectory = fileArray3[n3];
                ++n3;
                if (!StringsKt.equals((String)this.title, (String)contentDirectory.getName(), (boolean)true)) continue;
                Intrinsics.checkNotNull((Object)contentDirectory.listFiles());
                for (File file : fileArray4) {
                    String string = file.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"file.name");
                    if (!StringsKt.endsWith$default((String)string, (String)".html", (boolean)false, (int)2, null)) continue;
                    try {
                        Document document2 = this.simulationDoc;
                        if (document2 == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationDoc");
                            document2 = null;
                        }
                        Element element = document2.selectFirst("td a[href*=_" + langCode + "] span");
                        String langTitle = element == null ? null : element.text();
                        URL uRL = this.simulationUrl;
                        if (uRL == null) {
                            Intrinsics.throwUninitializedPropertyAccessException((String)"simulationUrl");
                            uRL = null;
                        }
                        String string2 = uRL.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"simulationUrl!!.toString()");
                        String path = StringsKt.replace$default((String)string2, (String)"/en/", (String)('/' + langCode + '/'), (boolean)false, (int)4, null);
                        URL translationUrl = new URL(path);
                        Intrinsics.checkNotNullExpressionValue((Object)langCode, (String)"langCode");
                        String[] stringArray = new String[]{"-"};
                        List country = StringsKt.split$default((CharSequence)StringsKt.replace$default((String)langCode, (String)"_", (String)"-", (boolean)false, (int)4, null), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                        String lang = (String)country.get(0);
                        String variant = country.size() > 1 ? (String)country.get(1) : "";
                        Language language = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao, lang);
                        LanguageVariant languageVariant = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageVariant(languageVariantDao, variant, language);
                        String string3 = translationUrl.getPath();
                        String string4 = translationUrl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"translationUrl.toString()");
                        LanguageVariant languageVariant2 = languageVariant;
                        ContentEntry languageContentEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string3, langTitle, string4, IndexPhetContentScraper.Companion.getPHET(), 1, language.getLangUid(), languageVariant2 == null ? null : Long.valueOf(languageVariant2.getLangVariantUid()), this.aboutDescription, true, "", thumbnailUrl, "", "", 0, contentEntryDao);
                        Map<Long, String> map = this.langIdMap;
                        Intrinsics.checkNotNull(map);
                        map.put(languageContentEntry.getContentEntryUid(), langCode);
                        translationsEntry.add(languageContentEntry);
                        continue block3;
                    }
                    catch (Exception e) {
                        UMLogUtil.INSTANCE.logError("Error while creating a entry for translated content lang code " + langCode + " in phet url " + this.url);
                    }
                }
            }
        }
        return translationsEntry;
    }

    private static final boolean getCategoryRelations$lambda-0(Element $category, String it) {
        String string = $category.text();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"category.text()");
        CharSequence charSequence = string;
        Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
        return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)it, (boolean)false, (int)2, null);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    static {
        String[] stringArray = new String[]{"iPad/Tablet", "New Sims", "Simulations", "HTML5"};
        CATEGORY = stringArray;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\t\u001a\u00020\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0002\u0010\fR\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/lib/contentscrapers/phetsimulation/PhetContentScraper$Companion;", "", "()V", "CATEGORY", "", "", "getCATEGORY", "()[Ljava/lang/String;", "[Ljava/lang/String;", "main", "", "args", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String[] getCATEGORY() {
            return CATEGORY;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 3) {
                System.err.println("Usage: <phet html url> <file destination><file container><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 4 ? args[3] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            UMLogUtil.INSTANCE.logInfo(args[1]);
            try {
                new PhetContentScraper(args[0], new File(args[1]), new File(args[2])).scrapeContent();
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError("Exception running scrapeContent phet");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

