/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.ck12;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.LogIndex;
import com.ustadmobile.lib.contentscrapers.LogResponse;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.ck12.CK12ContentScraper;
import com.ustadmobile.lib.contentscrapers.ck12.plix.PlixResponse;
import com.ustadmobile.lib.contentscrapers.ck12.practice.AnswerResponse;
import com.ustadmobile.lib.contentscrapers.ck12.practice.PracticeResponse;
import com.ustadmobile.lib.contentscrapers.ck12.practice.QuestionResponse;
import com.ustadmobile.lib.contentscrapers.ck12.practice.ScriptEngineReader;
import com.ustadmobile.lib.contentscrapers.ck12.practice.TestResponse;
import com.ustadmobile.lib.contentscrapers.harscraper.HarScraperKt;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import kotlin.text.StringsKt;
import net.lightbody.bmp.BrowserMobProxyServer;
import net.lightbody.bmp.core.har.HarEntry;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.logging.LogEntry;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0016\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010!\n\u0002\u0010\u0000\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\n\u0018\u0000 o2\u00020\u0001:\u0001oB5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ\b\u0010@\u001a\u00020\nH\u0002J\b\u0010A\u001a\u00020\nH\u0002J,\u0010B\u001a\b\u0012\u0004\u0012\u00020D0C2\f\u0010E\u001a\b\u0012\u0004\u0012\u00020D0C2\u0006\u0010F\u001a\u00020\u00052\u0006\u0010G\u001a\u00020\u0003H\u0002J\u000e\u0010H\u001a\u00020\n2\u0006\u0010I\u001a\u00020\nJ\u000e\u0010J\u001a\u00020\n2\u0006\u0010K\u001a\u00020\nJ\u000e\u0010L\u001a\u00020\n2\u0006\u0010M\u001a\u00020\nJ\"\u0010N\u001a\u00020\n2\b\u0010O\u001a\u0004\u0018\u00010\n2\b\u0010P\u001a\u0004\u0018\u00010\n2\u0006\u0010Q\u001a\u00020\fJ\u0010\u0010R\u001a\u00020\n2\b\u0010O\u001a\u0004\u0018\u00010\nJ\u0010\u0010S\u001a\u00020\n2\u0006\u0010T\u001a\u00020UH\u0002J\u0010\u0010V\u001a\u00020W2\u0006\u0010X\u001a\u00020UH\u0002J\"\u0010Y\u001a\u0004\u0018\u00010U2\u0006\u0010Z\u001a\u00020U2\u0006\u0010[\u001a\u00020\n2\u0006\u0010\\\u001a\u00020\nH\u0002J\u0010\u0010]\u001a\u00020\n2\u0006\u0010T\u001a\u00020UH\u0002J\u0012\u0010^\u001a\u0004\u0018\u00010\n2\u0006\u0010_\u001a\u00020UH\u0002J\u0010\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020UH\u0002J\u0012\u0010c\u001a\u00020\n2\b\u0010d\u001a\u0004\u0018\u00010\nH\u0002J\b\u0010e\u001a\u00020fH\u0016J\u000e\u0010g\u001a\u00020f2\u0006\u0010h\u001a\u00020\u0005J\u000e\u0010i\u001a\u00020f2\u0006\u0010h\u001a\u00020\u0005J\u0016\u0010j\u001a\u00020f2\u0006\u0010k\u001a\u00020\u00052\u0006\u0010l\u001a\u00020\u0003J\u000e\u0010m\u001a\u00020f2\u0006\u0010k\u001a\u00020\u0005J\u000e\u0010n\u001a\u00020f2\u0006\u0010k\u001a\u00020\u0005R\u000e\u0010\u000e\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0014\u0010\u0015\"\u0004\b\u0016\u0010\u0017R\u0014\u0010\u0018\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0015R\u001a\u0010\u0004\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u0011\"\u0004\b\u001b\u0010\u0013R\u001e\u0010\u001e\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u001a\u0010\u0007\u001a\u00020\bX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b%\u0010\u0015\"\u0004\b&\u0010\u0017R\u000e\u0010'\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010(\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010\u0015\"\u0004\b*\u0010\u0017R\u000e\u0010+\u001a\u00020\nX\u0082D\u00a2\u0006\u0002\n\u0000R\u001a\u0010,\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b-\u0010\u0015\"\u0004\b.\u0010\u0017R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b/\u00100\"\u0004\b1\u00102R\u001a\u00103\u001a\u000204X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b5\u00106\"\u0004\b7\u00108R\u001a\u0010\u000b\u001a\u00020\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b9\u0010:\"\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020\nX\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b>\u0010\u0015\"\u0004\b?\u0010\u0017\u00a8\u0006p"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ck12/CK12ContentScraper;", "Ljava/lang/Runnable;", "scrapeUrl", "Ljava/net/URL;", "destLocation", "Ljava/io/File;", "containerDir", "parentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "contentType", "", "sqiUid", "", "(Ljava/net/URL;Ljava/io/File;Ljava/io/File;Lcom/ustadmobile/lib/db/entities/ContentEntry;Ljava/lang/String;I)V", "POLICIES", "assetDirectory", "getContainerDir", "()Ljava/io/File;", "setContainerDir", "(Ljava/io/File;)V", "getContentType", "()Ljava/lang/String;", "setContentType", "(Ljava/lang/String;)V", "css", "getCss", "getDestLocation", "setDestLocation", "<set-?>", "", "isContentUpdated", "()Z", "getParentEntry", "()Lcom/ustadmobile/lib/db/entities/ContentEntry;", "setParentEntry", "(Lcom/ustadmobile/lib/db/entities/ContentEntry;)V", "plixLink", "getPlixLink$lib_content_scrapers", "setPlixLink$lib_content_scrapers", "postfix", "practiceIdLink", "getPracticeIdLink$lib_content_scrapers", "setPracticeIdLink$lib_content_scrapers", "practicePost", "questionLinkId", "getQuestionLinkId$lib_content_scrapers", "setQuestionLinkId$lib_content_scrapers", "getScrapeUrl", "()Ljava/net/URL;", "setScrapeUrl", "(Ljava/net/URL;)V", "scriptEngineReader", "Lcom/ustadmobile/lib/contentscrapers/ck12/practice/ScriptEngineReader;", "getScriptEngineReader", "()Lcom/ustadmobile/lib/contentscrapers/ck12/practice/ScriptEngineReader;", "setScriptEngineReader", "(Lcom/ustadmobile/lib/contentscrapers/ck12/practice/ScriptEngineReader;)V", "getSqiUid", "()I", "setSqiUid", "(I)V", "startTestLink", "getStartTestLink$lib_content_scrapers", "setStartTestLink$lib_content_scrapers", "appendMathJax", "appendMathJaxScript", "downloadAllResourcesFromAnswer", "", "", "answer", "questionAsset", "scrapUrl", "extractAnswerFromEncryption", "data", "generatePlixLink", "id", "generatePracticeLink", "url", "generateQuestionUrl", "testId", "testScoreId", "count", "generateTestUrl", "getDetailSectionHtml", "section", "Lorg/jsoup/nodes/Document;", "getIframefromHtml", "Lorg/jsoup/select/Elements;", "videoContent", "getMainContent", "document", "htmlTag", "search", "getTitleHtml", "getVocabHtml", "site", "isPageUpdated", "", "doc", "removeAllHref", "html", "run", "", "scrapeFlexBookContent", "content", "scrapePlixContent", "scrapePracticeContent", "destination", "startingUrl", "scrapeReadContent", "scrapeVideoContent", "Companion", "lib-content-scrapers"})
public final class CK12ContentScraper
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private URL scrapeUrl;
    @NotNull
    private File destLocation;
    @NotNull
    private File containerDir;
    @NotNull
    private ContentEntry parentEntry;
    @NotNull
    private String contentType;
    private int sqiUid;
    private File assetDirectory;
    @NotNull
    private final String css;
    @NotNull
    private final String postfix;
    @NotNull
    private final String POLICIES;
    @NotNull
    private final String practicePost;
    @NotNull
    private String practiceIdLink;
    @NotNull
    private String startTestLink;
    @NotNull
    private String questionLinkId;
    @NotNull
    private String plixLink;
    @NotNull
    private ScriptEngineReader scriptEngineReader;
    private boolean isContentUpdated;
    @NotNull
    public static final String RESPONSE_RECEIVED = "Network.responseReceived";
    @NotNull
    public static final String REQUEST_SENT = "Network.requestWillBeSent";

    public CK12ContentScraper(@NotNull URL scrapeUrl2, @NotNull File destLocation, @NotNull File containerDir, @NotNull ContentEntry parentEntry, @NotNull String contentType, int sqiUid) throws MalformedURLException {
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destLocation, (String)"destLocation");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Intrinsics.checkNotNullParameter((Object)parentEntry, (String)"parentEntry");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.scrapeUrl = scrapeUrl2;
        this.destLocation = destLocation;
        this.containerDir = containerDir;
        this.parentEntry = parentEntry;
        this.contentType = contentType;
        this.sqiUid = sqiUid;
        this.css = "<style> .read-more-container { display: none; } #plixIFrameContainer { float: left !important; margin-top: 15px; } #plixLeftWrapper { float: left !important; width: 49%; min-width: 200px; padding-left: 15px !important; padding-right: 15px !important; margin-right: 15px; } @media (max-width: 1070px) { #plixLeftWrapper { width: 98% !important; } } .plixQestionPlayer, .plixLeftMiddlequestionContainer { margin-bottom: 5px !important; } .leftTopFixedBar { padding-top: 20px !important; } #next-container { margin-top: 0 !important; } .overflow-container { background: transparent !important; width: 0px !important; } .overflow-indicator { left: 50% !important; padding: 12px !important; } .plixWrapper { width: 95% !important; max-width: inherit !important; } body.plix-modal { overflow: auto !important; padding: 0; width: 95% !important; height: inherit !important; } .show-description, .show-challenge { position: static !important; padding-top: 0 !important; } #hintModal { width: 90% !important; margin-left: -45% !important; } @media only screen and (max-device-width: 605px), only screen and (max-device-height: 605px) { #landscapeView { display: block !important; } } </style>";
        this.postfix = "?hints=true&evalData=true";
        this.POLICIES = "?policies=[{\"name\":\"shuffle\",\"value\":false},{\"name\":\"shuffle_question_options\",\"value\":false},{\"name\":\"max_questions\",\"value\":15},{\"name\":\"adaptive\",\"value\":false}]";
        this.practicePost = "?nextPractice=true&adaptive=true&checkUserLogin=false";
        this.practiceIdLink = "https://www.ck12.org/assessment/api/get/info/test/practice/";
        this.startTestLink = "https://www.ck12.org/assessment/api/start/test/";
        this.questionLinkId = "https://www.ck12.org/assessment/api/render/questionInstance/test/";
        this.plixLink = "https://www.ck12.org/assessment/api/get/info/question/";
        this.scriptEngineReader = new ScriptEngineReader();
        this.isContentUpdated = true;
    }

    @NotNull
    public final URL getScrapeUrl() {
        return this.scrapeUrl;
    }

    public final void setScrapeUrl(@NotNull URL uRL) {
        Intrinsics.checkNotNullParameter((Object)uRL, (String)"<set-?>");
        this.scrapeUrl = uRL;
    }

    @NotNull
    public final File getDestLocation() {
        return this.destLocation;
    }

    public final void setDestLocation(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.destLocation = file;
    }

    @NotNull
    public final File getContainerDir() {
        return this.containerDir;
    }

    public final void setContainerDir(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"<set-?>");
        this.containerDir = file;
    }

    @NotNull
    public final ContentEntry getParentEntry() {
        return this.parentEntry;
    }

    public final void setParentEntry(@NotNull ContentEntry contentEntry) {
        Intrinsics.checkNotNullParameter((Object)contentEntry, (String)"<set-?>");
        this.parentEntry = contentEntry;
    }

    @NotNull
    public final String getContentType() {
        return this.contentType;
    }

    public final void setContentType(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.contentType = string;
    }

    public final int getSqiUid() {
        return this.sqiUid;
    }

    public final void setSqiUid(int n) {
        this.sqiUid = n;
    }

    @NotNull
    public final String getCss() {
        return this.css;
    }

    @NotNull
    public final String getPracticeIdLink$lib_content_scrapers() {
        return this.practiceIdLink;
    }

    public final void setPracticeIdLink$lib_content_scrapers(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.practiceIdLink = string;
    }

    @NotNull
    public final String getStartTestLink$lib_content_scrapers() {
        return this.startTestLink;
    }

    public final void setStartTestLink$lib_content_scrapers(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.startTestLink = string;
    }

    @NotNull
    public final String getQuestionLinkId$lib_content_scrapers() {
        return this.questionLinkId;
    }

    public final void setQuestionLinkId$lib_content_scrapers(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.questionLinkId = string;
    }

    @NotNull
    public final String getPlixLink$lib_content_scrapers() {
        return this.plixLink;
    }

    public final void setPlixLink$lib_content_scrapers(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.plixLink = string;
    }

    @NotNull
    public final ScriptEngineReader getScriptEngineReader() {
        return this.scriptEngineReader;
    }

    public final void setScriptEngineReader(@NotNull ScriptEngineReader scriptEngineReader) {
        Intrinsics.checkNotNullParameter((Object)scriptEngineReader, (String)"<set-?>");
        this.scriptEngineReader = scriptEngineReader;
    }

    public final boolean isContentUpdated() {
        return this.isContentUpdated;
    }

    @Override
    public void run() {
        UmAppDatabase db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        UmAppDatabase repository = null;
        ContainerDao containerDao = repository.getContainerDao();
        ScrapeQueueItemDao queueDao = db.getScrapeQueueItemDao();
        long startTime = System.currentTimeMillis();
        UMLogUtil.INSTANCE.logInfo("Started scraper url " + this.scrapeUrl + " at start time: " + startTime + " with squUid " + this.sqiUid);
        queueDao.setTimeStarted(this.sqiUid, startTime);
        boolean successful = false;
        try {
            File content = new File(this.destLocation, this.destLocation.getName());
            String mimeType = "application/tincan+zip";
            switch (this.contentType) {
                case "video": {
                    content = new File(this.destLocation, Intrinsics.stringPlus((String)this.destLocation.getName(), (Object)".mp4"));
                    this.scrapeVideoContent(content);
                    mimeType = "video/mp4";
                    successful = true;
                    break;
                }
                case "plix": {
                    this.scrapePlixContent(content);
                    mimeType = "application/webchunk+zip";
                    successful = true;
                    break;
                }
                case "read": 
                case "real world": 
                case "activities": 
                case "lesson plans": 
                case "study aids": {
                    this.scrapeReadContent(content);
                    successful = true;
                    break;
                }
                case "practice": {
                    this.scrapePracticeContent(content, this.scrapeUrl);
                    successful = true;
                    break;
                }
                default: {
                    UMLogUtil.INSTANCE.logError("unsupported kind = " + this.contentType + " at url = " + this.scrapeUrl);
                    queueDao.updateSetStatusById(this.sqiUid, 4, 0);
                    queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
                    File modifiedFile = new File(this.destLocation, Intrinsics.stringPlus((String)this.destLocation.getName(), (Object)"last-modified.txt"));
                    FileUtils.deleteQuietly((File)modifiedFile);
                    throw new IllegalArgumentException("unsupported kind = " + this.contentType + " at url = " + this.scrapeUrl);
                }
            }
            if (this.isContentUpdated) {
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, this.parentEntry, true, mimeType, content.lastModified(), content, db, repository, this.containerDir);
            }
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Unable to scrape content from url ", (Object)this.scrapeUrl));
            string = this.destLocation.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"destLocation.name");
            ContentScraperUtil.INSTANCE.deleteETagOrModified(this.destLocation, string);
        }
        queueDao.updateSetStatusById(this.sqiUid, successful ? 3 : 4, 0);
        queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
        long duration = System.currentTimeMillis() - startTime;
        UMLogUtil.INSTANCE.logInfo("Ended scrape for url " + this.scrapeUrl + " in duration: " + duration + " squUid  " + this.sqiUid);
    }

    public final void scrapePlixContent(@NotNull File content) throws IOException {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        String string = this.scrapeUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scrapeUrl.toString()");
        String urlString = string;
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String string2 = urlString.substring(StringsKt.lastIndexOf$default((CharSequence)urlString, (String)"-", (int)0, (boolean)false, (int)6, null) + 1, StringsKt.lastIndexOf$default((CharSequence)urlString, (String)"?", (int)0, (boolean)false, (int)6, null));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
        String plixId = string2;
        content.mkdirs();
        String plixUrl = this.generatePlixLink(plixId);
        PlixResponse response = (PlixResponse)gson.fromJson(IOUtils.toString((URL)new URL(plixUrl), (String)"UTF-8"), PlixResponse.class);
        File fileLastModified = new File(this.destLocation, Intrinsics.stringPlus((String)content.getName(), (Object)"last-modified.txt"));
        PlixResponse.Response response2 = response.getResponse();
        Intrinsics.checkNotNull((Object)response2);
        PlixResponse.Question question = response2.getQuestion();
        Intrinsics.checkNotNull((Object)question);
        String string3 = question.getUpdated();
        Intrinsics.checkNotNull((Object)string3);
        this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated(fileLastModified, String.valueOf(ContentScraperUtil.INSTANCE.parseServerDate(string3)));
        if (!this.isContentUpdated) {
            return;
        }
        ContentScraperUtil.INSTANCE.setChromeDriverLocation();
        ChromeDriver driver = ContentScraperUtil.INSTANCE.setupLogIndexChromeDriver();
        driver.get(this.scrapeUrl.toString());
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
        try {
            ((WebElement)waitDriver.until((Function)ExpectedConditions.visibilityOfElementLocated((By)By.cssSelector((String)"div#questionController")))).click();
        }
        catch (Exception e) {
            String string4 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string4);
        }
        List<LogEntry> les = ContentScraperUtil.INSTANCE.waitForNewFiles(driver);
        Set cookieList = driver.manage().getCookies();
        driver.close();
        driver.quit();
        ArrayList<LogIndex.IndexEntry> indexList = new ArrayList<LogIndex.IndexEntry>();
        for (LogEntry le : les) {
            LogResponse log = (LogResponse)gson.fromJson(le.getMessage(), LogResponse.class);
            LogResponse.Message message = log.getMessage();
            Intrinsics.checkNotNull((Object)message);
            String string5 = message.getMethod();
            Intrinsics.checkNotNull((Object)string5);
            if (!StringsKt.equals((String)RESPONSE_RECEIVED, (String)string5, (boolean)true)) continue;
            LogResponse.Message message2 = log.getMessage();
            Intrinsics.checkNotNull((Object)message2);
            LogResponse.Message.Params params = message2.getParams();
            Intrinsics.checkNotNull((Object)params);
            LogResponse.Message.Params.Response response3 = params.getResponse();
            Intrinsics.checkNotNull((Object)response3);
            String mimeType = response3.getMimeType();
            LogResponse.Message message3 = log.getMessage();
            Intrinsics.checkNotNull((Object)message3);
            LogResponse.Message.Params params2 = message3.getParams();
            Intrinsics.checkNotNull((Object)params2);
            LogResponse.Message.Params.Response response4 = params2.getResponse();
            Intrinsics.checkNotNull((Object)response4);
            String urlString2 = response4.getUrl();
            try {
                String string6;
                String plixJs;
                String string7 = urlString2;
                Intrinsics.checkNotNull((Object)string7);
                URL url = new URL(string7);
                File urlDirectory = ContentScraperUtil.INSTANCE.createDirectoryFromUrl(content, url);
                Intrinsics.checkNotNullExpressionValue((Object)cookieList, (String)"cookieList");
                String cookies = ContentScraperUtil.INSTANCE.returnListOfCookies(urlString2, cookieList);
                File file = ContentScraperUtil.INSTANCE.downloadFileFromLogIndex(url, urlDirectory, log, cookies);
                String string8 = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"file.name");
                if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"plix.js", (boolean)false, (int)2, null)) {
                    String string9 = plixJs = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"plixJs");
                    if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"\"trialscount.plix.\"", (boolean)false, (int)2, null)) {
                        String string10 = plixJs;
                        Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"plixJs");
                        int startIndex = StringsKt.indexOf$default((CharSequence)string10, (String)"\"trialscount.plix.\"", (int)0, (boolean)false, (int)6, null);
                        string6 = plixJs;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"plixJs");
                        int lastIndex = StringsKt.lastIndexOf$default((CharSequence)string6, (String)"():", (int)0, (boolean)false, (int)6, null);
                        plixJs = new StringBuilder(plixJs).insert(lastIndex + 3, "*/").insert(startIndex, "/*").toString();
                        FileUtils.writeStringToFile((File)file, (String)plixJs, (String)"UTF-8");
                    }
                }
                plixJs = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)plixJs, (String)"file.name");
                if (StringsKt.contains$default((CharSequence)plixJs, (CharSequence)"plix.css", (boolean)false, (int)2, null)) {
                    String startIndex = plixJs = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    Intrinsics.checkNotNullExpressionValue((Object)startIndex, (String)"plixJs");
                    if (StringsKt.contains$default((CharSequence)startIndex, (CharSequence)"@media only screen and (max-device-width:", (boolean)false, (int)2, null)) {
                        String lastIndex = plixJs;
                        Intrinsics.checkNotNullExpressionValue((Object)lastIndex, (String)"plixJs");
                        int startIndex2 = StringsKt.indexOf$default((CharSequence)lastIndex, (String)"@media only screen and (max-device-width:", (int)0, (boolean)false, (int)6, null);
                        string6 = plixJs;
                        Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"plixJs");
                        int endIndex = StringsKt.indexOf$default((CharSequence)string6, (String)".plix{", (int)0, (boolean)false, (int)6, null);
                        plixJs = new StringBuilder(plixJs).insert(endIndex, "*/").insert(startIndex2, "/*").toString();
                        FileUtils.writeStringToFile((File)file, (String)plixJs, (String)"UTF-8");
                    }
                }
                plixJs = file.getName();
                Intrinsics.checkNotNullExpressionValue((Object)plixJs, (String)"file.name");
                if (StringsKt.contains$default((CharSequence)plixJs, (CharSequence)"plix.html", (boolean)false, (int)2, null)) {
                    Element rightWrapper;
                    Element leftWrapper;
                    Element iframe;
                    plixJs = FileUtils.readFileToString((File)file, (String)"UTF-8");
                    Document doc = Jsoup.parse((String)plixJs);
                    Element element = doc.selectFirst("div.read-more-container");
                    if (element != null) {
                        element.remove();
                    }
                    Element element2 = doc.selectFirst("div#portraitView");
                    if (element2 != null) {
                        element2.remove();
                    }
                    Element element3 = doc.selectFirst("div#ToolBarView");
                    if (element3 != null) {
                        element3.remove();
                    }
                    Element element4 = doc.selectFirst("div#deviceCompatibilityAlertPlix");
                    if (element4 != null) {
                        element4.remove();
                    }
                    Element element5 = doc.selectFirst("div#leftBackWrapper");
                    if (element5 != null) {
                        element5.remove();
                    }
                    Element head = doc.head();
                    head.append(this.css);
                    Element element6 = iframe = doc.selectFirst("div.plixIFrameContainer");
                    if (element6 != null) {
                        element6.removeClass("plixIFrameContainer");
                    }
                    Element element7 = leftWrapper = doc.selectFirst("div#plixLeftWrapper");
                    if (element7 != null) {
                        element7.removeClass("plixLeftWrapper");
                    }
                    Element element8 = leftWrapper;
                    if (element8 != null) {
                        element8.addClass("small-12");
                    }
                    Element element9 = leftWrapper;
                    if (element9 != null) {
                        element9.addClass("medium-6");
                    }
                    Element element10 = leftWrapper;
                    if (element10 != null) {
                        element10.addClass("large-6");
                    }
                    Element element11 = leftWrapper;
                    String leftAttr = element11 == null ? null : element11.attr("style");
                    Element element12 = leftWrapper;
                    if (element12 != null) {
                        element12.attr("style", Intrinsics.stringPlus((String)leftAttr, (Object)"display: block;"));
                    }
                    Element element13 = rightWrapper = doc.selectFirst("div#plixRightWrapper");
                    if (element13 != null) {
                        element13.removeClass("small-6");
                    }
                    Element element14 = rightWrapper;
                    if (element14 != null) {
                        element14.addClass("small-12");
                    }
                    Element element15 = rightWrapper;
                    if (element15 != null) {
                        element15.addClass("medium-6");
                    }
                    Element element16 = rightWrapper;
                    if (element16 != null) {
                        element16.addClass("large-6");
                    }
                    FileUtils.writeStringToFile((File)file, (String)doc.html(), (String)"UTF-8");
                }
                LogIndex.IndexEntry logIndex = ContentScraperUtil.INSTANCE.createIndexFromLog(urlString2, mimeType, urlDirectory, file, log);
                indexList.add(logIndex);
            }
            catch (Exception e) {
                String string11 = urlString2;
                Intrinsics.checkNotNull((Object)string11);
                UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Index url failed at ", (Object)string11));
                String string12 = le.getMessage();
                Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"le.message");
                UMLogUtil.INSTANCE.logDebug(string12);
            }
        }
        LogIndex logIndex = new LogIndex();
        logIndex.setTitle("CK12");
        logIndex.setEntries((List<LogIndex.IndexEntry>)indexList);
        FileUtils.writeStringToFile((File)new File(content, "index.json"), (String)gson.toJson((Object)logIndex), (String)"UTF-8");
    }

    public final void scrapeVideoContent(@NotNull File destination) throws IOException {
        String urlString;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Document fullSite = Jsoup.connect((String)this.scrapeUrl.toString()).get();
        File modifiedFile = new File(this.destLocation, Intrinsics.stringPlus((String)destination.getName(), (Object)"last-modified.txt"));
        Intrinsics.checkNotNullExpressionValue((Object)fullSite, (String)"fullSite");
        this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(this.isPageUpdated(fullSite)));
        if (!this.isContentUpdated) {
            return;
        }
        Document videoContent = this.getMainContent(fullSite, "div.modality_content[data-loadurl]", "data-loadurl");
        if (videoContent == null && (videoContent = this.getMainContent(fullSite, "iframe[src]", "src")) == null) {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Unsupported video content", (Object)this.scrapeUrl));
            throw new IOException(Intrinsics.stringPlus((String)"Did not find video content", (Object)this.scrapeUrl));
        }
        Elements videoElement = this.getIframefromHtml(videoContent);
        String string = urlString = Jsoup.parse((String)videoElement.outerHtml()).select("[src]").attr("src");
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlString");
        if (StringsKt.startsWith$default((String)string, (String)"//", (boolean)false, (int)2, null)) {
            Element element = Jsoup.connect((String)Intrinsics.stringPlus((String)"https:", (Object)urlString)).get().selectFirst("video source");
            urlString = element == null ? null : element.attr("src");
        } else {
            string = urlString;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"urlString");
            if (StringsKt.startsWith$default((String)string, (String)"/flx", (boolean)false, (int)2, null)) {
                String urlSrc;
                Document html;
                Document document2 = html = Jsoup.connect((String)Intrinsics.stringPlus((String)"https://www.ck12.org", (Object)urlString)).followRedirects(true).get();
                Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"html");
                Element element = Jsoup.parse((String)this.getIframefromHtml(document2).outerHtml()).selectFirst("[src]");
                String string2 = urlSrc = element == null ? null : element.attr("src");
                if (string2 == null ? false : StringsKt.contains$default((CharSequence)string2, (CharSequence)".mp4", (boolean)false, (int)2, null)) {
                    urlString = urlSrc;
                } else {
                    String string3 = urlSrc;
                    if (string3 == null ? false : StringsKt.startsWith$default((String)string3, (String)"//", (boolean)false, (int)2, null)) {
                        Element element2 = Jsoup.connect((String)Intrinsics.stringPlus((String)"https:", (Object)urlSrc)).get().selectFirst("video source");
                        urlString = element2 == null ? null : element2.attr("src");
                    } else {
                        UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"found flx video - might be youtube at ", (Object)urlSrc));
                        this.isContentUpdated = false;
                        return;
                    }
                }
            }
        }
        UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"final urlString =  ", (Object)urlString));
        FileUtils.copyURLToFile((URL)new URL(urlString), (File)destination);
    }

    private final Elements getIframefromHtml(Document videoContent) {
        Elements elements = videoContent.select("iframe");
        if (elements.size() > 0) {
            Intrinsics.checkNotNullExpressionValue((Object)elements, (String)"elements");
            return elements;
        }
        String videoElementsList = videoContent.select("textarea").text();
        Elements elements2 = Jsoup.parse((String)videoElementsList).select("iframe");
        Intrinsics.checkNotNullExpressionValue((Object)elements2, (String)"parse(videoElementsList).select(\"iframe\")");
        return elements2;
    }

    private final Document getMainContent(Document document2, String htmlTag, String search) throws IOException {
        Elements elements = document2.select(htmlTag);
        for (Element element : elements) {
            String string = element.attr(search);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.attr(search)");
            if (StringsKt.contains$default((CharSequence)string, (CharSequence)"googletag", (boolean)false, (int)2, null)) continue;
            String path = element.attr(search);
            URL contentUrl = new URL(this.scrapeUrl, path);
            return Jsoup.connect((String)contentUrl.toString()).followRedirects(true).get();
        }
        return null;
    }

    private final String getVocabHtml(Document site) throws IOException {
        Elements elements = site.select("section.vocabulary_content[data-loadurl]");
        Iterator iterator = elements.iterator();
        if (iterator.hasNext()) {
            Element element = (Element)iterator.next();
            String path = element.attr("data-loadurl");
            URL contentUrl = new URL(this.scrapeUrl, path);
            return Jsoup.connect((String)contentUrl.toString()).followRedirects(true).get().html();
        }
        return null;
    }

    private final long isPageUpdated(Document doc) {
        String date = doc.select("h2:contains(Last Modified) ~ span").attr("data-date");
        Intrinsics.checkNotNullExpressionValue((Object)date, (String)"date");
        return ContentScraperUtil.INSTANCE.parseServerDate(date);
    }

    public final void scrapeReadContent(@NotNull File destination) throws IOException {
        Object mathJaxDir;
        String readHtml;
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Document html = Jsoup.connect((String)this.scrapeUrl.toString()).get();
        String readContentName = FilenameUtils.getBaseName((String)this.scrapeUrl.getPath());
        destination.mkdirs();
        this.assetDirectory = new File(destination, "asset");
        File file = this.assetDirectory;
        if (file == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetDirectory");
            file = null;
        }
        file.mkdirs();
        File modifiedFile = new File(this.destLocation, Intrinsics.stringPlus((String)destination.getName(), (Object)"last-modified.txt"));
        Intrinsics.checkNotNullExpressionValue((Object)html, (String)"html");
        this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(this.isPageUpdated(html)));
        if (!this.isContentUpdated) {
            return;
        }
        String readTitle = this.getTitleHtml(html);
        Document content = this.getMainContent(html, "div.modality_content[data-loadurl]", "data-loadurl");
        if (content == null) {
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Unsupported read destination", (Object)this.scrapeUrl));
            throw new IllegalArgumentException(Intrinsics.stringPlus((String)"Did not find read destination", (Object)this.scrapeUrl));
        }
        String string = readHtml = content.html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"readHtml");
        File file2 = this.assetDirectory;
        if (file2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"assetDirectory");
            file2 = null;
        }
        readHtml = this.removeAllHref(ContentScraperUtil.INSTANCE.downloadAllResources(string, file2, this.scrapeUrl));
        String vocabHtml = this.removeAllHref(this.getVocabHtml(html));
        String detailHtml = this.removeAllHref(this.getDetailSectionHtml(html));
        String string2 = readHtml;
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"readHtml");
        if (StringsKt.contains$default((CharSequence)string2, (CharSequence)"x-ck12-mathEditor", (boolean)false, (int)2, null)) {
            readHtml = Intrinsics.stringPlus((String)this.appendMathJax(), (Object)readHtml);
            detailHtml = Intrinsics.stringPlus((String)detailHtml, (Object)this.appendMathJaxScript());
            mathJaxDir = new File(destination, "mathjax");
            ((File)mathJaxDir).mkdirs();
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/MathJax.js"), (File)new File((File)mathJaxDir, "MathJax.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/TeX-AMS-MML_HTMLorMML.js"), (File)new File((File)mathJaxDir, "/config/TeX-AMS-MML_HTMLorMML.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/tex2jax.js"), (File)new File((File)mathJaxDir, "/extensions/tex2jax.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/MathEvents.js"), (File)new File((File)mathJaxDir, "/extensions/MathEvents.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/AMSmath.js"), (File)new File((File)mathJaxDir, "/extensions/TeX/AMSmath.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/AMSsymbols.js"), (File)new File((File)mathJaxDir, "/extensions/TeX/AMSsymbols.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/autoload-all.js"), (File)new File((File)mathJaxDir, "/extensions/TeX/autoload-all.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/cancel.js"), (File)new File((File)mathJaxDir, "/extensions/TeX/cancel.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/color.js"), (File)new File((File)mathJaxDir, "/extensions/TeX/color.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/element/jax.js"), (File)new File((File)mathJaxDir, "/jax/element/mml/jax.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/input/jax.js"), (File)new File((File)mathJaxDir, "/jax/input/TeX/jax.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/input/config.js"), (File)new File((File)mathJaxDir, "/jax/input/TeX/config.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/output/mtable.js"), (File)new File((File)mathJaxDir, "/jax/output/HTML-CSS/autoload/mtable.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/output/fontdata.js"), (File)new File((File)mathJaxDir, "/jax/output/HTML-CSS/fonts/STIX/fontdata.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/output/fontdata-1.0.js"), (File)new File((File)mathJaxDir, "/jax/output/HTML-CSS/fonts/STIX/fontdata-1.0.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/output/jax.js"), (File)new File((File)mathJaxDir, "/jax/output/HTML-CSS/jax.js"));
            FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/mathjax/output/config.js"), (File)new File((File)mathJaxDir, "/jax/output/HTML-CSS/config.js"));
        }
        readHtml = readTitle + readHtml + vocabHtml + detailHtml;
        FileUtils.writeStringToFile((File)new File(destination, "index.html"), (String)readHtml, (String)"UTF-8");
        try {
            Intrinsics.checkNotNullExpressionValue((Object)readContentName, (String)"readContentName");
            mathJaxDir = this.scrapeUrl.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)mathJaxDir, (String)"scrapeUrl.path");
            ContentScraperUtil.INSTANCE.generateTinCanXMLFile(destination, readContentName, "en", "index.html", "http://activitystrea.ms/schema/1.0/ARTICLE_TIN_CAN_FILE", (String)mathJaxDir, "", "");
        }
        catch (TransformerException e) {
            String string3 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string3);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Read Tin can file unable to create for url", (Object)this.scrapeUrl));
        }
        catch (ParserConfigurationException e) {
            String string4 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string4);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Read Tin can file unable to create for url", (Object)this.scrapeUrl));
        }
    }

    public final void scrapeFlexBookContent(@NotNull File content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        content.mkdirs();
        BrowserMobProxyServer proxy = new BrowserMobProxyServer();
        proxy.start();
        ChromeDriver chromeDriver = HarScraperKt.setupProxyWithSelenium(proxy, ContentScraperUtil.INSTANCE.getDefaultSeleniumProxy(proxy), "CK12");
        String string = this.scrapeUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"scrapeUrl.toString()");
        HarScraperKt.scrapeUrlwithHar(proxy, chromeDriver, string, content, (Function1<? super WebDriverWait, Unit>)((Function1)scrapeFlexBookContent.1.INSTANCE), (Function1<? super HarEntry, ? extends HarEntry>)((Function1)new Function1<HarEntry, HarEntry>(this){
            final /* synthetic */ CK12ContentScraper this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @NotNull
            public final HarEntry invoke(@NotNull HarEntry it) {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                if (Intrinsics.areEqual((Object)this.this$0.getScrapeUrl().toString(), (Object)it.getRequest().getUrl())) {
                    Document doc = Jsoup.parse((String)it.getResponse().getContent().getText());
                    Element element = doc.selectFirst("div.breadcrumblist");
                    if (element != null) {
                        element.remove();
                    }
                    Element element2 = doc.selectFirst("header");
                    if (element2 != null) {
                        element2.remove();
                    }
                    Element element3 = doc.selectFirst("footer");
                    if (element3 != null) {
                        element3.remove();
                    }
                    Element element4 = doc.selectFirst("div.feedback");
                    if (element4 != null) {
                        element4.remove();
                    }
                    Element element5 = doc.selectFirst("div#flexbook2_banner");
                    if (element5 != null) {
                        element5.remove();
                    }
                    Element element6 = doc.selectFirst("div.ck12-annotation-toolbar-container");
                    if (element6 != null) {
                        element6.remove();
                    }
                    Element element7 = doc.selectFirst("section.myAnnotations-container");
                    if (element7 != null) {
                        element7.remove();
                    }
                    it.getResponse().getContent().setText(doc.html());
                }
                return it;
            }
        }));
        File harFile = new File(content, "harcontent");
        harFile.createNewFile();
        proxy.getHar().writeTo(harFile);
        proxy.stop();
    }

    private final String appendMathJaxScript() {
        return "<script language=\"JavaScript\" src=\"./mathjax/MathJax.js\" type=\"text/javascript\">\n  </script>\n  <script>\n   var els = document.getElementsByClassName(\"x-ck12-mathEditor\");\n    for(var i = 0; i < els.length; i++) {\n        var el = els.item(i);\n        var tex = decodeURIComponent(el.getAttribute(\"data-tex\"))\n        if (tex.indexOf(\"\\\\begin{align\") === -1) {\n            tex = \"\\\\begin{align*}\" + tex + \"\\\\end{align*}\";\n        }\n        tex = (\"@$\" + tex + \"@$\").replace(/</g, \"&lt;\");\n        el.innerHTML = tex;\n        el.removeAttribute(\"data-tex-mathjax\");\n    }\n\n    MathJax.Hub.Typeset(MathJax.Hub);\n  </script>\n </body>\n</html>";
    }

    private final String appendMathJax() {
        return "<html xmlns=\"http://www.w3.org/1999/xhtml\">\n <head>\n  <title>\n  </title><script language=\"JavaScript\" type=\"text/x-mathjax-config\">\n   MathJax.Hub.Config({\n\t\textensions: [\"tex2jax.js\",\"TeX/AMSmath.js\",\"TeX/AMSsymbols.js\"],\n\t\ttex2jax: {\n\t\t\tinlineMath: [['@$','@$']],\n\t\t\tdisplayMath: [['@$$','@$$']],\n\t\t\tskipTags: [\"script\",\"noscript\",\"style\",\"textarea\",\"code\"]\n\t\t},\n\t\tshowMathMenu : false,\n\t\tjax: [\"input/TeX\",\"output/HTML-CSS\"],\n\t\tmessageStyle: \"none\",\n\t\tTeX: {\n\t\t\textensions: [\"cancel.js\", \"color.js\", \"autoload-all.js\"]\n\t\t}\n\t});\n  </script>\n </head>\n <body>\n";
    }

    @NotNull
    public final String generatePlixLink(@NotNull String id) {
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        return this.plixLink + id + "?includeBasicPlixDataOnly=true";
    }

    @NotNull
    public final String generatePracticeLink(@NotNull String url) {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        return this.practiceIdLink + url + this.practicePost;
    }

    @NotNull
    public final String generateTestUrl(@Nullable String testId) {
        return this.startTestLink + testId + this.POLICIES;
    }

    @NotNull
    public final String generateQuestionUrl(@Nullable String testId, @Nullable String testScoreId, int count) {
        return this.questionLinkId + testId + '/' + count + '/' + testScoreId + this.postfix;
    }

    public final void scrapePracticeContent(@NotNull File destination, @NotNull URL startingUrl) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destination, (String)"destination");
        Intrinsics.checkNotNullParameter((Object)startingUrl, (String)"startingUrl");
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        String practiceUrl = FilenameUtils.getBaseName((String)startingUrl.getPath());
        Intrinsics.checkNotNullExpressionValue((Object)practiceUrl, (String)"practiceUrl");
        String testIdLink = this.generatePracticeLink(practiceUrl);
        destination.mkdirs();
        File practiceAssetDirectory = new File(destination, "asset");
        practiceAssetDirectory.mkdirs();
        PracticeResponse response = (PracticeResponse)gson.fromJson(IOUtils.toString((URL)new URL(testIdLink), (String)"UTF-8"), PracticeResponse.class);
        PracticeResponse.TestResponse testResponse = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse);
        PracticeResponse.TestResponse.Test test = testResponse.getTest();
        Intrinsics.checkNotNull((Object)test);
        String testId = test.getId();
        PracticeResponse.TestResponse testResponse2 = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse2);
        PracticeResponse.TestResponse.Test test2 = testResponse2.getTest();
        Intrinsics.checkNotNull((Object)test2);
        int goal = test2.getGoal();
        PracticeResponse.TestResponse testResponse3 = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse3);
        PracticeResponse.TestResponse.Test test3 = testResponse3.getTest();
        Intrinsics.checkNotNull((Object)test3);
        int questionsCount = test3.getQuestionsCount();
        PracticeResponse.TestResponse testResponse4 = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse4);
        PracticeResponse.TestResponse.Test test4 = testResponse4.getTest();
        Intrinsics.checkNotNull((Object)test4);
        String practiceName = test4.getTitle();
        PracticeResponse.TestResponse testResponse5 = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse5);
        PracticeResponse.TestResponse.Test test5 = testResponse5.getTest();
        Intrinsics.checkNotNull((Object)test5);
        String updated = test5.getUpdated();
        File modifiedFile = new File(this.destLocation, Intrinsics.stringPlus((String)destination.getName(), (Object)"last-modified.txt"));
        String string = updated;
        Intrinsics.checkNotNull((Object)string);
        this.isContentUpdated = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(ContentScraperUtil.INSTANCE.parseServerDate(string)));
        if (!this.isContentUpdated) {
            return;
        }
        String nextPracticeName = "";
        String nextPracticeUrl = "";
        PracticeResponse.TestResponse testResponse6 = response.getResponse();
        Intrinsics.checkNotNull((Object)testResponse6);
        PracticeResponse.TestResponse.Test test6 = testResponse6.getTest();
        Intrinsics.checkNotNull((Object)test6);
        if (test6.getNextPractice() != null) {
            PracticeResponse.TestResponse testResponse7 = response.getResponse();
            Intrinsics.checkNotNull((Object)testResponse7);
            PracticeResponse.TestResponse.Test test7 = testResponse7.getTest();
            Intrinsics.checkNotNull((Object)test7);
            PracticeResponse.TestResponse.Test.NextPractice nextPractice = test7.getNextPractice();
            Intrinsics.checkNotNull((Object)nextPractice);
            nextPracticeName = nextPractice.getNameOfNextPractice();
            nextPracticeUrl = this.practiceIdLink + nextPracticeName + this.practicePost;
        }
        String testLink = this.generateTestUrl(testId);
        TestResponse testResponse8 = (TestResponse)gson.fromJson(IOUtils.toString((URL)new URL(testLink), (String)"UTF-8"), TestResponse.class);
        TestResponse.Response response2 = testResponse8.getResponse();
        Intrinsics.checkNotNull((Object)response2);
        TestResponse.Response.TestScore testScore = response2.getTestScore();
        Intrinsics.checkNotNull((Object)testScore);
        String testScoreId = testScore.getId();
        ArrayList<QuestionResponse> questionList = new ArrayList<QuestionResponse>();
        int n = 1;
        if (n <= questionsCount) {
            int i;
            do {
                String questionId;
                i = n++;
                String questionLink = this.generateQuestionUrl(testId, testScoreId, i);
                QuestionResponse questionResponse = (QuestionResponse)gson.fromJson(IOUtils.toString((URL)new URL(questionLink), (String)"UTF-8"), QuestionResponse.class);
                QuestionResponse.Response response3 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response3);
                response3.setGoal(goal);
                QuestionResponse.Response response4 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response4);
                response4.setPracticeName(practiceName);
                QuestionResponse.Response response5 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response5);
                response5.setNextPracticeName(nextPracticeName);
                QuestionResponse.Response response6 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response6);
                response6.setNextPracticeUrl(nextPracticeUrl);
                QuestionResponse.Response response7 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response7);
                String string2 = questionId = response7.getQuestionID();
                Intrinsics.checkNotNull((Object)string2);
                File questionAsset = new File(destination, string2);
                questionAsset.mkdirs();
                QuestionResponse.Response response8 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response8);
                QuestionResponse.Response.Question question = response8.getStem();
                Intrinsics.checkNotNull((Object)question);
                QuestionResponse.Response response9 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response9);
                QuestionResponse.Response.Question question2 = response9.getStem();
                Intrinsics.checkNotNull((Object)question2);
                String string3 = question2.getDisplayText();
                if (string3 == null) {
                    string3 = "";
                }
                question.setDisplayText(ContentScraperUtil.INSTANCE.downloadAllResources(string3, questionAsset, this.scrapeUrl));
                QuestionResponse.Response response10 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response10);
                List<String> hintsList = response10.getHints();
                int n2 = 0;
                List<String> list = hintsList;
                Intrinsics.checkNotNull(list);
                int n3 = list.size();
                while (n2 < n3) {
                    int j = n2++;
                    hintsList.set(j, ContentScraperUtil.INSTANCE.downloadAllResources(hintsList.get(j), practiceAssetDirectory, startingUrl));
                }
                QuestionResponse.Response response11 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response11);
                response11.setHints(hintsList);
                QuestionResponse.Response response12 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response12);
                String string4 = response12.getData();
                if (string4 == null) {
                    string4 = "";
                }
                String answerResponse = this.extractAnswerFromEncryption(string4);
                AnswerResponse answer = (AnswerResponse)gson.fromJson(answerResponse, AnswerResponse.class);
                AnswerResponse.Instance instance2 = answer.getInstance();
                if (instance2 != null) {
                    String string5;
                    AnswerResponse.Instance instance3 = answer.getInstance();
                    instance2.setSolution(ContentScraperUtil.INSTANCE.downloadAllResources(instance3 == null ? "" : ((string5 = instance3.getSolution()) == null ? "" : string5), questionAsset, this.scrapeUrl));
                }
                AnswerResponse.Instance instance4 = answer.getInstance();
                if (instance4 != null) {
                    AnswerResponse.Instance instance5 = answer.getInstance();
                    Intrinsics.checkNotNull((Object)instance5);
                    List<Object> list2 = instance5.getAnswer();
                    Intrinsics.checkNotNull(list2);
                    instance4.setAnswer(this.downloadAllResourcesFromAnswer(list2, questionAsset, startingUrl));
                }
                String string6 = ScraperConstants.QUESTION_TYPE.MULTI_CHOICE.getType();
                QuestionResponse.Response response13 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response13);
                String string7 = response13.getQuestionType();
                Intrinsics.checkNotNull((Object)string7);
                if (StringsKt.equals((String)string6, (String)string7, (boolean)true)) {
                    QuestionResponse.Response response14 = questionResponse.getResponse();
                    Intrinsics.checkNotNull((Object)response14);
                    List<QuestionResponse.Response.QuestionObjects> questionOrderList = response14.getResponseObjects();
                    AnswerResponse.Instance instance6 = answer.getInstance();
                    Intrinsics.checkNotNull((Object)instance6);
                    List<AnswerResponse.Instance.AnswerObjects> answerObjectsList = instance6.getResponseObjects();
                    int n4 = 0;
                    List<QuestionResponse.Response.QuestionObjects> list3 = questionOrderList;
                    Intrinsics.checkNotNull(list3);
                    int n5 = list3.size();
                    while (n4 < n5) {
                        int order;
                        String string8;
                        QuestionResponse.Response.QuestionObjects question3;
                        question3.setDisplayText(ContentScraperUtil.INSTANCE.downloadAllResources((string8 = (question3 = questionOrderList.get(order = n4++)).getDisplayText()) == null ? "" : string8, questionAsset, startingUrl));
                        string8 = question3.getOptionKey();
                        question3.setOptionKey(ContentScraperUtil.INSTANCE.downloadAllResources(string8 == null ? "" : string8, questionAsset, startingUrl));
                        List<AnswerResponse.Instance.AnswerObjects> list4 = answerObjectsList;
                        Intrinsics.checkNotNull(list4);
                        AnswerResponse.Instance.AnswerObjects answerObject = list4.get(order);
                        String string9 = answerObject.getDisplayText();
                        answerObject.setDisplayText(ContentScraperUtil.INSTANCE.downloadAllResources(string9 == null ? "" : string9, questionAsset, startingUrl));
                        string9 = answerObject.getOptionKey();
                        answerObject.setOptionKey(ContentScraperUtil.INSTANCE.downloadAllResources(string9 == null ? "" : string9, questionAsset, startingUrl));
                    }
                }
                QuestionResponse.Response response15 = questionResponse.getResponse();
                Intrinsics.checkNotNull((Object)response15);
                response15.setAnswer(answer);
                questionList.add(questionResponse);
            } while (i != questionsCount);
        }
        try {
            String string10 = startingUrl.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"startingUrl.path");
            ContentScraperUtil.INSTANCE.generateTinCanXMLFile(destination, practiceUrl, "en", "index.html", "http://adlnet.gov/expapi/activities/assessment", string10, "", "");
        }
        catch (TransformerException e) {
            String string11 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string11);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Practice Tin can file unable to create for url", (Object)startingUrl));
        }
        catch (ParserConfigurationException e) {
            String string12 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string12);
            UMLogUtil.INSTANCE.logError(Intrinsics.stringPlus((String)"Practice Tin can file unable to create for url", (Object)startingUrl));
        }
        ContentScraperUtil.INSTANCE.saveListAsJson(destination, (List)questionList, "questions.json");
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/jquery-3.3.1.min.js"), (File)new File(destination, "jquery-3.3.1.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.css"), (File)new File(destination, "materialize.min.css"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.js"), (File)new File(destination, "materialize.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/index.html"), (File)new File(destination, "index.html"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/timer.svg"), (File)new File(destination, "timer.svg"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/trophy.svg"), (File)new File(destination, "trophy.svg"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/ck12/check.svg"), (File)new File(destination, "check.svg"));
    }

    @NotNull
    public final String extractAnswerFromEncryption(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        return this.scriptEngineReader.getResult(data);
    }

    private final List<Object> downloadAllResourcesFromAnswer(List<Object> answer, File questionAsset, URL scrapUrl) {
        int n = 0;
        int n2 = answer.size();
        while (n < n2) {
            int i;
            Object object;
            if ((object = answer.get(i = n++)) instanceof String) {
                answer.set(i, ContentScraperUtil.INSTANCE.downloadAllResources((String)object, questionAsset, scrapUrl));
                continue;
            }
            if (!TypeIntrinsics.isMutableList((Object)object)) continue;
            answer.set(i, this.downloadAllResourcesFromAnswer(TypeIntrinsics.asMutableList((Object)object), questionAsset, scrapUrl));
        }
        return answer;
    }

    private final String getTitleHtml(Document section) {
        String string = section.select("div.title").outerHtml();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"section.select(\"div.title\").outerHtml()");
        return string;
    }

    private final String getDetailSectionHtml(Document section) {
        String string = section.select("div.metadataview").html();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"section.select(\"div.metadataview\").html()");
        return string;
    }

    private final String removeAllHref(String html) {
        String string = html;
        Intrinsics.checkNotNull((Object)string);
        Document doc = Jsoup.parse((String)string);
        doc.select("[href]").removeAttr("href");
        String string2 = doc.body().html();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"doc.body().html()");
        return string2;
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ck12/CK12ContentScraper$Companion;", "", "()V", "REQUEST_SENT", "", "RESPONSE_RECEIVED", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

