/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.android.view.binding;

import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.view.View;
import android.widget.ImageView;
import androidx.activity.result.ActivityResultLauncher;
import androidx.activity.result.ActivityResultRegistry;
import androidx.activity.result.contract.ActivityResultContract;
import androidx.activity.result.contract.ActivityResultContracts;
import androidx.core.content.FileProvider;
import androidx.databinding.InverseBindingListener;
import androidx.lifecycle.DefaultLifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.lifecycle.SavedStateHandle;
import androidx.navigation.NavBackStackEntry;
import androidx.navigation.NavController;
import androidx.navigation.ViewKt;
import com.google.android.material.dialog.MaterialAlertDialogBuilder;
import com.toughra.ustadmobile.R;
import com.ustadmobile.port.android.util.ext.NavControllerExtKt;
import com.ustadmobile.port.android.view.binding.ImageViewBindingsKt;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 .2\u00020\u00012\u00020\u00022\u00020\u0003:\u0001.B!\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u001a\u0010\u001e\u001a\u00020\u001f2\b\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\"\u001a\u00020\tH\u0016J\u0012\u0010\u001e\u001a\u00020\u001f2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010%\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001f2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010)\u001a\u00020\u001f2\b\u0010*\u001a\u0004\u0018\u00010\rJ\u0006\u0010+\u001a\u00020\u001fJ\u0006\u0010,\u001a\u00020\u001fJ\u0006\u0010-\u001a\u00020\u001fR\u0016\u0010\u000b\u001a\n\u0012\u0004\u0012\u00020\r\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\u00020\u000f8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0016\u0010\u0012\u001a\n\u0012\u0004\u0012\u00020\u000f\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0016R\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R(\u0010\u0019\u001a\u0004\u0018\u00010\u00182\b\u0010\u0017\u001a\u0004\u0018\u00010\u0018@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006/"}, d2={"Lcom/ustadmobile/port/android/view/binding/ImageViewLifecycleObserver2;", "Landroidx/lifecycle/DefaultLifecycleObserver;", "Landroid/content/DialogInterface$OnClickListener;", "Landroid/view/View$OnClickListener;", "registry", "Landroidx/activity/result/ActivityResultRegistry;", "inverseBindingListener", "Landroidx/databinding/InverseBindingListener;", "registryId", "", "(Landroidx/activity/result/ActivityResultRegistry;Landroidx/databinding/InverseBindingListener;I)V", "cameraLauncher", "Landroidx/activity/result/ActivityResultLauncher;", "Landroid/net/Uri;", "cameraUriSavedStateKey", "", "getCameraUriSavedStateKey", "()Ljava/lang/String;", "galleryLauncher", "getInverseBindingListener", "()Landroidx/databinding/InverseBindingListener;", "setInverseBindingListener", "(Landroidx/databinding/InverseBindingListener;)V", "value", "Landroid/widget/ImageView;", "view", "getView", "()Landroid/widget/ImageView;", "setView", "(Landroid/widget/ImageView;)V", "onClick", "", "dialog", "Landroid/content/DialogInterface;", "which", "v", "Landroid/view/View;", "onCreate", "owner", "Landroidx/lifecycle/LifecycleOwner;", "onDestroy", "onPictureTakenOrSelected", "pictureUri", "openPicture", "showOptionsDialog", "takePicture", "Companion", "app-android_debug"})
public final class ImageViewLifecycleObserver2
implements DefaultLifecycleObserver,
DialogInterface.OnClickListener,
View.OnClickListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ActivityResultRegistry registry;
    @Nullable
    private InverseBindingListener inverseBindingListener;
    private int registryId;
    @Nullable
    private ImageView view;
    @Nullable
    private ActivityResultLauncher<Uri> cameraLauncher;
    @Nullable
    private ActivityResultLauncher<String> galleryLauncher;
    @NotNull
    private static final String PREFIX_URI_KEY = "galleryFileUri_";
    @NotNull
    private static final Integer[] OPTIONS_STRING_IDS;

    public ImageViewLifecycleObserver2(@Nullable ActivityResultRegistry registry, @Nullable InverseBindingListener inverseBindingListener, int registryId) {
        this.registry = registry;
        this.inverseBindingListener = inverseBindingListener;
        this.registryId = registryId;
    }

    @Nullable
    public final InverseBindingListener getInverseBindingListener() {
        return this.inverseBindingListener;
    }

    public final void setInverseBindingListener(@Nullable InverseBindingListener inverseBindingListener) {
        this.inverseBindingListener = inverseBindingListener;
    }

    @Nullable
    public final ImageView getView() {
        return this.view;
    }

    public final void setView(@Nullable ImageView value) {
        ImageView imageView = this.view;
        if (imageView != null) {
            imageView.setOnClickListener(null);
        }
        ImageView imageView2 = value;
        if (imageView2 != null) {
            imageView2.setOnClickListener((View.OnClickListener)this);
        }
        this.view = value;
    }

    private final String getCameraUriSavedStateKey() {
        return PREFIX_URI_KEY + this.registryId;
    }

    public void onClick(@Nullable View v) {
        this.showOptionsDialog();
    }

    public void onCreate(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onCreate(owner);
        ActivityResultRegistry activityResultRegistry = this.registry;
        this.cameraLauncher = activityResultRegistry != null ? activityResultRegistry.register("cameraFilePath_" + this.registryId, owner, (ActivityResultContract)new ActivityResultContracts.TakePicture(), arg_0 -> ImageViewLifecycleObserver2.onCreate$lambda$0(this, arg_0)) : null;
        ActivityResultRegistry activityResultRegistry2 = this.registry;
        this.galleryLauncher = activityResultRegistry2 != null ? activityResultRegistry2.register("galleryFilePath_" + this.registryId, owner, (ActivityResultContract)new ActivityResultContracts.GetContent(), arg_0 -> ImageViewLifecycleObserver2.onCreate$lambda$1(this, arg_0)) : null;
    }

    public void onDestroy(@NotNull LifecycleOwner owner) {
        Intrinsics.checkNotNullParameter((Object)owner, (String)"owner");
        super.onDestroy(owner);
        this.cameraLauncher = null;
        this.galleryLauncher = null;
        this.inverseBindingListener = null;
        ImageView imageView = this.view;
        if (imageView != null) {
            imageView.setOnClickListener(null);
        }
        this.setView(null);
        this.registry = null;
    }

    /*
     * WARNING - void declaration
     */
    public final void showOptionsDialog() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        ImageView imageView = this.view;
        if (imageView == null) {
            return;
        }
        ImageView viewVal = imageView;
        Integer[] integerArray = OPTIONS_STRING_IDS;
        MaterialAlertDialogBuilder materialAlertDialogBuilder = new MaterialAlertDialogBuilder(viewVal.getContext()).setTitle(R.string.change_photo);
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(((void)$this$map$iv).length);
        boolean $i$f$mapTo = false;
        for (void item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            int n = ((Number)item$iv$iv).intValue();
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(viewVal.getContext().getString((int)it));
        }
        Collection $this$toTypedArray$iv = (List)destination$iv$iv;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        String[] stringArray = thisCollection$iv.toArray(new String[0]);
        Intrinsics.checkNotNull((Object)stringArray, (String)"null cannot be cast to non-null type kotlin.Array<T of kotlin.collections.ArraysKt__ArraysJVMKt.toTypedArray>");
        materialAlertDialogBuilder.setItems((CharSequence[])stringArray, (DialogInterface.OnClickListener)this).show();
    }

    public void onClick(@Nullable DialogInterface dialog, int which) {
        int n = OPTIONS_STRING_IDS[which];
        if (n == R.string.remove_photo) {
            this.onPictureTakenOrSelected(null);
        } else if (n == R.string.take_new_photo_from_camera) {
            this.takePicture();
        } else if (n == R.string.select_new_photo_from_gallery) {
            this.openPicture();
        }
    }

    public final void takePicture() {
        block3: {
            ImageView imageView = this.view;
            if (imageView == null) {
                return;
            }
            ImageView viewVal = imageView;
            NavController navController = ViewKt.findNavController((View)((View)viewVal));
            Context context = viewVal.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"viewVal.context");
            File fileDest = NavControllerExtKt.createTempFileForDestination$default(navController, context, "takePicture-" + System.currentTimeMillis(), null, 4, null);
            Uri fileUri = FileProvider.getUriForFile((Context)viewVal.getContext().getApplicationContext(), (String)(viewVal.getContext().getPackageName() + ".provider"), (File)fileDest);
            Intent cameraIntent = new Intent("android.media.action.IMAGE_CAPTURE");
            List list = viewVal.getContext().getPackageManager().queryIntentActivities(cameraIntent, 65536);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"viewVal.context.packageM\u2026nager.MATCH_DEFAULT_ONLY)");
            List resInfoList = list;
            for (ResolveInfo resolveInfo : resInfoList) {
                String packageName = resolveInfo.activityInfo.packageName;
                viewVal.getContext().grantUriPermission(packageName, fileUri, 3);
            }
            NavBackStackEntry navBackStackEntry = ViewKt.findNavController((View)((View)viewVal)).getCurrentBackStackEntry();
            if (navBackStackEntry != null && (navBackStackEntry = navBackStackEntry.getSavedStateHandle()) != null) {
                navBackStackEntry.set(this.getCameraUriSavedStateKey(), (Object)fileUri.toString());
            }
            ActivityResultLauncher<Uri> activityResultLauncher = this.cameraLauncher;
            if (activityResultLauncher == null) break block3;
            activityResultLauncher.launch((Object)fileUri);
        }
    }

    public final void openPicture() {
        block0: {
            ActivityResultLauncher<String> activityResultLauncher = this.galleryLauncher;
            if (activityResultLauncher == null) break block0;
            activityResultLauncher.launch((Object)"image/*");
        }
    }

    public final void onPictureTakenOrSelected(@Nullable Uri pictureUri) {
        block1: {
            ImageView imageView = this.view;
            if (imageView != null) {
                Uri uri2 = pictureUri;
                ImageViewBindingsKt.setImageFilePath(imageView, uri2 != null ? uri2.toString() : null, null);
            }
            InverseBindingListener inverseBindingListener = this.inverseBindingListener;
            if (inverseBindingListener == null) break block1;
            inverseBindingListener.onChange();
        }
    }

    private static final void onCreate$lambda$0(ImageViewLifecycleObserver2 this$0, Boolean it) {
        String string2;
        SavedStateHandle savedStateHandle;
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        ImageView imageView = this$0.view;
        if (imageView == null) {
            return;
        }
        ImageView viewVal = imageView;
        NavBackStackEntry navBackStackEntry = ViewKt.findNavController((View)((View)viewVal)).getCurrentBackStackEntry();
        if (navBackStackEntry == null || (savedStateHandle = navBackStackEntry.getSavedStateHandle()) == null || (string2 = (String)savedStateHandle.get(this$0.getCameraUriSavedStateKey())) == null) {
            return;
        }
        String uriStr = string2;
        this$0.onPictureTakenOrSelected(Uri.parse((String)uriStr));
    }

    private static final void onCreate$lambda$1(ImageViewLifecycleObserver2 this$0, Uri it) {
        Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
        this$0.onPictureTakenOrSelected(it);
    }

    static {
        Integer[] integerArray = new Integer[]{R.string.remove_photo, R.string.take_new_photo_from_camera, R.string.select_new_photo_from_gallery};
        OPTIONS_STRING_IDS = integerArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0019\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\n\n\u0002\u0010\b\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\t\u001a\u00020\nX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/port/android/view/binding/ImageViewLifecycleObserver2$Companion;", "", "()V", "OPTIONS_STRING_IDS", "", "", "getOPTIONS_STRING_IDS", "()[Ljava/lang/Integer;", "[Ljava/lang/Integer;", "PREFIX_URI_KEY", "", "getPREFIX_URI_KEY", "()Ljava/lang/String;", "app-android_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getPREFIX_URI_KEY() {
            return PREFIX_URI_KEY;
        }

        @NotNull
        public final Integer[] getOPTIONS_STRING_IDS() {
            return OPTIONS_STRING_IDS;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

