package com.ustadmobile.port.android.view.util;

import java.lang.System;

/**
 * This adapter helps when in situations where it is desired to display attachment data together
 * with other data and avoid a situation where loading the attachment data delays the display of
 * the other data.
 *
 * For example where there is a list of of people and an attachment entity that contains the profile,
 * picture it would be desired to show the person's name etc. without waiting for the picture in the
 * attachment data to load.
 *
 * In this situation attachment data is typically connected using a foreign key.
 */
@kotlin.Metadata(mv = {1, 7, 1}, k = 1, d1 = {"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\bf\u0018\u00002\u00020\u0001J#\u0010\u0002\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u00a6@\u00f8\u0001\u0000\u00a2\u0006\u0002\u0010\b\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006\t"}, d2 = {"Lcom/ustadmobile/port/android/view/util/ForeignKeyAttachmentUriAdapter;", "", "getAttachmentUri", "", "foreignKey", "", "dbToUse", "Lcom/ustadmobile/core/db/UmAppDatabase;", "(JLcom/ustadmobile/core/db/UmAppDatabase;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "app-android_debug"})
public abstract interface ForeignKeyAttachmentUriAdapter {
    
    /**
     * This function is responsible to get an Android Uri for the given foreign key. This would
     * normally be done using a database query. The query should use coroutines (e.g. suspended).
     *
     * Normally something using this would call this function twice: the first time on the db, the
     * second time on the repo. The repo is included as an additional parameter because it is required
     * to resolve the attachment's Uri.
     *
     * @param foreignKey the foreign key to lookup
     * @param dbToUse the database against which to run a query (e.g. the db, then the repo)
     * @param repo an instance of the database that is always the repo. This is used to resolve the
     * attachment uri.
     */
    @org.jetbrains.annotations.Nullable()
    public abstract java.lang.Object getAttachmentUri(long foreignKey, @org.jetbrains.annotations.NotNull()
    com.ustadmobile.core.db.UmAppDatabase dbToUse, @org.jetbrains.annotations.NotNull()
    kotlin.coroutines.Continuation<? super java.lang.String> continuation);
}