/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.android.view;

import android.annotation.TargetApi;
import android.content.Context;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.webkit.WebView;
import android.widget.OverScroller;
import androidx.core.view.GestureDetectorCompat;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0013\u0018\u0000 -2\u00020\u00012\u00020\u0002:\u0001-B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u0017\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bB\u001f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bB'\b\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\n\u00a2\u0006\u0002\u0010\rJ\b\u0010\u001a\u001a\u00020\u001bH\u0016J(\u0010\u001c\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0002J\u0010\u0010!\u001a\u00020\u001b2\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0010\u0010\"\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0018H\u0016J(\u0010$\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0012H\u0016J\u0010\u0010%\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0018H\u0016J(\u0010&\u001a\u00020\u00102\u0006\u0010\u001d\u001a\u00020\u00182\u0006\u0010\u001e\u001a\u00020\u00182\u0006\u0010'\u001a\u00020\u00122\u0006\u0010(\u001a\u00020\u0012H\u0016J\u0010\u0010)\u001a\u00020\u001b2\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010*\u001a\u00020\u00102\u0006\u0010#\u001a\u00020\u0018H\u0016J\u0010\u0010+\u001a\u00020\u00102\u0006\u0010,\u001a\u00020\u0018H\u0016R\u000e\u0010\u000e\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0019\u001a\u0004\u0018\u00010\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/ustadmobile/port/android/view/EpubWebView;", "Landroid/webkit/WebView;", "Landroid/view/GestureDetector$OnGestureListener;", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "attrs", "Landroid/util/AttributeSet;", "(Landroid/content/Context;Landroid/util/AttributeSet;)V", "defStyleAttr", "", "(Landroid/content/Context;Landroid/util/AttributeSet;I)V", "defStyleRes", "(Landroid/content/Context;Landroid/util/AttributeSet;II)V", "columnIndex", "isScrolling", "", "mDownY", "", "mGestureDetector", "Landroidx/core/view/GestureDetectorCompat;", "mScroller", "Landroid/widget/OverScroller;", "scrollEvt1", "Landroid/view/MotionEvent;", "scrollEvt2", "computeScroll", "", "handleFlick", "e1", "e2", "velocityX", "velocityY", "initScrolling", "onDown", "motionEvent", "onFling", "onLongPress", "onScroll", "distanceX", "distanceY", "onShowPress", "onSingleTapUp", "onTouchEvent", "event", "Companion", "app-android_debug"})
public final class EpubWebView
extends WebView
implements GestureDetector.OnGestureListener {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private OverScroller mScroller;
    private GestureDetectorCompat mGestureDetector;
    private boolean isScrolling;
    @Nullable
    private MotionEvent scrollEvt1;
    @Nullable
    private MotionEvent scrollEvt2;
    private float mDownY;
    private int columnIndex;
    private static final int MIN_DISTANCE_FOR_FLING = 25;
    private static final int MAX_SETTLE_DURATION = 600;

    public EpubWebView(@NotNull Context context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        super(context);
        this.initScrolling(context);
    }

    public EpubWebView(@NotNull Context context, @NotNull AttributeSet attrs) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs);
        this.initScrolling(context);
    }

    public EpubWebView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr);
        this.initScrolling(context);
    }

    @TargetApi(value=21)
    public EpubWebView(@NotNull Context context, @NotNull AttributeSet attrs, int defStyleAttr, int defStyleRes) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)attrs, (String)"attrs");
        super(context, attrs, defStyleAttr, defStyleRes);
        this.initScrolling(context);
    }

    private final void initScrolling(Context context) {
        this.mScroller = new OverScroller(context);
        this.mGestureDetector = new GestureDetectorCompat(context, (GestureDetector.OnGestureListener)this);
        this.setVerticalScrollBarEnabled(false);
    }

    public void computeScroll() {
        super.computeScroll();
        OverScroller overScroller = this.mScroller;
        if (overScroller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScroller");
            overScroller = null;
        }
        if (overScroller.computeScrollOffset()) {
            OverScroller overScroller2 = this.mScroller;
            if (overScroller2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mScroller");
                overScroller2 = null;
            }
            int n = overScroller2.getCurrX();
            OverScroller overScroller3 = this.mScroller;
            if (overScroller3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"mScroller");
                overScroller3 = null;
            }
            this.scrollTo(n, overScroller3.getCurrY());
            ViewCompat.postInvalidateOnAnimation((View)((View)this));
        }
    }

    public boolean onTouchEvent(@NotNull MotionEvent event) {
        Intrinsics.checkNotNullParameter((Object)event, (String)"event");
        GestureDetectorCompat gestureDetectorCompat = this.mGestureDetector;
        if (gestureDetectorCompat == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGestureDetector");
            gestureDetectorCompat = null;
        }
        if (gestureDetectorCompat.onTouchEvent(event)) {
            return true;
        }
        GestureDetectorCompat gestureDetectorCompat2 = this.mGestureDetector;
        if (gestureDetectorCompat2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mGestureDetector");
            gestureDetectorCompat2 = null;
        }
        gestureDetectorCompat2.onTouchEvent(event);
        boolean endOfScroll = false;
        if (this.isScrolling && event.getAction() == 1) {
            endOfScroll = true;
            this.isScrolling = false;
        }
        if (event.getAction() == 0) {
            this.mDownY = event.getY();
        }
        if (this.isScrolling) {
            switch (event.getAction()) {
                case 1: 
                case 2: 
                case 3: {
                    event.setLocation(event.getX(), this.mDownY);
                }
            }
        }
        Log.i((String)"EpubWebView", (String)("isScrolling: " + this.isScrolling + " end of scroll: " + endOfScroll));
        if (endOfScroll) {
            Log.i((String)"EpubWebView", (String)"End of scroll: no fling");
            MotionEvent motionEvent = this.scrollEvt1;
            Intrinsics.checkNotNull((Object)motionEvent);
            MotionEvent motionEvent2 = this.scrollEvt2;
            Intrinsics.checkNotNull((Object)motionEvent2);
            return this.handleFlick(motionEvent, motionEvent2, 1.0f, 0.0f);
        }
        return super.onTouchEvent(event);
    }

    public boolean onDown(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
        OverScroller overScroller = this.mScroller;
        if (overScroller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScroller");
            overScroller = null;
        }
        overScroller.abortAnimation();
        return false;
    }

    public void onShowPress(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
    }

    public boolean onSingleTapUp(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
        return false;
    }

    public boolean onScroll(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float distanceX, float distanceY) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        this.isScrolling = true;
        this.scrollEvt1 = e1;
        this.scrollEvt2 = e2;
        return false;
    }

    public void onLongPress(@NotNull MotionEvent motionEvent) {
        Intrinsics.checkNotNullParameter((Object)motionEvent, (String)"motionEvent");
    }

    public boolean onFling(@NotNull MotionEvent e1, @NotNull MotionEvent e2, float velocityX, float velocityY) {
        Intrinsics.checkNotNullParameter((Object)e1, (String)"e1");
        Intrinsics.checkNotNullParameter((Object)e2, (String)"e2");
        Log.i((String)"EpubWebView", (String)"onFling");
        return this.handleFlick(e1, e2, velocityX, velocityY);
    }

    private final boolean handleFlick(MotionEvent e1, MotionEvent e2, float velocityX, float velocityY) {
        int swipeThresholdPx;
        int swipeDeltaX = Math.round(Math.abs(e1.getX() - e2.getX()));
        boolean isFlick = swipeDeltaX > (swipeThresholdPx = (int)TypedValue.applyDimension((int)1, (float)MIN_DISTANCE_FOR_FLING, (DisplayMetrics)this.getContext().getResources().getDisplayMetrics()));
        Log.i((String)"EpubWebView", (String)("handleFlick Delta X = " + swipeDeltaX + " threshold px = " + swipeThresholdPx + " isFlick: " + isFlick));
        int currentXPos = this.getScrollX();
        int increment = 0;
        if (isFlick) {
            increment = e1.getX() > e2.getX() ? 1 : -1;
        }
        int xDestination = (this.columnIndex + increment) * this.getWidth();
        int distanceX = xDestination - currentXPos;
        int duration = Math.min(Math.round(Math.abs((float)1000 * Math.abs((float)distanceX / velocityX))) * 4, MAX_SETTLE_DURATION);
        Log.i((String)"EpubWebView", (String)(": scroll duration " + duration + ", distanceX = " + distanceX + ", velocity = " + velocityX));
        OverScroller overScroller = this.mScroller;
        if (overScroller == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"mScroller");
            overScroller = null;
        }
        overScroller.startScroll(this.getScrollX(), 0, distanceX, 0, duration);
        this.columnIndex += increment;
        ViewCompat.postInvalidateOnAnimation((View)((View)this));
        return true;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/port/android/view/EpubWebView$Companion;", "", "()V", "MAX_SETTLE_DURATION", "", "MIN_DISTANCE_FOR_FLING", "app-android_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

