package com.toughra.ustadmobile.databinding;
import com.toughra.ustadmobile.R;
import com.toughra.ustadmobile.BR;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import android.view.View;
@SuppressWarnings("unchecked")
public class ItemListStatusBindingImpl extends ItemListStatusBinding  {

    @Nullable
    private static final androidx.databinding.ViewDataBinding.IncludedLayouts sIncludes;
    @Nullable
    private static final android.util.SparseIntArray sViewsWithIds;
    static {
        sIncludes = null;
        sViewsWithIds = new android.util.SparseIntArray();
        sViewsWithIds.put(R.id.icon_barrier, 4);
    }
    // views
    // variables
    // values
    // listeners
    // Inverse Binding Event Handlers

    public ItemListStatusBindingImpl(@Nullable androidx.databinding.DataBindingComponent bindingComponent, @NonNull View root) {
        this(bindingComponent, root, mapBindings(bindingComponent, root, 5, sIncludes, sViewsWithIds));
    }
    private ItemListStatusBindingImpl(androidx.databinding.DataBindingComponent bindingComponent, View root, Object[] bindings) {
        super(bindingComponent, root, 0
            , (androidx.constraintlayout.widget.Barrier) bindings[4]
            , (androidx.constraintlayout.widget.ConstraintLayout) bindings[0]
            , (androidx.appcompat.widget.AppCompatImageView) bindings[2]
            , (android.widget.ProgressBar) bindings[1]
            , (android.widget.TextView) bindings[3]
            );
        this.itemListStatusCl.setTag(null);
        this.loadingIcon.setTag(null);
        this.statusProgress.setTag(null);
        this.statusText.setTag(null);
        setRootTag(root);
        // listeners
        invalidateAll();
    }

    @Override
    public void invalidateAll() {
        synchronized(this) {
                mDirtyFlags = 0x8L;
        }
        requestRebind();
    }

    @Override
    public boolean hasPendingBindings() {
        synchronized(this) {
            if (mDirtyFlags != 0) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean setVariable(int variableId, @Nullable Object variable)  {
        boolean variableSet = true;
        if (BR.emptyStateMessage == variableId) {
            setEmptyStateMessage((java.lang.String) variable);
        }
        else if (BR.loadingStatus == variableId) {
            setLoadingStatus((com.ustadmobile.door.RepositoryLoadHelper.RepoLoadStatus) variable);
        }
        else if (BR.emptyStateDrawableId == variableId) {
            setEmptyStateDrawableId((java.lang.Integer) variable);
        }
        else {
            variableSet = false;
        }
            return variableSet;
    }

    public void setEmptyStateMessage(@Nullable java.lang.String EmptyStateMessage) {
        this.mEmptyStateMessage = EmptyStateMessage;
        synchronized(this) {
            mDirtyFlags |= 0x1L;
        }
        notifyPropertyChanged(BR.emptyStateMessage);
        super.requestRebind();
    }
    public void setLoadingStatus(@Nullable com.ustadmobile.door.RepositoryLoadHelper.RepoLoadStatus LoadingStatus) {
        this.mLoadingStatus = LoadingStatus;
        synchronized(this) {
            mDirtyFlags |= 0x2L;
        }
        notifyPropertyChanged(BR.loadingStatus);
        super.requestRebind();
    }
    public void setEmptyStateDrawableId(@Nullable java.lang.Integer EmptyStateDrawableId) {
        this.mEmptyStateDrawableId = EmptyStateDrawableId;
        synchronized(this) {
            mDirtyFlags |= 0x4L;
        }
        notifyPropertyChanged(BR.emptyStateDrawableId);
        super.requestRebind();
    }

    @Override
    protected boolean onFieldChange(int localFieldId, Object object, int fieldId) {
        switch (localFieldId) {
        }
        return false;
    }

    @Override
    protected void executeBindings() {
        long dirtyFlags = 0;
        synchronized(this) {
            dirtyFlags = mDirtyFlags;
            mDirtyFlags = 0;
        }
        java.lang.String emptyStateMessage = mEmptyStateMessage;
        com.ustadmobile.door.RepositoryLoadHelper.RepoLoadStatus loadingStatus = mLoadingStatus;
        java.lang.Integer emptyStateDrawableId = mEmptyStateDrawableId;
        int loadingStatusLoadStatus = 0;

        if ((dirtyFlags & 0x9L) != 0) {
        }
        if ((dirtyFlags & 0xaL) != 0) {



                if (loadingStatus != null) {
                    // read loadingStatus.loadStatus
                    loadingStatusLoadStatus = loadingStatus.getLoadStatus();
                }
        }
        if ((dirtyFlags & 0xcL) != 0) {
        }
        // batch finished
        if ((dirtyFlags & 0xaL) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.setImageLookupKey(this.loadingIcon, loadingStatusLoadStatus);
            com.ustadmobile.port.android.view.binding.ProgressBarBindingsKt.repoLoadStatus(this.statusProgress, loadingStatus);
            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setTextMessageIdOptionSelected(this.statusText, loadingStatusLoadStatus);
        }
        if ((dirtyFlags & 0xcL) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.ImageViewBindingsKt.setImageLookupMap(this.loadingIcon, com.ustadmobile.port.android.view.ListStatusRecyclerViewAdapter.MAP_ICON_IMAGEIDS, emptyStateDrawableId);
        }
        if ((dirtyFlags & 0x9L) != 0) {
            // api target 1

            com.ustadmobile.port.android.view.binding.TextViewBindingsKt.setTextMessageIdOptions(this.statusText, com.ustadmobile.port.android.view.ListStatusRecyclerViewAdapter.MAP_STATUS_STRINGS, (java.lang.Integer)null, emptyStateMessage);
        }
    }
    // Listener Stub Implementations
    // callback impls
    // dirty flag
    private  long mDirtyFlags = 0xffffffffffffffffL;
    /* flag mapping
        flag 0 (0x1L): emptyStateMessage
        flag 1 (0x2L): loadingStatus
        flag 2 (0x3L): emptyStateDrawableId
        flag 3 (0x4L): null
    flag mapping end*/
    //end
}