/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.android.impl;

import android.os.Handler;
import android.os.Looper;
import android.webkit.WebResourceRequest;
import android.webkit.WebResourceResponse;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.google.gson.Gson;
import com.ustadmobile.core.controller.IndexLog;
import com.ustadmobile.core.controller.WebChunkPresenter;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerEntryDao;
import com.ustadmobile.core.io.ext.ContainerEntryDaoExtKt;
import com.ustadmobile.core.io.ext.ContainerEntryFileJvmExtKt;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile;
import com.ustadmobile.lib.util.RangeResponse;
import com.ustadmobile.lib.util.RangeUtilKt;
import com.ustadmobile.port.sharedse.impl.http.RangeInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0017\u001a\u00020\u000bH\u0002J\u001a\u0010\u0018\u001a\u0004\u0018\u00010\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\t\u001a\u0012\u0012\u0004\u0012\u00020\u000b\u0012\b\u0012\u00060\fR\u00020\r0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000e\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0011\u001a\u00020\u000bX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u0006 "}, d2={"Lcom/ustadmobile/port/android/impl/WebChunkWebViewClient;", "Landroid/webkit/WebViewClient;", "containerUid", "", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "mPresenter", "Lcom/ustadmobile/core/controller/WebChunkPresenter;", "(JLcom/ustadmobile/core/db/UmAppDatabase;Lcom/ustadmobile/core/controller/WebChunkPresenter;)V", "indexMap", "Ljava/util/HashMap;", "", "Lcom/ustadmobile/core/controller/IndexLog$IndexEntry;", "Lcom/ustadmobile/core/controller/IndexLog;", "linkPatterns", "Ljava/util/regex/Pattern;", "presenter", "url", "getUrl", "()Ljava/lang/String;", "setUrl", "(Ljava/lang/String;)V", "checkWithPattern", "requestUrl", "shouldInterceptRequest", "Landroid/webkit/WebResourceResponse;", "view", "Landroid/webkit/WebView;", "request", "Landroid/webkit/WebResourceRequest;", "shouldOverrideUrlLoading", "", "app-android_debug"})
public final class WebChunkWebViewClient
extends WebViewClient {
    private final long containerUid;
    @NotNull
    private final UmAppDatabase db;
    @Nullable
    private WebChunkPresenter presenter;
    @NotNull
    private final HashMap<String, IndexLog.IndexEntry> indexMap;
    @NotNull
    private final HashMap<Pattern, String> linkPatterns;
    public String url;

    public WebChunkWebViewClient(long containerUid, @NotNull UmAppDatabase db, @Nullable WebChunkPresenter mPresenter) {
        Intrinsics.checkNotNullParameter((Object)db, (String)"db");
        this.containerUid = containerUid;
        this.db = db;
        this.indexMap = new HashMap();
        this.linkPatterns = new HashMap();
        try {
            List indexList;
            byte[] byArray;
            this.presenter = mPresenter;
            InputStream inputStream = ContainerEntryDaoExtKt.openEntryInputStream((ContainerEntryDao)this.db.getContainerEntryDao(), (long)this.containerUid, (String)"index.json");
            if (inputStream == null || (byArray = ByteStreamsKt.readBytes((InputStream)inputStream)) == null) {
                throw new IOException("Could not find index.json");
            }
            byte[] indexBytes = byArray;
            IndexLog indexLog = (IndexLog)new Gson().fromJson(new String(indexBytes, Charsets.UTF_8), IndexLog.class);
            List list = indexList = indexLog.getEntries();
            Intrinsics.checkNotNull((Object)list);
            IndexLog.IndexEntry firstUrlToOpen = (IndexLog.IndexEntry)list.get(0);
            this.setUrl(firstUrlToOpen.getUrl());
            for (IndexLog.IndexEntry log : indexList) {
                ((Map)this.indexMap).put(log.getUrl(), log);
            }
            Map linksMap = indexLog.getLinks();
            if (linksMap != null && !linksMap.isEmpty()) {
                for (String link : linksMap.keySet()) {
                    Pattern pattern;
                    Map map = this.linkPatterns;
                    Intrinsics.checkNotNullExpressionValue((Object)Pattern.compile(link), (String)"compile(link)");
                    Object object = MapsKt.getValue((Map)linksMap, (Object)link);
                    map.put(pattern, object);
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error opening Zip File");
        }
    }

    @NotNull
    public final String getUrl() {
        String string2 = this.url;
        if (string2 != null) {
            return string2;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"url");
        return null;
    }

    public final void setUrl(@NotNull String string2) {
        Intrinsics.checkNotNullParameter((Object)string2, (String)"<set-?>");
        this.url = string2;
    }

    public boolean shouldOverrideUrlLoading(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        String string2 = request.getUrl().toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"request.url.toString()");
        String requestUrl = this.checkWithPattern(string2);
        if (requestUrl != null) {
            WebChunkPresenter webChunkPresenter = this.presenter;
            if (webChunkPresenter != null) {
                webChunkPresenter.handleUrlLinkToContentEntry(requestUrl);
            }
            return true;
        }
        return super.shouldOverrideUrlLoading(view, request);
    }

    @Nullable
    public WebResourceResponse shouldInterceptRequest(@NotNull WebView view, @NotNull WebResourceRequest request) {
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        StringBuilder requestUrl = new StringBuilder(request.getUrl().toString());
        String string2 = requestUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"requestUrl.toString()");
        String sourceUrl = this.checkWithPattern(string2);
        if (sourceUrl != null) {
            WebChunkPresenter webChunkPresenter = this.presenter;
            if (webChunkPresenter != null) {
                webChunkPresenter.handleUrlLinkToContentEntry(sourceUrl);
            }
            new Handler(Looper.getMainLooper()).post(() -> WebChunkWebViewClient.shouldInterceptRequest$lambda$0(view, this));
            return new WebResourceResponse("text/html", "utf-8", null);
        }
        String string3 = requestUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"requestUrl.toString()");
        if (StringsKt.contains$default((CharSequence)string3, (CharSequence)"/Take-a-hint", (boolean)false, (int)2, null)) {
            String string4 = "true";
            Charset charset = StandardCharsets.UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"UTF_8");
            byte[] byArray = string4.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
            return new WebResourceResponse("text/plain", "utf-8", (InputStream)new ByteArrayInputStream(byArray));
        }
        IndexLog.IndexEntry log = this.indexMap.get(requestUrl.toString());
        if (log == null) {
            Iterator iterator = ((Map)this.indexMap).entrySet().iterator();
            while (iterator.hasNext()) {
                String key = (String)iterator.next().getKey();
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"plixbrowse", (boolean)false, (int)2, null)) {
                    String string5 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"plixbrowse", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/render/questionInstance?qID", (boolean)false, (int)2, null)) {
                    String string6 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string6, (CharSequence)"https://www.ck12.org/assessment/api/render/questionInstance?qID", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/get/info/test/plix%20practice/plixID/", (boolean)false, (int)2, null)) {
                    String string7 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string7, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string7, (CharSequence)"https://www.ck12.org/assessment/api/get/info/test/plix%20practice/plixID/", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"https://www.ck12.org/assessment/api/start/tests/", (boolean)false, (int)2, null)) {
                    String string8 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string8, (CharSequence)"https://www.ck12.org/assessment/api/start/tests/", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"hint", (boolean)false, (int)2, null)) {
                    String string9 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string9, (CharSequence)"hint", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"attempt", (boolean)false, (int)2, null)) {
                    String string10 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"attempt", (boolean)false, (int)2, null)) {
                        log = this.indexMap.get(key);
                        break;
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"/api/internal/user/task/practice/", (boolean)false, (int)2, null)) {
                    String string11 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string11, (CharSequence)"/api/internal/user/task/practice/", (boolean)false, (int)2, null)) {
                        view.post(() -> WebChunkWebViewClient.shouldInterceptRequest$lambda$1(view, this));
                        return super.shouldInterceptRequest(view, request);
                    }
                }
                if (StringsKt.contains$default((CharSequence)key, (CharSequence)"/assessment_item", (boolean)false, (int)2, null)) {
                    int langIndex;
                    String newRequestUrl;
                    String string12 = requestUrl.toString();
                    Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"requestUrl.toString()");
                    if (StringsKt.contains$default((CharSequence)string12, (CharSequence)"/assessment_item", (boolean)false, (int)2, null) && (log = this.indexMap.get(newRequestUrl = requestUrl.substring(0, langIndex = requestUrl.indexOf("?lang")))) != null) break;
                }
                if (!StringsKt.contains$default((CharSequence)key, (CharSequence)"/Quiz/Answer", (boolean)false, (int)2, null)) continue;
                String string13 = requestUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"requestUrl.toString()");
                if (!StringsKt.contains$default((CharSequence)string13, (CharSequence)"/Quiz/Answer", (boolean)false, (int)2, null)) continue;
                Map headers = request.getRequestHeaders();
                String pageIndex = (String)headers.get("PageIndex");
                String answerId = (String)headers.get("AnswerId");
                requestUrl.append("?page=").append(pageIndex);
                if (answerId != null && ((CharSequence)answerId).length() == 0) {
                    requestUrl.append("&answer=").append(answerId);
                }
                log = this.indexMap.get(requestUrl.toString());
                break;
            }
        }
        if (log == null) {
            System.err.println("did not find match for url in indexMap " + request.getUrl());
            return new WebResourceResponse("", "utf-8", 200, "OK", null, null);
        }
        try {
            Object object;
            ContainerEntryDao containerEntryDao = this.db.getContainerEntryDao();
            String string14 = log.getPath();
            Intrinsics.checkNotNull((Object)string14);
            ContainerEntryWithContainerEntryFile containerEntryWithContainerEntryFile = containerEntryDao.findByPathInContainer(this.containerUid, string14);
            if (containerEntryWithContainerEntryFile == null) {
                return new WebResourceResponse("", "utf-8", 404, "Not Found", null, null);
            }
            ContainerEntryWithContainerEntryFile entry = containerEntryWithContainerEntryFile;
            Map mutMap = null;
            mutMap = new LinkedHashMap();
            if (log.getHeaders() != null) {
                Map map = log.getHeaders();
                Intrinsics.checkNotNull((Object)map);
                mutMap.putAll(map);
            }
            ContainerEntryFile containerEntryFile = entry.getContainerEntryFile();
            Intrinsics.checkNotNull((Object)containerEntryFile);
            if (containerEntryFile.getCompression() == 1) {
                mutMap.put("Content-Encoding", "gzip");
                ContainerEntryFile containerEntryFile2 = entry.getContainerEntryFile();
                Intrinsics.checkNotNull((Object)containerEntryFile2);
                mutMap.put("Content-Length", String.valueOf(containerEntryFile2.getCeCompressedSize()));
            }
            if ((object = entry.getContainerEntryFile()) == null || (object = ContainerEntryFileJvmExtKt.openInputStream((ContainerEntryFile)object)) == null) {
                throw new IOException(entry.getCePath() + " has no containerentryfile");
            }
            Object data = object;
            String string15 = (String)request.getRequestHeaders().get("Range");
            if (string15 == null) {
                return new WebResourceResponse(log.getMimeType(), "utf-8", 200, "OK", mutMap, (InputStream)data);
            }
            String rangeHeader = string15;
            ContainerEntryFile containerEntryFile3 = entry.getContainerEntryFile();
            Intrinsics.checkNotNull((Object)containerEntryFile3);
            long totalLength = containerEntryFile3.getCeTotalSize();
            boolean isHEADRequest = Intrinsics.areEqual((Object)request.getMethod(), (Object)"HEAD");
            RangeResponse range = RangeUtilKt.parseRangeRequestHeader((String)rangeHeader, (long)totalLength);
            if (range != null && range.getStatusCode() == 206) {
                if (!isHEADRequest) {
                    data = (InputStream)new RangeInputStream((InputStream)data, range.getFromByte(), range.getToByte());
                }
                Map $this$forEach$iv = range.getResponseHeaders();
                boolean $i$f$forEach = false;
                Iterator iterator = $this$forEach$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry element$iv;
                    Map.Entry it = element$iv = iterator.next();
                    boolean bl = false;
                    mutMap.put(it.getKey(), it.getValue());
                }
                return new WebResourceResponse(log.getMimeType(), "utf-8", 206, "Partial Content", mutMap, (InputStream)(isHEADRequest ? null : data));
            }
            RangeResponse rangeResponse = range;
            boolean bl = rangeResponse != null ? rangeResponse.getStatusCode() == 416 : false;
            if (bl) {
                return new WebResourceResponse("text/plain", "utf-8", 416, isHEADRequest ? "" : "Range request not satisfiable", null, null);
            }
            mutMap.put("Content-Length", String.valueOf(totalLength));
            mutMap.put("Connection", "close");
            return new WebResourceResponse(log.getMimeType(), "utf-8", 200, "OK", mutMap, (InputStream)data);
        }
        catch (Exception e) {
            StringBuilder stringBuilder = new StringBuilder().append("did not find entry in zip for url ");
            String string16 = log.getUrl();
            Intrinsics.checkNotNull((Object)string16);
            System.err.println(stringBuilder.append(string16).toString());
            e.printStackTrace();
            return super.shouldInterceptRequest(view, request);
        }
    }

    private final String checkWithPattern(String requestUrl) {
        for (Pattern linkPattern : this.linkPatterns.keySet()) {
            if (!linkPattern.matcher(requestUrl).lookingAt()) continue;
            return this.linkPatterns.get(linkPattern);
        }
        return null;
    }

    private static final void shouldInterceptRequest$lambda$0(WebView $view, WebChunkWebViewClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $view.loadUrl(this$0.getUrl());
    }

    private static final void shouldInterceptRequest$lambda$1(WebView $view, WebChunkWebViewClient this$0) {
        Intrinsics.checkNotNullParameter((Object)$view, (String)"$view");
        Intrinsics.checkNotNullParameter((Object)((Object)this$0), (String)"this$0");
        $view.loadUrl(this$0.getUrl());
    }
}

