/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.abztract.Indexer;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstantsKt;
import com.ustadmobile.lib.contentscrapers.khanacademy.ModuleResponse;
import com.ustadmobile.lib.contentscrapers.khanacademy.PropsSubjectResponse;
import com.ustadmobile.lib.contentscrapers.khanacademy.SubjectListResponse;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.kodein.di.DI;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B5\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\u0006\u0010\u0007\u001a\u00020\u0003\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J \u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005H\u0002J\u0010\u0010\u0015\u001a\u00020\u000e2\u0006\u0010\u0016\u001a\u00020\u0017H\u0016\u00a8\u0006\u0019"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanTopicIndexer;", "Lcom/ustadmobile/lib/contentscrapers/abztract/Indexer;", "parentContentEntry", "", "runUid", "", "sqiUid", "contentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "close", "", "createModule", "url", "Ljava/net/URL;", "module", "Lcom/ustadmobile/lib/contentscrapers/khanacademy/ModuleResponse;", "count", "indexUrl", "sourceUrl", "", "Companion", "lib-content-scrapers"})
public final class KhanTopicIndexer
extends Indexer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Map<String, String> contentKindMap;

    public KhanTopicIndexer(long parentContentEntry, int runUid, int sqiUid, long contentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(parentContentEntry, runUid, sqiUid, contentEntryUid, endpoint, di);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void indexUrl(@NotNull String sourceUrl) {
        List<SubjectListResponse.ComponentData.Curation.Tab> list;
        SubjectListResponse response;
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        URL url = new URL(sourceUrl);
        String jsonContent = KhanConstantsKt.getJsonContent(url);
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        SubjectListResponse subjectListResponse = response = (SubjectListResponse)gson.fromJson(jsonContent, SubjectListResponse.class);
        Intrinsics.checkNotNull((Object)subjectListResponse);
        if (subjectListResponse.getComponentProps() == null) {
            response = ((PropsSubjectResponse)gson.fromJson(jsonContent, PropsSubjectResponse.class)).getProps();
        }
        if ((list = response) != null && (list = ((SubjectListResponse)((Object)list)).getComponentProps()) != null && (list = ((SubjectListResponse.ComponentData)((Object)list)).getCuration()) != null && (list = ((SubjectListResponse.ComponentData.Curation)((Object)list)).getTabs()) != null) {
            Iterable $this$forEachIndexed$iv = list;
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void tab;
                int n;
                if ((n = index$iv++) < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                SubjectListResponse.ComponentData.Curation.Tab tab2 = (SubjectListResponse.ComponentData.Curation.Tab)item$iv;
                int i = n;
                boolean bl = false;
                List<ModuleResponse> tabModules = tab.getModules();
                if (tabModules == null || tabModules.isEmpty()) continue;
                Iterable $this$forEachIndexed$iv2 = tabModules;
                boolean $i$f$forEachIndexed2 = false;
                int index$iv2 = 0;
                for (Object item$iv2 : $this$forEachIndexed$iv2) {
                    List<Object> moduleItems;
                    void module;
                    int n2;
                    if ((n2 = index$iv2++) < 0) {
                        CollectionsKt.throwIndexOverflow();
                    }
                    ModuleResponse moduleResponse = (ModuleResponse)item$iv2;
                    int moduleCount = n2;
                    boolean bl2 = false;
                    if (Intrinsics.areEqual((Object)"TableOfContentsRow", (Object)module.getKind())) {
                        this.createModule(url, (ModuleResponse)module, moduleCount);
                        continue;
                    }
                    if (Intrinsics.areEqual((Object)"SubjectProgress", (Object)module.getKind())) {
                        moduleItems = module.getModules();
                        if (moduleItems == null || moduleItems.isEmpty()) continue;
                        Iterable $this$forEachIndexed$iv3 = moduleItems;
                        boolean $i$f$forEachIndexed3 = false;
                        int index$iv3 = 0;
                        for (Object item$iv3 : $this$forEachIndexed$iv3) {
                            void moduleItem;
                            int n3;
                            if ((n3 = index$iv3++) < 0) {
                                CollectionsKt.throwIndexOverflow();
                            }
                            ModuleResponse moduleResponse2 = (ModuleResponse)item$iv3;
                            int itemCount = n3;
                            boolean bl3 = false;
                            if (!Intrinsics.areEqual((Object)"SubjectPageTopicCard", (Object)moduleItem.getKind())) continue;
                            this.createModule(url, (ModuleResponse)moduleItem, itemCount);
                        }
                        continue;
                    }
                    if (module.getTutorials() != null) {
                        List<ModuleResponse.Tutorial> list2 = module.getTutorials();
                        Intrinsics.checkNotNull(list2);
                        if (!((Collection)list2).isEmpty()) {
                            List<ModuleResponse.Tutorial> list3 = module.getTutorials();
                            Intrinsics.checkNotNull(list3);
                            Iterable $this$forEachIndexed$iv4 = list3;
                            boolean $i$f$forEachIndexed4 = false;
                            int index$iv4 = 0;
                            for (Object item$iv4 : $this$forEachIndexed$iv4) {
                                void tutorial;
                                int item$iv3;
                                if ((item$iv3 = index$iv4++) < 0) {
                                    CollectionsKt.throwIndexOverflow();
                                }
                                ModuleResponse.Tutorial tutorial2 = (ModuleResponse.Tutorial)item$iv4;
                                int tutorialCount = item$iv3;
                                boolean bl4 = false;
                                String string = tutorial.getUrl();
                                Intrinsics.checkNotNull((Object)string);
                                URL subjectUrl = new URL(url, string);
                                String string2 = tutorial.getSlug();
                                Intrinsics.checkNotNull((Object)string2);
                                String string3 = tutorial.getTitle();
                                String string4 = subjectUrl.toString();
                                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"subjectUrl.toString()");
                                ContentEntry contentEntry = this.getParentContentEntry();
                                Intrinsics.checkNotNull((Object)contentEntry);
                                long l = contentEntry.getPrimaryLanguageUid();
                                ContentEntry contentEntry2 = this.getParentContentEntry();
                                Intrinsics.checkNotNull((Object)contentEntry2);
                                ContentEntry tutorialEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string2, string3, string4, "Khan Academy", 4, l, contentEntry2.getLanguageVariantUid(), tutorial.getDescription(), false, "", "", "", "", 0, this.getRepo().getContentEntryDao());
                                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.getRepo().getContentEntryParentChildJoinDao();
                                ContentEntry contentEntry3 = this.getParentContentEntry();
                                Intrinsics.checkNotNull((Object)contentEntry3);
                                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, contentEntry3, tutorialEntry, tutorialCount);
                                List<ModuleResponse.Tutorial.ContentItem> list4 = tutorial.getContentItems();
                                if (list4 == null) continue;
                                Iterable $this$forEachIndexed$iv5 = list4;
                                boolean $i$f$forEachIndexed5 = false;
                                int index$iv5 = 0;
                                for (Object item$iv5 : $this$forEachIndexed$iv5) {
                                    void contentItem;
                                    int n4;
                                    if ((n4 = index$iv5++) < 0) {
                                        CollectionsKt.throwIndexOverflow();
                                    }
                                    ModuleResponse.Tutorial.ContentItem contentItem2 = (ModuleResponse.Tutorial.ContentItem)item$iv5;
                                    int contentCount = n4;
                                    boolean bl5 = false;
                                    String type2 = contentKindMap.get(contentItem.getKind());
                                    if (type2 == null) {
                                        UMLogUtil.INSTANCE.logFatal("Do not have support for kind " + contentItem.getKind() + " for source Url " + url);
                                        continue;
                                    }
                                    String string5 = contentItem.getNodeUrl();
                                    Intrinsics.checkNotNull((Object)string5);
                                    URL contentUrl = new URL(url, string5);
                                    String lang = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)sourceUrl, (String)".khan", null, (int)2, null), (String)"://", null, (int)2, null);
                                    if (Intrinsics.areEqual((Object)lang, (Object)"www")) {
                                        lang = "";
                                    }
                                    String string6 = contentItem.getSlug();
                                    Intrinsics.checkNotNull((Object)string6);
                                    String string7 = contentItem.getTitle();
                                    StringBuilder stringBuilder = new StringBuilder().append("khan-id://");
                                    String string8 = contentItem.getContentId();
                                    Intrinsics.checkNotNull((Object)string8);
                                    String string9 = stringBuilder.append(string8).append(((CharSequence)lang).length() > 0 ? '.' + lang : "").toString();
                                    ContentEntry contentEntry4 = this.getParentContentEntry();
                                    Intrinsics.checkNotNull((Object)contentEntry4);
                                    long l2 = contentEntry4.getPrimaryLanguageUid();
                                    ContentEntry contentEntry5 = this.getParentContentEntry();
                                    Intrinsics.checkNotNull((Object)contentEntry5);
                                    ContentEntry entry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string6, string7, string9, "Khan Academy", 4, l2, contentEntry5.getLanguageVariantUid(), contentItem.getDescription(), true, "", contentItem.getThumbnailUrl(), "", "", 0, this.getRepo().getContentEntryDao());
                                    ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(this.getRepo().getContentEntryParentChildJoinDao(), tutorialEntry, entry, contentCount);
                                    Indexer indexer = this;
                                    String string10 = contentUrl.toString();
                                    Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"contentUrl.toString()");
                                    Indexer.createQueueItem$default(indexer, string10, entry, type2, 2, tutorialEntry.getContentEntryUid(), 0, 32, null);
                                }
                            }
                            continue;
                        }
                    }
                    if (!Intrinsics.areEqual((Object)"ContentList", (Object)module.getKind()) || (moduleItems = module.getContentItems()) == null || moduleItems.isEmpty()) continue;
                    String string = module.getSlug();
                    Intrinsics.checkNotNull((Object)string);
                    String string11 = module.getTitle();
                    String string12 = module.getTopicId();
                    Intrinsics.checkNotNull((Object)string12);
                    ContentEntry contentEntry = this.getParentContentEntry();
                    Intrinsics.checkNotNull((Object)contentEntry);
                    long l = contentEntry.getPrimaryLanguageUid();
                    ContentEntry contentEntry6 = this.getParentContentEntry();
                    Intrinsics.checkNotNull((Object)contentEntry6);
                    ContentEntry tutorialEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, string11, string12, "Khan Academy", 4, l, contentEntry6.getLanguageVariantUid(), module.getDescription(), false, "", module.getImageUrl(), "", "", 0, this.getRepo().getContentEntryDao());
                    ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.getRepo().getContentEntryParentChildJoinDao();
                    ContentEntry contentEntry7 = this.getParentContentEntry();
                    Intrinsics.checkNotNull((Object)contentEntry7);
                    ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, contentEntry7, tutorialEntry, moduleCount);
                    List<ModuleResponse.Tutorial.ContentItem> list5 = module.getContentItems();
                    if (list5 == null) continue;
                    Iterable $this$forEachIndexed$iv6 = list5;
                    boolean $i$f$forEachIndexed6 = false;
                    int index$iv6 = 0;
                    for (Object item$iv6 : $this$forEachIndexed$iv6) {
                        void contentItem;
                        int n5;
                        if ((n5 = index$iv6++) < 0) {
                            CollectionsKt.throwIndexOverflow();
                        }
                        ModuleResponse.Tutorial.ContentItem subjectUrl = (ModuleResponse.Tutorial.ContentItem)item$iv6;
                        int itemCount = n5;
                        boolean bl6 = false;
                        String type3 = contentKindMap.get(contentItem.getKind());
                        if (type3 == null) {
                            UMLogUtil.INSTANCE.logFatal("Do not have support for kind " + contentItem.getKind() + " for source Url " + url);
                            continue;
                        }
                        String string13 = contentItem.getNodeUrl();
                        Intrinsics.checkNotNull((Object)string13);
                        URL contentUrl = new URL(url, string13);
                        String lang = StringsKt.substringAfter$default((String)StringsKt.substringBefore$default((String)sourceUrl, (String)".khan", null, (int)2, null), (String)"://", null, (int)2, null);
                        if (Intrinsics.areEqual((Object)lang, (Object)"www")) {
                            lang = "";
                        }
                        String string14 = contentItem.getSlug();
                        Intrinsics.checkNotNull((Object)string14);
                        String string15 = contentItem.getTitle();
                        StringBuilder stringBuilder = new StringBuilder().append("khan-id://");
                        String string16 = contentItem.getContentId();
                        Intrinsics.checkNotNull((Object)string16);
                        String string17 = stringBuilder.append(string16).append(((CharSequence)lang).length() > 0 ? '.' + lang : "").toString();
                        ContentEntry contentEntry8 = this.getParentContentEntry();
                        Intrinsics.checkNotNull((Object)contentEntry8);
                        long l3 = contentEntry8.getPrimaryLanguageUid();
                        ContentEntry contentEntry9 = this.getParentContentEntry();
                        Intrinsics.checkNotNull((Object)contentEntry9);
                        ContentEntry entry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string14, string15, string17, "Khan Academy", 4, l3, contentEntry9.getLanguageVariantUid(), contentItem.getDescription(), true, "", contentItem.getThumbnailUrl(), "", "", 0, this.getRepo().getContentEntryDao());
                        ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(this.getRepo().getContentEntryParentChildJoinDao(), tutorialEntry, entry, itemCount);
                        Indexer indexer = this;
                        String string18 = contentUrl.toString();
                        Intrinsics.checkNotNullExpressionValue((Object)string18, (String)"contentUrl.toString()");
                        Indexer.createQueueItem$default(indexer, string18, entry, type3, 2, tutorialEntry.getContentEntryUid(), 0, 32, null);
                    }
                }
            }
        }
        this.setIndexerDone(true, 0);
    }

    @Override
    public void close() {
    }

    private final void createModule(URL url, ModuleResponse module, int count) {
        String string = module.getUrl();
        Intrinsics.checkNotNull((Object)string);
        URL subjectUrl = new URL(url, string);
        String string2 = module.getSlug();
        Intrinsics.checkNotNull((Object)string2);
        String string3 = module.getTitle();
        String string4 = subjectUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"subjectUrl.toString()");
        ContentEntry contentEntry = this.getParentContentEntry();
        Intrinsics.checkNotNull((Object)contentEntry);
        long l = contentEntry.getPrimaryLanguageUid();
        ContentEntry contentEntry2 = this.getParentContentEntry();
        Intrinsics.checkNotNull((Object)contentEntry2);
        ContentEntry subjectEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string2, string3, string4, "Khan Academy", 4, l, contentEntry2.getLanguageVariantUid(), module.getDescription(), false, "", module.getIcon(), "", "", 0, this.getRepo().getContentEntryDao());
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.getRepo().getContentEntryParentChildJoinDao();
        ContentEntry contentEntry3 = this.getParentContentEntry();
        Intrinsics.checkNotNull((Object)contentEntry3);
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, contentEntry3, subjectEntry, count);
        Indexer indexer = this;
        String string5 = subjectUrl.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"subjectUrl.toString()");
        Indexer.createQueueItem$default(indexer, string5, subjectEntry, "khanTopicIndexer", 1, this.getParentContentEntryUid(), 0, 32, null);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"Video", (Object)"khanFullVideoScraper"), TuplesKt.to((Object)"Talkthrough", (Object)"khanFullVideoScraper"), TuplesKt.to((Object)"Article", (Object)"khanFullArticleScraper"), TuplesKt.to((Object)"Exercise", (Object)"khanFullExerciseScraper")};
        contentKindMap = MapsKt.mapOf((Pair[])pairArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001d\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanTopicIndexer$Companion;", "", "()V", "contentKindMap", "", "", "getContentKindMap", "()Ljava/util/Map;", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Map<String, String> getContentKindMap() {
            return contentKindMap;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

