/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.etekkatho;

import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u0011\u001a\u00020\u0012R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001e\u0010\n\u001a\u00020\t2\u0006\u0010\b\u001a\u00020\t@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\"\u0010\f\u001a\u0004\u0018\u00010\u00032\b\u0010\b\u001a\u0004\u0018\u00010\u0003@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/ustadmobile/lib/contentscrapers/etekkatho/EtekkathoScraper;", "", "url", "", "destinationDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "etekDirectory", "<set-?>", "", "isUpdated", "()Z", "mimeType", "getMimeType", "()Ljava/lang/String;", "scrapUrl", "Ljava/net/URL;", "scrapeContent", "", "lib-content-scrapers"})
public final class EtekkathoScraper {
    @NotNull
    private final File destinationDir;
    @NotNull
    private final URL scrapUrl;
    @NotNull
    private final File etekDirectory;
    private boolean isUpdated;
    @Nullable
    private String mimeType;

    public EtekkathoScraper(@NotNull String url, @NotNull File destinationDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        this.destinationDir = destinationDir;
        this.scrapUrl = new URL(url);
        String string = url.substring(StringsKt.indexOf$default((CharSequence)url, (String)"=", (int)0, (boolean)false, (int)6, null) + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"this as java.lang.String).substring(startIndex)");
        this.etekDirectory = new File(this.destinationDir, string);
        this.etekDirectory.mkdirs();
    }

    public final boolean isUpdated() {
        return this.isUpdated;
    }

    @Nullable
    public final String getMimeType() {
        return this.mimeType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final void scrapeContent() {
        HttpURLConnection conn = null;
        try {
            String string;
            String hrefLink;
            Document document2 = Jsoup.connect((String)this.scrapUrl.toString()).get();
            Element element = document2.selectFirst("th:contains(Download) ~td a[href].btn");
            String string2 = hrefLink = element != null ? element.attr("href") : null;
            if (string2 != null) {
                CharSequence charSequence = string2;
                Regex regex = new Regex(" ");
                String string3 = "_";
                string = regex.replace(charSequence, string3);
            } else {
                string = null;
            }
            hrefLink = string;
            URL contentUrl = new URL(this.scrapUrl, hrefLink);
            URLConnection uRLConnection = contentUrl.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            conn = (HttpURLConnection)uRLConnection;
            conn.setRequestProperty("User-Agent", "Mozilla/5.0 (Linux; Android 8.0.0; Pixel 2 XL Build/OPD1.170816.004) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/71.0.3578.98 Mobile Safari/537.36");
            File content = new File(this.etekDirectory, this.etekDirectory.getName());
            URLConnection uRLConnection2 = conn;
            String string4 = this.etekDirectory.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"etekDirectory.name");
            this.isUpdated = ContentScraperUtil.INSTANCE.isFileModified(uRLConnection2, this.etekDirectory, string4);
            if (ContentScraperUtil.INSTANCE.fileHasContent(content)) {
                this.isUpdated = false;
                ContentScraperUtil.INSTANCE.deleteFile(content);
                conn.disconnect();
                return;
            }
            if (!this.isUpdated) {
                conn.disconnect();
                return;
            }
            this.mimeType = conn.getContentType();
            FileUtils.copyInputStreamToFile((InputStream)conn.getInputStream(), (File)content);
            conn.disconnect();
            return;
        }
        catch (IOException e) {
            UMLogUtil.INSTANCE.logError("Unable to download content for etekkatho for url " + this.scrapUrl);
            String string = this.etekDirectory.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"etekDirectory.name");
            ContentScraperUtil.INSTANCE.deleteETagOrModified(this.etekDirectory, string);
            return;
        }
        finally {
            HttpURLConnection httpURLConnection = conn;
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }
}

