/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.staging.contentscrapers.voa;

import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.core.util.LiveDataWorkQueue;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.voa.VoaScraper;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.ScrapeQueueItem;
import com.ustadmobile.lib.staging.contentscrapers.voa.IndexVoaScraper;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.GlobalScope;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B7\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\u000b\u00a2\u0006\u0002\u0010\rJ \u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u00032\u0006\u0010\u0011\u001a\u00020\u0007H\u0002J \u0010\u0012\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00052\u0006\u0010\u0014\u001a\u00020\u00072\u0006\u0010\u0015\u001a\u00020\u0003H\u0002J\b\u0010\u0016\u001a\u00020\u000fH\u0016R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/voa/IndexVoaScraper;", "Ljava/lang/Runnable;", "indexerUrl", "Ljava/net/URL;", "parentEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "indexLocation", "Ljava/io/File;", "contentType", "", "scrapeQueueItemUid", "", "runId", "(Ljava/net/URL;Lcom/ustadmobile/lib/db/entities/ContentEntry;Ljava/io/File;Ljava/lang/String;II)V", "findContentInCategories", "", "urlString", "destinationDirectory", "findLessons", "categoryEntry", "categoryFolder", "lessonUrl", "run", "Companion", "lib-content-scrapers"})
public final class IndexVoaScraper
implements Runnable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final URL indexerUrl;
    @NotNull
    private final ContentEntry parentEntry;
    @NotNull
    private final File indexLocation;
    @NotNull
    private final String contentType;
    private final int scrapeQueueItemUid;
    private final int runId;
    @NotNull
    private static final String ROOT_URL = "https://learningenglish.voanews.com/";
    @NotNull
    private static final String VOA = "VOA";
    @Nullable
    private static URL url;
    private static ContentEntryDao contentEntryDao;
    private static ContentEntryParentChildJoinDao contentParentChildJoinDao;
    @NotNull
    private static final String[] CATEGORY;
    private static Language englishLang;
    private static ScrapeQueueItemDao queueDao;
    private static LiveDataWorkQueue<ScrapeQueueItem> scrapeWorkQueue;

    public IndexVoaScraper(@NotNull URL indexerUrl, @NotNull ContentEntry parentEntry, @NotNull File indexLocation, @NotNull String contentType, int scrapeQueueItemUid, int runId) {
        Intrinsics.checkNotNullParameter((Object)indexerUrl, (String)"indexerUrl");
        Intrinsics.checkNotNullParameter((Object)parentEntry, (String)"parentEntry");
        Intrinsics.checkNotNullParameter((Object)indexLocation, (String)"indexLocation");
        Intrinsics.checkNotNullParameter((Object)contentType, (String)"contentType");
        this.indexerUrl = indexerUrl;
        this.parentEntry = parentEntry;
        this.indexLocation = indexLocation;
        this.contentType = contentType;
        this.scrapeQueueItemUid = scrapeQueueItemUid;
        this.runId = runId;
    }

    @Override
    public void run() {
        ScrapeQueueItemDao scrapeQueueItemDao;
        System.gc();
        ScrapeQueueItemDao scrapeQueueItemDao2 = queueDao;
        if (scrapeQueueItemDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao2 = null;
        }
        scrapeQueueItemDao2.setTimeStarted(this.scrapeQueueItemUid, System.currentTimeMillis());
        boolean successful = false;
        if (Intrinsics.areEqual((Object)ScraperConstants.VoaContentType.LEVELS.getType(), (Object)this.contentType)) {
            try {
                this.findContentInCategories(this.parentEntry, this.indexerUrl, this.indexLocation);
                successful = true;
            }
            catch (Exception e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError("Error creating topics for url " + this.indexerUrl);
            }
        } else if (Intrinsics.areEqual((Object)ScraperConstants.VoaContentType.LESSONS.getType(), (Object)this.contentType)) {
            try {
                this.findLessons(this.parentEntry, this.indexLocation, this.indexerUrl);
                successful = true;
            }
            catch (Exception e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError("Error creating subjects for url " + this.indexerUrl);
            }
        }
        if ((scrapeQueueItemDao = queueDao) == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao = null;
        }
        scrapeQueueItemDao.updateSetStatusById(this.scrapeQueueItemUid, successful ? 3 : 4, 0);
        ScrapeQueueItemDao scrapeQueueItemDao3 = queueDao;
        if (scrapeQueueItemDao3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
            scrapeQueueItemDao3 = null;
        }
        scrapeQueueItemDao3.setTimeFinished(this.scrapeQueueItemUid, System.currentTimeMillis());
    }

    private final void findContentInCategories(ContentEntry parentEntry, URL urlString, File destinationDirectory) throws IOException {
        Document categoryDocument = Jsoup.connect((String)urlString.toString()).get();
        Elements categoryList = categoryDocument.select("h2.section-head a");
        int categoryCount = 0;
        for (Element category : categoryList) {
            String title = category.text();
            if (!((Stream)Arrays.stream(CATEGORY).parallel()).noneMatch(arg_0 -> IndexVoaScraper.findContentInCategories$lambda$0((Function1)new Function1<String, Boolean>(title){
                final /* synthetic */ String $title;
                {
                    this.$title = $title;
                    super(1);
                }

                @NotNull
                public final Boolean invoke(String it) {
                    String string = this.$title;
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"title");
                    CharSequence charSequence = string;
                    Intrinsics.checkNotNullExpressionValue((Object)it, (String)"it");
                    return StringsKt.contains$default((CharSequence)charSequence, (CharSequence)it, (boolean)false, (int)2, null);
                }
            }, arg_0))) continue;
            String hrefLink = category.attr("href");
            try {
                File categoryFolder = new File(destinationDirectory, title);
                categoryFolder.mkdirs();
                URL lessonListUrl = new URL(urlString, hrefLink);
                String string = FilenameUtils.getBaseName((String)hrefLink);
                String string2 = lessonListUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lessonListUrl.toString()");
                Language language = englishLang;
                if (language == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                    language = null;
                }
                long l = language.getLangUid();
                ContentEntryDao contentEntryDao = IndexVoaScraper.contentEntryDao;
                if (contentEntryDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                    contentEntryDao = null;
                }
                ContentEntry categoryEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, title, string2, VOA, 7, l, null, "", false, "", "", "", "", 0, contentEntryDao);
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = contentParentChildJoinDao;
                if (contentEntryParentChildJoinDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                    contentEntryParentChildJoinDao = null;
                }
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, parentEntry, categoryEntry, categoryCount++);
                ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
                if (scrapeQueueItemDao == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                    scrapeQueueItemDao = null;
                }
                ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, lessonListUrl, categoryEntry, categoryFolder, ScraperConstants.VoaContentType.LESSONS.getType(), this.runId, 1);
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
                UMLogUtil.INSTANCE.logError("Error with voa category = " + hrefLink + " with title " + title);
            }
        }
    }

    private final void findLessons(ContentEntry categoryEntry, File categoryFolder, URL lessonUrl) throws IOException {
        Document lessonListDoc = Jsoup.connect((String)lessonUrl.toString()).get();
        Elements elementList = lessonListDoc.select("div.container div.media-block-wrap div.media-block a.img-wrap");
        int lessonCount = 0;
        for (Element lessonElement : elementList) {
            String lessonHref = lessonElement.attr("href");
            URL lesson = new URL(url, lessonHref);
            String title = lessonElement.attr("title");
            String string = FilenameUtils.getBaseName((String)lessonHref);
            String string2 = lesson.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"lesson.toString()");
            Language language = englishLang;
            if (language == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language = null;
            }
            long l = language.getLangUid();
            ContentEntryDao contentEntryDao = IndexVoaScraper.contentEntryDao;
            if (contentEntryDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao = null;
            }
            ContentEntry lessonEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, title, string2, VOA, 7, l, null, "", true, "", "", "", "", 0, contentEntryDao);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, categoryEntry, lessonEntry, lessonCount++);
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, lesson, lessonEntry, categoryFolder, "", this.runId, 2);
        }
        if (lessonListDoc.hasClass("btn--load-more")) {
            Element element = lessonListDoc.selectFirst("p.btn--load-more a");
            String loadMoreHref = element != null ? element.attr("href") : null;
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, new URL(this.indexerUrl, loadMoreHref), categoryEntry, categoryFolder, ScraperConstants.VoaContentType.LESSONS.getType(), this.runId, 1);
        }
    }

    private static final boolean findContentInCategories$lambda$0(Function1 $tmp0, Object p0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        return (Boolean)$tmp0.invoke(p0);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    public static final /* synthetic */ LiveDataWorkQueue access$getScrapeWorkQueue$cp() {
        return scrapeWorkQueue;
    }

    static {
        String[] stringArray = new String[]{"Test Your English", "The Day in Photos", "Most Popular ", "Read, Listen & Learn"};
        CATEGORY = stringArray;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0016\u001a\u00020\u00172\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0007\u00a2\u0006\u0002\u0010\u0019J \u0010\u001a\u001a\u00020\u00172\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002J(\u0010 \u001a\u00020\u00172\u0006\u0010!\u001a\u00020\u00052\u0006\u0010\"\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001fH\u0002R\u0016\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00130\u0012X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0014\u001a\u0004\u0018\u00010\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lcom/ustadmobile/lib/staging/contentscrapers/voa/IndexVoaScraper$Companion;", "", "()V", "CATEGORY", "", "", "[Ljava/lang/String;", "ROOT_URL", "VOA", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "englishLang", "Lcom/ustadmobile/lib/db/entities/Language;", "queueDao", "Lcom/ustadmobile/core/db/dao/ScrapeQueueItemDao;", "scrapeWorkQueue", "Lcom/ustadmobile/core/util/LiveDataWorkQueue;", "Lcom/ustadmobile/lib/db/entities/ScrapeQueueItem;", "url", "Ljava/net/URL;", "main", "", "args", "([Ljava/lang/String;)V", "scrapeFromRoot", "dest", "Ljava/io/File;", "containerDir", "runId", "", "startScrape", "scrapeUrl", "destinationDir", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 2) {
                System.err.println("Usage: <file destination><file container><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
                throw new RuntimeException("System.exit returned normally, while it was supposed to halt JVM.");
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            try {
                this.scrapeFromRoot(new File(args[0]), new File(args[1]), 0);
            }
            catch (Exception e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logError("Main method exception catch khan");
            }
        }

        private final void scrapeFromRoot(File dest, File containerDir, int runId) throws IOException {
            this.startScrape(ROOT_URL, dest, containerDir, runId);
        }

        private final void startScrape(String scrapeUrl2, File destinationDir, File containerDir, int runId) throws IOException {
            try {
                url = new URL(scrapeUrl2);
            }
            catch (MalformedURLException e) {
                UMLogUtil.INSTANCE.logError("Index Malformed url" + scrapeUrl2);
                throw new IllegalArgumentException("Malformed url" + scrapeUrl2, e);
            }
            destinationDir.mkdirs();
            containerDir.mkdirs();
            Object db = null;
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
            Object repository = null;
            IndexVoaScraper.contentEntryDao = repository.getContentEntryDao();
            contentParentChildJoinDao = repository.getContentEntryParentChildJoinDao();
            LanguageDao languageDao = repository.getLanguageDao();
            queueDao = db.getScrapeQueueItemDao();
            englishLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, "English");
            Language language = englishLang;
            if (language == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language = null;
            }
            long l = language.getLangUid();
            ContentEntryDao contentEntryDao = contentEntryDao;
            if (contentEntryDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao = null;
            }
            ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
            String string = VOA;
            Language language2 = englishLang;
            if (language2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language2 = null;
            }
            long l2 = language2.getLangUid();
            ContentEntryDao contentEntryDao2 = contentEntryDao;
            if (contentEntryDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao2 = null;
            }
            ContentEntry parentVoa = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://learningenglish.voanews.com/", "Voice of America - Learning English", "https://learningenglish.voanews.com/", string, 7, l2, null, "Learn American English with English language lessons from Voice of America. VOA Learning English helps you learn English with vocabulary, listening and comprehension lessons through daily news and interactive English learning activities.", false, "", "https://learningenglish.voanews.com/Content/responsive/VOA/img/top_logo_news.png", "", "", 0, contentEntryDao2);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, masterRootParent, parentVoa, 18);
            String beginningUrl = "https://learningenglish.voanews.com/p/5609.html";
            String intermediateUrl = "https://learningenglish.voanews.com/p/5610.html";
            String advancedUrl = "https://learningenglish.voanews.com/p/5611.html";
            String historyUrl = "https://learningenglish.voanews.com/p/6353.html";
            String string2 = VOA;
            Language language3 = englishLang;
            if (language3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language3 = null;
            }
            long l3 = language3.getLangUid();
            ContentEntryDao contentEntryDao3 = contentEntryDao;
            if (contentEntryDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao3 = null;
            }
            ContentEntry beginningLevel = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("5609", "Beginning Level", beginningUrl, string2, 7, l3, null, "", false, "", "", "", "", 0, contentEntryDao3);
            String string3 = VOA;
            Language language4 = englishLang;
            if (language4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language4 = null;
            }
            long l4 = language4.getLangUid();
            ContentEntryDao contentEntryDao4 = contentEntryDao;
            if (contentEntryDao4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao4 = null;
            }
            ContentEntry intermediateLevel = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("5610", "Intermediate Level", intermediateUrl, string3, 7, l4, null, "", false, "", "", "", "", 0, contentEntryDao4);
            String string4 = VOA;
            Language language5 = englishLang;
            if (language5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language5 = null;
            }
            long l5 = language5.getLangUid();
            ContentEntryDao contentEntryDao5 = contentEntryDao;
            if (contentEntryDao5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao5 = null;
            }
            ContentEntry advancedLevel = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("5611", "Advanced Level", advancedUrl, string4, 7, l5, null, "", false, "", "", "", "", 0, contentEntryDao5);
            String string5 = VOA;
            Language language6 = englishLang;
            if (language6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"englishLang");
                language6 = null;
            }
            long l6 = language6.getLangUid();
            ContentEntryDao contentEntryDao6 = contentEntryDao;
            if (contentEntryDao6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                contentEntryDao6 = null;
            }
            ContentEntry usHistory = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("6353", "US History", historyUrl, string5, 7, l6, null, "", false, "", "", "", "", 0, contentEntryDao6);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao2 = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao2 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao2, parentVoa, beginningLevel, 0);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao3 = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao3 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao3, parentVoa, intermediateLevel, 1);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao4 = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao4 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao4, parentVoa, advancedLevel, 2);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao5 = contentParentChildJoinDao;
            if (contentEntryParentChildJoinDao5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"contentParentChildJoinDao");
                contentEntryParentChildJoinDao5 = null;
            }
            ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao5, parentVoa, usHistory, 3);
            ScrapeQueueItemDao scrapeQueueItemDao = queueDao;
            if (scrapeQueueItemDao == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao, new URL(beginningUrl), beginningLevel, destinationDir, ScraperConstants.VoaContentType.LEVELS.getType(), runId, 1);
            ScrapeQueueItemDao scrapeQueueItemDao2 = queueDao;
            if (scrapeQueueItemDao2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao2 = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao2, new URL(intermediateUrl), intermediateLevel, destinationDir, ScraperConstants.VoaContentType.LEVELS.getType(), runId, 1);
            ScrapeQueueItemDao scrapeQueueItemDao3 = queueDao;
            if (scrapeQueueItemDao3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao3 = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao3, new URL(advancedUrl), advancedLevel, destinationDir, ScraperConstants.VoaContentType.LEVELS.getType(), runId, 1);
            ScrapeQueueItemDao scrapeQueueItemDao4 = queueDao;
            if (scrapeQueueItemDao4 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao4 = null;
            }
            ContentScraperUtil.INSTANCE.createQueueItem(scrapeQueueItemDao4, new URL(historyUrl), usHistory, destinationDir, ScraperConstants.VoaContentType.LEVELS.getType(), runId, 1);
            int indexProcessors = 2;
            ScrapeQueueItemDao scrapeQueueItemDao5 = queueDao;
            if (scrapeQueueItemDao5 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao5 = null;
            }
            LiveDataWorkQueue indexWorkQueue2 = new LiveDataWorkQueue(scrapeQueueItemDao5.findNextQueueItems(1), (Function2)startScrape.indexWorkQueue.1.INSTANCE, indexProcessors, null, null, null, null, null, (Function2)new Function2<ScrapeQueueItem, Continuation<? super Unit>, Object>(containerDir, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ File $containerDir;
                {
                    this.$containerDir = $containerDir;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (ScrapeQueueItem)this.L$0;
                            v0 = IndexVoaScraper.access$getQueueDao$cp();
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                                v0 = null;
                            }
                            v0.updateSetStatusById(it.getSqiUid(), 2, 0);
                            v1 = IndexVoaScraper.access$getContentEntryDao$cp();
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                                v1 = null;
                            }
                            this.L$0 = it;
                            this.label = 1;
                            v2 = v1.findByUidAsync(it.getSqiContentEntryParentUid(), (Continuation)this);
                            if (v2 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl25
                        }
                        case 1: {
                            it = (ScrapeQueueItem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v2 = $result;
lbl25:
                            // 2 sources

                            parent = (ContentEntry)v2;
                            try {
                                v3 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v3);
                                scrapeContentUrl = new URL(v3);
                                v4 = it.getDestDir();
                                Intrinsics.checkNotNull((Object)v4);
                                v5 = new File(v4);
                                v6 = parent;
                                Intrinsics.checkNotNull((Object)v6);
                                new VoaScraper(scrapeContentUrl, v5, this.$containerDir, v6, it.getSqiUid()).run();
                            }
                            catch (IOException var5_6) {
                                v7 = new StringBuilder().append("SEVERE: invalid URL to scrape: should not be in queue:");
                                v8 = it;
                                Intrinsics.checkNotNull((Object)v8);
                                v9 = v8.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v9);
                                throw new RuntimeException(v7.append(v9).toString());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ScrapeQueueItem, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ScrapeQueueItem p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 248, null);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((LiveDataWorkQueue<ScrapeQueueItem>)indexWorkQueue2, null){
                int label;
                final /* synthetic */ LiveDataWorkQueue<ScrapeQueueItem> $indexWorkQueue;
                {
                    this.$indexWorkQueue = $indexWorkQueue;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            this.label = 1;
                            Object object3 = this.$indexWorkQueue.start((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
            int scrapePrecessor = 6;
            ScrapeQueueItemDao scrapeQueueItemDao6 = queueDao;
            if (scrapeQueueItemDao6 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                scrapeQueueItemDao6 = null;
            }
            scrapeWorkQueue = new LiveDataWorkQueue(scrapeQueueItemDao6.findNextQueueItems(2), (Function2)startScrape.2.INSTANCE, scrapePrecessor, null, null, null, null, null, (Function2)new Function2<ScrapeQueueItem, Continuation<? super Unit>, Object>(containerDir, null){
                int label;
                /* synthetic */ Object L$0;
                final /* synthetic */ File $containerDir;
                {
                    this.$containerDir = $containerDir;
                    super(2, $completion);
                }

                /*
                 * Unable to fully structure code
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object var1_1) {
                    var6_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)var1_1);
                            it = (ScrapeQueueItem)this.L$0;
                            v0 = IndexVoaScraper.access$getQueueDao$cp();
                            if (v0 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"queueDao");
                                v0 = null;
                            }
                            v0.updateSetStatusById(it.getSqiUid(), 2, 0);
                            v1 = IndexVoaScraper.access$getContentEntryDao$cp();
                            if (v1 == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"contentEntryDao");
                                v1 = null;
                            }
                            v2 = it;
                            Intrinsics.checkNotNull((Object)v2);
                            this.L$0 = it;
                            this.label = 1;
                            v3 = v1.findByUidAsync(v2.getSqiContentEntryParentUid(), (Continuation)this);
                            if (v3 == var6_2) {
                                return var6_2;
                            }
                            ** GOTO lbl27
                        }
                        case 1: {
                            it = (ScrapeQueueItem)this.L$0;
                            ResultKt.throwOnFailure((Object)$result);
                            v3 = $result;
lbl27:
                            // 2 sources

                            parent = (ContentEntry)v3;
                            try {
                                v4 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v4);
                                scrapeContentUrl = new URL(v4);
                                v5 = it.getDestDir();
                                Intrinsics.checkNotNull((Object)v5);
                                v6 = new File(v5);
                                v7 = parent;
                                Intrinsics.checkNotNull((Object)v7);
                                new VoaScraper(scrapeContentUrl, v6, this.$containerDir, v7, it.getSqiUid()).run();
                            }
                            catch (IOException var5_6) {
                                v8 = new StringBuilder().append("SEVERE: invalid URL to scrape: should not be in queue:");
                                v9 = it.getScrapeUrl();
                                Intrinsics.checkNotNull((Object)v9);
                                throw new RuntimeException(v8.append(v9).toString());
                            }
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    Function2<ScrapeQueueItem, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                    function2.L$0 = value;
                    return (Continuation)function2;
                }

                @Nullable
                public final Object invoke(@NotNull ScrapeQueueItem p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }, 248, null);
            BuildersKt.launch$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(null){
                int label;

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            LiveDataWorkQueue liveDataWorkQueue = IndexVoaScraper.access$getScrapeWorkQueue$cp();
                            if (liveDataWorkQueue == null) {
                                Intrinsics.throwUninitializedPropertyAccessException((String)"scrapeWorkQueue");
                                liveDataWorkQueue = null;
                            }
                            this.label = 1;
                            Object object3 = liveDataWorkQueue.start((Continuation)this);
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)3, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

