/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.ddl;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContentEntryContentCategoryJoinDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import java.io.File;
import java.io.IOException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000  2\u00020\u0001:\u0001 B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002J\u0018\u0010\u001c\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u000fH\u0002J\u0016\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u00042\u0006\u0010\u0003\u001a\u00020\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0015\u001a\u0004\u0018\u00010\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ddl/IndexDdlContent;", "", "()V", "containerDir", "Ljava/io/File;", "contentCategoryChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryContentCategoryJoinDao;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "destinationDirectory", "langCount", "", "langEntry", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "languageDao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "maxNumber", "parentDdl", "browseLanguages", "", "lang", "", "langEntity", "Lcom/ustadmobile/lib/db/entities/Language;", "browseList", "count", "findContent", "destinationDir", "Companion", "lib-content-scrapers"})
public final class IndexDdlContent {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private UmAppDatabase db;
    @Nullable
    private File destinationDirectory;
    private int maxNumber;
    @Nullable
    private ContentEntry parentDdl;
    @Nullable
    private ContentEntry langEntry;
    private int langCount;
    @Nullable
    private ContentEntryDao contentEntryDao;
    @Nullable
    private ContentEntryParentChildJoinDao contentParentChildJoinDao;
    @Nullable
    private ContentEntryContentCategoryJoinDao contentCategoryChildJoinDao;
    private LanguageDao languageDao;
    private File containerDir;
    @NotNull
    private static final String DDL = "DDL";

    public final void findContent(@NotNull File destinationDir, @NotNull File containerDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        destinationDir.mkdirs();
        this.destinationDirectory = destinationDir;
        containerDir.mkdirs();
        this.containerDir = containerDir;
        UmAppDatabase umAppDatabase = this.db;
        if (umAppDatabase == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"db");
            umAppDatabase = null;
        }
        UmAppDatabase repository = umAppDatabase;
        this.contentEntryDao = repository.getContentEntryDao();
        this.contentParentChildJoinDao = repository.getContentEntryParentChildJoinDao();
        this.contentCategoryChildJoinDao = repository.getContentEntryContentCategoryJoinDao();
        this.languageDao = repository.getLanguageDao();
        LanguageDao languageDao = this.languageDao;
        if (languageDao == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageDao");
            languageDao = null;
        }
        Language englishLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao, "en");
        LanguageDao languageDao2 = this.languageDao;
        if (languageDao2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageDao");
            languageDao2 = null;
        }
        Language farsiLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao2, "fa");
        LanguageDao languageDao3 = this.languageDao;
        if (languageDao3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"languageDao");
            languageDao3 = null;
        }
        Language pashtoLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao3, "ps");
        long l = englishLang.getLangUid();
        ContentEntryDao contentEntryDao = this.contentEntryDao;
        Intrinsics.checkNotNull((Object)contentEntryDao);
        ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
        long l2 = englishLang.getLangUid();
        ContentEntryDao contentEntryDao2 = this.contentEntryDao;
        Intrinsics.checkNotNull((Object)contentEntryDao2);
        this.parentDdl = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("https://www.ddl.af/", "Darakht-e Danesh", "https://www.ddl.af/", DDL, 1, l2, null, "Free and open educational resources for Afghanistan", false, "", "https://ddl.af/storage/files/logo-dd.png", "", "", 0, contentEntryDao2);
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
        Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao);
        ContentEntry contentEntry = this.parentDdl;
        Intrinsics.checkNotNull((Object)contentEntry);
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, masterRootParent, contentEntry, 5);
        UMLogUtil.INSTANCE.logTrace("browse English");
        this.browseLanguages("en", englishLang);
        UMLogUtil.INSTANCE.logTrace("browse Farsi");
        this.browseLanguages("fa", farsiLang);
        UMLogUtil.INSTANCE.logTrace("browse Pashto");
        this.browseLanguages("ps", pashtoLang);
    }

    private final void browseLanguages(String lang, Language langEntity) throws IOException {
        Document document2 = Jsoup.connect((String)("https://www.ddl.af/" + lang + "/resources/list")).header("X-Requested-With", "XMLHttpRequest").get();
        Elements pageList = document2.select("a.page-link");
        String string = lang + "/resources/list";
        String string2 = langEntity.getName();
        String string3 = "https://www.ddl.af/" + lang + "/resources/list";
        long l = langEntity.getLangUid();
        ContentEntryDao contentEntryDao = this.contentEntryDao;
        Intrinsics.checkNotNull((Object)contentEntryDao);
        this.langEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, string2, string3, DDL, 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
        Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao);
        ContentEntry contentEntry = this.parentDdl;
        Intrinsics.checkNotNull((Object)contentEntry);
        ContentEntry contentEntry2 = this.langEntry;
        Intrinsics.checkNotNull((Object)contentEntry2);
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, contentEntry, contentEntry2, this.langCount);
        this.maxNumber = 0;
        for (Element page : pageList) {
            String num = page.text();
            try {
                int number = Integer.parseInt(num);
                if (number <= this.maxNumber) continue;
                this.maxNumber = number;
            }
            catch (NumberFormatException numberFormatException) {}
        }
        UMLogUtil.INSTANCE.logTrace(DDL + " max number of pages: " + this.maxNumber);
        this.browseList(lang, 1);
        int n = this.langCount;
        this.langCount = n + 1;
    }

    private final void browseList(String lang, int count) throws IOException {
        int counter = count;
        if (counter > this.maxNumber) {
            return;
        }
        UMLogUtil.INSTANCE.logTrace(DDL + " starting page: " + counter);
        Document document2 = Jsoup.connect((String)("https://www.ddl.af/" + lang + "/resources/list?page=" + counter)).header("X-Requested-With", "XMLHttpRequest").get();
        Elements resourceList = document2.select("article a[href]");
        UMLogUtil.INSTANCE.logTrace(DDL + " found " + resourceList.size() + " articles to download");
        for (Element resource : resourceList) {
            ContentEntry contentEntry;
            String url = resource.attr("href");
            Intrinsics.checkNotNullExpressionValue((Object)url, (String)"url");
            if (!StringsKt.contains$default((CharSequence)url, (CharSequence)"resource/", (boolean)false, (int)2, null)) continue;
            UmAppDatabase umAppDatabase = this.db;
            if (umAppDatabase == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                umAppDatabase = null;
            }
            if ((contentEntry = umAppDatabase.getContentEntryDao().findBySourceUrl(url)) == null) {
                contentEntry = new ContentEntry();
                contentEntry.setSourceUrl(url);
                UmAppDatabase umAppDatabase2 = this.db;
                if (umAppDatabase2 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"db");
                    umAppDatabase2 = null;
                }
                contentEntry.setContentEntryUid(umAppDatabase2.getContentEntryDao().insert((Object)contentEntry));
            }
            try {
                UMLogUtil.INSTANCE.logTrace(DDL + " scraped url: " + url);
            }
            catch (Exception e) {
                UMLogUtil.INSTANCE.logError(DDL + " Exception - Something went wrong here " + url);
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string);
            }
        }
        this.browseList(lang, ++counter);
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\nH\u0007\u00a2\u0006\u0002\u0010\u000bR\u0014\u0010\u0003\u001a\u00020\u0004X\u0080D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/lib/contentscrapers/ddl/IndexDdlContent$Companion;", "", "()V", "DDL", "", "getDDL$lib_content_scrapers", "()Ljava/lang/String;", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final String getDDL$lib_content_scrapers() {
            return DDL;
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 3) {
                System.err.println("Usage:<file destination><container destination><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 3 ? args[2] : "");
            UMLogUtil.INSTANCE.logTrace(args[0]);
            UMLogUtil.INSTANCE.logTrace(args[1]);
            try {
                new IndexDdlContent().findContent(new File(args[0]), new File(args[1]));
            }
            catch (Exception e) {
                UMLogUtil.INSTANCE.logFatal(this.getDDL$lib_content_scrapers() + " Exception running findContent DDL Scraper");
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

