/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.voa;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ScrapeQueueItemDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.ScraperConstants;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.voa.VoaQuiz;
import com.ustadmobile.lib.contentscrapers.voa.VoaResponse;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.DataOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Attribute;
import org.jsoup.nodes.Attributes;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;
import org.openqa.selenium.By;
import org.openqa.selenium.NoSuchElementException;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.WebDriverWait;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B/\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0005\u0012\u0006\u0010\n\u001a\u00020\u0005\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fJ\u0018\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!H\u0002J6\u0010\"\u001a\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u00030#2\u0006\u0010$\u001a\u00020\u00032\u0006\u0010%\u001a\u00020\u000e2\b\u0010&\u001a\u0004\u0018\u00010\u00032\u0006\u0010'\u001a\u00020\u0003H\u0002J\u0010\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020+H\u0002J\b\u0010,\u001a\u00020)H\u0016J\u0006\u0010-\u001a\u00020)R\u001a\u0010\u0010\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0012\"\u0004\b\u0013\u0010\u0014R\u000e\u0010\n\u001a\u00020\u0005X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001e\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0015\u001a\u00020\u0016@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u000e\u0010\u001a\u001a\u00020\fX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001b\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcom/ustadmobile/lib/contentscrapers/voa/VoaScraper;", "Ljava/lang/Runnable;", "url", "", "destinationDir", "Ljava/io/File;", "(Ljava/lang/String;Ljava/io/File;)V", "scrapeUrl", "Ljava/net/URL;", "destinationDirectory", "containerDir", "parent", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "sqiUid", "", "(Ljava/net/URL;Ljava/io/File;Ljava/io/File;Lcom/ustadmobile/lib/db/entities/ContentEntry;I)V", "answerUrl", "getAnswerUrl", "()Ljava/lang/String;", "setAnswerUrl", "(Ljava/lang/String;)V", "<set-?>", "", "isContentUpdated", "isContentUpdated$lib_content_scrapers", "()Z", "parentEntry", "scrapUrl", "voaDirectory", "createConnectionForPost", "Ljava/net/HttpURLConnection;", "answersUrl", "requestParams", "Ljava/lang/StringBuffer;", "createParams", "", "quizId", "count", "selectedAnswer", "voted", "removeAllAttributesFromVideoAudio", "", "document", "Lorg/jsoup/nodes/Document;", "run", "scrapeContent", "lib-content-scrapers"})
public final class VoaScraper
implements Runnable {
    private File containerDir;
    private int sqiUid;
    private ContentEntry parentEntry;
    @NotNull
    private URL scrapUrl;
    @NotNull
    private File voaDirectory;
    @NotNull
    private File destinationDir;
    private boolean isContentUpdated;
    @NotNull
    private String answerUrl;

    public final boolean isContentUpdated$lib_content_scrapers() {
        return this.isContentUpdated;
    }

    @NotNull
    public final String getAnswerUrl() {
        return this.answerUrl;
    }

    public final void setAnswerUrl(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.answerUrl = string;
    }

    public VoaScraper(@NotNull String url, @NotNull File destinationDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        this.isContentUpdated = true;
        this.answerUrl = "https://learningenglish.voanews.com/Quiz/Answer";
        this.scrapUrl = new URL(url);
        this.destinationDir = destinationDir;
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        File file = this.voaDirectory = new File(destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
    }

    public VoaScraper(@NotNull URL scrapeUrl2, @NotNull File destinationDirectory, @NotNull File containerDir, @NotNull ContentEntry parent, int sqiUid) {
        Intrinsics.checkNotNullParameter((Object)scrapeUrl2, (String)"scrapeUrl");
        Intrinsics.checkNotNullParameter((Object)destinationDirectory, (String)"destinationDirectory");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        this.isContentUpdated = true;
        this.answerUrl = "https://learningenglish.voanews.com/Quiz/Answer";
        this.destinationDir = destinationDirectory;
        this.containerDir = containerDir;
        this.scrapUrl = scrapeUrl2;
        this.parentEntry = parent;
        this.sqiUid = sqiUid;
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        File file = this.voaDirectory = new File(this.destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
        Intrinsics.checkNotNull((Object)file);
        file.mkdirs();
    }

    @Override
    public void run() {
        System.gc();
        UmAppDatabase db = null;
        Intrinsics.throwUninitializedPropertyAccessException((String)"db");
        UmAppDatabase repository = null;
        ContainerDao containerDao = repository.getContainerDao();
        ScrapeQueueItemDao queueDao = db.getScrapeQueueItemDao();
        long startTime = System.currentTimeMillis();
        UMLogUtil.INSTANCE.logInfo("Started scraper url " + this.scrapUrl + " at start time: " + startTime);
        queueDao.setTimeStarted(this.sqiUid, startTime);
        boolean successful = false;
        try {
            this.scrapeContent();
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            File content = new File(this.destinationDir, FilenameUtils.getBaseName((String)uRL.getPath()));
            successful = true;
            if (this.isContentUpdated) {
                ContentEntry contentEntry = this.parentEntry;
                if (contentEntry == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"parentEntry");
                    contentEntry = null;
                }
                long l = content.lastModified();
                File file = this.containerDir;
                if (file == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"containerDir");
                    file = null;
                }
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, contentEntry, true, "application/tincan+zip", l, content, db, repository, file);
            }
        }
        catch (Exception e) {
            String string = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logTrace(string);
            StringBuilder stringBuilder = new StringBuilder();
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            ContentScraperUtil.INSTANCE.deleteFile(new File(this.destinationDir, stringBuilder.append(FilenameUtils.getBaseName((String)uRL.getPath())).append("last-modified.txt").toString()));
        }
        queueDao.updateSetStatusById(this.sqiUid, successful ? 3 : 4, 0);
        queueDao.setTimeFinished(this.sqiUid, System.currentTimeMillis());
        long duration = System.currentTimeMillis() - startTime;
        UMLogUtil.INSTANCE.logInfo("Ended scrape for url " + this.scrapUrl + " in duration: " + duration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void scrapeContent() throws IOException {
        String voaData;
        boolean element22;
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        ContentScraperUtil.INSTANCE.setChromeDriverLocation();
        ChromeDriver driver = ContentScraperUtil.INSTANCE.setupChrome(true);
        URL uRL = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL);
        driver.get(uRL.toString());
        WebDriverWait waitDriver = new WebDriverWait((WebDriver)driver, ScraperConstants.INSTANCE.getTIME_OUT_SELENIUM());
        ContentScraperUtil.INSTANCE.waitForJSandJQueryToLoad(waitDriver);
        URL uRL2 = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL2);
        String lessonId = FilenameUtils.getBaseName((String)uRL2.getPath());
        File voaDirectory = new File(this.destinationDir, lessonId);
        File modifiedFile = new File(this.destinationDir, lessonId + "last-modified.txt");
        voaDirectory.mkdirs();
        boolean isUpdated = false;
        try {
            WebElement element22 = driver.findElement(By.cssSelector((String)"script[type*=json]"));
            Object[] objectArray = new Object[]{element22};
            Object object = driver.executeScript("return arguments[0].innerText;", objectArray);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.String");
            String scriptText = (String)object;
            VoaResponse response = (VoaResponse)gson.fromJson(scriptText, VoaResponse.class);
            String string = response.getDateModified();
            Intrinsics.checkNotNull((Object)string);
            long dateModified = ContentScraperUtil.INSTANCE.parseServerDate(StringsKt.replace$default((String)StringsKt.replace$default((String)string, (String)"Z", (String)"", (boolean)false, (int)4, null), (String)" ", (String)"T", (boolean)false, (int)4, null));
            element22 = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(dateModified));
        }
        catch (NoSuchElementException ignored) {
            String string = driver.findElement(By.cssSelector((String)"time")).getAttribute("datetime");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"driver.findElement(By.cs\u2026.getAttribute(\"datetime\")");
            long modified = ContentScraperUtil.INSTANCE.parseServerDate(string);
            element22 = ContentScraperUtil.INSTANCE.isFileContentsUpdated(modifiedFile, String.valueOf(modified));
        }
        isUpdated = element22;
        if (!isUpdated) {
            this.isContentUpdated = false;
            driver.close();
            driver.quit();
            return;
        }
        if (ContentScraperUtil.INSTANCE.fileHasContent(voaDirectory)) {
            FileUtils.deleteDirectory((File)voaDirectory);
            voaDirectory.mkdirs();
        }
        String quizHref = null;
        String quizAjaxUrl = null;
        try {
            WebElement quizElement = driver.findElement(By.cssSelector((String)"a[data-ajax-url*=Quiz]"));
            quizHref = quizElement.getAttribute("href");
            quizAjaxUrl = quizElement.getAttribute("data-ajax-url");
        }
        catch (NoSuchElementException quizElement) {
            // empty catch block
        }
        URL uRL3 = this.scrapUrl;
        Intrinsics.checkNotNull((Object)uRL3);
        Document document2 = Jsoup.connect((String)uRL3.toString()).get();
        Intrinsics.checkNotNullExpressionValue((Object)document2, (String)"document");
        this.removeAllAttributesFromVideoAudio(document2);
        File assetDirectory = new File(voaDirectory, "asset");
        assetDirectory.mkdirs();
        driver.close();
        driver.quit();
        if (quizHref != null && !(((CharSequence)quizHref).length() == 0)) {
            VoaQuiz quizResponse = new VoaQuiz();
            String string = quizAjaxUrl;
            Intrinsics.checkNotNull((Object)string);
            String string2 = string.substring(StringsKt.indexOf$default((CharSequence)quizAjaxUrl, (String)"id=", (int)0, (boolean)false, (int)6, null) + 3, StringsKt.indexOf$default((CharSequence)quizAjaxUrl, (String)"&", (int)0, (boolean)false, (int)6, null));
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String quizId = string2;
            int quizCount = 12;
            quizResponse.setQuizId(quizId);
            File quizFile = new File(voaDirectory, "questions.json");
            ArrayList<VoaQuiz.Questions> questionList = new ArrayList<VoaQuiz.Questions>();
            for (int i = 1; i <= quizCount; i += 2) {
                HttpURLConnection conn = null;
                HttpURLConnection selectedConn = null;
                try {
                    String string3;
                    String questionData;
                    URL answersUrl = new URL(this.answerUrl);
                    File urlDirectory = ContentScraperUtil.INSTANCE.createDirectoryFromUrl(voaDirectory, answersUrl);
                    urlDirectory.mkdirs();
                    File questionPage = new File(urlDirectory, i + "question");
                    Map<String, String> params = this.createParams(quizId, i, null, "True");
                    StringBuffer requestParams = ContentScraperUtil.INSTANCE.convertMapToStringBuffer(params);
                    conn = this.createConnectionForPost(answersUrl, requestParams);
                    conn.connect();
                    String string4 = questionData = IOUtils.toString((InputStream)conn.getInputStream(), (String)"UTF-8");
                    Intrinsics.checkNotNull((Object)string4);
                    Document questionDoc = Jsoup.parse((String)string4);
                    Intrinsics.checkNotNullExpressionValue((Object)questionDoc, (String)"questionDoc");
                    this.removeAllAttributesFromVideoAudio(questionDoc);
                    String quizSize = questionDoc.select("span.caption").text();
                    Intrinsics.checkNotNullExpressionValue((Object)quizSize, (String)"quizSize");
                    int n = quizSize.length() - 1;
                    String string5 = string3.substring(n);
                    Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"this as java.lang.String).substring(startIndex)");
                    quizSize = string5;
                    quizCount = Integer.valueOf(quizSize) * 2;
                    String string6 = questionDoc.html();
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"questionDoc.html()");
                    questionData = ContentScraperUtil.INSTANCE.downloadAllResources(string6, assetDirectory, this.scrapUrl);
                    Element answerLabel = questionDoc.selectFirst("input[name=SelectedAnswerId]");
                    FileUtils.writeStringToFile((File)questionPage, (String)questionData, (String)"UTF-8");
                    String string7 = questionData;
                    Intrinsics.checkNotNull((Object)string7);
                    Document videoDoc = Jsoup.parse((String)string7);
                    VoaQuiz.Questions question = new VoaQuiz.Questions();
                    Element element = questionDoc.selectFirst("h2.ta-l");
                    question.setQuestionText(element != null ? element.text() : null);
                    try {
                        Element mediaSource;
                        Element element3 = mediaSource = videoDoc.selectFirst("div.quiz__answers-img video,div.quiz__answers-img img");
                        question.setVideoHref(element3 != null ? element3.attr("src") : null);
                    }
                    catch (NoSuchElementException mediaSource) {
                    }
                    catch (NullPointerException mediaSource) {
                        // empty catch block
                    }
                    ArrayList<VoaQuiz.Questions.Choices> choiceList = new ArrayList<VoaQuiz.Questions.Choices>();
                    Elements answerTextList = questionDoc.select("label.quiz__answers-label");
                    for (Element answer : answerTextList) {
                        VoaQuiz.Questions.Choices choices = new VoaQuiz.Questions.Choices();
                        Element element4 = answer.selectFirst("input");
                        choices.setId(element4 != null ? element4.attr("value") : null);
                        Element element5 = answer.selectFirst("span.quiz__answers-item-text");
                        choices.setAnswerText(element5 != null ? element5.text() : null);
                        choiceList.add(choices);
                    }
                    question.setChoices((List<VoaQuiz.Questions.Choices>)choiceList);
                    Element element6 = answerLabel;
                    String answerId = element6 != null ? element6.attr("value") : null;
                    Map<String, String> selectedParams = this.createParams(quizId, i + 1, answerId, "False");
                    StringBuffer selectedRequestParams = ContentScraperUtil.INSTANCE.convertMapToStringBuffer(selectedParams);
                    selectedConn = this.createConnectionForPost(answersUrl, selectedRequestParams);
                    File answerPage = new File(urlDirectory, answerId + "answersIndex");
                    selectedConn.connect();
                    FileUtils.copyInputStreamToFile((InputStream)selectedConn.getInputStream(), (File)answerPage);
                    Document selectedAnswerDoc = Jsoup.parse((File)answerPage, (String)"UTF-8");
                    Element element7 = selectedAnswerDoc.selectFirst("li.quiz__answers-item--correct input");
                    question.setAnswerId(element7 != null ? element7.attr("value") : null);
                    Element element8 = selectedAnswerDoc.selectFirst("p.p-t-md");
                    question.setAnswer(element8 != null ? element8.text() : null);
                    questionList.add(question);
                    continue;
                }
                catch (IOException e) {
                    String string8 = ExceptionUtils.getStackTrace((Throwable)e);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"getStackTrace(e)");
                    UMLogUtil.INSTANCE.logError(string8);
                    continue;
                }
                finally {
                    HttpURLConnection httpURLConnection = conn;
                    if (httpURLConnection != null) {
                        httpURLConnection.disconnect();
                    }
                    HttpURLConnection httpURLConnection2 = selectedConn;
                    if (httpURLConnection2 != null) {
                        httpURLConnection2.disconnect();
                    }
                }
            }
            quizResponse.setQuestions((List<VoaQuiz.Questions>)questionList);
            FileUtils.writeStringToFile((File)quizFile, (String)gson.toJson((Object)quizResponse), (String)"UTF-8");
        }
        Element element = document2.selectFirst("div#content");
        String string = element != null ? element.html() : null;
        if (string == null) {
            string = "";
        }
        String string9 = voaData = ContentScraperUtil.INSTANCE.downloadAllResources(string, assetDirectory, this.scrapUrl);
        Intrinsics.checkNotNull((Object)string9);
        Document finalDoc = Jsoup.parse((String)string9);
        finalDoc.head().append("<link rel=\"stylesheet\" href=\"asset/materialize.min.css\">");
        finalDoc.head().append("<meta charset=\"utf-8\" name=\"viewport\"\n          content=\"width=device-width, initial-scale=1, shrink-to-fit=no,user-scalable=no\">");
        finalDoc.head().append("<link rel=\"stylesheet\" href=\"asset/voa.min.css\">");
        finalDoc.body().append("<script type=\"text/javascript\" src=\"asset/iframeResizer.min.js\"></script>");
        finalDoc.body().append("<script type=\"text/javascript\" src=\"asset/voa.min.js\"></script>");
        finalDoc.body().attr("style", "padding:2%");
        if (quizHref != null) {
            Element element9 = finalDoc.selectFirst("div.quiz__body");
            if (element9 != null) {
                element9.after("<div class=\"iframe-container\"><iframe id=\"myFrame\" src=\"quiz.html\" frameborder=\"0\" scrolling=\"no\" width=\"100%\"></frame></div>");
            }
        }
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/quiz.html"), (File)new File(voaDirectory, "quiz.html"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/iframeResizer.min.js"), (File)new File(assetDirectory, "iframeResizer.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/iframeResizer.contentWindow.min.js"), (File)new File(assetDirectory, "iframeResizer.contentWindow.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/jquery-3.3.1.min.js"), (File)new File(assetDirectory, "jquery-3.3.1.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.css"), (File)new File(assetDirectory, "materialize.min.css"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/materialize.min.js"), (File)new File(assetDirectory, "materialize.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voa.min.css"), (File)new File(assetDirectory, "voa.min.css"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voa.min.js"), (File)new File(assetDirectory, "voa.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voaquiz.min.js"), (File)new File(assetDirectory, "voaquiz.min.js"));
        FileUtils.copyToFile((InputStream)this.getClass().getResourceAsStream("/com/ustadmobile/lib/contentscrapers/voa/voaquiz.min.css"), (File)new File(assetDirectory, "voaquiz.min.css"));
        FileUtils.writeStringToFile((File)new File(voaDirectory, "index.html"), (String)finalDoc.toString(), (String)"UTF-8");
        try {
            URL uRL4 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL4);
            String string10 = FilenameUtils.getBaseName((String)uRL4.toString());
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"getBaseName(scrapUrl!!.toString())");
            URL uRL5 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL5);
            String string11 = uRL5.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"scrapUrl!!.path");
            ContentScraperUtil.INSTANCE.generateTinCanXMLFile(voaDirectory, string10, "en", "index.html", "http://activitystrea.ms/schema/1.0/video", string11, "", "");
        }
        catch (TransformerException e) {
            String string12 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string12, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string12);
            StringBuilder stringBuilder = new StringBuilder().append("VOA failed to create tin can file for url ");
            URL uRL6 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL6);
            UMLogUtil.INSTANCE.logError(stringBuilder.append(uRL6).toString());
        }
        catch (ParserConfigurationException e) {
            String string13 = ExceptionUtils.getStackTrace((Throwable)e);
            Intrinsics.checkNotNullExpressionValue((Object)string13, (String)"getStackTrace(e)");
            UMLogUtil.INSTANCE.logError(string13);
            StringBuilder stringBuilder = new StringBuilder().append("VOA failed to create tin can file for url ");
            URL uRL7 = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL7);
            UMLogUtil.INSTANCE.logError(stringBuilder.append(uRL7).toString());
        }
    }

    private final Map<String, String> createParams(String quizId, int count, String selectedAnswer, String voted) {
        HashMap selectedParams = new HashMap();
        if (selectedAnswer != null) {
            ((Map)selectedParams).put("SelectedAnswerId", selectedAnswer);
        }
        ((Map)selectedParams).put("QuestionVoted", voted);
        ((Map)selectedParams).put("quizId", quizId);
        ((Map)selectedParams).put("PageIndex", String.valueOf(count));
        ((Map)selectedParams).put("isEmbedded", "True");
        return selectedParams;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final HttpURLConnection createConnectionForPost(URL answersUrl, StringBuffer requestParams) throws IOException {
        HttpURLConnection conn = null;
        DataOutputStream out = null;
        try {
            URLConnection uRLConnection = answersUrl.openConnection();
            Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
            conn = (HttpURLConnection)uRLConnection;
            conn.setRequestMethod("POST");
            conn.setDoOutput(true);
            conn.setDoInput(true);
            conn.setRequestProperty("Content-length", String.valueOf(requestParams.length()));
            conn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            URL uRL = this.scrapUrl;
            Intrinsics.checkNotNull((Object)uRL);
            conn.setRequestProperty("Referer", uRL.toString());
            out = new DataOutputStream(conn.getOutputStream());
            out.writeBytes(requestParams.toString());
        }
        catch (Throwable throwable) {
            DataOutputStream dataOutputStream = out;
            if (dataOutputStream != null) {
                dataOutputStream.flush();
            }
            DataOutputStream dataOutputStream2 = out;
            if (dataOutputStream2 != null) {
                dataOutputStream2.close();
            }
            throw throwable;
        }
        out.flush();
        out.close();
        return conn;
    }

    private final void removeAllAttributesFromVideoAudio(Document document2) {
        document2.select("div.c-spinner").remove();
        document2.select("div.js-poster").remove();
        document2.select("a.c-mmp__fallback-link").remove();
        document2.select("div#comments").remove();
        document2.select("div.article-share").remove();
        document2.select("div.link-function").remove();
        document2.select("div.media-download").remove();
        document2.select("div.c-mmp__overlay").remove();
        document2.select("button.btn-popout-player").remove();
        document2.select("div.js-cpanel-container").remove();
        document2.select("div.design-top-offset").remove();
        document2.select("div.quiz__main-img").remove();
        document2.select("div.quiz__intro").remove();
        document2.select("div.media-block-wrap").remove();
        document2.select("aside.js-share--horizontal").remove();
        document2.select("div.nav-tabs__inner").remove();
        document2.select("[href]").removeAttr("href");
        Elements linkElements = document2.select("video,audio");
        for (Element link : linkElements) {
            ArrayList<String> keys = new ArrayList<String>();
            Attributes attrList = link.attributes();
            for (Attribute attribute : attrList) {
                Intrinsics.checkNotNullExpressionValue((Object)attribute, (String)"attrList");
                String key = (String)((Map.Entry)attribute).getKey();
                if (Intrinsics.areEqual((Object)key, (Object)"src")) continue;
                keys.add(key);
            }
            for (String key : keys) {
                link.removeAttr(key);
            }
            link.attr("controls", "controls");
        }
    }
}

