/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.etekkatho;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.ContainerDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContentEntryParentChildJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.lib.contentscrapers.ContentScraperUtil;
import com.ustadmobile.lib.contentscrapers.UMLogUtil;
import com.ustadmobile.lib.contentscrapers.etekkatho.EtekkathoScraper;
import com.ustadmobile.lib.db.entities.ContentEntry;
import com.ustadmobile.lib.db.entities.Language;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\f\u0018\u0000 $2\u00020\u0001:\u0001$B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0006H\u0002J\"\u0010\u001c\u001a\u00020\u00192\b\u0010\u001d\u001a\u0004\u0018\u00010\u00122\u0006\u0010\u001e\u001a\u00020\u00112\u0006\u0010\u001f\u001a\u00020\u0006H\u0002J\u001e\u0010 \u001a\u00020\u00192\u0006\u0010!\u001a\u00020\u00112\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u0006R\u0010\u0010\u0003\u001a\u0004\u0018\u00010\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0005\u001a\u0004\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0007\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0010\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u0012\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0013\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0016\u001a\u0004\u0018\u00010\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006%"}, d2={"Lcom/ustadmobile/lib/contentscrapers/etekkatho/IndexEtekkathoScraper;", "", "()V", "containerDao", "Lcom/ustadmobile/core/db/dao/ContainerDao;", "containerDirectory", "Ljava/io/File;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "contentParentChildJoinDao", "Lcom/ustadmobile/core/db/dao/ContentEntryParentChildJoinDao;", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "englishLang", "Lcom/ustadmobile/lib/db/entities/Language;", "headingHashMap", "Ljava/util/HashMap;", "", "Lcom/ustadmobile/lib/db/entities/ContentEntry;", "repository", "subjectCount", "", "url", "Ljava/net/URL;", "browseSubHeading", "", "hrefLink", "folder", "browseSubjects", "contentEntry", "subHrefLink", "subHeadingFolder", "findContent", "urlString", "destinationDir", "containerDir", "Companion", "lib-content-scrapers"})
public final class IndexEtekkathoScraper {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private URL url;
    @Nullable
    private ContentEntryDao contentEntryDao;
    @Nullable
    private ContentEntryParentChildJoinDao contentParentChildJoinDao;
    @Nullable
    private HashMap<String, ContentEntry> headingHashMap;
    @Nullable
    private Language englishLang;
    private int subjectCount;
    @Nullable
    private ContainerDao containerDao;
    @Nullable
    private UmAppDatabase db;
    @Nullable
    private UmAppDatabase repository;
    @Nullable
    private File containerDirectory;
    @NotNull
    private static final String ETEKKATHO = "Etekkatho";

    public final void findContent(@NotNull String urlString, @NotNull File destinationDir, @NotNull File containerDir) throws IOException {
        Intrinsics.checkNotNullParameter((Object)urlString, (String)"urlString");
        Intrinsics.checkNotNullParameter((Object)destinationDir, (String)"destinationDir");
        Intrinsics.checkNotNullParameter((Object)containerDir, (String)"containerDir");
        try {
            this.url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            UMLogUtil.INSTANCE.logError("Index Malformed url" + urlString);
            throw new IllegalArgumentException("Malformed url" + urlString, e);
        }
        destinationDir.mkdirs();
        containerDir.mkdirs();
        this.containerDirectory = containerDir;
        UmAppDatabase umAppDatabase = this.repository = this.db;
        Intrinsics.checkNotNull((Object)umAppDatabase);
        this.contentEntryDao = umAppDatabase.getContentEntryDao();
        UmAppDatabase umAppDatabase2 = this.repository;
        Intrinsics.checkNotNull((Object)umAppDatabase2);
        this.contentParentChildJoinDao = umAppDatabase2.getContentEntryParentChildJoinDao();
        UmAppDatabase umAppDatabase3 = this.repository;
        Intrinsics.checkNotNull((Object)umAppDatabase3);
        this.containerDao = umAppDatabase3.getContainerDao();
        UmAppDatabase umAppDatabase4 = this.repository;
        Intrinsics.checkNotNull((Object)umAppDatabase4);
        LanguageDao languageDao = umAppDatabase4.getLanguageDao();
        this.headingHashMap = new HashMap();
        Language language = this.englishLang = ContentScraperUtil.INSTANCE.insertOrUpdateLanguageByName(languageDao, "English");
        Intrinsics.checkNotNull((Object)language);
        long l = language.getLangUid();
        ContentEntryDao contentEntryDao = this.contentEntryDao;
        Intrinsics.checkNotNull((Object)contentEntryDao);
        ContentEntry masterRootParent = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("root", "Ustad Mobile", "root", "Ustad Mobile", 1, l, null, "", false, "", "", "", "", 0, contentEntryDao);
        Language language2 = this.englishLang;
        Intrinsics.checkNotNull((Object)language2);
        long l2 = language2.getLangUid();
        ContentEntryDao contentEntryDao2 = this.contentEntryDao;
        Intrinsics.checkNotNull((Object)contentEntryDao2);
        ContentEntry parentEtek = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry("http://www.etekkatho.org/subjects/", "eTekkatho", "http://www.etekkatho.org/", ETEKKATHO, 1, l2, null, "Educational resources for the Myanmar academic community", false, "", "http://www.etekkatho.org/img/logos/etekkatho-myanmar-lang.png", "", "", 0, contentEntryDao2);
        ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
        Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao);
        ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao, masterRootParent, parentEtek, 6);
        Document document2 = Jsoup.connect((String)urlString).get();
        Elements elements = document2.select("tr th[scope=row], tr td");
        int subjectCount = 0;
        int headingCount = 0;
        ContentEntry subjectEntry = null;
        for (int i = 0; i < elements.size(); ++i) {
            Element element = (Element)elements.get(i);
            String string = element.attr("scope");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"element.attr(\"scope\")");
            if (!(((CharSequence)string).length() == 0)) {
                String title;
                Element element2 = element.selectFirst("a");
                URL headingUrl = new URL(this.url, element2 != null ? element2.attr("href") : null);
                String string2 = element.text();
                String string3 = element.text();
                String string4 = headingUrl.toString();
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"headingUrl.toString()");
                Language language3 = this.englishLang;
                Intrinsics.checkNotNull((Object)language3);
                long l3 = language3.getLangUid();
                ContentEntryDao contentEntryDao3 = this.contentEntryDao;
                Intrinsics.checkNotNull((Object)contentEntryDao3);
                subjectEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string2, string3, string4, ETEKKATHO, 1, l3, null, "", false, "", "", "", "", 0, contentEntryDao3);
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao2 = this.contentParentChildJoinDao;
                Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao2);
                ContentEntry contentEntry = subjectEntry;
                Intrinsics.checkNotNull((Object)contentEntry);
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao2, parentEtek, contentEntry, subjectCount++);
                Element subHeadingElement = (Element)elements.get(++i);
                Element descriptionElement = (Element)elements.get(++i);
                String string5 = title = subHeadingElement.text();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"title");
                if (StringsKt.contains$default((CharSequence)string5, (CharSequence)"*", (boolean)false, (int)2, null)) {
                    String string6 = title;
                    Intrinsics.checkNotNullExpressionValue((Object)string6, (String)"title");
                    String $this$trim$iv = StringsKt.replace$default((String)string6, (String)"*", (String)"", (boolean)false, (int)4, null);
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim2 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl2 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    title = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                String string7 = element.text() + '/' + title;
                Language language4 = this.englishLang;
                Intrinsics.checkNotNull((Object)language4);
                long l4 = language4.getLangUid();
                String string8 = descriptionElement.text();
                ContentEntryDao contentEntryDao4 = this.contentEntryDao;
                Intrinsics.checkNotNull((Object)contentEntryDao4);
                ContentEntry subHeadingEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(title, title, string7, ETEKKATHO, 1, l4, null, string8, false, "", "", "", "", 0, contentEntryDao4);
                HashMap<String, ContentEntry> hashMap = this.headingHashMap;
                Intrinsics.checkNotNull(hashMap);
                Map $i$f$trim = hashMap;
                String string9 = title;
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"title");
                $i$f$trim.put(string9, subHeadingEntry);
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao3 = this.contentParentChildJoinDao;
                Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao3);
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao3, subjectEntry, subHeadingEntry, headingCount++);
                continue;
            }
            if (element.hasClass("span3")) {
                String title;
                Element descriptionElement = (Element)elements.get(++i);
                String string10 = title = element.text();
                Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"title");
                if (StringsKt.contains$default((CharSequence)string10, (CharSequence)"*", (boolean)false, (int)2, null)) {
                    String string11 = title;
                    Intrinsics.checkNotNullExpressionValue((Object)string11, (String)"title");
                    String $this$trim$iv = StringsKt.replace$default((String)string11, (String)"*", (String)"", (boolean)false, (int)4, null);
                    boolean $i$f$trim = false;
                    CharSequence $this$trim$iv$iv = $this$trim$iv;
                    boolean $i$f$trim3 = false;
                    int startIndex$iv$iv = 0;
                    int endIndex$iv$iv = $this$trim$iv$iv.length() - 1;
                    boolean startFound$iv$iv = false;
                    while (startIndex$iv$iv <= endIndex$iv$iv) {
                        boolean match$iv$iv;
                        int index$iv$iv = !startFound$iv$iv ? startIndex$iv$iv : endIndex$iv$iv;
                        char it = $this$trim$iv$iv.charAt(index$iv$iv);
                        boolean bl = false;
                        boolean bl3 = match$iv$iv = Intrinsics.compare((int)it, (int)32) <= 0;
                        if (!startFound$iv$iv) {
                            if (!match$iv$iv) {
                                startFound$iv$iv = true;
                                continue;
                            }
                            ++startIndex$iv$iv;
                            continue;
                        }
                        if (!match$iv$iv) break;
                        --endIndex$iv$iv;
                    }
                    title = ((Object)$this$trim$iv$iv.subSequence(startIndex$iv$iv, endIndex$iv$iv + 1)).toString();
                }
                String string12 = element.text();
                StringBuilder stringBuilder = new StringBuilder();
                ContentEntry contentEntry = subjectEntry;
                Intrinsics.checkNotNull(contentEntry);
                String string13 = stringBuilder.append(contentEntry.getTitle()).append('/').append(title).toString();
                Language language5 = this.englishLang;
                Intrinsics.checkNotNull((Object)language5);
                long l5 = language5.getLangUid();
                String string14 = descriptionElement.text();
                ContentEntryDao contentEntryDao5 = this.contentEntryDao;
                Intrinsics.checkNotNull((Object)contentEntryDao5);
                ContentEntry subHeadingEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string12, title, string13, ETEKKATHO, 1, l5, null, string14, false, "", "", "", "", 0, contentEntryDao5);
                HashMap<String, ContentEntry> hashMap = this.headingHashMap;
                Intrinsics.checkNotNull(hashMap);
                Map $i$f$trim = hashMap;
                String string15 = title;
                Intrinsics.checkNotNullExpressionValue((Object)string15, (String)"title");
                $i$f$trim.put(string15, subHeadingEntry);
                ContentEntryParentChildJoinDao contentEntryParentChildJoinDao4 = this.contentParentChildJoinDao;
                Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao4);
                ContentScraperUtil.INSTANCE.insertOrUpdateParentChildJoin(contentEntryParentChildJoinDao4, subjectEntry, subHeadingEntry, headingCount++);
                continue;
            }
            if (!element.hasClass("span6")) continue;
            UMLogUtil.INSTANCE.logError("Should not come here" + element.text());
        }
        Elements subjectList = document2.select("th.span3 a");
        for (Element subject : subjectList) {
            String hrefLink = subject.attr("href");
            File folder = new File(destinationDir, subject.text());
            folder.mkdirs();
            Intrinsics.checkNotNullExpressionValue((Object)hrefLink, (String)"hrefLink");
            this.browseSubHeading(hrefLink, folder);
        }
    }

    private final void browseSubHeading(String hrefLink, File folder) throws IOException {
        URL subHeadingUrl = new URL(this.url, hrefLink);
        Document document2 = Jsoup.connect((String)subHeadingUrl.toString()).get();
        Elements subHeadingList = document2.select("div.row li a");
        for (Element subHeading : subHeadingList) {
            String subHrefLink = subHeading.attr("href");
            String title = subHeading.text();
            File subHeadingFolder = new File(folder, title);
            subHeadingFolder.mkdirs();
            HashMap<String, ContentEntry> hashMap = this.headingHashMap;
            Intrinsics.checkNotNull(hashMap);
            ContentEntry subject = hashMap.get(title);
            if (subject == null) {
                UMLogUtil.INSTANCE.logError("Subheading title was not found " + title);
                if (Intrinsics.areEqual((Object)title, (Object)"Agriculture, aquaculture and the environment")) {
                    HashMap<String, ContentEntry> hashMap2 = this.headingHashMap;
                    Intrinsics.checkNotNull(hashMap2);
                    subject = hashMap2.get("Agriculture and the environment");
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)subHrefLink, (String)"subHrefLink");
            this.browseSubjects(subject, subHrefLink, subHeadingFolder);
        }
    }

    private final void browseSubjects(ContentEntry contentEntry, String subHrefLink, File subHeadingFolder) throws IOException {
        URL subjectListUrl = new URL(this.url, subHrefLink);
        Document document2 = Jsoup.connect((String)subjectListUrl.toString()).get();
        Elements subjectList = document2.select("dl.results-item");
        for (Element subject : subjectList) {
            String subjectUrlString;
            Element publisherElement;
            Element authorElement;
            Element descriptionElement;
            Element titleElement;
            Element element = titleElement = subject.selectFirst("dd.title");
            String title = element != null ? element.text() : "";
            Element element2 = descriptionElement = subject.selectFirst("dd.description");
            String description = element2 != null ? element2.text() : "";
            Element element3 = authorElement = subject.selectFirst("dd.author");
            String author = element3 != null ? element3.text() : "";
            Element element4 = publisherElement = subject.selectFirst("dd.publisher");
            String publisher = element4 != null ? element4.text() : ETEKKATHO;
            Element element5 = subject.selectFirst("a");
            String hrefLink = element5 != null ? element5.attr("href") : null;
            URL subjectUrl = new URL(this.url, hrefLink);
            Intrinsics.checkNotNullExpressionValue((Object)subjectUrl.toString(), (String)"subjectUrl.toString()");
            String string = subjectUrl.getQuery();
            Intrinsics.checkNotNullExpressionValue((Object)publisher, (String)"publisher");
            Language language = this.englishLang;
            Intrinsics.checkNotNull((Object)language);
            long l = language.getLangUid();
            ContentEntryDao contentEntryDao = this.contentEntryDao;
            Intrinsics.checkNotNull((Object)contentEntryDao);
            ContentEntry lessonEntry = ContentScraperUtil.INSTANCE.createOrUpdateContentEntry(string, title, subjectUrlString, publisher, 1, l, null, description, true, author, "", "", "", 0, contentEntryDao);
            ContentEntryParentChildJoinDao contentEntryParentChildJoinDao = this.contentParentChildJoinDao;
            Intrinsics.checkNotNull((Object)contentEntryParentChildJoinDao);
            ContentEntry contentEntry2 = contentEntry;
            Intrinsics.checkNotNull((Object)contentEntry2);
            int n = this.subjectCount;
            this.subjectCount = n + 1;
            ContentScraperUtil.INSTANCE.insertOrUpdateChildWithMultipleParentsJoin(contentEntryParentChildJoinDao, contentEntry2, lessonEntry, n);
            EtekkathoScraper scraper = new EtekkathoScraper(subjectUrlString, subHeadingFolder);
            try {
                String fileName;
                scraper.scrapeContent();
                Intrinsics.checkNotNullExpressionValue((Object)subjectUrlString.substring(StringsKt.indexOf$default((CharSequence)subjectUrlString, (String)"=", (int)0, (boolean)false, (int)6, null) + 1), (String)"this as java.lang.String).substring(startIndex)");
                File contentFolder = new File(subHeadingFolder, fileName);
                File content = new File(contentFolder, fileName);
                if (!scraper.isUpdated()) continue;
                ContainerDao containerDao = this.containerDao;
                Intrinsics.checkNotNull((Object)containerDao);
                String string2 = scraper.getMimeType();
                Intrinsics.checkNotNull((Object)string2);
                long l2 = content.lastModified();
                UmAppDatabase umAppDatabase = this.db;
                Intrinsics.checkNotNull((Object)umAppDatabase);
                UmAppDatabase umAppDatabase2 = this.repository;
                Intrinsics.checkNotNull((Object)umAppDatabase2);
                File file = this.containerDirectory;
                Intrinsics.checkNotNull((Object)file);
                ContentScraperUtil.INSTANCE.insertContainer(containerDao, lessonEntry, true, string2, l2, content, umAppDatabase, umAppDatabase2, file);
                ContentScraperUtil.INSTANCE.deleteFile(content);
            }
            catch (Exception e) {
                String string3 = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logError(string3);
                UMLogUtil.INSTANCE.logError("Unable to scrape content from " + title + " at url " + subjectUrlString);
            }
        }
        Element nextLink = document2.selectFirst("li.next a");
        if (nextLink != null) {
            String string = nextLink.attr("href");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"nextLink.attr(\"href\")");
            this.browseSubjects(contentEntry, string, subHeadingFolder);
        }
    }

    @JvmStatic
    public static final void main(@NotNull String[] args) {
        Companion.main(args);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001b\u0010\u0005\u001a\u00020\u00062\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00040\bH\u0007\u00a2\u0006\u0002\u0010\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/lib/contentscrapers/etekkatho/IndexEtekkathoScraper$Companion;", "", "()V", "ETEKKATHO", "", "main", "", "args", "", "([Ljava/lang/String;)V", "lib-content-scrapers"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        public final void main(@NotNull String[] args) {
            Intrinsics.checkNotNullParameter((Object)args, (String)"args");
            if (args.length < 3) {
                System.err.println("Usage: <etekkatho html url> <file destination><file container><optional log{trace, debug, info, warn, error, fatal}>");
                System.exit(1);
            }
            UMLogUtil.INSTANCE.setLevel(args.length == 4 ? args[3] : "");
            UMLogUtil.INSTANCE.logInfo(args[0]);
            UMLogUtil.INSTANCE.logInfo(args[1]);
            try {
                new IndexEtekkathoScraper().findContent(args[0], new File(args[1]), new File(args[2]));
            }
            catch (IOException e) {
                String string = ExceptionUtils.getStackTrace((Throwable)e);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getStackTrace(e)");
                UMLogUtil.INSTANCE.logFatal(string);
                UMLogUtil.INSTANCE.logFatal("Exception running findContent Etek");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

