/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.lib.contentscrapers.khanacademy;

import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.container.ContainerAddOptions;
import com.ustadmobile.core.controller.VideoContentPresenterCommon;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.io.ext.UmAppDatabaseContainerIoExtKt;
import com.ustadmobile.door.DoorUri;
import com.ustadmobile.door.ext.FileExpectExtKt;
import com.ustadmobile.lib.contentscrapers.abztract.Scraper;
import com.ustadmobile.lib.contentscrapers.abztract.ScraperException;
import com.ustadmobile.lib.contentscrapers.abztract.YoutubeScraper;
import com.ustadmobile.lib.contentscrapers.khanacademy.KhanConstantsKt;
import com.ustadmobile.lib.db.entities.Container;
import com.ustadmobile.lib.db.entities.ContainerETag;
import com.ustadmobile.lib.db.entities.ContentEntry;
import java.io.File;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.io.FilesKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u000e\u0010\u0011\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fJ\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u000fH\u0002J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u000fH\u0016R\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\r\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/lib/contentscrapers/khanacademy/KhanLiteVideoScraper;", "Lcom/ustadmobile/lib/contentscrapers/abztract/YoutubeScraper;", "contentEntryUid", "", "sqiUid", "", "parentContentEntryUid", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(JIJLcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "getDi", "()Lorg/kodein/di/DI;", "getMp4LowUrl", "", "videoId", "getMp4Url", "getValidUrl", "Ljava/net/URL;", "khanId", "scrapeUrl", "", "sourceUrl", "lib-content-scrapers"})
public final class KhanLiteVideoScraper
extends YoutubeScraper {
    @NotNull
    private final DI di;

    public KhanLiteVideoScraper(long contentEntryUid, int sqiUid, long parentContentEntryUid, @NotNull Endpoint endpoint, @NotNull DI di) {
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        super(contentEntryUid, sqiUid, parentContentEntryUid, endpoint, di);
        this.di = di;
    }

    @Override
    @NotNull
    public DI getDi() {
        return this.di;
    }

    @Override
    public void scrapeUrl(@NotNull String sourceUrl) {
        Intrinsics.checkNotNullParameter((Object)sourceUrl, (String)"sourceUrl");
        Ref.ObjectRef entry = new Ref.ObjectRef();
        BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>((Ref.ObjectRef<ContentEntry>)entry, this, null){
            Object L$0;
            int label;
            final /* synthetic */ Ref.ObjectRef<ContentEntry> $entry;
            final /* synthetic */ KhanLiteVideoScraper this$0;
            {
                this.$entry = $entry;
                this.this$0 = $receiver;
                super(2, $completion);
            }

            /*
             * Unable to fully structure code
             */
            @Nullable
            public final Object invokeSuspend(@NotNull Object var1_1) {
                var3_2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)var1_1);
                        this.L$0 = var2_3 = this.$entry;
                        this.label = 1;
                        v0 = this.this$0.getDb().getContentEntryDao().findByUidAsync(this.this$0.getContentEntryUid(), (Continuation)this);
                        if (v0 == var3_2) {
                            return var3_2;
                        }
                        ** GOTO lbl15
                    }
                    case 1: {
                        var2_3 = (Ref.ObjectRef<ContentEntry>)this.L$0;
                        ResultKt.throwOnFailure((Object)$result);
                        v0 = $result;
lbl15:
                        // 2 sources

                        var2_3.element = v0;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            @NotNull
            public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            @Nullable
            public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), (int)1, null);
        if (entry.element == null) {
            this.hideContentEntry();
            throw new ScraperException(104, "Content Entry was not found for url " + sourceUrl);
        }
        Object object = entry.element;
        Intrinsics.checkNotNull((Object)object);
        String string = ((ContentEntry)object).getSourceUrl();
        Intrinsics.checkNotNull((Object)string);
        String khanId = StringsKt.substringAfter$default((String)string, (String)"khan-id://", null, (int)2, null);
        URL url = this.getValidUrl(khanId);
        if (url == null) {
            String ytUrl = KhanConstantsKt.getYoutubeUrl(khanId);
            try {
                super.scrapeYoutubeVideo(ytUrl, "worst[ext=webm]/worst");
            }
            catch (ScraperException s) {
                this.close();
                throw s;
            }
            catch (Exception e) {
                this.close();
                throw e;
            }
        } else {
            Container recentContainer = this.getDb().getContainerDao().getMostRecentContainerForContentEntry(this.getContentEntryUid());
            Scraper.HeadRequestValues headRequestValues = this.isUrlContentUpdated(url, recentContainer);
            String ext = (String)VideoContentPresenterCommon.Companion.getVIDEO_MIME_MAP().get(headRequestValues.getMimeType());
            if (!VideoContentPresenterCommon.Companion.getVIDEO_MIME_MAP().keySet().contains(headRequestValues.getMimeType())) {
                this.hideContentEntry();
                this.setScrapeDone(false, 100);
                throw new ScraperException(100, "Video type not supported for " + headRequestValues.getMimeType() + " for url " + url);
            }
            if (recentContainer != null && !headRequestValues.isUpdated()) {
                this.showContentEntry();
                this.setScrapeDone(true, 0);
                return;
            }
            File tempDir = Files.createTempDirectory(khanId, new FileAttribute[0]).toFile();
            File tempFile = new File(tempDir, khanId + ext);
            FileUtils.copyURLToFile((URL)url, (File)tempFile);
            Container container2 = this.createBaseContainer(headRequestValues.getMimeType());
            ContainerAddOptions containerAddOptions = new ContainerAddOptions(FileExpectExtKt.toDoorUri((File)this.getContainerFolder()), false, null, null, false, 30, null);
            BuildersKt.runBlocking$default(null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, container2, tempFile, containerAddOptions, null){
                int label;
                final /* synthetic */ KhanLiteVideoScraper this$0;
                final /* synthetic */ Container $container;
                final /* synthetic */ File $tempFile;
                final /* synthetic */ ContainerAddOptions $containerAddOptions;
                {
                    this.this$0 = $receiver;
                    this.$container = $container;
                    this.$tempFile = $tempFile;
                    this.$containerAddOptions = $containerAddOptions;
                    super(2, $completion);
                }

                /*
                 * WARNING - void declaration
                 * Enabled force condition propagation
                 * Lifted jumps to return sites
                 */
                @Nullable
                public final Object invokeSuspend(@NotNull Object object) {
                    Object object2 = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                    switch (this.label) {
                        case 0: {
                            ResultKt.throwOnFailure((Object)object);
                            UmAppDatabase umAppDatabase = this.this$0.getRepo();
                            long l = this.$container.getContainerUid();
                            DoorUri doorUri = FileExpectExtKt.toDoorUri((File)this.$tempFile);
                            String string = this.$tempFile.getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"tempFile.name");
                            this.label = 1;
                            Object object3 = UmAppDatabaseContainerIoExtKt.addFileToContainer((UmAppDatabase)umAppDatabase, (long)l, (DoorUri)doorUri, (String)string, (Object)new Object(), (DI)this.this$0.getDi(), (ContainerAddOptions)this.$containerAddOptions, (Continuation)((Continuation)this));
                            if (object3 != object2) return Unit.INSTANCE;
                            return object2;
                        }
                        case 1: {
                            void $result;
                            ResultKt.throwOnFailure((Object)$result);
                            Object object3 = $result;
                            return Unit.INSTANCE;
                        }
                    }
                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                }

                @NotNull
                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> $completion) {
                    return (Continuation)new /* invalid duplicate definition of identical inner class */;
                }

                @Nullable
                public final Object invoke(@NotNull CoroutineScope p1, @Nullable Continuation<? super Unit> p2) {
                    return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
                }
            }), (int)1, null);
            CharSequence charSequence = headRequestValues.getMimeType();
            if (!(charSequence == null || charSequence.length() == 0)) {
                ContainerETag etagContainer = new ContainerETag(container2.getContainerUid(), headRequestValues.getEtag());
                this.getDb().getContainerETagDao().insert((Object)etagContainer);
            }
            this.showContentEntry();
            this.setScrapeDone(true, 0);
            Intrinsics.checkNotNullExpressionValue((Object)tempDir, (String)"tempDir");
            FilesKt.deleteRecursively((File)tempDir);
        }
    }

    private final URL getValidUrl(String khanId) {
        URL lowUrl = new URL(this.getMp4LowUrl(khanId));
        URL mp4Url = new URL(this.getMp4Url(khanId));
        return KhanConstantsKt.isUrlValid(lowUrl) ? lowUrl : (KhanConstantsKt.isUrlValid(mp4Url) ? mp4Url : (URL)null);
    }

    @NotNull
    public final String getMp4LowUrl(@NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        return "https://cdn.kastatic.org/ka-youtube-converted/" + videoId + ".mp4-low/" + videoId + "-low.mp4";
    }

    @NotNull
    public final String getMp4Url(@NotNull String videoId) {
        Intrinsics.checkNotNullParameter((Object)videoId, (String)"videoId");
        return "https://cdn.kastatic.org/ka-youtube-converted/" + videoId + ".mp4/" + videoId + ".mp4";
    }
}

