/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.contentformats.xapi.endpoints;

import com.google.gson.Gson;
import com.neovisionaries.i18n.CountryCode;
import com.neovisionaries.i18n.LanguageCode;
import com.ustadmobile.core.contentformats.xapi.Actor;
import com.ustadmobile.core.contentformats.xapi.Definition;
import com.ustadmobile.core.contentformats.xapi.Result;
import com.ustadmobile.core.contentformats.xapi.State;
import com.ustadmobile.core.contentformats.xapi.Statement;
import com.ustadmobile.core.contentformats.xapi.Verb;
import com.ustadmobile.core.contentformats.xapi.XContext;
import com.ustadmobile.core.contentformats.xapi.XObject;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.AgentDao;
import com.ustadmobile.core.db.dao.ContentEntryDao;
import com.ustadmobile.core.db.dao.ContextXObjectStatementJoinDao;
import com.ustadmobile.core.db.dao.LanguageDao;
import com.ustadmobile.core.db.dao.LanguageVariantDao;
import com.ustadmobile.core.db.dao.PersonDao;
import com.ustadmobile.core.db.dao.StateContentDao;
import com.ustadmobile.core.db.dao.StateDao;
import com.ustadmobile.core.db.dao.StatementDao;
import com.ustadmobile.core.db.dao.VerbDao;
import com.ustadmobile.core.db.dao.XLangMapEntryDao;
import com.ustadmobile.core.db.dao.XObjectDao;
import com.ustadmobile.core.util.TimeUtilKt;
import com.ustadmobile.core.util.UMCalendarUtil;
import com.ustadmobile.lib.db.entities.AgentEntity;
import com.ustadmobile.lib.db.entities.ContextXObjectStatementJoin;
import com.ustadmobile.lib.db.entities.Language;
import com.ustadmobile.lib.db.entities.LanguageVariant;
import com.ustadmobile.lib.db.entities.Person;
import com.ustadmobile.lib.db.entities.StateContentEntity;
import com.ustadmobile.lib.db.entities.StateEntity;
import com.ustadmobile.lib.db.entities.StatementEntity;
import com.ustadmobile.lib.db.entities.VerbEntity;
import com.ustadmobile.lib.db.entities.XLangMapEntry;
import com.ustadmobile.lib.db.entities.XObjectEntity;
import com.ustadmobile.lib.util.SystemTimeKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u00e8\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J*\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0012\u0010\u000b\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u001e\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0018\u0010\u0017\u001a\u0004\u0018\u00010\u00182\u0006\u0010\u0011\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016J\u0012\u0010\u0019\u001a\u00020\u00062\b\u0010\u001a\u001a\u0004\u0018\u00010\u0005H\u0002J&\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0011\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\u0006J\u001e\u0010\"\u001a\u00020\b2\u0006\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(J\u0016\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020\u0005J\"\u0010.\u001a\u0004\u0018\u00010/2\u0006\u00100\u001a\u0002012\b\u00102\u001a\u0004\u0018\u00010\u00052\u0006\u00103\u001a\u00020*J\u001e\u00104\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u0002052\u0006\u00106\u001a\u0002072\u0006\u00108\u001a\u00020\u001fJ*\u00109\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020\n2\u0012\u0010:\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00010\f2\u0006\u0010\r\u001a\u00020\u000eJ\u009c\u0001\u0010;\u001a\u00020$2\u0006\u0010\u0011\u001a\u00020<2\u0006\u0010=\u001a\u00020>2\u0006\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020\u001f2\u0006\u0010B\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010C\u001a\u00020\u00052\u0006\u0010D\u001a\u00020\u001f2\u0006\u00108\u001a\u00020\u001f2\u0006\u0010E\u001a\u00020\u001f2\u0006\u0010F\u001a\u00020\u001f2\u0006\u0010G\u001a\u00020\u001f2\u0006\u0010H\u001a\u00020\u001f2\u0006\u0010I\u001a\u00020\u001f2\b\b\u0002\u0010J\u001a\u00020\u001f2\u0006\u0010K\u001a\u00020\u001f2\b\b\u0002\u0010L\u001a\u00020M2\b\b\u0002\u0010N\u001a\u00020\u001fJ\u0016\u0010O\u001a\u00020(2\u0006\u0010\u0011\u001a\u00020P2\u0006\u0010Q\u001a\u00020RJ.\u0010S\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020T2\u0006\u0010Q\u001a\u00020R2\u0006\u0010'\u001a\u00020(2\u0006\u0010+\u001a\u00020,2\u0006\u0010U\u001a\u000201J0\u0010V\u001a\u00020W2\u0006\u0010\u0011\u001a\u00020X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010?\u001a\u00020@2\u0006\u0010[\u001a\u00020\\2\b\b\u0002\u0010J\u001a\u00020\u001fJ.\u0010]\u001a\u00020\b2\u0006\u0010\u0011\u001a\u00020T2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010^\u001a\u00020W2\u0006\u0010+\u001a\u00020,2\u0006\u0010U\u001a\u000201J\u000e\u0010_\u001a\u00020\u0006*\u0004\u0018\u00010\u0001H\u0002J\n\u0010`\u001a\u00020\u0006*\u00020MR\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006a"}, d2={"Lcom/ustadmobile/port/sharedse/contentformats/xapi/endpoints/XapiUtil;", "", "()V", "statusFlagMap", "", "", "", "deleteAndInsertNewStateContent", "", "stateContentDao", "Lcom/ustadmobile/core/db/dao/StateContentDao;", "content", "Ljava/util/HashMap;", "stateEntity", "Lcom/ustadmobile/lib/db/entities/StateEntity;", "getAgent", "Lcom/ustadmobile/lib/db/entities/AgentEntity;", "dao", "Lcom/ustadmobile/core/db/dao/AgentDao;", "personDao", "Lcom/ustadmobile/core/db/dao/PersonDao;", "actor", "Lcom/ustadmobile/core/contentformats/xapi/Actor;", "getPerson", "Lcom/ustadmobile/lib/db/entities/Person;", "getStatusFlag", "id", "insertOrUpdateContextStatementJoin", "Lcom/ustadmobile/lib/db/entities/ContextXObjectStatementJoin;", "Lcom/ustadmobile/core/db/dao/ContextXObjectStatementJoinDao;", "statementUid", "", "objectUid", "flag", "insertOrUpdateEntryProgress", "statementEntity", "Lcom/ustadmobile/lib/db/entities/StatementEntity;", "repo", "Lcom/ustadmobile/core/db/UmAppDatabase;", "verbEntity", "Lcom/ustadmobile/lib/db/entities/VerbEntity;", "insertOrUpdateLanguageByTwoCode", "Lcom/ustadmobile/lib/db/entities/Language;", "languageDao", "Lcom/ustadmobile/core/db/dao/LanguageDao;", "langTwoCode", "insertOrUpdateLanguageVariant", "Lcom/ustadmobile/lib/db/entities/LanguageVariant;", "variantDao", "Lcom/ustadmobile/core/db/dao/LanguageVariantDao;", "variant", "language", "insertOrUpdateState", "Lcom/ustadmobile/core/db/dao/StateDao;", "state", "Lcom/ustadmobile/core/contentformats/xapi/State;", "agentUid", "insertOrUpdateStateContent", "contentMap", "insertOrUpdateStatementEntity", "Lcom/ustadmobile/core/db/dao/StatementDao;", "statement", "Lcom/ustadmobile/core/contentformats/xapi/Statement;", "gson", "Lcom/google/gson/Gson;", "personUid", "verbUid", "contextStatementUid", "instructorUid", "authorityUid", "teamUid", "subActorUid", "subVerbUid", "subObjectUid", "contentEntryUid", "learnerGroupUid", "contentEntryRoot", "", "clazzUid", "insertOrUpdateVerb", "Lcom/ustadmobile/core/db/dao/VerbDao;", "verb", "Lcom/ustadmobile/core/contentformats/xapi/Verb;", "insertOrUpdateVerbLangMap", "Lcom/ustadmobile/core/db/dao/XLangMapEntryDao;", "languageVariantDao", "insertOrUpdateXObject", "Lcom/ustadmobile/lib/db/entities/XObjectEntity;", "Lcom/ustadmobile/core/db/dao/XObjectDao;", "xobject", "Lcom/ustadmobile/core/contentformats/xapi/XObject;", "contentEntryDao", "Lcom/ustadmobile/core/db/dao/ContentEntryDao;", "insertOrUpdateXObjectLangMap", "xObjectEntity", "anyToInt", "toInt", "sharedse_debug"})
public final class XapiUtil {
    @NotNull
    public static final XapiUtil INSTANCE = new XapiUtil();
    @NotNull
    private static final Map<String, Integer> statusFlagMap;

    private XapiUtil() {
    }

    @NotNull
    public final AgentEntity getAgent(@NotNull AgentDao dao, @NotNull PersonDao personDao, @NotNull Actor actor) {
        String string;
        String string2;
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)personDao, (String)"personDao");
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Person person = this.getPerson(personDao, actor);
        String string3 = actor.getOpenid();
        String string4 = actor.getMbox();
        if (actor.getAccount() != null) {
            Actor.Account account = actor.getAccount();
            Intrinsics.checkNotNull((Object)account);
            string2 = account.getName();
        } else {
            string2 = null;
        }
        if (actor.getAccount() != null) {
            Actor.Account account = actor.getAccount();
            Intrinsics.checkNotNull((Object)account);
            string = account.getHomePage();
        } else {
            string = null;
        }
        AgentEntity agentEntity = dao.getAgentByAnyId(string3, string4, string2, string, actor.getMbox_sha1sum());
        if (agentEntity == null) {
            String string5;
            String string6;
            agentEntity = new AgentEntity();
            agentEntity.setAgentOpenid(actor.getOpenid());
            agentEntity.setAgentMbox(actor.getMbox());
            if (actor.getAccount() != null) {
                Actor.Account account = actor.getAccount();
                Intrinsics.checkNotNull((Object)account);
                string6 = account.getName();
            } else {
                string6 = null;
            }
            agentEntity.setAgentAccountName(string6);
            if (actor.getAccount() != null) {
                Actor.Account account = actor.getAccount();
                Intrinsics.checkNotNull((Object)account);
                string5 = account.getHomePage();
            } else {
                string5 = null;
            }
            agentEntity.setAgentHomePage(string5);
            agentEntity.setAgentMbox_sha1sum(actor.getMbox_sha1sum());
            Person person2 = person;
            agentEntity.setAgentPersonUid(person2 != null ? person2.getPersonUid() : 0L);
            agentEntity.setAgentUid(dao.insert((Object)agentEntity));
        }
        return agentEntity;
    }

    @NotNull
    public final VerbEntity insertOrUpdateVerb(@NotNull VerbDao dao, @NotNull Verb verb) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
        VerbEntity verbEntity = dao.findByUrl(verb.getId());
        if (verbEntity == null) {
            verbEntity = new VerbEntity();
            verbEntity.setUrlId(verb.getId());
            verbEntity.setVerbUid(dao.insert((Object)verbEntity));
        }
        return verbEntity;
    }

    /*
     * WARNING - void declaration
     */
    public final void insertOrUpdateVerbLangMap(@NotNull XLangMapEntryDao dao, @NotNull Verb verb, @NotNull VerbEntity verbEntity, @NotNull LanguageDao languageDao, @NotNull LanguageVariantDao languageVariantDao) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)verb, (String)"verb");
        Intrinsics.checkNotNullParameter((Object)verbEntity, (String)"verbEntity");
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)languageVariantDao, (String)"languageVariantDao");
        Map verbDisplay = verb.getDisplay();
        if (verbDisplay != null) {
            void $this$mapNotNullTo$iv$iv;
            Map $this$mapNotNull$iv = verbDisplay;
            boolean $i$f$mapNotNull = false;
            Map map = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                XLangMapEntry xLangMapEntry;
                Map.Entry element$iv$iv$iv;
                Map.Entry element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                Map.Entry it = element$iv$iv;
                boolean bl2 = false;
                Language lang = INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao, StringsKt.substringBefore$default((String)((String)it.getKey()), (char)'-', null, (int)2, null));
                String it2 = StringsKt.substringAfter((String)((String)it.getKey()), (String)"-", (String)"");
                boolean bl3 = false;
                LanguageVariant variant = !Intrinsics.areEqual((Object)it2, (Object)"") ? INSTANCE.insertOrUpdateLanguageVariant(languageVariantDao, it2, lang) : null;
                XLangMapEntry existingMap = dao.getXLangMapFromVerb(verbEntity.getVerbUid(), lang.getLangUid());
                if (existingMap == null) {
                    LanguageVariant languageVariant = variant;
                    xLangMapEntry = new XLangMapEntry(verbEntity.getVerbUid(), 0L, lang.getLangUid(), languageVariant != null ? languageVariant.getLangVariantUid() : 0L, (String)it.getValue(), 0, 0, 0, 0L, 480, null);
                } else {
                    xLangMapEntry = null;
                }
                if (xLangMapEntry == null) continue;
                XLangMapEntry it$iv$iv = xLangMapEntry;
                boolean bl4 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            List listToInsert = (List)destination$iv$iv;
            if (!((Collection)listToInsert).isEmpty()) {
                dao.insertList(listToInsert);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public final void insertOrUpdateXObjectLangMap(@NotNull XLangMapEntryDao dao, @NotNull XObject xobject, @NotNull XObjectEntity xObjectEntity, @NotNull LanguageDao languageDao, @NotNull LanguageVariantDao languageVariantDao) {
        List listToInsert;
        List list;
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)xobject, (String)"xobject");
        Intrinsics.checkNotNullParameter((Object)xObjectEntity, (String)"xObjectEntity");
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)languageVariantDao, (String)"languageVariantDao");
        Object object = xobject.getDefinition();
        if (object != null && (object = object.getName()) != null) {
            void $this$mapTo$iv$iv;
            Object $this$map$iv = object;
            boolean $i$f$map = false;
            Object object2 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList($this$map$iv.size());
            boolean $i$f$mapTo = false;
            Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
            while (iterator.hasNext()) {
                XLangMapEntry xLangMapEntry;
                void it;
                Map.Entry item$iv$iv;
                Map.Entry entry = item$iv$iv = iterator.next();
                Collection collection = destination$iv$iv;
                boolean bl = false;
                String[] stringArray = new String[]{"-"};
                List split = StringsKt.split$default((CharSequence)((CharSequence)it.getKey()), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                Language lang = INSTANCE.insertOrUpdateLanguageByTwoCode(languageDao, (String)split.get(0));
                LanguageVariant variant = INSTANCE.insertOrUpdateLanguageVariant(languageVariantDao, (String)split.get(1), lang);
                XLangMapEntry existingMap = dao.getXLangMapFromObject(xObjectEntity.getXObjectUid(), lang.getLangUid());
                if (existingMap == null) {
                    LanguageVariant languageVariant = variant;
                    xLangMapEntry = new XLangMapEntry(0L, xObjectEntity.getXObjectUid(), lang.getLangUid(), languageVariant != null ? languageVariant.getLangVariantUid() : 0L, (String)it.getValue(), 0, 0, 0, 0L, 480, null);
                } else {
                    xLangMapEntry = null;
                }
                collection.add(xLangMapEntry);
            }
            list = CollectionsKt.filterNotNull((Iterable)((List)destination$iv$iv));
        } else {
            list = listToInsert = null;
        }
        if (listToInsert != null && !((Collection)listToInsert).isEmpty()) {
            dao.insertList(listToInsert);
        }
    }

    @NotNull
    public final ContextXObjectStatementJoin insertOrUpdateContextStatementJoin(@NotNull ContextXObjectStatementJoinDao dao, long statementUid, long objectUid, int flag) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        ContextXObjectStatementJoin join = dao.findByStatementAndObjectUid(statementUid, objectUid);
        if (join == null) {
            join = new ContextXObjectStatementJoin();
            join.setContextActivityFlag(flag);
            join.setContextStatementUid(statementUid);
            join.setContextXObjectUid(objectUid);
            join.setContextXObjectStatementJoinUid(dao.insert((Object)join));
        }
        return join;
    }

    @NotNull
    public final XObjectEntity insertOrUpdateXObject(@NotNull XObjectDao dao, @NotNull XObject xobject, @NotNull Gson gson, @NotNull ContentEntryDao contentEntryDao, long contentEntryUid) {
        XObjectEntity changedXObject;
        block2: {
            XObjectDao xObjectDao;
            XObjectEntity entity;
            block1: {
                Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
                Intrinsics.checkNotNullParameter((Object)xobject, (String)"xobject");
                Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
                Intrinsics.checkNotNullParameter((Object)contentEntryDao, (String)"contentEntryDao");
                String string = xobject.getId();
                if (string == null) {
                    throw new IllegalArgumentException("XObject has no id");
                }
                String xObjectId = string;
                entity = dao.findByObjectId(xObjectId);
                long contentEntryUidVal = contentEntryUid != 0L ? contentEntryUid : contentEntryDao.getContentEntryUidFromXapiObjectId(xObjectId);
                Definition definition = xobject.getDefinition();
                Definition definition2 = definition;
                Definition definition3 = definition;
                Definition definition4 = definition;
                changedXObject = new XObjectEntity(xobject.getId(), xobject.getObjectType(), definition2 != null ? definition2.getType() : "", definition3 != null ? definition3.getInteractionType() : "", definition4 != null ? gson.toJson((Object)definition4.getCorrectResponsePattern()) : "", contentEntryUidVal, xobject.getStatementRefUid());
                if (entity != null) break block1;
                changedXObject.setXObjectUid(dao.insert((Object)changedXObject));
                break block2;
            }
            changedXObject.setXObjectUid(entity.getXObjectUid());
            XObjectDao it = xObjectDao = dao;
            boolean bl = false;
            Object object = !Intrinsics.areEqual((Object)changedXObject, (Object)entity) ? xObjectDao : null;
            if (object == null) break block2;
            object.update((Object)changedXObject);
        }
        return changedXObject;
    }

    public static /* synthetic */ XObjectEntity insertOrUpdateXObject$default(XapiUtil xapiUtil, XObjectDao xObjectDao, XObject xObject, Gson gson, ContentEntryDao contentEntryDao, long l, int n, Object object) {
        if ((n & 0x10) != 0) {
            l = 0L;
        }
        return xapiUtil.insertOrUpdateXObject(xObjectDao, xObject, gson, contentEntryDao, l);
    }

    @Nullable
    public final Person getPerson(@NotNull PersonDao dao, @NotNull Actor actor) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)actor, (String)"actor");
        Person person = null;
        if (actor.getAccount() != null) {
            Actor.Account account = actor.getAccount();
            Intrinsics.checkNotNull((Object)account);
            person = dao.findByUsername(account.getName());
        }
        return person;
    }

    @NotNull
    public final Language insertOrUpdateLanguageByTwoCode(@NotNull LanguageDao languageDao, @NotNull String langTwoCode) {
        Intrinsics.checkNotNullParameter((Object)languageDao, (String)"languageDao");
        Intrinsics.checkNotNullParameter((Object)langTwoCode, (String)"langTwoCode");
        Language language = languageDao.findByTwoCode(langTwoCode);
        if (language == null) {
            language = new Language();
            language.setIso_639_1_standard(langTwoCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langTwoCode);
            if (nameOfLang != null) {
                language.setName(nameOfLang.getName());
            }
            language.setLangUid(languageDao.insert((Object)language));
        } else {
            Language changedLang = new Language();
            changedLang.setLangUid(language.getLangUid());
            changedLang.setIso_639_1_standard(langTwoCode);
            LanguageCode nameOfLang = LanguageCode.getByCode((String)langTwoCode);
            if (nameOfLang != null) {
                changedLang.setName(nameOfLang.getName());
            }
            boolean isChanged = false;
            if (language.getIso_639_1_standard() == null || !Intrinsics.areEqual((Object)language.getIso_639_1_standard(), (Object)changedLang.getIso_639_1_standard())) {
                isChanged = true;
            }
            if (language.getName() == null || Intrinsics.areEqual((Object)language.getName(), (Object)changedLang.getName())) {
                isChanged = true;
            }
            if (isChanged) {
                languageDao.update(changedLang);
            }
            language = changedLang;
        }
        return language;
    }

    @Nullable
    public final LanguageVariant insertOrUpdateLanguageVariant(@NotNull LanguageVariantDao variantDao, @Nullable String variant, @NotNull Language language) {
        Intrinsics.checkNotNullParameter((Object)variantDao, (String)"variantDao");
        Intrinsics.checkNotNullParameter((Object)language, (String)"language");
        LanguageVariant languageVariant = null;
        if (variant != null && ((CharSequence)variant).length() > 0) {
            CountryCode countryCode = CountryCode.getByCode((String)variant);
            if (countryCode == null) {
                List countryList = CountryCode.findByName((String)variant);
                Intrinsics.checkNotNullExpressionValue((Object)countryList, (String)"countryList");
                if (!((Collection)countryList).isEmpty()) {
                    countryCode = (CountryCode)countryList.get(0);
                }
            }
            if (countryCode != null) {
                String alpha2 = countryCode.getAlpha2();
                String name = countryCode.getName();
                Intrinsics.checkNotNullExpressionValue((Object)alpha2, (String)"alpha2");
                languageVariant = variantDao.findByCode(alpha2);
                if (languageVariant == null) {
                    languageVariant = new LanguageVariant();
                    languageVariant.setCountryCode(alpha2);
                    languageVariant.setName(name);
                    languageVariant.setLangUid(language.getLangUid());
                    languageVariant.setLangVariantUid(variantDao.insert((Object)languageVariant));
                } else {
                    LanguageVariant changedVariant = new LanguageVariant();
                    changedVariant.setLangVariantUid(languageVariant.getLangVariantUid());
                    changedVariant.setCountryCode(alpha2);
                    changedVariant.setName(name);
                    changedVariant.setLangUid(language.getLangUid());
                    if (!Intrinsics.areEqual((Object)changedVariant, (Object)languageVariant)) {
                        variantDao.update((Object)languageVariant);
                    }
                    languageVariant = changedVariant;
                }
            }
        }
        return languageVariant;
    }

    @NotNull
    public final StateEntity insertOrUpdateState(@NotNull StateDao dao, @NotNull State state, long agentUid) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        StateEntity stateEntity = dao.findByStateId(state.getStateId(), agentUid, state.getActivityId(), state.getRegistration());
        StateEntity changedState = new StateEntity(state.getActivityId(), agentUid, state.getRegistration(), state.getStateId(), true, System.currentTimeMillis());
        if (stateEntity == null) {
            changedState.setStateUid(dao.insert((Object)changedState));
        } else {
            changedState.setStateUid(stateEntity.getStateUid());
            if (!Intrinsics.areEqual((Object)changedState, (Object)stateEntity)) {
                dao.update((Object)changedState);
            }
        }
        return changedState;
    }

    public final void insertOrUpdateStateContent(@NotNull StateContentDao dao, @NotNull HashMap<String, Object> contentMap, @NotNull StateEntity stateEntity) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter(contentMap, (String)"contentMap");
        Intrinsics.checkNotNullParameter((Object)stateEntity, (String)"stateEntity");
        for (String key : contentMap.keySet()) {
            Object value = contentMap.get(key);
            Intrinsics.checkNotNullExpressionValue((Object)key, (String)"key");
            StateContentEntity content = dao.findStateContentByKeyAndStateUid(key, stateEntity.getStateUid());
            if (content == null) {
                StateContentEntity contentEntity = new StateContentEntity(key, stateEntity.getStateUid(), String.valueOf(value), true);
                contentEntity.setStateContentUid(dao.insert((Object)contentEntity));
                continue;
            }
            StateContentEntity changedContent = new StateContentEntity(key, stateEntity.getStateUid(), String.valueOf(value), true);
            changedContent.setStateContentUid(content.getStateContentUid());
            if (Intrinsics.areEqual((Object)changedContent, (Object)content)) continue;
            dao.update((Object)changedContent);
        }
    }

    public final void deleteAndInsertNewStateContent(@NotNull StateContentDao stateContentDao, @NotNull HashMap<String, Object> content, @NotNull StateEntity stateEntity) {
        Intrinsics.checkNotNullParameter((Object)stateContentDao, (String)"stateContentDao");
        Intrinsics.checkNotNullParameter(content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)stateEntity, (String)"stateEntity");
        stateContentDao.setInActiveStateContentByKeyAndUid(false, stateEntity.getStateUid(), SystemTimeKt.getSystemTimeInMillis());
        this.insertOrUpdateStateContent(stateContentDao, content, stateEntity);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final StatementEntity insertOrUpdateStatementEntity(@NotNull StatementDao dao, @NotNull Statement statement, @NotNull Gson gson, long personUid, long verbUid, long objectUid, @NotNull String contextStatementUid, long instructorUid, long agentUid, long authorityUid, long teamUid, long subActorUid, long subVerbUid, long subObjectUid, long contentEntryUid, long learnerGroupUid, boolean contentEntryRoot, long clazzUid) {
        Intrinsics.checkNotNullParameter((Object)dao, (String)"dao");
        Intrinsics.checkNotNullParameter((Object)statement, (String)"statement");
        Intrinsics.checkNotNullParameter((Object)gson, (String)"gson");
        Intrinsics.checkNotNullParameter((Object)contextStatementUid, (String)"contextStatementUid");
        String string = statement.getId();
        if (string == null) {
            throw new IllegalArgumentException("Statement " + statement + " to be stored has no id!");
        }
        String statementId = string;
        StatementEntity statementEntity = dao.findByStatementId(statementId);
        if (statementEntity == null) {
            XContext statementContext;
            StatementEntity statementEntity2;
            StatementEntity it = statementEntity2 = new StatementEntity();
            boolean bl = false;
            it.setStatementPersonUid(personUid);
            it.setStatementId(statement.getId());
            it.setStatementVerbUid(verbUid);
            it.setXObjectUid(objectUid);
            it.setAgentUid(agentUid);
            it.setAuthorityUid(authorityUid);
            it.setInstructorUid(instructorUid);
            it.setTeamUid(teamUid);
            it.setContextStatementId(contextStatementUid);
            it.setSubStatementActorUid(subActorUid);
            it.setSubstatementVerbUid(subVerbUid);
            it.setSubStatementObjectUid(subObjectUid);
            it.setTimestamp(UMCalendarUtil.parse8601TimestampOrDefault$default((UMCalendarUtil)UMCalendarUtil.INSTANCE, (String)statement.getTimestamp(), (long)0L, (int)2, null));
            it.setStored(UMCalendarUtil.parse8601TimestampOrDefault$default((UMCalendarUtil)UMCalendarUtil.INSTANCE, (String)statement.getStored(), (long)0L, (int)2, null));
            it.setStatementContentEntryUid(contentEntryUid);
            it.setStatementLearnerGroupUid(learnerGroupUid);
            it.setContentEntryRoot(contentEntryRoot);
            it.setStatementClazzUid(clazzUid);
            it.setFullStatement(gson.toJson((Object)statement));
            statementEntity = statementEntity2;
            Result statementResult = statement.getResult();
            if (statementResult != null) {
                Object progressExtension;
                long l;
                statementEntity.setResultCompletion(statementResult.getCompletion());
                StatementEntity statementEntity3 = statementEntity;
                String string2 = statementResult.getDuration();
                if (string2 != null) {
                    void it2;
                    String string3 = string2;
                    StatementEntity statementEntity4 = statementEntity3;
                    boolean bl2 = false;
                    long l2 = TimeUtilKt.parse8601Duration((String)it2);
                    statementEntity3 = statementEntity4;
                    l = l2;
                } else {
                    l = 0L;
                }
                statementEntity3.setResultDuration(l);
                statementEntity.setResultResponse(statementResult.getResponse());
                Boolean success = statementResult.getSuccess();
                statementEntity.setResultSuccess((byte)(success != null ? (success.booleanValue() ? 2 : 1) : 0));
                Result.Score resultScore = statementResult.getScore();
                if (resultScore != null) {
                    statementEntity.setResultScoreMax(resultScore.getMax());
                    statementEntity.setResultScoreMin(resultScore.getMin());
                    statementEntity.setResultScoreScaled(resultScore.getScaled());
                    statementEntity.setResultScoreRaw(resultScore.getRaw());
                }
                Map map = statementResult.getExtensions();
                Object object = progressExtension = map != null ? map.get("https://w3id.org/xapi/cmi5/result/extensions/progress") : null;
                if (progressExtension != null) {
                    statementEntity.setExtensionProgress(this.anyToInt(progressExtension));
                }
            } else {
                statementEntity.setResultSuccess((byte)0);
            }
            if ((statementContext = statement.getContext()) != null) {
                statementEntity.setContextPlatform(statementContext.getPlatform());
                statementEntity.setContextRegistration(statementContext.getRegistration());
            }
            statementEntity.setStatementUid(dao.insert((Object)statementEntity));
        }
        return statementEntity;
    }

    public static /* synthetic */ StatementEntity insertOrUpdateStatementEntity$default(XapiUtil xapiUtil, StatementDao statementDao, Statement statement, Gson gson, long l, long l2, long l3, String string, long l4, long l5, long l6, long l7, long l8, long l9, long l10, long l11, long l12, boolean bl, long l13, int n, Object object) {
        if ((n & 0x4000) != 0) {
            l11 = 0L;
        }
        if ((n & 0x10000) != 0) {
            bl = false;
        }
        if ((n & 0x20000) != 0) {
            l13 = 0L;
        }
        return xapiUtil.insertOrUpdateStatementEntity(statementDao, statement, gson, l, l2, l3, string, l4, l5, l6, l7, l8, l9, l10, l11, l12, bl, l13);
    }

    public final void insertOrUpdateEntryProgress(@NotNull StatementEntity statementEntity, @NotNull UmAppDatabase repo, @NotNull VerbEntity verbEntity) {
        Intrinsics.checkNotNullParameter((Object)statementEntity, (String)"statementEntity");
        Intrinsics.checkNotNullParameter((Object)repo, (String)"repo");
        Intrinsics.checkNotNullParameter((Object)verbEntity, (String)"verbEntity");
        int statusFlag = this.getStatusFlag(verbEntity.getUrlId());
        int progress = statementEntity.getExtensionProgress();
        if (progress == 0 && (statusFlag == 100 || statusFlag == 102 || statementEntity.getResultCompletion())) {
            progress = 100;
            repo.getStatementDao().updateProgress(statementEntity.getStatementUid(), progress, SystemTimeKt.getSystemTimeInMillis());
        }
    }

    private final int getStatusFlag(String id) {
        Integer n = statusFlagMap.get(id);
        return n != null ? n : 0;
    }

    public final int toInt(boolean $this$toInt) {
        return $this$toInt ? 1 : 0;
    }

    private final int anyToInt(Object $this$anyToInt) {
        return $this$anyToInt instanceof Double ? (int)((Number)$this$anyToInt).doubleValue() : ($this$anyToInt instanceof Float ? (int)((Number)$this$anyToInt).floatValue() : ($this$anyToInt instanceof Integer ? ((Number)$this$anyToInt).intValue() : ($this$anyToInt instanceof Long ? (int)((Number)$this$anyToInt).longValue() : ($this$anyToInt instanceof String ? Integer.parseInt((String)$this$anyToInt) : 0))));
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to((Object)"http://adlnet.gov/expapi/verbs/completed", (Object)100), TuplesKt.to((Object)"http://adlnet.gov/expapi/verbs/passed", (Object)102), TuplesKt.to((Object)"http://adlnet.gov/expapi/verbs/failed", (Object)103), TuplesKt.to((Object)"https://w3id.org/xapi/adl/verbs/satisfied", (Object)100)};
        statusFlagMap = MapsKt.mapOf((Pair[])pairArray);
    }
}

