/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.NetworkInfo;
import android.net.wifi.WifiConfiguration;
import android.net.wifi.WifiManager;
import android.util.Log;
import com.ustadmobile.core.impl.UMAndroidUtil;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.List;

public class NetworkManagerBleHelper {
    private WifiManager wifiManager;
    private ConnectivityManager connectivityManager;
    private final List<String> temporaryWifiDirectSsids = new ArrayList<String>();
    private String ssid;
    private String passphrase;
    private int lastNetworkIdAdded = -1;

    public NetworkManagerBleHelper(Context context) {
        if (this.wifiManager == null) {
            this.wifiManager = (WifiManager)context.getApplicationContext().getSystemService("wifi");
        }
        if (this.connectivityManager == null) {
            this.connectivityManager = (ConnectivityManager)context.getSystemService("connectivity");
        }
    }

    public WifiManager getWifiManager() {
        return this.wifiManager;
    }

    public ConnectivityManager getConnectivityManager() {
        return this.connectivityManager;
    }

    public void setGroupInfo(String ssid, String passphrase) {
        this.ssid = ssid;
        this.passphrase = passphrase;
        this.lastNetworkIdAdded = -1;
        if (ssid.startsWith("DIRECT-")) {
            this.temporaryWifiDirectSsids.add(ssid);
        }
    }

    public int addNetwork() {
        int networkId;
        WifiConfiguration config = new WifiConfiguration();
        config.SSID = "\"" + this.ssid + "\"";
        config.preSharedKey = "\"" + this.passphrase + "\"";
        config.allowedKeyManagement.set(1);
        config.allowedAuthAlgorithms.set(0);
        config.allowedProtocols.set(1);
        config.allowedPairwiseCiphers.set(2);
        config.allowedGroupCiphers.set(3);
        config.allowedProtocols.set(1);
        config.hiddenSSID = true;
        this.lastNetworkIdAdded = networkId = this.wifiManager.addNetwork(config);
        return networkId;
    }

    public int getLastNetworkIdAdded() {
        List configuredNetworks = this.wifiManager.getConfiguredNetworks();
        for (WifiConfiguration config : configuredNetworks) {
            if (!UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(config.SSID).equals(this.ssid)) continue;
            return config.networkId;
        }
        return -1;
    }

    public void deleteTemporaryWifiDirectSsids() {
        if (this.temporaryWifiDirectSsids.isEmpty()) {
            return;
        }
        List configuredNetworks = this.wifiManager.getConfiguredNetworks();
        for (WifiConfiguration config : configuredNetworks) {
            boolean removedOk;
            String ssid;
            if (config.SSID == null || !this.temporaryWifiDirectSsids.contains(ssid = UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(config.SSID)) || !(removedOk = this.wifiManager.removeNetwork(config.networkId))) continue;
            this.temporaryWifiDirectSsids.remove(ssid);
            if (!this.temporaryWifiDirectSsids.isEmpty()) continue;
            return;
        }
    }

    public boolean enableWifiNetwork() {
        if (this.isConnectedToWifi()) {
            this.disableCurrentWifiNetwork();
        }
        try {
            Class<?> actionLister = Class.forName("android.net.wifi.WifiManager$ActionListener");
            Object proxyInstance = Proxy.newProxyInstance(actionLister.getClassLoader(), new Class[]{actionLister}, (InvocationHandler)new WifiConnectInvocationProxyHandler());
            Method connectMethod = this.wifiManager.getClass().getMethod("connect", Integer.TYPE, actionLister);
            int networkId = this.lastNetworkIdAdded == -1 ? this.addNetwork() : this.lastNetworkIdAdded;
            connectMethod.invoke((Object)this.wifiManager, networkId, proxyInstance);
            return true;
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return false;
    }

    private void disableCurrentWifiNetwork() {
        if (this.isConnectedToWifi() && this.wifiManager.disconnect()) {
            this.wifiManager.disableNetwork(this.wifiManager.getConnectionInfo().getNetworkId());
        }
    }

    private boolean isConnectedToWifi() {
        NetworkInfo info = this.connectivityManager.getActiveNetworkInfo();
        return info != null && info.getType() == 1 && info.isConnected();
    }

    public void restoreWiFi() {
        this.wifiManager.disconnect();
        this.deleteTemporaryWifiDirectSsids();
        this.wifiManager.reconnect();
    }

    public class WifiConnectInvocationProxyHandler
    implements InvocationHandler {
        @Override
        public Object invoke(Object proxy, Method method, Object[] args) {
            Log.d((String)"Invocation", (String)("Method was invoked using reflection  " + method.getName()));
            return null;
        }
    }
}

