/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.util;

import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.ReentrantLock;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\u000e\u0010\r\u001a\u00020\u000b2\u0006\u0010\b\u001a\u00020\u000eR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/port/sharedse/util/RunnableQueue;", "", "()V", "lock", "Ljava/util/concurrent/locks/ReentrantLock;", "queue", "Ljava/util/Vector;", "Ljava/lang/Runnable;", "ready", "Ljava/util/concurrent/atomic/AtomicBoolean;", "runWhenReady", "", "runnable", "setReady", "", "sharedse_debug"})
public final class RunnableQueue {
    @NotNull
    private final Vector<Runnable> queue = new Vector();
    @NotNull
    private final AtomicBoolean ready = new AtomicBoolean(false);
    @NotNull
    private final ReentrantLock lock = new ReentrantLock();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void runWhenReady(@NotNull Runnable runnable) {
        Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
        try {
            this.lock.lock();
            if (this.ready.get()) {
                runnable.run();
            } else {
                this.queue.add(runnable);
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void setReady(boolean ready) {
        List itemsToRun = null;
        try {
            this.lock.lock();
            if (ready && !this.ready.get()) {
                this.ready.set(ready);
                itemsToRun = new LinkedList(this.queue);
                this.queue.clear();
            }
        }
        finally {
            this.lock.unlock();
        }
        if (itemsToRun != null) {
            for (Runnable r : itemsToRun) {
                r.run();
            }
        }
    }
}

