/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import com.ustadmobile.sharedse.io.ByteBufferSe;
import io.ktor.utils.io.charsets.CharsetJVMKt;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0016\n\u0002\b\t\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\b\u0086\b\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0001H\u0096\u0002J\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0006\u0010\u0013\u001a\u00020\u0014J\t\u0010\u0015\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0017"}, d2={"Lcom/ustadmobile/sharedse/network/EntryStatusRequest;", "", "endpointUrl", "", "entryList", "", "(Ljava/lang/String;[J)V", "getEndpointUrl", "()Ljava/lang/String;", "getEntryList", "()[J", "component1", "component2", "copy", "equals", "", "other", "hashCode", "", "toBytes", "", "toString", "Companion", "sharedse_debug"})
public final class EntryStatusRequest {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String endpointUrl;
    @NotNull
    private final long[] entryList;

    public EntryStatusRequest(@NotNull String endpointUrl, @NotNull long[] entryList) {
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        Intrinsics.checkNotNullParameter((Object)entryList, (String)"entryList");
        this.endpointUrl = endpointUrl;
        this.entryList = entryList;
    }

    @NotNull
    public final String getEndpointUrl() {
        return this.endpointUrl;
    }

    @NotNull
    public final long[] getEntryList() {
        return this.entryList;
    }

    @NotNull
    public final byte[] toBytes() {
        byte[] byArray;
        String $this$toByteArray_u24default$iv = this.endpointUrl;
        Charset charset$iv = Charsets.UTF_8;
        boolean $i$f$toByteArray = false;
        if (Intrinsics.areEqual((Object)charset$iv, (Object)Charsets.UTF_8)) {
            byArray = StringsKt.encodeToByteArray((String)$this$toByteArray_u24default$iv);
        } else {
            CharsetEncoder charsetEncoder = charset$iv.newEncoder();
            Intrinsics.checkNotNullExpressionValue((Object)charsetEncoder, (String)"charset.newEncoder()");
            byArray = CharsetJVMKt.encodeToByteArray((CharsetEncoder)charsetEncoder, (CharSequence)$this$toByteArray_u24default$iv, (int)0, (int)$this$toByteArray_u24default$iv.length());
        }
        byte[] endpointUrlBytes = byArray;
        ByteBufferSe buffer = ByteBufferSe.Companion.allocate(4 + endpointUrlBytes.length + this.entryList.length * 8);
        buffer.putInt(endpointUrlBytes.length);
        buffer.put(endpointUrlBytes);
        long[] $this$forEach$iv = this.entryList;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            long element$iv;
            long it = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            buffer.putLong(it);
        }
        return buffer.array();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || !Intrinsics.areEqual((Object)Reflection.getOrCreateKotlinClass(this.getClass()), (Object)Reflection.getOrCreateKotlinClass(other.getClass()))) {
            return false;
        }
        EntryStatusRequest cfr_ignored_0 = (EntryStatusRequest)other;
        if (!Intrinsics.areEqual((Object)this.endpointUrl, (Object)((EntryStatusRequest)other).endpointUrl)) {
            return false;
        }
        return Arrays.equals(this.entryList, ((EntryStatusRequest)other).entryList);
    }

    public int hashCode() {
        int result = this.endpointUrl.hashCode();
        result = 31 * result + Arrays.hashCode(this.entryList);
        return result;
    }

    @NotNull
    public final String component1() {
        return this.endpointUrl;
    }

    @NotNull
    public final long[] component2() {
        return this.entryList;
    }

    @NotNull
    public final EntryStatusRequest copy(@NotNull String endpointUrl, @NotNull long[] entryList) {
        Intrinsics.checkNotNullParameter((Object)endpointUrl, (String)"endpointUrl");
        Intrinsics.checkNotNullParameter((Object)entryList, (String)"entryList");
        return new EntryStatusRequest(endpointUrl, entryList);
    }

    public static /* synthetic */ EntryStatusRequest copy$default(EntryStatusRequest entryStatusRequest, String string2, long[] lArray, int n, Object object) {
        if ((n & 1) != 0) {
            string2 = entryStatusRequest.endpointUrl;
        }
        if ((n & 2) != 0) {
            lArray = entryStatusRequest.entryList;
        }
        return entryStatusRequest.copy(string2, lArray);
    }

    @NotNull
    public String toString() {
        return "EntryStatusRequest(endpointUrl=" + this.endpointUrl + ", entryList=" + Arrays.toString(this.entryList) + ')';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/sharedse/network/EntryStatusRequest$Companion;", "", "()V", "fromBytes", "Lcom/ustadmobile/sharedse/network/EntryStatusRequest;", "byteArray", "", "sharedse_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final EntryStatusRequest fromBytes(@NotNull byte[] byteArray) {
            Intrinsics.checkNotNullParameter((Object)byteArray, (String)"byteArray");
            ByteBufferSe buffer = ByteBufferSe.Companion.wrap(byteArray);
            int endpointLen = buffer.getInt();
            byte[] endpointBytes = new byte[endpointLen];
            buffer.get(endpointBytes, 0, endpointLen);
            long[] entryList = new long[buffer.remaining() / 8];
            int n = entryList.length;
            for (int index = 0; index < n; ++index) {
                entryList[index] = buffer.getLong();
            }
            return new EntryStatusRequest(StringsKt.decodeToString((byte[])endpointBytes), entryList);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

