/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothManager;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.net.ConnectivityManager;
import android.net.DhcpInfo;
import android.net.Network;
import android.net.NetworkInfo;
import android.net.NetworkRequest;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.net.wifi.p2p.WifiP2pGroup;
import android.net.wifi.p2p.WifiP2pManager;
import android.os.Build;
import android.os.Looper;
import android.os.ParcelUuid;
import android.os.SystemClock;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.core.net.ConnectivityManagerCompat;
import com.ustadmobile.core.impl.UMAndroidUtil;
import com.ustadmobile.core.impl.UMLog;
import com.ustadmobile.lib.db.entities.ConnectivityStatus;
import com.ustadmobile.port.sharedse.impl.http.EmbeddedHTTPD;
import com.ustadmobile.port.sharedse.util.AsyncServiceManager;
import com.ustadmobile.sharedse.network.EnablePromptsSnackbarManager;
import com.ustadmobile.sharedse.network.NetworkManagerBle;
import com.ustadmobile.sharedse.network.NetworkManagerBleCommon;
import com.ustadmobile.sharedse.network.NetworkManagerBleHelper;
import com.ustadmobile.sharedse.network.NetworkManagerWithConnectionOpener;
import com.ustadmobile.sharedse.network.WiFiDirectGroupBle;
import fi.iki.elonen.NanoHTTPD;
import io.ktor.client.HttpClientConfig;
import io.ktor.client.HttpClientKt;
import io.ktor.client.engine.HttpClientEngineFactory;
import io.ktor.client.engine.okhttp.OkHttp;
import io.ktor.client.engine.okhttp.OkHttpConfig;
import io.ktor.client.plugins.HttpClientPlugin;
import io.ktor.client.plugins.contentnegotiation.ContentNegotiation;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.HttpURLConnection;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import kotlin.text.StringsKt;
import kotlinx.coroutines.CoroutineDispatcher;
import kotlinx.coroutines.Dispatchers;
import okhttp3.OkHttpClient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DirectDI;
import org.kodein.di.DirectDIAware;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008f\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\r*\u0001=\b\u0016\u0018\u0000 ~2\u00020\u00012\u00020\u00022\u00020\u0003:\u0006~\u007f\u0080\u0001\u0081\u0001B!\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0010\u0010S\u001a\u00020T2\u0006\u0010U\u001a\u00020VH\u0002J\u0010\u0010W\u001a\u00020X2\u0006\u0010Y\u001a\u00020ZH\u0016J \u0010[\u001a\u00020T2\u0006\u0010\\\u001a\u00020V2\u0006\u0010]\u001a\u00020V2\u0006\u0010Y\u001a\u00020/H\u0016J\r\u0010^\u001a\u00020_H\u0001\u00a2\u0006\u0002\b`J\b\u0010a\u001a\u00020TH\u0002J\u0012\u0010b\u001a\u00020T2\b\u0010c\u001a\u0004\u0018\u00010dH\u0002J\u0010\u0010e\u001a\u00020\u001e2\u0006\u0010\\\u001a\u00020VH\u0002J\u0010\u0010f\u001a\u00020T2\u0006\u0010g\u001a\u00020\u0005H\u0016J\b\u0010h\u001a\u00020TH\u0016J\b\u0010i\u001a\u00020TH\u0016J\b\u0010j\u001a\u00020TH\u0016J\u0018\u0010k\u001a\u00020\u001e2\u0006\u0010l\u001a\u00020V2\u0006\u0010Y\u001a\u00020/H\u0002J\u0012\u0010m\u001a\u00020V2\b\u0010n\u001a\u0004\u0018\u00010oH\u0002J\u0010\u0010p\u001a\u00020T2\u0006\u0010g\u001a\u00020\u0005H\u0016J\u001a\u0010q\u001a\u00020T2\u0006\u0010r\u001a\u00020s2\b\u0010t\u001a\u0004\u0018\u00010uH\u0016J\u0018\u0010v\u001a\u00020T2\u0006\u0010r\u001a\u00020s2\u0006\u0010t\u001a\u00020uH\u0016J\b\u0010w\u001a\u00020TH\u0016J\u0010\u0010x\u001a\u00020T2\u0006\u0010y\u001a\u00020_H\u0007J\u0010\u0010z\u001a\u00020\u001e2\u0006\u0010{\u001a\u00020\u001eH\u0016J\b\u0010|\u001a\u00020TH\u0002J\u0006\u0010}\u001a\u00020TR\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001b\u0010\u0017\u001a\u00020\u00188FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001fR\u0014\u0010 \u001a\u00020\u001e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001fRl\u0010)\u001a%\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'\u0018\u00010\"j\u0004\u0018\u0001`(2)\u0010!\u001a%\u0012\u0013\u0012\u00110#\u00a2\u0006\f\b$\u0012\b\b%\u0012\u0004\b\b(&\u0012\u0004\u0012\u00020'\u0018\u00010\"j\u0004\u0018\u0001`(8V@TX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b*\u0010+\"\u0004\b,\u0010-R\u0014\u0010.\u001a\u00020/8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u00104\u001a\u000205X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u00106\u001a\u000207X\u0080.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b8\u00109\"\u0004\b:\u0010;R\u0010\u0010<\u001a\u00020=X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010>R\u000e\u0010?\u001a\u00020@X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010A\u001a\u00020BX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010C\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010E\u001a\u00020DX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010F\u001a\f\u0012\b\u0012\u00060HR\u00020I0GX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010J\u001a\u00020IX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010K\u001a\u00020LX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010M\u001a\u0004\u0018\u00010NX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010O\u001a\u00020PX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010Q\u001a\u0004\u0018\u00010RX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0082\u0001"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle;", "Lcom/ustadmobile/sharedse/network/NetworkManagerBleCommon;", "Lcom/ustadmobile/port/sharedse/impl/http/EmbeddedHTTPD$ResponseListener;", "Lcom/ustadmobile/sharedse/network/NetworkManagerWithConnectionOpener;", "context", "", "di", "Lorg/kodein/di/DI;", "singleThreadDispatcher", "Lkotlinx/coroutines/CoroutineDispatcher;", "(Ljava/lang/Object;Lorg/kodein/di/DI;Lkotlinx/coroutines/CoroutineDispatcher;)V", "bluetoothAdapter", "Landroid/bluetooth/BluetoothAdapter;", "bluetoothManager", "connectivityManager", "Landroid/net/ConnectivityManager;", "delayedExecutor", "Ljava/util/concurrent/ScheduledExecutorService;", "kotlin.jvm.PlatformType", "enablePromptsSnackbarManager", "Lcom/ustadmobile/sharedse/network/EnablePromptsSnackbarManager;", "getEnablePromptsSnackbarManager", "()Lcom/ustadmobile/sharedse/network/EnablePromptsSnackbarManager;", "httpd", "Lcom/ustadmobile/port/sharedse/impl/http/EmbeddedHTTPD;", "getHttpd", "()Lcom/ustadmobile/port/sharedse/impl/http/EmbeddedHTTPD;", "httpd$delegate", "Lkotlin/Lazy;", "isBluetoothEnabled", "", "()Z", "isWiFiEnabled", "<set-?>", "Lkotlin/Function1;", "Ljava/net/URL;", "Lkotlin/ParameterName;", "name", "url", "Ljava/net/HttpURLConnection;", "Lcom/ustadmobile/sharedse/network/containerfetcher/ConnectionOpener;", "localConnectionOpener", "getLocalConnectionOpener", "()Lkotlin/jvm/functions/Function1;", "setLocalConnectionOpener", "(Lkotlin/jvm/functions/Function1;)V", "localHttpPort", "", "getLocalHttpPort", "()I", "localOkHttpClient", "Lokhttp3/OkHttpClient;", "mContext", "Landroid/content/Context;", "managerHelper", "Lcom/ustadmobile/sharedse/network/NetworkManagerBleHelper;", "getManagerHelper$sharedse_release", "()Lcom/ustadmobile/sharedse/network/NetworkManagerBleHelper;", "setManagerHelper$sharedse_release", "(Lcom/ustadmobile/sharedse/network/NetworkManagerBleHelper;)V", "networkStateChangeReceiver", "com/ustadmobile/sharedse/network/NetworkManagerBle$networkStateChangeReceiver$1", "Lcom/ustadmobile/sharedse/network/NetworkManagerBle$networkStateChangeReceiver$1;", "numActiveRequests", "Ljava/util/concurrent/atomic/AtomicInteger;", "parcelServiceUuid", "Landroid/os/ParcelUuid;", "wifiDirectGroupLastRequestedTime", "Ljava/util/concurrent/atomic/AtomicLong;", "wifiDirectRequestLastCompletedTime", "wifiLockReference", "Ljava/util/concurrent/atomic/AtomicReference;", "Landroid/net/wifi/WifiManager$WifiLock;", "Landroid/net/wifi/WifiManager;", "wifiManager", "wifiP2PCapable", "Ljava/util/concurrent/atomic/AtomicBoolean;", "wifiP2pChannel", "Landroid/net/wifi/p2p/WifiP2pManager$Channel;", "wifiP2pGroupServiceManager", "Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiP2PGroupServiceManager;", "wifiP2pManager", "Landroid/net/wifi/p2p/WifiP2pManager;", "addLogs", "", "message", "", "awaitWifiDirectGroupReady", "Lcom/ustadmobile/sharedse/network/WiFiDirectGroupBle;", "timeout", "", "connectToWiFi", "ssid", "passphrase", "getBluetoothManager", "Landroid/bluetooth/BluetoothManager;", "getBluetoothManager$sharedse_release", "handleDisconnected", "handleNetworkAvailable", "network", "Landroid/net/Network;", "isConnectedToRequiredWiFi", "lockWifi", "lockHolder", "onCreate", "onDestroy", "openBluetoothSettings", "ping", "ipAddress", "prettyPrintNetwork", "networkInfo", "Landroid/net/NetworkInfo;", "releaseWifiLock", "responseFinished", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "response", "Lfi/iki/elonen/NanoHTTPD$Response;", "responseStarted", "restoreWifi", "setBluetoothManager", "manager", "setWifiEnabled", "enabled", "startMonitoringNetworkChanges", "updateEnableServicesPromptsRequired", "Companion", "UmNetworkCallback", "WifiDirectGroupAndroid", "WifiP2PGroupServiceManager", "sharedse_release"})
public class NetworkManagerBle
extends NetworkManagerBleCommon
implements EmbeddedHTTPD.ResponseListener,
NetworkManagerWithConnectionOpener {
    @NotNull
    public static final Companion Companion;
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Lazy httpd$delegate;
    private WifiManager wifiManager;
    @Nullable
    private Object bluetoothManager;
    @Nullable
    private BluetoothAdapter bluetoothAdapter;
    @NotNull
    private final Context mContext;
    @NotNull
    private final ParcelUuid parcelServiceUuid;
    @Nullable
    private WifiP2pManager.Channel wifiP2pChannel;
    @Nullable
    private WifiP2pManager wifiP2pManager;
    @Nullable
    private ConnectivityManager connectivityManager;
    @NotNull
    private final AtomicBoolean wifiP2PCapable;
    @NotNull
    private final AtomicReference<WifiManager.WifiLock> wifiLockReference;
    private WifiP2PGroupServiceManager wifiP2pGroupServiceManager;
    public NetworkManagerBleHelper managerHelper;
    @NotNull
    private final AtomicLong wifiDirectGroupLastRequestedTime;
    @NotNull
    private final AtomicLong wifiDirectRequestLastCompletedTime;
    @NotNull
    private final AtomicInteger numActiveRequests;
    @NotNull
    private final EnablePromptsSnackbarManager enablePromptsSnackbarManager;
    @Nullable
    private OkHttpClient localOkHttpClient;
    @Nullable
    private Function1<? super URL, ? extends HttpURLConnection> localConnectionOpener;
    private final ScheduledExecutorService delayedExecutor;
    @NotNull
    private final networkStateChangeReceiver.1 networkStateChangeReceiver;
    @NotNull
    private static final List<Integer> BLUETOOTH_ON_OR_TURNING_ON_STATES;
    @NotNull
    private static final List<Integer> WIFI_ON_OR_TURNING_ON_STATES;

    public NetworkManagerBle(@NotNull Object context, @NotNull DI di, @NotNull CoroutineDispatcher singleThreadDispatcher) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        Intrinsics.checkNotNullParameter((Object)singleThreadDispatcher, (String)"singleThreadDispatcher");
        super(context, di, singleThreadDispatcher, null, null, 24, null);
        DIAware $this$instance_u24default$iv = this;
        Object tag$iv = null;
        boolean $i$f$instance = false;
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<EmbeddedHTTPD>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        this.httpd$delegate = DIAwareKt.Instance((DIAware)$this$instance_u24default$iv, (TypeToken)((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, EmbeddedHTTPD.class)), tag$iv).provideDelegate((Object)this, $$delegatedProperties[0]);
        this.mContext = (Context)context;
        this.parcelServiceUuid = new ParcelUuid(UUID.fromString("7d2ea28a-f7bd-485a-bd9d-92ad6ecfe93a"));
        this.wifiP2PCapable = new AtomicBoolean(false);
        this.wifiLockReference = new AtomicReference();
        this.wifiDirectGroupLastRequestedTime = new AtomicLong();
        this.wifiDirectRequestLastCompletedTime = new AtomicLong();
        this.numActiveRequests = new AtomicInteger();
        this.enablePromptsSnackbarManager = new EnablePromptsSnackbarManager();
        this.delayedExecutor = Executors.newSingleThreadScheduledExecutor();
        this.networkStateChangeReceiver = new BroadcastReceiver(this){
            final /* synthetic */ NetworkManagerBle this$0;
            {
                this.this$0 = $receiver;
            }

            public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                ConnectivityManager connectivityManager = NetworkManagerBle.access$getConnectivityManager$p(this.this$0);
                Intrinsics.checkNotNull((Object)connectivityManager);
                NetworkInfo info = connectivityManager.getActiveNetworkInfo();
                if (info != null && info.isConnected()) {
                    NetworkManagerBle.access$handleNetworkAvailable(this.this$0, null);
                } else {
                    NetworkManagerBle.access$handleDisconnected(this.this$0);
                }
            }
        };
    }

    public /* synthetic */ NetworkManagerBle(Object object, DI dI, CoroutineDispatcher coroutineDispatcher, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            object = new Object();
        }
        if ((n & 4) != 0) {
            coroutineDispatcher = Dispatchers.getDefault();
        }
        this(object, dI, coroutineDispatcher);
    }

    @NotNull
    public final EmbeddedHTTPD getHttpd() {
        Lazy lazy = this.httpd$delegate;
        return (EmbeddedHTTPD)((Object)lazy.getValue());
    }

    @NotNull
    public final NetworkManagerBleHelper getManagerHelper$sharedse_release() {
        NetworkManagerBleHelper networkManagerBleHelper = this.managerHelper;
        if (networkManagerBleHelper != null) {
            return networkManagerBleHelper;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"managerHelper");
        return null;
    }

    public final void setManagerHelper$sharedse_release(@NotNull NetworkManagerBleHelper networkManagerBleHelper) {
        Intrinsics.checkNotNullParameter((Object)networkManagerBleHelper, (String)"<set-?>");
        this.managerHelper = networkManagerBleHelper;
    }

    @NotNull
    public final EnablePromptsSnackbarManager getEnablePromptsSnackbarManager() {
        return this.enablePromptsSnackbarManager;
    }

    @Override
    @Nullable
    public Function1<URL, HttpURLConnection> getLocalConnectionOpener() {
        return this.localConnectionOpener;
    }

    protected void setLocalConnectionOpener(@Nullable Function1<? super URL, ? extends HttpURLConnection> function1) {
        this.localConnectionOpener = function1;
    }

    @Override
    public int getLocalHttpPort() {
        return this.getHttpd().getListeningPort();
    }

    private final void handleDisconnected() {
        this.setLocalHttpClient(null);
        this.setLocalConnectionOpener(null);
        UMLog.Companion.l(4, 42, "NetworkCallback: handleDisconnected");
        this.get_connectivityStatus().postValue((Object)new ConnectivityStatus(0, false, null));
    }

    private final void handleNetworkAvailable(Network network) {
        String string;
        ConnectivityManager connectivityManager = this.connectivityManager;
        Intrinsics.checkNotNull((Object)connectivityManager);
        boolean isMeteredConnection = ConnectivityManagerCompat.isActiveNetworkMetered((ConnectivityManager)connectivityManager);
        int state = isMeteredConnection ? 3 : 4;
        ConnectivityManager connectivityManager2 = this.connectivityManager;
        Intrinsics.checkNotNull((Object)connectivityManager2);
        NetworkInfo networkInfo = connectivityManager2.getNetworkInfo(network);
        UMLog.Companion.l(4, 42, "NetworkCallback: onAvailable" + this.prettyPrintNetwork(networkInfo));
        NetworkInfo networkInfo2 = networkInfo;
        String networkExtraInfo = networkInfo2 != null ? networkInfo2.getExtraInfo() : null;
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        WifiInfo wifiManagerConnectionInfo = wifiManager.getConnectionInfo();
        if (Build.VERSION.SDK_INT < 29 && networkExtraInfo != null) {
            string = UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(networkExtraInfo);
        } else {
            WifiInfo wifiInfo = wifiManagerConnectionInfo;
            string = wifiInfo != null ? UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(wifiInfo.getSSID()) : null;
        }
        String ssid = string;
        ConnectivityStatus status = new ConnectivityStatus(state, true, ssid);
        this.addLogs("changed to " + state);
        if (ssid != null) {
            if (StringsKt.startsWith$default((String)ssid, (String)"DIRECT-", (boolean)false, (int)2, null)) {
                status.setConnectivityState(2);
            }
            Network network2 = network;
            Intrinsics.checkNotNull((Object)network2);
            SocketFactory socketFactory = network2.getSocketFactory();
            UMLog.Companion.l(5, 0, "NetworkManager: create local network http client for " + ssid + " using " + socketFactory);
            DirectDIAware $this$instance_u24default$iv = (DirectDIAware)DIAwareKt.getDirect((DIAware)((DIAware)this.getDi()));
            Object tag$iv = null;
            boolean $i$f$instance = false;
            DirectDI directDI = $this$instance_u24default$iv.getDirectDI();
            boolean $i$f$generic = false;
            JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<OkHttpClient>(){}.getSuperType());
            Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
            OkHttpClient.Builder builder = ((OkHttpClient)directDI.Instance((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, OkHttpClient.class), tag$iv)).newBuilder();
            Intrinsics.checkNotNullExpressionValue((Object)socketFactory, (String)"socketFactory");
            OkHttpClient localOkHttpClientVal = builder.socketFactory(socketFactory).build();
            this.setLocalHttpClient(HttpClientKt.HttpClient((HttpClientEngineFactory)((HttpClientEngineFactory)OkHttp.INSTANCE), (Function1)((Function1)new Function1<HttpClientConfig<OkHttpConfig>, Unit>(localOkHttpClientVal){
                final /* synthetic */ OkHttpClient $localOkHttpClientVal;
                {
                    this.$localOkHttpClientVal = $localOkHttpClientVal;
                    super(1);
                }

                public final void invoke(@NotNull HttpClientConfig<OkHttpConfig> $this$HttpClient) {
                    Intrinsics.checkNotNullParameter($this$HttpClient, (String)"$this$HttpClient");
                    $this$HttpClient.engine((Function1)new Function1<OkHttpConfig, Unit>(this.$localOkHttpClientVal){
                        final /* synthetic */ OkHttpClient $localOkHttpClientVal;
                        {
                            this.$localOkHttpClientVal = $localOkHttpClientVal;
                            super(1);
                        }

                        public final void invoke(@NotNull OkHttpConfig $this$engine) {
                            Intrinsics.checkNotNullParameter((Object)$this$engine, (String)"$this$engine");
                            $this$engine.setPreconfigured(this.$localOkHttpClientVal);
                        }
                    });
                    $this$HttpClient.install((HttpClientPlugin)ContentNegotiation.Plugin, (Function1)handleNetworkAvailable.2.INSTANCE);
                }
            })));
            this.setLocalConnectionOpener((Function1<? super URL, ? extends HttpURLConnection>)((Function1)new Function1<URL, HttpURLConnection>(network){
                final /* synthetic */ Network $network;
                {
                    this.$network = $network;
                    super(1);
                }

                @NotNull
                public final HttpURLConnection invoke(@NotNull URL it) {
                    Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                    URLConnection uRLConnection = this.$network.openConnection(it);
                    Intrinsics.checkNotNull((Object)uRLConnection, (String)"null cannot be cast to non-null type java.net.HttpURLConnection");
                    return (HttpURLConnection)uRLConnection;
                }
            }));
        }
        this.get_connectivityStatus().postValue((Object)status);
    }

    private final void addLogs(String message) {
        System.out.println((Object)("NetworkConnectivityStatus: " + message));
    }

    private final String prettyPrintNetwork(NetworkInfo networkInfo) {
        String val = "Network : ";
        if (networkInfo != null) {
            val = val + " type: " + networkInfo.getTypeName();
            val = val + " extraInfo: " + networkInfo.getExtraInfo();
        } else {
            val = val + " (null network info)";
        }
        return val;
    }

    @Override
    public void onCreate() {
        this.setManagerHelper$sharedse_release(new NetworkManagerBleHelper(this.mContext));
        this.connectivityManager = this.getManagerHelper$sharedse_release().getConnectivityManager();
        WifiManager wifiManager = this.getManagerHelper$sharedse_release().getWifiManager();
        Intrinsics.checkNotNullExpressionValue((Object)wifiManager, (String)"managerHelper.wifiManager");
        this.wifiManager = wifiManager;
        if (this.wifiP2pManager == null) {
            this.wifiP2pManager = (WifiP2pManager)this.mContext.getSystemService("wifip2p");
        }
        this.wifiP2PCapable.set(this.wifiP2pManager != null);
        this.wifiP2pGroupServiceManager = new WifiP2PGroupServiceManager(this);
        if (this.wifiP2PCapable.get()) {
            WifiP2pManager wifiP2pManager = this.wifiP2pManager;
            Intrinsics.checkNotNull((Object)wifiP2pManager);
            this.wifiP2pChannel = wifiP2pManager.initialize(this.mContext, Looper.getMainLooper(), null);
            WifiP2PGroupServiceManager wifiP2PGroupServiceManager = this.wifiP2pGroupServiceManager;
            if (wifiP2PGroupServiceManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
                wifiP2PGroupServiceManager = null;
            }
            this.mContext.registerReceiver(wifiP2PGroupServiceManager.getWifiP2pBroadcastReceiver(), new IntentFilter("android.net.wifi.p2p.CONNECTION_STATE_CHANGE"));
        }
        this.startMonitoringNetworkChanges();
        this.updateEnableServicesPromptsRequired();
        super.onCreate();
    }

    @Override
    public void responseStarted(@NotNull NanoHTTPD.IHTTPSession session, @NotNull NanoHTTPD.Response response) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        Intrinsics.checkNotNullParameter((Object)response, (String)"response");
        if (session.getRemoteIpAddress() != null) {
            String string = session.getRemoteIpAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.remoteIpAddress");
            if (StringsKt.startsWith$default((String)string, (String)"192.168.49", (boolean)false, (int)2, null)) {
                this.numActiveRequests.incrementAndGet();
            }
        }
    }

    @Override
    public void responseFinished(@NotNull NanoHTTPD.IHTTPSession session, @Nullable NanoHTTPD.Response response) {
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        if (session.getRemoteIpAddress() != null) {
            String string = session.getRemoteIpAddress();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"session.remoteIpAddress");
            if (StringsKt.startsWith$default((String)string, (String)"192.168.49", (boolean)false, (int)2, null)) {
                this.numActiveRequests.decrementAndGet();
                this.wifiDirectGroupLastRequestedTime.set(System.currentTimeMillis());
            }
        }
    }

    public final void updateEnableServicesPromptsRequired() {
        BluetoothAdapter cBluetoothAdapter = this.bluetoothAdapter;
        this.enablePromptsSnackbarManager.setPromptRequired(1, cBluetoothAdapter != null && !BLUETOOTH_ON_OR_TURNING_ON_STATES.contains(cBluetoothAdapter.getState()));
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        this.enablePromptsSnackbarManager.setPromptRequired(2, !WIFI_ON_OR_TURNING_ON_STATES.contains(wifiManager.getWifiState()));
    }

    @Override
    public boolean isWiFiEnabled() {
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        return wifiManager.isWifiEnabled();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public boolean isBluetoothEnabled() {
        if (this.bluetoothAdapter == null) return false;
        BluetoothAdapter bluetoothAdapter = this.bluetoothAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter);
        if (!bluetoothAdapter.isEnabled()) return false;
        BluetoothAdapter bluetoothAdapter2 = this.bluetoothAdapter;
        Intrinsics.checkNotNull((Object)bluetoothAdapter2);
        if (bluetoothAdapter2.getState() != 12) return false;
        return true;
    }

    @Override
    public void openBluetoothSettings() {
        this.mContext.startActivity(new Intent("android.settings.BLUETOOTH_SETTINGS"));
    }

    @Override
    public boolean setWifiEnabled(boolean enabled) {
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        return wifiManager.setWifiEnabled(enabled);
    }

    @Override
    @NotNull
    public WiFiDirectGroupBle awaitWifiDirectGroupReady(long timeout) {
        this.wifiDirectGroupLastRequestedTime.set(System.currentTimeMillis());
        WifiP2PGroupServiceManager wifiP2PGroupServiceManager = this.wifiP2pGroupServiceManager;
        if (wifiP2PGroupServiceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
            wifiP2PGroupServiceManager = null;
        }
        wifiP2PGroupServiceManager.setEnabled(true);
        WifiP2PGroupServiceManager wifiP2PGroupServiceManager2 = this.wifiP2pGroupServiceManager;
        if (wifiP2PGroupServiceManager2 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
            wifiP2PGroupServiceManager2 = null;
        }
        wifiP2PGroupServiceManager2.await((Function1<? super Integer, Boolean>)((Function1)awaitWifiDirectGroupReady.1.INSTANCE), timeout);
        WifiP2PGroupServiceManager wifiP2PGroupServiceManager3 = this.wifiP2pGroupServiceManager;
        if (wifiP2PGroupServiceManager3 == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
            wifiP2PGroupServiceManager3 = null;
        }
        return wifiP2PGroupServiceManager3.getGroup();
    }

    @Override
    public void connectToWiFi(@NotNull String ssid, @NotNull String passphrase, int timeout) {
        Intrinsics.checkNotNullParameter((Object)ssid, (String)"ssid");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        this.getManagerHelper$sharedse_release().deleteTemporaryWifiDirectSsids();
        this.getManagerHelper$sharedse_release().setGroupInfo(ssid, passphrase);
        long startTime = System.currentTimeMillis();
        long connectionDeadline = System.currentTimeMillis() + (long)timeout;
        boolean connectedOrFailed = false;
        boolean networkEnabled = false;
        boolean networkSeenInScan = false;
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        WifiManager.WifiLock scanLock = wifiManager.createWifiLock(2, "NetworkManagerBle-Scan");
        scanLock.acquire();
        do {
            StringBuilder stringBuilder = new StringBuilder().append("ConnectToWifi: Trying to connect to ").append(ssid).append(". Current SSID = ");
            WifiManager wifiManager2 = this.wifiManager;
            if (wifiManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
                wifiManager2 = null;
            }
            WifiInfo wifiInfo = wifiManager2.getConnectionInfo();
            UMLog.Companion.l(3, 693, stringBuilder.append(wifiInfo != null ? wifiInfo.getSSID() : null).toString());
            if (this.isConnectedToRequiredWiFi(ssid)) {
                UMLog.Companion.l(3, 693, "ConnectToWifi: Already connected to WiFi with ssid =" + ssid);
                break;
            }
            if (!networkEnabled) {
                networkEnabled = this.getManagerHelper$sharedse_release().enableWifiNetwork();
                UMLog.Companion.l(3, 693, "ConnectToWifi: called enableWifiNetwork for " + ssid + " Result: " + networkEnabled);
            } else {
                boolean hasDhcpGateway;
                WifiManager wifiManager3 = this.wifiManager;
                if (wifiManager3 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
                    wifiManager3 = null;
                }
                DhcpInfo routeInfo = wifiManager3.getDhcpInfo();
                WifiManager wifiManager4 = this.wifiManager;
                if (wifiManager4 == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
                    wifiManager4 = null;
                }
                WifiInfo wifiInfo2 = wifiManager4.getConnectionInfo();
                String currentSsid = UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(wifiInfo2 != null ? wifiInfo2.getSSID() : null);
                boolean isCorrectSsid = Intrinsics.areEqual((Object)currentSsid, (Object)ssid);
                boolean bl = hasDhcpGateway = routeInfo != null && routeInfo.gateway > 0;
                if (isCorrectSsid && hasDhcpGateway) {
                    String gatewayIp;
                    String string = "%d.%d.%d.%d";
                    Object[] objectArray = new Object[]{routeInfo.gateway & 0xFF, routeInfo.gateway >> 8 & 0xFF, routeInfo.gateway >> 16 & 0xFF, routeInfo.gateway >> 24 & 0xFF};
                    Intrinsics.checkNotNullExpressionValue((Object)String.format(string, Arrays.copyOf(objectArray, objectArray.length)), (String)"format(format, *args)");
                    UMLog.Companion.l(3, 693, "Trying to ping gateway IP personAddress " + gatewayIp);
                    if (this.ping(gatewayIp, 1000)) {
                        UMLog.Companion.l(3, 693, "Ping successful! " + ssid);
                        connectedOrFailed = true;
                    } else {
                        UMLog.Companion.l(3, 693, "ConnectToWifi: ping to " + gatewayIp + " failed on " + ssid);
                    }
                } else if (!isCorrectSsid) {
                    UMLog.Companion.l(3, 693, "ConnectToWifi: Connected to wrong SSID: Got: " + currentSsid + " Wanted: " + ssid);
                } else if (!hasDhcpGateway) {
                    UMLog.Companion.l(3, 693, "ConnectToWifi: Connected to correct network, but no DHCP gateway yet on " + currentSsid);
                }
            }
            if (!connectedOrFailed && System.currentTimeMillis() > connectionDeadline) {
                UMLog.Companion.l(3, 693, " TIMEOUT: failed to connect " + ssid);
                break;
            }
            SystemClock.sleep((long)1000L);
        } while (!connectedOrFailed);
        scanLock.release();
        UMLog.Companion.l(5, 0, "ConnectToWifi: Finished");
    }

    private final boolean ping(String ipAddress, int timeout) {
        try {
            return InetAddress.getByName(ipAddress).isReachable(timeout);
        }
        catch (IOException iOException) {
            return false;
        }
    }

    private final boolean isConnectedToRequiredWiFi(String ssid) {
        WifiInfo wifiInfo;
        WifiManager wifiManager = this.wifiManager;
        if (wifiManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
            wifiManager = null;
        }
        return (wifiInfo = wifiManager.getConnectionInfo()) != null && Intrinsics.areEqual((Object)UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(wifiInfo.getSSID()), (Object)UMAndroidUtil.INSTANCE.normalizeAndroidWifiSsid(ssid));
    }

    @Override
    public void restoreWifi() {
        UMLog.Companion.l(3, 339, "NetworkManager: restore wifi");
        this.getManagerHelper$sharedse_release().restoreWiFi();
    }

    private final void startMonitoringNetworkChanges() {
        NetworkRequest networkRequest = new NetworkRequest.Builder().addTransportType(0).addTransportType(1).build();
        if (this.connectivityManager != null) {
            ConnectivityManager connectivityManager = this.connectivityManager;
            Intrinsics.checkNotNull((Object)connectivityManager);
            connectivityManager.requestNetwork(networkRequest, (ConnectivityManager.NetworkCallback)new UmNetworkCallback());
        }
    }

    @RequiresApi(api=18)
    @NotNull
    public final BluetoothManager getBluetoothManager$sharedse_release() {
        Object object = this.bluetoothManager;
        Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type android.bluetooth.BluetoothManager");
        return (BluetoothManager)object;
    }

    @VisibleForTesting
    public final void setBluetoothManager(@NotNull BluetoothManager manager) {
        Intrinsics.checkNotNullParameter((Object)manager, (String)"manager");
        this.bluetoothManager = manager;
    }

    @Override
    public void lockWifi(@NotNull Object lockHolder) {
        Intrinsics.checkNotNullParameter((Object)lockHolder, (String)"lockHolder");
        super.lockWifi(lockHolder);
        if (this.wifiLockReference.get() == null) {
            WifiManager wifiManager = this.wifiManager;
            if (wifiManager == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiManager");
                wifiManager = null;
            }
            WifiManager.WifiLock newLock = wifiManager.createWifiLock(3, "UstadMobile-Wifi-Lock-Tag");
            this.wifiLockReference.set(newLock);
            newLock.acquire();
            this.getWifiLockHolders().add(lockHolder);
            UMLog.Companion.l(3, 699, "WiFi lock acquired for " + lockHolder);
        }
    }

    @Override
    public void releaseWifiLock(@NotNull Object lockHolder) {
        Intrinsics.checkNotNullParameter((Object)lockHolder, (String)"lockHolder");
        super.releaseWifiLock(lockHolder);
        WifiManager.WifiLock lock = this.wifiLockReference.get();
        this.getWifiLockHolders().remove(lockHolder);
        if (this.getWifiLockHolders().isEmpty() && lock != null) {
            this.wifiLockReference.set(null);
            lock.release();
            UMLog.Companion.l(1, 699, "WiFi lock released from object " + lockHolder);
        }
    }

    @Override
    public void onDestroy() {
        WifiP2PGroupServiceManager wifiP2PGroupServiceManager = this.wifiP2pGroupServiceManager;
        if (wifiP2PGroupServiceManager == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
            wifiP2PGroupServiceManager = null;
        }
        wifiP2PGroupServiceManager.setEnabled(false);
        this.mContext.unregisterReceiver((BroadcastReceiver)this.networkStateChangeReceiver);
        if (this.wifiP2PCapable.get()) {
            WifiP2PGroupServiceManager wifiP2PGroupServiceManager2 = this.wifiP2pGroupServiceManager;
            if (wifiP2PGroupServiceManager2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"wifiP2pGroupServiceManager");
                wifiP2PGroupServiceManager2 = null;
            }
            this.mContext.unregisterReceiver(wifiP2PGroupServiceManager2.getWifiP2pBroadcastReceiver());
        }
        super.onDestroy();
    }

    static {
        Object[] objectArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(NetworkManagerBle.class, "httpd", "getHttpd()Lcom/ustadmobile/port/sharedse/impl/http/EmbeddedHTTPD;", 0)))};
        $$delegatedProperties = objectArray;
        Companion = new Companion(null);
        objectArray = new Integer[]{12, 11};
        BLUETOOTH_ON_OR_TURNING_ON_STATES = CollectionsKt.listOf((Object[])objectArray);
        objectArray = new Integer[]{3, 2};
        WIFI_ON_OR_TURNING_ON_STATES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiDirectGroupAndroid;", "Lcom/ustadmobile/sharedse/network/WiFiDirectGroupBle;", "group", "Landroid/net/wifi/p2p/WifiP2pGroup;", "endpointPort", "", "(Landroid/net/wifi/p2p/WifiP2pGroup;I)V", "sharedse_release"})
    private static final class WifiDirectGroupAndroid
    extends WiFiDirectGroupBle {
        public WifiDirectGroupAndroid(@NotNull WifiP2pGroup group, int endpointPort) {
            Intrinsics.checkNotNullParameter((Object)group, (String)"group");
            String string = group.getNetworkName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group.networkName");
            String string2 = group.getPassphrase();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group.passphrase");
            super(string, string2);
            this.setPort(endpointPort);
            this.setIpAddress("192.168.49.1");
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0002\u0018\u0000 \u00142\u00020\u0001:\u0002\u0013\u0014B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u000f\u001a\u00020\u0010H\u0002J\b\u0010\u0011\u001a\u00020\u0010H\u0016J\b\u0010\u0012\u001a\u00020\u0010H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0015"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiP2PGroupServiceManager;", "Lcom/ustadmobile/port/sharedse/util/AsyncServiceManager;", "networkManager", "Lcom/ustadmobile/sharedse/network/NetworkManagerBle;", "(Lcom/ustadmobile/sharedse/network/NetworkManagerBle;)V", "group", "Lcom/ustadmobile/sharedse/network/WiFiDirectGroupBle;", "getGroup", "()Lcom/ustadmobile/sharedse/network/WiFiDirectGroupBle;", "wiFiDirectGroup", "Ljava/util/concurrent/atomic/AtomicReference;", "wifiP2pBroadcastReceiver", "Landroid/content/BroadcastReceiver;", "getWifiP2pBroadcastReceiver", "()Landroid/content/BroadcastReceiver;", "createNewGroup", "", "start", "stop", "CheckTimeoutRunnable", "Companion", "sharedse_release"})
    private static final class WifiP2PGroupServiceManager
    extends AsyncServiceManager {
        @NotNull
        public static final Companion Companion = new Companion(null);
        @NotNull
        private final NetworkManagerBle networkManager;
        @NotNull
        private final AtomicReference<WiFiDirectGroupBle> wiFiDirectGroup;
        @NotNull
        private final BroadcastReceiver wifiP2pBroadcastReceiver;
        private static final int TIMEOUT_AFTER_GROUP_CREATION = 300000;
        private static final int TIMEOUT_AFTER_LAST_REQUEST = 30000;
        private static final int TIMEOUT_CHECK_INTERVAL = 30000;

        public WifiP2PGroupServiceManager(final @NotNull NetworkManagerBle networkManager) {
            Intrinsics.checkNotNullParameter((Object)networkManager, (String)"networkManager");
            super(0, (Function2<? super Runnable, ? super Long, Unit>)((Function2)new Function2<Runnable, Long, Unit>(){

                public final void invoke(@NotNull Runnable runnable, long delay) {
                    Intrinsics.checkNotNullParameter((Object)runnable, (String)"runnable");
                    networkManager.delayedExecutor.schedule(runnable, delay, TimeUnit.MILLISECONDS);
                }
            }));
            this.networkManager = networkManager;
            this.wiFiDirectGroup = new AtomicReference();
            this.wifiP2pBroadcastReceiver = new BroadcastReceiver(this){
                final /* synthetic */ WifiP2PGroupServiceManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onReceive(@NotNull Context context, @NotNull Intent intent) {
                    Intrinsics.checkNotNullParameter((Object)context, (String)"context");
                    Intrinsics.checkNotNullParameter((Object)intent, (String)"intent");
                    WifiP2pManager wifiP2pManager = NetworkManagerBle.access$getWifiP2pManager$p(WifiP2PGroupServiceManager.access$getNetworkManager$p(this.this$0));
                    Intrinsics.checkNotNull((Object)wifiP2pManager);
                    wifiP2pManager.requestGroupInfo(NetworkManagerBle.access$getWifiP2pChannel$p(WifiP2PGroupServiceManager.access$getNetworkManager$p(this.this$0)), arg_0 -> wifiP2pBroadcastReceiver.1.onReceive$lambda$0(this.this$0, arg_0));
                }

                private static final void onReceive$lambda$0(WifiP2PGroupServiceManager this$0, WifiP2pGroup group) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    UMLog.Companion.l(5, 0, "NetworkManagerBle: WiFi direct group broadcast received: group = " + group);
                    WifiP2PGroupServiceManager.access$getWiFiDirectGroup$p(this$0).set(group != null ? new WifiDirectGroupAndroid(group, WifiP2PGroupServiceManager.access$getNetworkManager$p(this$0).getHttpd().getListeningPort()) : null);
                    if (group == null && this$0.getState() == 1 || group != null && this$0.getState() == 3) {
                        return;
                    }
                    if (group != null) {
                        WifiP2PGroupServiceManager.access$getNetworkManager$p(this$0).lockWifi(this$0);
                    }
                    AsyncServiceManager.notifyStateChanged$default(this$0, group != null ? 2 : 0, 0, 2, null);
                }
            };
        }

        @NotNull
        public final BroadcastReceiver getWifiP2pBroadcastReceiver() {
            return this.wifiP2pBroadcastReceiver;
        }

        @NotNull
        public final WiFiDirectGroupBle getGroup() {
            WiFiDirectGroupBle wiFiDirectGroupBle = this.wiFiDirectGroup.get();
            Intrinsics.checkNotNullExpressionValue((Object)wiFiDirectGroupBle, (String)"wiFiDirectGroup.get()");
            return wiFiDirectGroupBle;
        }

        @Override
        public void start() {
            WifiP2pManager wifiP2pManager = this.networkManager.wifiP2pManager;
            Intrinsics.checkNotNull((Object)wifiP2pManager);
            wifiP2pManager.requestGroupInfo(this.networkManager.wifiP2pChannel, arg_0 -> WifiP2PGroupServiceManager.start$lambda$0(this, arg_0));
        }

        private final void createNewGroup() {
            WifiP2pManager wifiP2pManager = this.networkManager.wifiP2pManager;
            Intrinsics.checkNotNull((Object)wifiP2pManager);
            wifiP2pManager.createGroup(this.networkManager.wifiP2pChannel, new WifiP2pManager.ActionListener(this){
                final /* synthetic */ WifiP2PGroupServiceManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess() {
                    UMLog.Companion.l(3, 692, "NetworkManagerBle: Group created successfully");
                }

                public void onFailure(int reason) {
                    UMLog.Companion.l(1, 692, "NetworkManagerBle: Failed to create a group with error code: " + reason);
                    this.this$0.notifyStateChanged(0, 0);
                }
            });
        }

        @Override
        public void stop() {
            UMLog.Companion.l(4, 0, "NetworkManagerBle: stopping group");
            WifiP2pManager wifiP2pManager = this.networkManager.wifiP2pManager;
            Intrinsics.checkNotNull((Object)wifiP2pManager);
            wifiP2pManager.removeGroup(this.networkManager.wifiP2pChannel, new WifiP2pManager.ActionListener(this){
                final /* synthetic */ WifiP2PGroupServiceManager this$0;
                {
                    this.this$0 = $receiver;
                }

                public void onSuccess() {
                    UMLog.Companion.l(3, 693, "NetworkManagerBle: Group removed successfully");
                    WifiP2PGroupServiceManager.access$getWiFiDirectGroup$p(this.this$0).set(null);
                    WifiP2PGroupServiceManager.access$getNetworkManager$p(this.this$0).releaseWifiLock(this.this$0);
                    AsyncServiceManager.notifyStateChanged$default(this.this$0, 0, 0, 2, null);
                }

                public void onFailure(int reason) {
                    UMLog.Companion.l(1, 693, "NetworkManagerBle: Failed to remove a group with error code " + reason);
                    WifiP2pManager wifiP2pManager = NetworkManagerBle.access$getWifiP2pManager$p(WifiP2PGroupServiceManager.access$getNetworkManager$p(this.this$0));
                    Intrinsics.checkNotNull((Object)wifiP2pManager);
                    wifiP2pManager.requestGroupInfo(NetworkManagerBle.access$getWifiP2pChannel$p(WifiP2PGroupServiceManager.access$getNetworkManager$p(this.this$0)), arg_0 -> stop.1.onFailure$lambda$0(this.this$0, arg_0));
                }

                private static final void onFailure$lambda$0(WifiP2PGroupServiceManager this$0, WifiP2pGroup wifiP2pGroup) {
                    Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
                    if (wifiP2pGroup != null) {
                        WifiP2PGroupServiceManager.access$getWiFiDirectGroup$p(this$0).set(new WifiDirectGroupAndroid(wifiP2pGroup, WifiP2PGroupServiceManager.access$getNetworkManager$p(this$0).getHttpd().getListeningPort()));
                        this$0.notifyStateChanged(2, 2);
                    } else {
                        WifiP2PGroupServiceManager.access$getWiFiDirectGroup$p(this$0).set(null);
                        WifiP2PGroupServiceManager.access$getNetworkManager$p(this$0).releaseWifiLock(this$0);
                        AsyncServiceManager.notifyStateChanged$default(this$0, 0, 0, 2, null);
                    }
                }
            });
        }

        private static final void start$lambda$0(WifiP2PGroupServiceManager this$0, WifiP2pGroup wifiP2pGroup) {
            Intrinsics.checkNotNullParameter((Object)this$0, (String)"this$0");
            if (wifiP2pGroup != null) {
                WifiDirectGroupAndroid existingGroup = new WifiDirectGroupAndroid(wifiP2pGroup, this$0.networkManager.getHttpd().getListeningPort());
                UMLog.Companion.l(4, 0, "NetworkManagerBle: group already exists: " + existingGroup);
                this$0.wiFiDirectGroup.set(existingGroup);
                AsyncServiceManager.notifyStateChanged$default(this$0, 2, 0, 2, null);
            } else {
                UMLog.Companion.l(4, 0, "NetworkManagerBle: Creating new WiFi direct group");
                this$0.createNewGroup();
            }
        }

        public static final /* synthetic */ AtomicReference access$getWiFiDirectGroup$p(WifiP2PGroupServiceManager $this) {
            return $this.wiFiDirectGroup;
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016\u00a8\u0006\u0005"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiP2PGroupServiceManager$CheckTimeoutRunnable;", "Ljava/lang/Runnable;", "(Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiP2PGroupServiceManager;)V", "run", "", "sharedse_release"})
        private final class CheckTimeoutRunnable
        implements Runnable {
            @Override
            public void run() {
                long timeNow = System.currentTimeMillis();
                boolean timedOut = WifiP2PGroupServiceManager.this.networkManager.numActiveRequests.get() == 0 && timeNow - WifiP2PGroupServiceManager.this.networkManager.wifiDirectGroupLastRequestedTime.get() > 300000L && timeNow - WifiP2PGroupServiceManager.this.networkManager.wifiDirectRequestLastCompletedTime.get() > 30000L;
                WifiP2PGroupServiceManager.this.setEnabled(!timedOut);
            }
        }

        @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$WifiP2PGroupServiceManager$Companion;", "", "()V", "TIMEOUT_AFTER_GROUP_CREATION", "", "TIMEOUT_AFTER_LAST_REQUEST", "TIMEOUT_CHECK_INTERVAL", "sharedse_release"})
        public static final class Companion {
            private Companion() {
            }

            public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
                this();
            }
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0010\u0010\u0007\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$UmNetworkCallback;", "Landroid/net/ConnectivityManager$NetworkCallback;", "(Lcom/ustadmobile/sharedse/network/NetworkManagerBle;)V", "onAvailable", "", "network", "Landroid/net/Network;", "onLost", "onUnavailable", "sharedse_release"})
    private final class UmNetworkCallback
    extends ConnectivityManager.NetworkCallback {
        public void onAvailable(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            super.onAvailable(network);
            NetworkManagerBle.this.handleNetworkAvailable(network);
        }

        public void onLost(@NotNull Network network) {
            Intrinsics.checkNotNullParameter((Object)network, (String)"network");
            super.onLost(network);
            StringBuilder stringBuilder = new StringBuilder().append("NetworkCallback: onAvailable");
            ConnectivityManager connectivityManager = NetworkManagerBle.this.connectivityManager;
            Intrinsics.checkNotNull((Object)connectivityManager);
            UMLog.Companion.l(4, 42, stringBuilder.append(NetworkManagerBle.this.prettyPrintNetwork(connectivityManager.getNetworkInfo(network))).toString());
            NetworkManagerBle.this.handleDisconnected();
        }

        public void onUnavailable() {
            UMLog.Companion.l(4, 42, "NetworkCallback: onUnavailable");
            super.onUnavailable();
            NetworkManagerBle.this.handleDisconnected();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\u0006\u0010\u0002R\u001c\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\u00048\u0002X\u0083\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\b\u0010\u0002\u00a8\u0006\t"}, d2={"Lcom/ustadmobile/sharedse/network/NetworkManagerBle$Companion;", "", "()V", "BLUETOOTH_ON_OR_TURNING_ON_STATES", "", "", "getBLUETOOTH_ON_OR_TURNING_ON_STATES$annotations", "WIFI_ON_OR_TURNING_ON_STATES", "getWIFI_ON_OR_TURNING_ON_STATES$annotations", "sharedse_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        private static /* synthetic */ void getBLUETOOTH_ON_OR_TURNING_ON_STATES$annotations() {
        }

        @JvmStatic
        private static /* synthetic */ void getWIFI_ON_OR_TURNING_ON_STATES$annotations() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

