/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import com.ustadmobile.sharedse.io.ByteBufferSe;
import com.ustadmobile.sharedse.network.NetworkManagerBleCommon;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\t\n\u0002\u0010\b\n\u0002\b\n\b\u0016\u0018\u00002\u00020\u0001B\u0017\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0006\u0010\u0019\u001a\u00020\u0007J\b\u0010\u001a\u001a\u00020\u0003H\u0016R\u001c\u0010\t\u001a\u0004\u0018\u00010\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u000b\"\u0004\b\u000f\u0010\rR\u001e\u0010\u0010\u001a\u0004\u0018\u00010\u0011X\u0086\u000e\u00a2\u0006\u0010\n\u0002\u0010\u0016\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015R\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u000b\"\u0004\b\u0018\u0010\r\u00a8\u0006\u001b"}, d2={"Lcom/ustadmobile/sharedse/network/WiFiDirectGroupBle;", "", "ssid", "", "passphrase", "(Ljava/lang/String;Ljava/lang/String;)V", "byteArr", "", "([B)V", "ipAddress", "getIpAddress", "()Ljava/lang/String;", "setIpAddress", "(Ljava/lang/String;)V", "getPassphrase", "setPassphrase", "port", "", "getPort", "()Ljava/lang/Integer;", "setPort", "(Ljava/lang/Integer;)V", "Ljava/lang/Integer;", "getSsid", "setSsid", "toBytes", "toString", "sharedse_debug"})
public class WiFiDirectGroupBle {
    @NotNull
    private String ssid;
    @NotNull
    private String passphrase;
    @Nullable
    private Integer port;
    @Nullable
    private String ipAddress;

    public WiFiDirectGroupBle(@NotNull String ssid, @NotNull String passphrase) {
        Intrinsics.checkNotNullParameter((Object)ssid, (String)"ssid");
        Intrinsics.checkNotNullParameter((Object)passphrase, (String)"passphrase");
        this.ssid = "";
        this.passphrase = "";
        this.port = 0;
        this.ipAddress = "";
        this.ssid = ssid;
        this.passphrase = passphrase;
    }

    public WiFiDirectGroupBle(@NotNull byte[] byteArr) {
        Intrinsics.checkNotNullParameter((Object)byteArr, (String)"byteArr");
        this.ssid = "";
        this.passphrase = "";
        this.port = 0;
        this.ipAddress = "";
        ByteBufferSe buffer = ByteBufferSe.Companion.wrap(byteArr);
        int ipInt = buffer.getInt();
        this.port = buffer.getChar();
        this.ipAddress = NetworkManagerBleCommon.Companion.convertIpAddressToString(ipInt);
        byte[] ssidAndPassphraseArr = new byte[buffer.remaining()];
        buffer.get(ssidAndPassphraseArr, 0, buffer.remaining());
        String[] stringArray = new String[]{"|"};
        List ssidAndPassphrase = StringsKt.split$default((CharSequence)StringsKt.decodeToString((byte[])ssidAndPassphraseArr), (String[])stringArray, (boolean)false, (int)0, (int)6, null);
        this.ssid = (String)ssidAndPassphrase.get(0);
        this.passphrase = (String)ssidAndPassphrase.get(1);
    }

    @NotNull
    public final byte[] toBytes() {
        String string = this.ssid + '|' + this.passphrase;
        ByteBufferSe byteBufferSe = ByteBufferSe.Companion.allocate(StringsKt.encodeToByteArray((String)string).length + 4 + 2);
        String string2 = this.ipAddress;
        Intrinsics.checkNotNull((Object)string2);
        ByteBufferSe byteBufferSe2 = byteBufferSe.putInt(NetworkManagerBleCommon.Companion.convertIpAddressToInteger(string2));
        Integer n = this.port;
        Intrinsics.checkNotNull((Object)n);
        ByteBufferSe buffer = byteBufferSe2.putChar((char)n.intValue()).put(StringsKt.encodeToByteArray((String)string));
        return buffer.array();
    }

    @NotNull
    public final String getSsid() {
        return this.ssid;
    }

    public final void setSsid(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.ssid = string;
    }

    @NotNull
    public final String getPassphrase() {
        return this.passphrase;
    }

    public final void setPassphrase(@NotNull String string) {
        Intrinsics.checkNotNullParameter((Object)string, (String)"<set-?>");
        this.passphrase = string;
    }

    @Nullable
    public final Integer getPort() {
        return this.port;
    }

    public final void setPort(@Nullable Integer n) {
        this.port = n;
    }

    @Nullable
    public final String getIpAddress() {
        return this.ipAddress;
    }

    public final void setIpAddress(@Nullable String string) {
        this.ipAddress = string;
    }

    @NotNull
    public String toString() {
        return "WiFiDirectGroupBle ssid='" + this.ssid + "' passphrase='" + this.passphrase + "' ownerIp=" + this.ipAddress + " ownerPort=" + this.port;
    }
}

