/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.contentformats.xapi.endpoints;

import com.google.gson.Gson;
import com.ustadmobile.core.account.Endpoint;
import com.ustadmobile.core.contentformats.xapi.Actor;
import com.ustadmobile.core.contentformats.xapi.State;
import com.ustadmobile.core.contentformats.xapi.endpoints.XapiStateEndpoint;
import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.core.db.dao.AgentDao;
import com.ustadmobile.core.db.dao.PersonDao;
import com.ustadmobile.core.db.dao.StateContentDao;
import com.ustadmobile.lib.db.entities.AgentEntity;
import com.ustadmobile.lib.db.entities.StateContentEntity;
import com.ustadmobile.lib.db.entities.StateEntity;
import com.ustadmobile.lib.util.SystemTimeKt;
import com.ustadmobile.port.sharedse.contentformats.xapi.endpoints.StatementRequestException;
import com.ustadmobile.port.sharedse.contentformats.xapi.endpoints.XapiStatementEndpointImpl;
import com.ustadmobile.port.sharedse.contentformats.xapi.endpoints.XapiUtil;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.kodein.di.DI;
import org.kodein.di.DIAware;
import org.kodein.di.DIAwareKt;
import org.kodein.di.DIContext;
import org.kodein.di.DITrigger;
import org.kodein.type.GenericJVMTypeTokenDelegate;
import org.kodein.type.JVMTypeToken;
import org.kodein.type.TypeReference;
import org.kodein.type.TypeToken;
import org.kodein.type.TypeTokensJVMKt;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J \u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J(\u0010\u001f\u001a\u00020\u001a2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cH\u0016J0\u0010!\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001cH\u0016J&\u0010#\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001c2\u0006\u0010\"\u001a\u00020\u001cJ&\u0010$\u001a\u00020\u001c2\u0006\u0010 \u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001e\u001a\u00020\u001cJ\u0010\u0010%\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0016J\u0010\u0010(\u001a\u00020\u001a2\u0006\u0010&\u001a\u00020'H\u0016R\u001b\u0010\u0007\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000b\u0010\f\u001a\u0004\b\t\u0010\nR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u001b\u0010\u0011\u001a\u00020\u00128BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0015\u0010\f\u001a\u0004\b\u0013\u0010\u0014R\u001b\u0010\u0016\u001a\u00020\b8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0018\u0010\f\u001a\u0004\b\u0017\u0010\n\u00a8\u0006)"}, d2={"Lcom/ustadmobile/port/sharedse/contentformats/xapi/endpoints/XapiStateEndpointImpl;", "Lcom/ustadmobile/core/contentformats/xapi/endpoints/XapiStateEndpoint;", "endpoint", "Lcom/ustadmobile/core/account/Endpoint;", "di", "Lorg/kodein/di/DI;", "(Lcom/ustadmobile/core/account/Endpoint;Lorg/kodein/di/DI;)V", "db", "Lcom/ustadmobile/core/db/UmAppDatabase;", "getDb", "()Lcom/ustadmobile/core/db/UmAppDatabase;", "db$delegate", "Lkotlin/Lazy;", "getDi", "()Lorg/kodein/di/DI;", "getEndpoint", "()Lcom/ustadmobile/core/account/Endpoint;", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "gson$delegate", "repo", "getRepo", "repo$delegate", "deleteListOfStates", "", "agentJson", "", "activityId", "registration", "deleteStateContent", "stateId", "getContent", "since", "getListOfStateId", "getStateContent", "overrideState", "state", "Lcom/ustadmobile/core/contentformats/xapi/State;", "storeState", "sharedse"})
public final class XapiStateEndpointImpl
implements XapiStateEndpoint {
    static final /* synthetic */ KProperty<Object>[] $$delegatedProperties;
    @NotNull
    private final Endpoint endpoint;
    @NotNull
    private final DI di;
    @NotNull
    private final Lazy db$delegate;
    @NotNull
    private final Lazy repo$delegate;
    @NotNull
    private final Lazy gson$delegate;

    public XapiStateEndpointImpl(@NotNull Endpoint endpoint, @NotNull DI di) {
        DIAware $this$instance$iv;
        DIAware $this$on_u24default$iv;
        Intrinsics.checkNotNullParameter((Object)endpoint, (String)"endpoint");
        Intrinsics.checkNotNullParameter((Object)di, (String)"di");
        this.endpoint = endpoint;
        this.di = di;
        DIAware dIAware = (DIAware)this;
        Endpoint context$iv = this.endpoint;
        DITrigger trigger$iv = $this$on_u24default$iv.getDiTrigger();
        boolean $i$f$on = false;
        boolean $i$f$diContext = false;
        boolean $i$f$generic = false;
        JVMTypeToken jVMTypeToken = TypeTokensJVMKt.typeToken((Type)new TypeReference<Endpoint>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        $this$on_u24default$iv = (DIAware)DIAwareKt.On((DIAware)$this$on_u24default$iv, (DIContext)DIContext.Companion.invoke((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken, Endpoint.class), (Object)context$iv), (DITrigger)trigger$iv);
        Integer tag$iv = 1;
        boolean $i$f$instance = false;
        boolean $i$f$generic2 = false;
        JVMTypeToken jVMTypeToken2 = TypeTokensJVMKt.typeToken((Type)new TypeReference<UmAppDatabase>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken2, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        this.db$delegate = DIAwareKt.Instance((DIAware)$this$instance$iv, (TypeToken)((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken2, UmAppDatabase.class)), (Object)tag$iv).provideDelegate((Object)this, $$delegatedProperties[0]);
        $this$instance$iv = (DIAware)this;
        context$iv = this.endpoint;
        trigger$iv = $this$on_u24default$iv.getDiTrigger();
        $i$f$on = false;
        $i$f$diContext = false;
        $i$f$generic = false;
        JVMTypeToken jVMTypeToken3 = TypeTokensJVMKt.typeToken((Type)new TypeReference<Endpoint>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken3, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        $this$on_u24default$iv = (DIAware)DIAwareKt.On((DIAware)$this$on_u24default$iv, (DIContext)DIContext.Companion.invoke((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken3, Endpoint.class), (Object)context$iv), (DITrigger)trigger$iv);
        tag$iv = 2;
        $i$f$instance = false;
        $i$f$generic2 = false;
        JVMTypeToken jVMTypeToken4 = TypeTokensJVMKt.typeToken((Type)new TypeReference<UmAppDatabase>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken4, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        this.repo$delegate = DIAwareKt.Instance((DIAware)$this$instance$iv, (TypeToken)((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken4, UmAppDatabase.class)), (Object)tag$iv).provideDelegate((Object)this, $$delegatedProperties[1]);
        DIAware $this$instance_u24default$iv = (DIAware)this.getDi();
        tag$iv = null;
        $i$f$instance = false;
        $i$f$generic2 = false;
        JVMTypeToken jVMTypeToken5 = TypeTokensJVMKt.typeToken((Type)new TypeReference<Gson>(){}.getSuperType());
        Intrinsics.checkNotNull((Object)jVMTypeToken5, (String)"null cannot be cast to non-null type org.kodein.type.JVMTypeToken<T of org.kodein.type.TypeTokensJVMKt.generic>");
        this.gson$delegate = DIAwareKt.Instance((DIAware)$this$instance_u24default$iv, (TypeToken)((TypeToken)new GenericJVMTypeTokenDelegate(jVMTypeToken5, Gson.class)), (Object)tag$iv).provideDelegate((Object)this, $$delegatedProperties[2]);
    }

    @NotNull
    public final Endpoint getEndpoint() {
        return this.endpoint;
    }

    @NotNull
    public DI getDi() {
        return this.di;
    }

    private final UmAppDatabase getDb() {
        Lazy lazy = this.db$delegate;
        return (UmAppDatabase)lazy.getValue();
    }

    private final UmAppDatabase getRepo() {
        Lazy lazy = this.repo$delegate;
        return (UmAppDatabase)lazy.getValue();
    }

    private final Gson getGson() {
        Lazy lazy = this.gson$delegate;
        return (Gson)lazy.getValue();
    }

    public void storeState(@NotNull State state) throws StatementRequestException {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Actor actor = state.getAgent();
        if (actor == null) {
            throw new IllegalArgumentException("State has null agent");
        }
        Actor agentVal = actor;
        HashMap hashMap = state.getContent();
        if (hashMap == null) {
            throw new IllegalArgumentException("State has null content");
        }
        HashMap contentVal = hashMap;
        XapiStatementEndpointImpl.Companion.checkValidActor(agentVal);
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(this.getRepo().getAgentDao(), this.getRepo().getPersonDao(), agentVal);
        StateEntity stateEntity = XapiUtil.INSTANCE.insertOrUpdateState(this.getRepo().getStateDao(), state, agentEntity.getAgentUid());
        XapiUtil.INSTANCE.insertOrUpdateStateContent(this.getRepo().getStateContentDao(), contentVal, stateEntity);
    }

    public void overrideState(@NotNull State state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Actor actor = state.getAgent();
        Intrinsics.checkNotNull((Object)actor);
        XapiStatementEndpointImpl.Companion.checkValidActor(actor);
        AgentDao agentDao = this.getRepo().getAgentDao();
        PersonDao personDao = this.getRepo().getPersonDao();
        Actor actor2 = state.getAgent();
        Intrinsics.checkNotNull((Object)actor2);
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(agentDao, personDao, actor2);
        StateEntity stateEntity = XapiUtil.INSTANCE.insertOrUpdateState(this.getRepo().getStateDao(), state, agentEntity.getAgentUid());
        StateContentDao stateContentDao = this.getRepo().getStateContentDao();
        HashMap hashMap = state.getContent();
        Intrinsics.checkNotNull((Object)hashMap);
        XapiUtil.INSTANCE.deleteAndInsertNewStateContent(stateContentDao, hashMap, stateEntity);
    }

    @NotNull
    public String getContent(@NotNull String stateId, @NotNull String agentJson, @NotNull String activityId, @NotNull String registration, @NotNull String since) {
        Intrinsics.checkNotNullParameter((Object)stateId, (String)"stateId");
        Intrinsics.checkNotNullParameter((Object)agentJson, (String)"agentJson");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        return ((CharSequence)stateId).length() == 0 ? this.getListOfStateId(agentJson, activityId, registration, since) : this.getStateContent(stateId, agentJson, activityId, registration);
    }

    @NotNull
    public final String getStateContent(@NotNull String stateId, @NotNull String agentJson, @NotNull String activityId, @NotNull String registration) {
        Intrinsics.checkNotNullParameter((Object)stateId, (String)"stateId");
        Intrinsics.checkNotNullParameter((Object)agentJson, (String)"agentJson");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        Actor agent = (Actor)this.getGson().fromJson(agentJson, Actor.class);
        AgentDao agentDao = this.getRepo().getAgentDao();
        PersonDao personDao = this.getRepo().getPersonDao();
        Intrinsics.checkNotNullExpressionValue((Object)agent, (String)"agent");
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(agentDao, personDao, agent);
        StateEntity entity = this.getDb().getStateDao().findByStateId(stateId, agentEntity.getAgentUid(), activityId, registration);
        StateContentDao stateContentDao = this.getDb().getStateContentDao();
        StateEntity stateEntity = entity;
        Intrinsics.checkNotNull((Object)stateEntity);
        List list = stateContentDao.findAllStateContentWithStateUid(stateEntity.getStateUid());
        HashMap contentMap = new HashMap();
        for (StateContentEntity contentEntity : list) {
            ((Map)contentMap).put(contentEntity.getStateContentKey(), contentEntity.getStateContentValue());
        }
        String string = this.getGson().toJson(contentMap);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(contentMap)");
        return string;
    }

    @NotNull
    public final String getListOfStateId(@NotNull String agentJson, @NotNull String activityId, @NotNull String registration, @NotNull String since) {
        Intrinsics.checkNotNullParameter((Object)agentJson, (String)"agentJson");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        Intrinsics.checkNotNullParameter((Object)since, (String)"since");
        Actor agent = (Actor)this.getGson().fromJson(agentJson, Actor.class);
        AgentDao agentDao = this.getDb().getAgentDao();
        PersonDao personDao = this.getDb().getPersonDao();
        Intrinsics.checkNotNullExpressionValue((Object)agent, (String)"agent");
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(agentDao, personDao, agent);
        List list = this.getDb().getStateDao().findStateIdByAgentAndActivity(agentEntity.getAgentUid(), activityId, registration, since);
        ArrayList<String> idList = new ArrayList<String>();
        for (StateEntity state : list) {
            idList.add(state.getStateId());
        }
        String string = this.getGson().toJson(idList);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"gson.toJson(idList)");
        return string;
    }

    public void deleteStateContent(@NotNull String stateId, @NotNull String agentJson, @NotNull String activityId, @NotNull String registration) {
        Intrinsics.checkNotNullParameter((Object)stateId, (String)"stateId");
        Intrinsics.checkNotNullParameter((Object)agentJson, (String)"agentJson");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        Actor agent = (Actor)this.getGson().fromJson(agentJson, Actor.class);
        AgentDao agentDao = this.getDb().getAgentDao();
        PersonDao personDao = this.getDb().getPersonDao();
        Intrinsics.checkNotNullExpressionValue((Object)agent, (String)"agent");
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(agentDao, personDao, agent);
        this.getRepo().getStateDao().setStateInActive(stateId, agentEntity.getAgentUid(), activityId, registration, false, SystemTimeKt.getSystemTimeInMillis());
    }

    public void deleteListOfStates(@NotNull String agentJson, @NotNull String activityId, @NotNull String registration) {
        Intrinsics.checkNotNullParameter((Object)agentJson, (String)"agentJson");
        Intrinsics.checkNotNullParameter((Object)activityId, (String)"activityId");
        Intrinsics.checkNotNullParameter((Object)registration, (String)"registration");
        Actor agent = (Actor)this.getGson().fromJson(agentJson, Actor.class);
        AgentDao agentDao = this.getDb().getAgentDao();
        PersonDao personDao = this.getDb().getPersonDao();
        Intrinsics.checkNotNullExpressionValue((Object)agent, (String)"agent");
        AgentEntity agentEntity = XapiUtil.INSTANCE.getAgent(agentDao, personDao, agent);
        this.getRepo().getStateDao().updateStateToInActive(agentEntity.getAgentUid(), activityId, registration, false, SystemTimeKt.getSystemTimeInMillis());
    }

    @NotNull
    public DIContext<?> getDiContext() {
        return XapiStateEndpoint.DefaultImpls.getDiContext((XapiStateEndpoint)this);
    }

    @Nullable
    public DITrigger getDiTrigger() {
        return XapiStateEndpoint.DefaultImpls.getDiTrigger((XapiStateEndpoint)this);
    }

    static {
        KProperty[] kPropertyArray = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(XapiStateEndpointImpl.class, "db", "getDb()Lcom/ustadmobile/core/db/UmAppDatabase;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(XapiStateEndpointImpl.class, "repo", "getRepo()Lcom/ustadmobile/core/db/UmAppDatabase;", 0))), (KProperty)Reflection.property1((PropertyReference1)((PropertyReference1)new PropertyReference1Impl(XapiStateEndpointImpl.class, "gson", "getGson()Lcom/google/gson/Gson;", 0)))};
        $$delegatedProperties = kPropertyArray;
    }
}

