/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.impl.http;

import com.ustadmobile.core.db.UmAppDatabase;
import com.ustadmobile.lib.db.entities.ContainerEntryFile;
import com.ustadmobile.lib.db.entities.ContainerEntryWithContainerEntryFile;
import com.ustadmobile.lib.util.AcceptEncodingUtilKt;
import com.ustadmobile.port.sharedse.impl.http.FileResponder;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.File;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u0000 \u00122\u00020\u00012\u00020\u0002:\u0002\u0012\u0013B\u0005\u00a2\u0006\u0002\u0010\u0003J.\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J-\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0096\u0002J6\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\n2\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u0010\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016J.\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u000b\u001a\u00020\fH\u0016\u00a8\u0006\u0014"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/MountedContainerResponder;", "Lcom/ustadmobile/port/sharedse/impl/http/FileResponder;", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResponder;", "()V", "delete", "Lfi/iki/elonen/NanoHTTPD$Response;", "uriResource", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "get", "other", "method", "post", "put", "Companion", "MountedContainerFilter", "sharedse"})
public final class MountedContainerResponder
extends FileResponder
implements RouterNanoHTTPD.UriResponder {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    public static final String URI_ROUTE_POSTFIX = "(.)+";
    public static final int CONTAINER_UID_INDEX = 1;
    @NotNull
    private static final ArrayList<String> HTML_EXTENSIONS = new ArrayList();
    public static final int PARAM_CONTAINERUID_INDEX = 0;
    public static final int PARAM_DB_INDEX = 1;
    public static final int PARAM_FILTERS_INDEX = 2;

    @NotNull
    public NanoHTTPD.Response get(@NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull Map<String, String> urlParams, @NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
        Intrinsics.checkNotNullParameter(urlParams, (String)"urlParams");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        try {
            FileResponder.IFileSource iFileSource;
            boolean fileIsGzipped;
            String requestUri = session.getUri();
            Object object = uriResource.initParameter(0, String.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"uriResource.initParamete\u2026NDEX, String::class.java)");
            long containerUid = Long.parseLong((String)object);
            String string = requestUri;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"requestUri");
            String string2 = string;
            int n = uriResource.getUri().length() - 4;
            String string3 = string2.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String).substring(startIndex)");
            String pathInContainer = StringsKt.removePrefix((String)string3, (CharSequence)"/");
            UmAppDatabase appDb = (UmAppDatabase)uriResource.initParameter(1, UmAppDatabase.class);
            ContainerEntryWithContainerEntryFile containerEntryWithContainerEntryFile = appDb.getContainerEntryDao().findByPathInContainer(containerUid, pathInContainer);
            if (containerEntryWithContainerEntryFile == null) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)("Entry not found in container: " + pathInContainer + " uriResource.uri=" + uriResource.getUri() + "\nrequestUri=" + requestUri));
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026equestUri=${requestUri}\")");
                return response;
            }
            ContainerEntryWithContainerEntryFile entryFile = containerEntryWithContainerEntryFile;
            Object object2 = uriResource.initParameter(2, List.class);
            Intrinsics.checkNotNull((Object)object2, (String)"null cannot be cast to non-null type kotlin.collections.List<com.ustadmobile.port.sharedse.impl.http.MountedContainerResponder.MountedContainerFilter>");
            List filterList = (List)object2;
            Object object3 = entryFile.getContainerEntryFile();
            if (object3 == null || (object3 = object3.getCefPath()) == null) {
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)("Entry found but does not have containerEntryFile/cefPath: " + pathInContainer + " uriResource.uri=" + uriResource.getUri() + "\nrequestUri=" + requestUri));
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026equestUri=${requestUri}\")");
                return response;
            }
            Object it = object3;
            boolean bl = false;
            File responseFile = new File((String)it);
            boolean acceptsGzip = AcceptEncodingUtilKt.parseAcceptedEncoding((String)((String)session.getHeaders().get("accept-encoding"))).isEncodingAcceptable("gzip");
            ContainerEntryFile containerEntryFile = entryFile.getContainerEntryFile();
            boolean bl2 = containerEntryFile != null ? containerEntryFile.getCompression() == 1 : (fileIsGzipped = false);
            if (!fileIsGzipped || acceptsGzip) {
                iFileSource = new FileResponder.FileSource(responseFile);
            } else {
                ContainerEntryFile containerEntryFile2 = entryFile.getContainerEntryFile();
                if (containerEntryFile2 == null) {
                    throw new IllegalStateException("no total size");
                }
                iFileSource = new FileResponder.InflateFileSource(responseFile, containerEntryFile2.getCeTotalSize());
            }
            FileResponder.IFileSource fileSource = iFileSource;
            NanoHTTPD.Response response = FileResponder.Companion.newResponseFromFile(uriResource, session, fileSource);
            if (acceptsGzip && fileIsGzipped) {
                response.addHeader("Content-Encoding", "gzip");
            }
            for (MountedContainerFilter filter : filterList) {
                response = filter.filterResponse(response, uriResource, urlParams, session);
            }
            return response;
        }
        catch (URISyntaxException e) {
            e.printStackTrace();
            NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.BAD_REQUEST), (String)"text/plain", (String)("URISyntax error: " + e));
            Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026\", \"URISyntax error: $e\")");
            return response;
        }
    }

    @Nullable
    public NanoHTTPD.Response put(@NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull Map<String, String> urlParams, @NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
        Intrinsics.checkNotNullParameter(urlParams, (String)"urlParams");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return null;
    }

    @Nullable
    public NanoHTTPD.Response post(@NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull Map<String, String> urlParams, @NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
        Intrinsics.checkNotNullParameter(urlParams, (String)"urlParams");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return null;
    }

    @Nullable
    public NanoHTTPD.Response delete(@NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull Map<String, String> urlParams, @NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
        Intrinsics.checkNotNullParameter(urlParams, (String)"urlParams");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return null;
    }

    @Nullable
    public NanoHTTPD.Response other(@NotNull String method, @NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull Map<String, String> urlParams, @NotNull NanoHTTPD.IHTTPSession session) {
        Intrinsics.checkNotNullParameter((Object)method, (String)"method");
        Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
        Intrinsics.checkNotNullParameter(urlParams, (String)"urlParams");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        return null;
    }

    static {
        HTML_EXTENSIONS.add("xhtml");
        HTML_EXTENSIONS.add("html");
        HTML_EXTENSIONS.add("htm");
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J4\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00062\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u000bH&\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/MountedContainerResponder$MountedContainerFilter;", "", "filterResponse", "Lfi/iki/elonen/NanoHTTPD$Response;", "responseIn", "uriResource", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResource;", "urlParams", "", "", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "sharedse"})
    public static interface MountedContainerFilter {
        @NotNull
        public NanoHTTPD.Response filterResponse(@NotNull NanoHTTPD.Response var1, @NotNull RouterNanoHTTPD.UriResource var2, @NotNull Map<String, String> var3, @NotNull NanoHTTPD.IHTTPSession var4);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\u0007X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/MountedContainerResponder$Companion;", "", "()V", "CONTAINER_UID_INDEX", "", "HTML_EXTENSIONS", "Ljava/util/ArrayList;", "", "PARAM_CONTAINERUID_INDEX", "PARAM_DB_INDEX", "PARAM_FILTERS_INDEX", "URI_ROUTE_POSTFIX", "sharedse"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

