/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.util;

import java.util.List;
import java.util.Vector;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\t\u0018\u00002\u00020\u0001:\u0002\u0016\u0017B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0011\u001a\u00020\u000fJ\b\u0010\u0012\u001a\u00020\u000fH\u0004J\u000e\u0010\u0013\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000bJ\u0006\u0010\u0014\u001a\u00020\u000fJ\u0006\u0010\u0015\u001a\u00020\u000fR\u0014\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lcom/ustadmobile/port/sharedse/util/WorkQueue;", "", "source", "Lcom/ustadmobile/port/sharedse/util/WorkQueue$WorkQueueSource;", "maxThreads", "", "(Lcom/ustadmobile/port/sharedse/util/WorkQueue$WorkQueueSource;I)V", "activeItems", "", "Ljava/lang/Runnable;", "emptyWorkQueueListeners", "Lcom/ustadmobile/port/sharedse/util/WorkQueue$EmptyWorkQueueListener;", "executor", "Ljava/util/concurrent/ExecutorService;", "addEmptyWorkQueueListener", "", "listener", "checkQueue", "fireWorkQueueEmptyEvent", "removeEmptyWorkQueueListener", "shutdown", "start", "EmptyWorkQueueListener", "WorkQueueSource", "sharedse"})
public final class WorkQueue {
    @NotNull
    private final WorkQueueSource source;
    private final int maxThreads;
    @Nullable
    private ExecutorService executor;
    @NotNull
    private final List<Runnable> activeItems;
    @NotNull
    private final List<EmptyWorkQueueListener> emptyWorkQueueListeners;

    public WorkQueue(@NotNull WorkQueueSource source, int maxThreads) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        this.source = source;
        this.maxThreads = maxThreads;
        this.activeItems = new Vector(this.maxThreads);
        this.emptyWorkQueueListeners = new Vector();
    }

    public final void start() {
        this.executor = Executors.newFixedThreadPool(this.maxThreads);
        this.checkQueue();
    }

    public final void shutdown() {
        ExecutorService executorService = this.executor;
        Intrinsics.checkNotNull((Object)executorService);
        executorService.shutdown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void checkQueue() {
        List<Runnable> list = this.activeItems;
        synchronized (list) {
            boolean bl = false;
            Ref.ObjectRef nextItem = new Ref.ObjectRef();
            nextItem.element = this.source.nextItem();
            while (this.activeItems.size() < this.maxThreads && nextItem.element != null) {
                Function0 runWrapper2 = (Function0)new Function0<Unit>((Ref.ObjectRef<Runnable>)nextItem, this){
                    final /* synthetic */ Ref.ObjectRef<Runnable> $nextItem;
                    final /* synthetic */ WorkQueue this$0;
                    {
                        this.$nextItem = $nextItem;
                        this.this$0 = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        Object object = this.$nextItem.element;
                        Intrinsics.checkNotNull((Object)object);
                        ((Runnable)object).run();
                        List list = WorkQueue.access$getActiveItems$p(this.this$0);
                        Object object2 = this.$nextItem.element;
                        Intrinsics.checkNotNull((Object)object2);
                        list.remove(object2);
                        this.this$0.checkQueue();
                    }
                };
                this.activeItems.add((Runnable)nextItem.element);
                ExecutorService executorService = this.executor;
                Intrinsics.checkNotNull((Object)executorService);
                executorService.submit(() -> WorkQueue.checkQueue$lambda$1$lambda$0(runWrapper2));
                nextItem.element = this.source.nextItem();
            }
            if (this.activeItems.isEmpty()) {
                this.fireWorkQueueEmptyEvent();
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    protected final void fireWorkQueueEmptyEvent() {
        for (EmptyWorkQueueListener listener2 : this.emptyWorkQueueListeners) {
            listener2.onQueueEmpty(this);
        }
    }

    public final void addEmptyWorkQueueListener(@NotNull EmptyWorkQueueListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.emptyWorkQueueListeners.add(listener2);
    }

    public final void removeEmptyWorkQueueListener(@NotNull EmptyWorkQueueListener listener2) {
        Intrinsics.checkNotNullParameter((Object)listener2, (String)"listener");
        this.emptyWorkQueueListeners.remove(listener2);
    }

    private static final void checkQueue$lambda$1$lambda$0(Function0 $tmp0) {
        Intrinsics.checkNotNullParameter((Object)$tmp0, (String)"$tmp0");
        $tmp0.invoke();
    }

    public static final /* synthetic */ List access$getActiveItems$p(WorkQueue $this) {
        return $this.activeItems;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\n\u0010\u0002\u001a\u0004\u0018\u00010\u0003H&\u00a8\u0006\u0004"}, d2={"Lcom/ustadmobile/port/sharedse/util/WorkQueue$WorkQueueSource;", "", "nextItem", "Ljava/lang/Runnable;", "sharedse"})
    public static interface WorkQueueSource {
        @Nullable
        public Runnable nextItem();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\bf\u0018\u00002\u00020\u0001J\u0010\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005H&\u00a8\u0006\u0006"}, d2={"Lcom/ustadmobile/port/sharedse/util/WorkQueue$EmptyWorkQueueListener;", "", "onQueueEmpty", "", "queue", "Lcom/ustadmobile/port/sharedse/util/WorkQueue;", "sharedse"})
    public static interface EmptyWorkQueueListener {
        public void onQueueEmpty(@NotNull WorkQueue var1);
    }
}

