/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.sharedse.network;

import com.ustadmobile.lib.util.SystemTimeKt;
import com.ustadmobile.sharedse.network.BleMessage;
import java.util.LinkedHashMap;
import java.util.Map;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.TypeIntrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0002\u0010$\n\u0002\u0010\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0002\b\u0002\u0018\u00002\u00020\u0001:\u0001\u000eB\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\rR&\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/sharedse/network/BleMessageAssembler;", "", "()V", "clientAddrToMessagesMap", "", "", "", "", "Lcom/ustadmobile/sharedse/network/BleMessageAssembler$BleMessageInProgress;", "handleIncomingPacket", "Lcom/ustadmobile/sharedse/network/BleMessage;", "senderAddr", "packet", "", "BleMessageInProgress", "sharedse"})
public final class BleMessageAssembler {
    @NotNull
    private final Map<String, Map<Byte, BleMessageInProgress>> clientAddrToMessagesMap = new LinkedHashMap();

    @Nullable
    public final synchronized BleMessage handleIncomingPacket(@NotNull String senderAddr, @NotNull byte[] packet) {
        boolean complete;
        byte messageId;
        BleMessageInProgress messageInProgress;
        Intrinsics.checkNotNullParameter((Object)senderAddr, (String)"senderAddr");
        Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
        Map clientMessageIdToMessageMap = TypeIntrinsics.asMutableMap(this.clientAddrToMessagesMap.get(senderAddr));
        if (clientMessageIdToMessageMap == null) {
            clientMessageIdToMessageMap = new LinkedHashMap();
            this.clientAddrToMessagesMap.put(senderAddr, clientMessageIdToMessageMap);
        }
        if ((messageInProgress = (BleMessageInProgress)clientMessageIdToMessageMap.get(messageId = BleMessage.Companion.findMessageId(packet))) == null) {
            messageInProgress = new BleMessageInProgress();
            Byte by = messageId;
            clientMessageIdToMessageMap.put(by, messageInProgress);
        }
        if (complete = messageInProgress.onPacketReceived(packet)) {
            clientMessageIdToMessageMap.remove(messageId);
            return messageInProgress.getMessage();
        }
        return null;
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0012\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\r"}, d2={"Lcom/ustadmobile/sharedse/network/BleMessageAssembler$BleMessageInProgress;", "", "()V", "lastUpdated", "", "message", "Lcom/ustadmobile/sharedse/network/BleMessage;", "getMessage", "()Lcom/ustadmobile/sharedse/network/BleMessage;", "onPacketReceived", "", "packet", "", "sharedse"})
    private static final class BleMessageInProgress {
        @NotNull
        private final BleMessage message = new BleMessage();
        private volatile long lastUpdated;

        @NotNull
        public final BleMessage getMessage() {
            return this.message;
        }

        public final boolean onPacketReceived(@NotNull byte[] packet) {
            Intrinsics.checkNotNullParameter((Object)packet, (String)"packet");
            this.lastUpdated = SystemTimeKt.getSystemTimeInMillis();
            return this.message.onPackageReceived(packet);
        }
    }
}

