/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.port.sharedse.impl.http;

import com.ustadmobile.core.util.UMFileUtil;
import com.ustadmobile.lib.util.RangeResponse;
import com.ustadmobile.lib.util.RangeUtilKt;
import com.ustadmobile.port.sharedse.impl.http.EmbeddedHTTPD;
import com.ustadmobile.port.sharedse.impl.http.RangeInputStream;
import fi.iki.elonen.NanoHTTPD;
import fi.iki.elonen.router.RouterNanoHTTPD;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPInputStream;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0006\b&\u0018\u0000 \u00032\u00020\u0001:\u0004\u0003\u0004\u0005\u0006B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0007"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/FileResponder;", "", "()V", "Companion", "FileSource", "IFileSource", "InflateFileSource", "sharedse_release"})
public abstract class FileResponder {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\bf\u0018\u00002\u00020\u0001R\u0014\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0005R\u0012\u0010\u0006\u001a\u00020\u0007X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\b\u0010\tR\u0012\u0010\n\u001a\u00020\u000bX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0012\u0010\u000e\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\u0011R\u0012\u0010\u0012\u001a\u00020\u000fX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0011R\u0014\u0010\u0014\u001a\u0004\u0018\u00010\u0003X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0005\u00a8\u0006\u0016"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$IFileSource;", "", "eTag", "", "getETag", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "lastModifiedTime", "", "getLastModifiedTime", "()J", "length", "getLength", "name", "getName", "sharedse_release"})
    public static interface IFileSource {
        public long getLength();

        public long getLastModifiedTime();

        @NotNull
        public InputStream getInputStream();

        @Nullable
        public String getName();

        public boolean getExists();

        @Nullable
        public String getETag();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004R\u0016\u0010\u0005\u001a\u0004\u0018\u00010\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0014\u0010\r\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00128VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0014R\u0014\u0010\u0017\u001a\u00020\u00068VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$FileSource;", "Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$IFileSource;", "src", "Ljava/io/File;", "(Ljava/io/File;)V", "eTag", "", "getETag", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "lastModifiedTime", "", "getLastModifiedTime", "()J", "length", "getLength", "name", "getName", "sharedse_release"})
    public static final class FileSource
    implements IFileSource {
        @NotNull
        private final File src;
        private final boolean exists;

        public FileSource(@NotNull File src) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.src = src;
            this.exists = this.src.exists();
        }

        @Override
        public long getLength() {
            return this.src.length();
        }

        @Override
        public long getLastModifiedTime() {
            return this.src.lastModified();
        }

        @Override
        @NotNull
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.src));
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.src.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"src.name");
            return string2;
        }

        @Override
        public boolean getExists() {
            return this.exists;
        }

        @Override
        @Nullable
        public String getETag() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\n\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u0014\u0010\u0013\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u00058VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0015R\u0014\u0010\u0018\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$InflateFileSource;", "Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$IFileSource;", "src", "Ljava/io/File;", "sizeInflated", "", "(Ljava/io/File;J)V", "eTag", "", "getETag", "()Ljava/lang/String;", "exists", "", "getExists", "()Z", "inputStream", "Ljava/io/InputStream;", "getInputStream", "()Ljava/io/InputStream;", "lastModifiedTime", "getLastModifiedTime", "()J", "length", "getLength", "name", "getName", "sharedse_release"})
    public static final class InflateFileSource
    implements IFileSource {
        @NotNull
        private final File src;
        private final long sizeInflated;
        private final boolean exists;

        public InflateFileSource(@NotNull File src, long sizeInflated) {
            Intrinsics.checkNotNullParameter((Object)src, (String)"src");
            this.src = src;
            this.sizeInflated = sizeInflated;
            this.exists = this.src.exists();
        }

        @Override
        public long getLength() {
            return this.sizeInflated;
        }

        @Override
        public long getLastModifiedTime() {
            return this.src.lastModified();
        }

        @Override
        @NotNull
        public InputStream getInputStream() {
            return new BufferedInputStream(new GZIPInputStream(new FileInputStream(this.src)));
        }

        @Override
        @NotNull
        public String getName() {
            String string2 = this.src.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"src.name");
            return string2;
        }

        @Override
        public boolean getExists() {
            return this.exists;
        }

        @Override
        @Nullable
        public String getETag() {
            return null;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J4\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0007J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\u000f"}, d2={"Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$Companion;", "", "()V", "newResponseFromFile", "Lfi/iki/elonen/NanoHTTPD$Response;", "method", "Lfi/iki/elonen/NanoHTTPD$Method;", "uriResource", "Lfi/iki/elonen/router/RouterNanoHTTPD$UriResource;", "session", "Lfi/iki/elonen/NanoHTTPD$IHTTPSession;", "file", "Lcom/ustadmobile/port/sharedse/impl/http/FileResponder$IFileSource;", "cacheControlHeader", "", "sharedse_release"})
    public static final class Companion {
        private Companion() {
        }

        @JvmOverloads
        @NotNull
        public final NanoHTTPD.Response newResponseFromFile(@NotNull NanoHTTPD.Method method, @NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull NanoHTTPD.IHTTPSession session, @NotNull IFileSource file, @Nullable String cacheControlHeader) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            boolean isHeadRequest = method == NanoHTTPD.Method.HEAD;
            try {
                String fileName;
                RangeResponse range = null;
                String ifNoneMatchHeader = null;
                InputStream retInputStream = null;
                if (!file.getExists()) {
                    NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_FOUND), (String)"text/plain", (String)(isHeadRequest ? null : "File not found"));
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026ll else \"File not found\")");
                    return response;
                }
                long totalLength = file.getLength();
                long lastModifiedTime = file.getLastModifiedTime();
                String etagNameInput = fileName = file.getName();
                String string2 = session.getUri();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"session.uri");
                String mimeType = EmbeddedHTTPD.Companion.getMimeType(string2);
                String string3 = file.getETag();
                if (string3 == null) {
                    string3 = Integer.toHexString((file.getName() + lastModifiedTime + "" + totalLength).hashCode());
                }
                String etag = string3;
                String string4 = fileName;
                Intrinsics.checkNotNull((Object)string4);
                String extension = UMFileUtil.getExtension((String)string4);
                ifNoneMatchHeader = (String)session.getHeaders().get("if-none-match");
                if (ifNoneMatchHeader != null && Intrinsics.areEqual((Object)ifNoneMatchHeader, (Object)etag)) {
                    NanoHTTPD.Response r = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.NOT_MODIFIED), (String)EmbeddedHTTPD.Companion.getMimeType(fileName), null);
                    r.addHeader("ETag", etag);
                    Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                    return r;
                }
                String rangeHeader = (String)session.getHeaders().get("content-range");
                range = rangeHeader != null ? RangeUtilKt.parseRangeRequestHeader((String)rangeHeader, (long)totalLength) : (RangeResponse)null;
                InputStream inputStream = retInputStream = isHeadRequest ? null : file.getInputStream();
                if (range != null && range.getStatusCode() == 206) {
                    InputStream inputStream2;
                    if (isHeadRequest) {
                        inputStream2 = null;
                    } else {
                        InputStream inputStream3 = retInputStream;
                        Intrinsics.checkNotNull((Object)inputStream3);
                        inputStream2 = new RangeInputStream(inputStream3, range.getFromByte(), range.getToByte());
                    }
                    retInputStream = inputStream2;
                    NanoHTTPD.Response r = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.PARTIAL_CONTENT), (String)mimeType, (InputStream)retInputStream, (long)range.getActualContentLength());
                    r.addHeader("ETag", etag);
                    Map $this$forEach$iv = range.getResponseHeaders();
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv.entrySet().iterator();
                    while (iterator.hasNext()) {
                        Map.Entry element$iv;
                        Map.Entry it = element$iv = iterator.next();
                        boolean bl = false;
                        r.addHeader((String)it.getKey(), (String)it.getValue());
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                    return r;
                }
                RangeResponse rangeResponse = range;
                boolean bl = rangeResponse != null ? rangeResponse.getStatusCode() == 416 : false;
                if (bl) {
                    NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.RANGE_NOT_SATISFIABLE), (String)"text/plain", (String)(isHeadRequest ? null : "Range request not satisfiable"));
                    Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026request not satisfiable\")");
                    return response;
                }
                retInputStream = isHeadRequest ? null : retInputStream;
                NanoHTTPD.Response r = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.OK), (String)mimeType, (InputStream)retInputStream, (long)totalLength);
                r.addHeader("ETag", etag);
                r.addHeader("Content-Length", String.valueOf(totalLength));
                r.addHeader("Connection", "close");
                if (cacheControlHeader != null) {
                    r.addHeader("Cache-Control", cacheControlHeader);
                }
                Intrinsics.checkNotNullExpressionValue((Object)r, (String)"r");
                return r;
            }
            catch (IOException e) {
                e.printStackTrace();
                NanoHTTPD.Response response = NanoHTTPD.newFixedLengthResponse((NanoHTTPD.Response.IStatus)((NanoHTTPD.Response.IStatus)NanoHTTPD.Response.Status.INTERNAL_ERROR), (String)"text/plain", isHeadRequest ? null : "Internal exception: " + e);
                Intrinsics.checkNotNullExpressionValue((Object)response, (String)"newFixedLengthResponse(N\u2026\"Internal exception: $e\")");
                return response;
            }
        }

        public static /* synthetic */ NanoHTTPD.Response newResponseFromFile$default(Companion companion, NanoHTTPD.Method method, RouterNanoHTTPD.UriResource uriResource, NanoHTTPD.IHTTPSession iHTTPSession, IFileSource iFileSource, String string2, int n, Object object) {
            if ((n & 0x10) != 0) {
                string2 = "cache, max-age=86400";
            }
            return companion.newResponseFromFile(method, uriResource, iHTTPSession, iFileSource, string2);
        }

        @NotNull
        public final NanoHTTPD.Response newResponseFromFile(@NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull NanoHTTPD.IHTTPSession session, @NotNull IFileSource file) {
            Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return com.ustadmobile.port.sharedse.impl.http.FileResponder$Companion.newResponseFromFile$default(this, NanoHTTPD.Method.GET, uriResource, session, file, null, 16, null);
        }

        @JvmOverloads
        @NotNull
        public final NanoHTTPD.Response newResponseFromFile(@NotNull NanoHTTPD.Method method, @NotNull RouterNanoHTTPD.UriResource uriResource, @NotNull NanoHTTPD.IHTTPSession session, @NotNull IFileSource file) {
            Intrinsics.checkNotNullParameter((Object)method, (String)"method");
            Intrinsics.checkNotNullParameter((Object)uriResource, (String)"uriResource");
            Intrinsics.checkNotNullParameter((Object)session, (String)"session");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            return com.ustadmobile.port.sharedse.impl.http.FileResponder$Companion.newResponseFromFile$default(this, method, uriResource, session, file, null, 16, null);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

