/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.serializer.cbor;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import com.webauthn4j.converter.AuthenticatorDataConverter;
import com.webauthn4j.converter.util.ObjectConverter;
import com.webauthn4j.data.attestation.authenticator.AuthenticatorData;
import com.webauthn4j.data.extension.authenticator.ExtensionAuthenticatorInput;
import com.webauthn4j.util.AssertUtil;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public class AuthenticatorDataSerializer
extends StdSerializer<AuthenticatorData<? extends ExtensionAuthenticatorInput>> {
    private final ObjectConverter objectConverter;

    public AuthenticatorDataSerializer(ObjectConverter objectConverter) {
        super(AuthenticatorData.class, false);
        AssertUtil.notNull(objectConverter, "objectConverter must not be null");
        this.objectConverter = objectConverter;
    }

    @Override
    public void serialize(@NotNull AuthenticatorData<? extends ExtensionAuthenticatorInput> value, @NotNull JsonGenerator gen, @NotNull SerializerProvider provider) throws IOException {
        gen.writeBinary(new AuthenticatorDataConverter(this.objectConverter).convert(value));
    }
}

