/*
 * Decompiled with CFR 0.152.
 */
package io.netty.channel.socket.nio;

import io.netty.channel.ChannelException;
import io.netty.channel.ChannelOption;
import java.io.IOException;
import java.net.SocketOption;
import java.net.StandardSocketOptions;
import java.nio.channels.Channel;
import java.nio.channels.NetworkChannel;
import java.nio.channels.ServerSocketChannel;
import java.util.ArrayList;
import java.util.Set;

public final class NioChannelOption<T>
extends ChannelOption<T> {
    private final SocketOption<T> option;

    private NioChannelOption(SocketOption<T> option2) {
        super(option2.name());
        this.option = option2;
    }

    public static <T> ChannelOption<T> of(SocketOption<T> option2) {
        return new NioChannelOption<T>(option2);
    }

    static <T> boolean setOption(Channel jdkChannel, NioChannelOption<T> option2, T value) {
        NetworkChannel channel2 = (NetworkChannel)jdkChannel;
        if (!channel2.supportedOptions().contains(option2.option)) {
            return false;
        }
        if (channel2 instanceof ServerSocketChannel && option2.option == StandardSocketOptions.IP_TOS) {
            return false;
        }
        try {
            channel2.setOption(option2.option, value);
            return true;
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static <T> T getOption(Channel jdkChannel, NioChannelOption<T> option2) {
        NetworkChannel channel2 = (NetworkChannel)jdkChannel;
        if (!channel2.supportedOptions().contains(option2.option)) {
            return null;
        }
        if (channel2 instanceof ServerSocketChannel && option2.option == StandardSocketOptions.IP_TOS) {
            return null;
        }
        try {
            return channel2.getOption(option2.option);
        }
        catch (IOException e) {
            throw new ChannelException(e);
        }
    }

    static ChannelOption<?>[] getOptions(Channel jdkChannel) {
        NetworkChannel channel2 = (NetworkChannel)jdkChannel;
        Set<SocketOption<?>> supportedOpts = channel2.supportedOptions();
        if (channel2 instanceof ServerSocketChannel) {
            ArrayList extraOpts = new ArrayList(supportedOpts.size());
            for (SocketOption<?> opt : supportedOpts) {
                if (opt == StandardSocketOptions.IP_TOS) continue;
                extraOpts.add(new NioChannelOption(opt));
            }
            return extraOpts.toArray(new ChannelOption[0]);
        }
        ChannelOption[] extraOpts = new ChannelOption[supportedOpts.size()];
        int i2 = 0;
        for (SocketOption<?> opt : supportedOpts) {
            extraOpts[i2++] = new NioChannelOption(opt);
        }
        return extraOpts;
    }
}

