/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.verifier.attestation.statement.tpm;

import com.webauthn4j.verifier.attestation.statement.tpm.TPMDeviceProperty;
import com.webauthn4j.verifier.attestation.statement.tpm.TPMDevicePropertyDecoder;
import com.webauthn4j.verifier.exception.BadAttestationStatementException;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.naming.InvalidNameException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import org.apache.kerby.asn1.type.Asn1Utf8String;

public class DefaultTPMDevicePropertyDecoder
implements TPMDevicePropertyDecoder {
    @Override
    public TPMDeviceProperty decode(String subjectAlternativeName) throws BadAttestationStatementException {
        try {
            Map<String, Object> map = DefaultTPMDevicePropertyDecoder.parseSubjectAlternativeName(subjectAlternativeName);
            byte[] manufacturerAttr = (byte[])map.get("2.23.133.2.1");
            byte[] partNumberAttr = (byte[])map.get("2.23.133.2.2");
            byte[] firmwareVersionAttr = (byte[])map.get("2.23.133.2.3");
            String manufacturer = DefaultTPMDevicePropertyDecoder.decodeAttr(manufacturerAttr);
            String partNumber = DefaultTPMDevicePropertyDecoder.decodeAttr(partNumberAttr);
            String firmwareVersion = DefaultTPMDevicePropertyDecoder.decodeAttr(firmwareVersionAttr);
            return new TPMDeviceProperty(manufacturer, partNumber, firmwareVersion);
        }
        catch (IOException e) {
            throw new BadAttestationStatementException("The Subject Alternative Name extension of attestation certificate does not contain a TPM device property", e);
        }
    }

    public static String decodeAttr(byte[] attr) throws IOException {
        if (attr == null) {
            return null;
        }
        Asn1Utf8String attrAsn1Utf8String = new Asn1Utf8String();
        attrAsn1Utf8String.decode(attr);
        return (String)attrAsn1Utf8String.getValue();
    }

    private static Map<String, Object> parseSubjectAlternativeName(String subjectAlternativeName) {
        LdapName subjectDN;
        try {
            subjectDN = new LdapName(subjectAlternativeName);
        }
        catch (InvalidNameException e) {
            throw new IllegalArgumentException(e);
        }
        return subjectDN.getRdns().stream().flatMap(rdn -> DefaultTPMDevicePropertyDecoder.convertRdnToMap(rdn).entrySet().stream()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private static Map<String, Object> convertRdnToMap(Rdn rdn) {
        try {
            HashMap<String, Object> map = new HashMap<String, Object>();
            Attributes attributes = rdn.toAttributes();
            NamingEnumeration<String> ids = rdn.toAttributes().getIDs();
            while (ids.hasMore()) {
                String id = ids.next();
                map.put(id, attributes.get(id).get());
            }
            return map;
        }
        catch (NamingException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

