/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.annotation;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.annotation.JsonNodeAnnotation;
import com.networknt.schema.serialization.JsonMapperFactory;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class JsonNodeAnnotations {
    private final Map<JsonNodePath, List<JsonNodeAnnotation>> values = new LinkedHashMap<JsonNodePath, List<JsonNodeAnnotation>>();

    public Map<JsonNodePath, List<JsonNodeAnnotation>> asMap() {
        return this.values;
    }

    public void put(JsonNodeAnnotation annotation) {
        this.values.computeIfAbsent(annotation.getInstanceLocation(), k -> new ArrayList()).add(annotation);
    }

    public String toString() {
        return Formatter.format(this.values);
    }

    public static class Formatter {
        public static String format(Map<JsonNodePath, List<JsonNodeAnnotation>> annotations) {
            LinkedHashMap<String, Map> results = new LinkedHashMap<String, Map>();
            for (List<JsonNodeAnnotation> list2 : annotations.values()) {
                for (JsonNodeAnnotation annotation : list2) {
                    String keyword = annotation.getKeyword();
                    String instancePath = annotation.getInstanceLocation().toString();
                    String evaluationPath = annotation.getEvaluationPath().toString();
                    Map values2 = results.computeIfAbsent(instancePath, key -> new LinkedHashMap()).computeIfAbsent(keyword, key -> new LinkedHashMap());
                    values2.put(evaluationPath, annotation.getValue());
                }
            }
            try {
                return JsonMapperFactory.getInstance().writerWithDefaultPrettyPrinter().writeValueAsString(results);
            }
            catch (JsonProcessingException e) {
                return "";
            }
        }
    }
}

