/*
 * Decompiled with CFR 0.152.
 */
package androidx.collection;

import androidx.annotation.IntRange;
import androidx.collection.IntList;
import androidx.collection.internal.RuntimeHelpersKt;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0011\u0018\u00002\u00020\u0001B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u0018\u0010\b\u001a\u00020\u000b2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003J\u0011\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\bJ\u0018\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u0001J\u0018\u0010\r\u001a\u00020\t2\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fJ\u0011\u0010\r\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\bJ\u0006\u0010\u0010\u001a\u00020\u000bJ\u000e\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0005\u001a\u00020\u0003J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\u0002J\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0003H\u0086\nJ\u0011\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\u0002J\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u0001H\u0086\nJ\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\n\u001a\u00020\u0003H\u0086\nJ\u0011\u0010\u0013\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0086\nJ\u000e\u0010\u0014\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u0015\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u0010\u0010\u0016\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\u0003J\u001a\u0010\u0017\u001a\u00020\u000b2\b\b\u0001\u0010\u0018\u001a\u00020\u00032\b\b\u0001\u0010\u0019\u001a\u00020\u0003J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u0001J\u000e\u0010\u001a\u001a\u00020\t2\u0006\u0010\u000e\u001a\u00020\u000fJ\u001b\u0010\u001b\u001a\u00020\u00032\b\b\u0001\u0010\f\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0003H\u0086\u0002J\u0006\u0010\u001c\u001a\u00020\u000bJ\u0006\u0010\u001d\u001a\u00020\u000bJ\u0010\u0010\u001e\u001a\u00020\u000b2\b\b\u0002\u0010\u001f\u001a\u00020\u0003R\u0012\u0010\u0005\u001a\u00020\u00038\u00c6\u0002\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007\u00a8\u0006 "}, d2={"Landroidx/collection/MutableIntList;", "Landroidx/collection/IntList;", "initialCapacity", "", "(I)V", "capacity", "getCapacity", "()I", "add", "", "element", "", "index", "addAll", "elements", "", "clear", "ensureCapacity", "minusAssign", "plusAssign", "remove", "removeAll", "removeAt", "removeRange", "start", "end", "retainAll", "set", "sort", "sortDescending", "trim", "minCapacity", "collection"})
@SourceDebugExtension(value={"SMAP\nIntList.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n+ 2 IntList.kt\nandroidx/collection/IntList\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,968:1\n556#1:970\n363#2:969\n70#2:971\n237#2,6:974\n70#2:980\n70#2:981\n70#2:988\n13330#3,2:972\n1663#3,6:982\n*S KotlinDebug\n*F\n+ 1 IntList.kt\nandroidx/collection/MutableIntList\n*L\n692#1:970\n628#1:969\n749#1:971\n762#1:974,6\n776#1:980\n822#1:981\n839#1:988\n757#1:972,2\n824#1:982,6\n*E\n"})
public final class MutableIntList
extends IntList {
    public MutableIntList(int initialCapacity) {
        super(initialCapacity, null);
    }

    public /* synthetic */ MutableIntList(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 1) != 0) {
            n = 16;
        }
        this(n);
    }

    public final int getCapacity() {
        boolean $i$f$getCapacity = false;
        return this.content.length;
    }

    public final boolean add(int element) {
        this.ensureCapacity(this._size + 1);
        this.content[this._size] = element;
        int n = this._size;
        this._size = n + 1;
        return true;
    }

    public final void add(@IntRange(from=0L) int index2, int element) {
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        this.ensureCapacity(this._size + 1);
        int[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + 1, index2, this._size);
        }
        content2[index2] = element;
        int n = this._size;
        this._size = n + 1;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        if (elements.length == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements.length);
        int[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements.length, index2, this._size);
        }
        ArraysKt.copyInto$default(elements, content2, index2, 0, 0, 12, null);
        this._size += elements.length;
        return true;
    }

    public final boolean addAll(@IntRange(from=0L) int index2, @NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        if (!(0 <= index2 ? index2 <= this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("");
        }
        IntList this_$iv = elements;
        boolean $i$f$isEmpty = false;
        if (this_$iv._size == 0) {
            return false;
        }
        this.ensureCapacity(this._size + elements._size);
        int[] content2 = this.content;
        if (index2 != this._size) {
            ArraysKt.copyInto(content2, content2, index2 + elements._size, index2, this._size);
        }
        ArraysKt.copyInto(elements.content, content2, index2, 0, elements._size);
        this._size += elements._size;
        return true;
    }

    public final boolean addAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$addAll = false;
        return this.addAll(this._size, elements);
    }

    public final boolean addAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$addAll = false;
        return this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$plusAssign = false;
        this.addAll(this._size, elements);
    }

    public final void plusAssign(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        boolean $i$f$plusAssign = false;
        this.addAll(this._size, elements);
    }

    public final void clear() {
        this._size = 0;
    }

    public final void trim(int minCapacity) {
        int minSize = Math.max(minCapacity, this._size);
        MutableIntList this_$iv = this;
        boolean $i$f$getCapacity = false;
        if (this_$iv.content.length > minSize) {
            int[] nArray = Arrays.copyOf(this.content, minSize);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.content = nArray;
        }
    }

    public static /* synthetic */ void trim$default(MutableIntList mutableIntList, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = mutableIntList._size;
        }
        mutableIntList.trim(n);
    }

    public final void ensureCapacity(int capacity) {
        int[] oldContent = this.content;
        if (oldContent.length < capacity) {
            int newSize = Math.max(capacity, oldContent.length * 3 / 2);
            int[] nArray = Arrays.copyOf(oldContent, newSize);
            Intrinsics.checkNotNullExpressionValue(nArray, "copyOf(...)");
            this.content = nArray;
        }
    }

    public final void plusAssign(int element) {
        boolean $i$f$plusAssign = false;
        this.add(element);
    }

    public final void minusAssign(int element) {
        boolean $i$f$minusAssign = false;
        this.remove(element);
    }

    public final boolean remove(int element) {
        int index2 = this.indexOf(element);
        if (index2 >= 0) {
            this.removeAt(index2);
            return true;
        }
        return false;
    }

    public final boolean removeAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int n = elements.length;
        for (int i2 = 0; i2 < n; ++i2) {
            this.remove(elements[i2]);
        }
        return initialSize != this._size;
    }

    public final boolean removeAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int i2 = 0;
        IntList this_$iv = elements;
        boolean $i$f$getLastIndex = false;
        int n = this_$iv._size - 1;
        if (i2 <= n) {
            while (true) {
                this.remove(elements.get(i2));
                if (i2 == n) break;
                ++i2;
            }
        }
        return initialSize != this._size;
    }

    public final void minusAssign(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int[] $this$forEach$iv = elements;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int j = 0; j < n; ++j) {
            int element$iv;
            int element = element$iv = $this$forEach$iv[j];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final void minusAssign(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        IntList this_$iv = elements;
        boolean $i$f$forEach = false;
        int[] content$iv = this_$iv.content;
        int n = this_$iv._size;
        for (int i$iv = 0; i$iv < n; ++i$iv) {
            int element = content$iv[i$iv];
            boolean bl = false;
            this.remove(element);
        }
    }

    public final int removeAt(@IntRange(from=0L) int index2) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        int[] content2 = this.content;
        int item2 = content2[index2];
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        if (index2 != this_$iv._size - 1) {
            ArraysKt.copyInto(content2, content2, index2, index2 + 1, this._size);
        }
        int n = this._size;
        this._size = n + -1;
        return item2;
    }

    public final void removeRange(@IntRange(from=0L) int start2, @IntRange(from=0L) int end) {
        block7: {
            block6: {
                boolean bl = 0 <= start2 ? start2 <= this._size : false;
                if (!bl) break block6;
                if (0 <= end ? end <= this._size : false) break block7;
            }
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        if (end < start2) {
            RuntimeHelpersKt.throwIllegalArgumentException("The end index must be < start index");
        }
        if (end != start2) {
            if (end < this._size) {
                ArraysKt.copyInto(this.content, this.content, start2, end, this._size);
            }
            this._size -= end - start2;
        }
    }

    public final boolean retainAll(@NotNull int[] elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int[] content2 = this.content;
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv._size - 1; -1 < i2; --i2) {
            int n;
            block2: {
                int item2 = content2[i2];
                int[] $this$indexOfFirst$iv = elements;
                boolean $i$f$indexOfFirst = false;
                int n2 = $this$indexOfFirst$iv.length;
                for (int index$iv = 0; index$iv < n2; ++index$iv) {
                    int it = $this$indexOfFirst$iv[index$iv];
                    boolean bl = false;
                    if (!(it == item2)) continue;
                    n = index$iv;
                    break block2;
                }
                n = -1;
            }
            if (n >= 0) continue;
            this.removeAt(i2);
        }
        return initialSize != this._size;
    }

    public final boolean retainAll(@NotNull IntList elements) {
        Intrinsics.checkNotNullParameter(elements, "elements");
        int initialSize = this._size;
        int[] content2 = this.content;
        IntList this_$iv = this;
        boolean $i$f$getLastIndex = false;
        for (int i2 = this_$iv._size - 1; -1 < i2; --i2) {
            int item2 = content2[i2];
            if (elements.contains(item2)) continue;
            this.removeAt(i2);
        }
        return initialSize != this._size;
    }

    public final int set(@IntRange(from=0L) int index2, int element) {
        if (!(0 <= index2 ? index2 < this._size : false)) {
            RuntimeHelpersKt.throwIndexOutOfBoundsException("Index must be between 0 and size");
        }
        int[] content2 = this.content;
        int old = content2[index2];
        content2[index2] = element;
        return old;
    }

    public final void sort() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sort(this.content, 0, this._size);
    }

    public final void sortDescending() {
        if (this._size == 0) {
            return;
        }
        ArraysKt.sortDescending(this.content, 0, this._size);
    }

    public MutableIntList() {
        this(0, 1, null);
    }
}

