/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractJavaFloatingPointBitsFromByteArray;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastDoubleMath;
import java.nio.charset.StandardCharsets;

final class JavaDoubleBitsFromByteArray
extends AbstractJavaFloatingPointBitsFromByteArray {
    @Override
    long nan() {
        return Double.doubleToRawLongBits(Double.NaN);
    }

    @Override
    long negativeInfinity() {
        return Double.doubleToRawLongBits(Double.NEGATIVE_INFINITY);
    }

    @Override
    long positiveInfinity() {
        return Double.doubleToRawLongBits(Double.POSITIVE_INFINITY);
    }

    @Override
    long valueOfFloatLiteral(byte[] str2, int startIndex, int endIndex, boolean isNegative2, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand) {
        double d = FastDoubleMath.tryDecFloatToDoubleTruncated(isNegative2, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return Double.doubleToRawLongBits(Double.isNaN(d) ? Double.parseDouble(new String(str2, startIndex, endIndex - startIndex, StandardCharsets.ISO_8859_1)) : d);
    }

    @Override
    long valueOfHexLiteral(byte[] str2, int startIndex, int endIndex, boolean isNegative2, long significand, int exponent, boolean isSignificandTruncated, int exponentOfTruncatedSignificand) {
        double d = FastDoubleMath.tryHexFloatToDoubleTruncated(isNegative2, significand, exponent, isSignificandTruncated, exponentOfTruncatedSignificand);
        return Double.doubleToRawLongBits(Double.isNaN(d) ? Double.parseDouble(new String(str2, startIndex, endIndex - startIndex, StandardCharsets.ISO_8859_1)) : d);
    }
}

