/*
 * Decompiled with CFR 0.152.
 */
package com.ustadmobile.libcache.distributed.model;

import com.ustadmobile.libcache.distributed.model.DistributedCachePacket;
import com.ustadmobile.libcache.distributed.model.DistributedCacheWhatWithIdAndPayload;
import com.ustadmobile.libcache.util.ByteBufferExtKt;
import java.nio.ByteBuffer;
import java.util.Arrays;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\t\b\u0086\b\u0018\u0000 \u001f2\u00020\u00012\u00020\u0002:\u0001\u001fB'\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\n\u0010\u000bJ\b\u0010\u0013\u001a\u00020\tH\u0016J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0017H\u0096\u0002J\b\u0010\u0018\u001a\u00020\u0004H\u0016J\t\u0010\u0019\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0004H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\tH\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00042\b\b\u0002\u0010\u0005\u001a\u00020\u00042\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\t\u0010\u001e\u001a\u00020\u0007H\u00d6\u0001R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u0005\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\rR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006 "}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePacket;", "Lcom/ustadmobile/libcache/distributed/model/DistributedCacheWhatWithIdAndPayload;", "id", "", "httpPort", "deviceName", "", "payload", "", "<init>", "(IILjava/lang/String;[B)V", "getId", "()I", "getHttpPort", "getDeviceName", "()Ljava/lang/String;", "getPayload", "()[B", "toBytes", "equals", "", "other", "", "hashCode", "component1", "component2", "component3", "component4", "copy", "toString", "Companion", "respect-lib-cache_debug"})
public final class DistributedCachePing
extends DistributedCachePacket
implements DistributedCacheWhatWithIdAndPayload {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final int id;
    private final int httpPort;
    @NotNull
    private final String deviceName;
    @NotNull
    private final byte[] payload;
    public static final int OVERHEAD_SIZE = 13;

    public DistributedCachePing(int id, int httpPort, @NotNull String deviceName, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        super(null);
        this.id = id;
        this.httpPort = httpPort;
        this.deviceName = deviceName;
        this.payload = payload;
    }

    @Override
    public int getId() {
        return this.id;
    }

    @Override
    public int getHttpPort() {
        return this.httpPort;
    }

    @NotNull
    public final String getDeviceName() {
        return this.deviceName;
    }

    @Override
    @NotNull
    public byte[] getPayload() {
        return this.payload;
    }

    @Override
    @NotNull
    public byte[] toBytes() {
        int n = 13 + this.getPayload().length;
        String string = this.deviceName;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        int size = n + byArray.length;
        ByteBuffer byteBuffer = ByteBuffer.allocate(size);
        byteBuffer.put((byte)2);
        byteBuffer.putInt(this.getHttpPort());
        byteBuffer.putInt(this.getId());
        Intrinsics.checkNotNull((Object)byteBuffer);
        ByteBufferExtKt.writeShortString(byteBuffer, this.deviceName);
        ByteBufferExtKt.writePayload(byteBuffer, this.getPayload());
        byte[] byArray2 = byteBuffer.array();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"array(...)");
        return byArray2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof DistributedCachePing)) {
            return false;
        }
        if (this.getId() != ((DistributedCachePing)other).getId()) {
            return false;
        }
        if (this.getHttpPort() != ((DistributedCachePing)other).getHttpPort()) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.deviceName, (Object)((DistributedCachePing)other).deviceName)) {
            return false;
        }
        return Arrays.equals(this.getPayload(), ((DistributedCachePing)other).getPayload());
    }

    public int hashCode() {
        int result = this.getId();
        result = 31 * result + this.getHttpPort();
        result = 31 * result + this.deviceName.hashCode();
        result = 31 * result + Arrays.hashCode(this.getPayload());
        return result;
    }

    public final int component1() {
        return this.id;
    }

    public final int component2() {
        return this.httpPort;
    }

    @NotNull
    public final String component3() {
        return this.deviceName;
    }

    @NotNull
    public final byte[] component4() {
        return this.payload;
    }

    @NotNull
    public final DistributedCachePing copy(int id, int httpPort, @NotNull String deviceName, @NotNull byte[] payload) {
        Intrinsics.checkNotNullParameter((Object)deviceName, (String)"deviceName");
        Intrinsics.checkNotNullParameter((Object)payload, (String)"payload");
        return new DistributedCachePing(id, httpPort, deviceName, payload);
    }

    public static /* synthetic */ DistributedCachePing copy$default(DistributedCachePing distributedCachePing, int n, int n2, String string, byte[] byArray, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = distributedCachePing.id;
        }
        if ((n3 & 2) != 0) {
            n2 = distributedCachePing.httpPort;
        }
        if ((n3 & 4) != 0) {
            string = distributedCachePing.deviceName;
        }
        if ((n3 & 8) != 0) {
            byArray = distributedCachePing.payload;
        }
        return distributedCachePing.copy(n, n2, string, byArray);
    }

    @NotNull
    public String toString() {
        return "DistributedCachePing(id=" + this.id + ", httpPort=" + this.httpPort + ", deviceName=" + this.deviceName + ", payload=" + Arrays.toString(this.payload) + ")";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\u0006\u001a\u00020\u0007*\u00020\b2\u0006\u0010\t\u001a\u00020\u0005R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing$Companion;", "", "<init>", "()V", "OVERHEAD_SIZE", "", "readDistributedCachePing", "Lcom/ustadmobile/libcache/distributed/model/DistributedCachePing;", "Ljava/nio/ByteBuffer;", "httpPort", "respect-lib-cache_debug"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final DistributedCachePing readDistributedCachePing(@NotNull ByteBuffer $this$readDistributedCachePing, int httpPort) {
            Intrinsics.checkNotNullParameter((Object)$this$readDistributedCachePing, (String)"<this>");
            int id = $this$readDistributedCachePing.getInt();
            String deviceName = ByteBufferExtKt.readShortString($this$readDistributedCachePing);
            byte[] payload = ByteBufferExtKt.readPayload($this$readDistributedCachePing);
            return new DistributedCachePing(id, httpPort, deviceName, payload);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

