/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.skiko.swing;

import java.awt.Graphics2D;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.skia.BackendRenderTarget;
import org.jetbrains.skia.Canvas;
import org.jetbrains.skia.ColorSpace;
import org.jetbrains.skia.DirectContext;
import org.jetbrains.skia.PixelGeometry;
import org.jetbrains.skia.Surface;
import org.jetbrains.skia.SurfaceColorFormat;
import org.jetbrains.skia.SurfaceOrigin;
import org.jetbrains.skia.SurfaceProps;
import org.jetbrains.skiko.CloseScope;
import org.jetbrains.skiko.GraphicsApi;
import org.jetbrains.skiko.Library;
import org.jetbrains.skiko.RenderException;
import org.jetbrains.skiko.ResourceUtilsKt;
import org.jetbrains.skiko.SkiaLayerAnalytics;
import org.jetbrains.skiko.SkikoRenderDelegate;
import org.jetbrains.skiko.graphicapi.InternalDirectXApi;
import org.jetbrains.skiko.swing.SoftwareSwingPainter;
import org.jetbrains.skiko.swing.SwingLayerProperties;
import org.jetbrains.skiko.swing.SwingPainter;
import org.jetbrains.skiko.swing.SwingRedrawerBase;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0004\b\u0000\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\u0014\u001a\u00020\u0015H\u0016J\u0016\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aJ\b\u0010\u001b\u001a\u00020\u001cH\u0002J(\u0010\u001d\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\u0006\u0010!\u001a\u00020\nH\u0014R\u0012\u0010\t\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0010\u001a\u00060\nj\u0002`\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer;", "Lorg/jetbrains/skiko/swing/SwingRedrawerBase;", "swingLayerProperties", "Lorg/jetbrains/skiko/swing/SwingLayerProperties;", "renderDelegate", "Lorg/jetbrains/skiko/SkikoRenderDelegate;", "analytics", "Lorg/jetbrains/skiko/SkiaLayerAnalytics;", "(Lorg/jetbrains/skiko/swing/SwingLayerProperties;Lorg/jetbrains/skiko/SkikoRenderDelegate;Lorg/jetbrains/skiko/SkiaLayerAnalytics;)V", "adapter", "", "Lorg/jetbrains/skia/impl/NativePointer;", "bytesToDraw", "", "context", "Lorg/jetbrains/skia/DirectContext;", "device", "painter", "Lorg/jetbrains/skiko/swing/SwingPainter;", "texturePtr", "dispose", "", "flush", "surface", "Lorg/jetbrains/skia/Surface;", "g", "Ljava/awt/Graphics2D;", "makeRenderTarget", "Lorg/jetbrains/skia/BackendRenderTarget;", "onRender", "width", "", "height", "nanoTime", "Companion", "skiko"})
public final class Direct3DSwingRedrawer
extends SwingRedrawerBase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SkikoRenderDelegate renderDelegate;
    private final long adapter;
    private final long device;
    @NotNull
    private final SwingPainter painter;
    @NotNull
    private final DirectContext context;
    private long texturePtr;
    @NotNull
    private byte[] bytesToDraw;

    public Direct3DSwingRedrawer(@NotNull SwingLayerProperties swingLayerProperties2, @NotNull SkikoRenderDelegate renderDelegate, @NotNull SkiaLayerAnalytics analytics) {
        long l;
        Intrinsics.checkNotNullParameter((Object)swingLayerProperties2, (String)"swingLayerProperties");
        Intrinsics.checkNotNullParameter((Object)renderDelegate, (String)"renderDelegate");
        Intrinsics.checkNotNullParameter((Object)analytics, (String)"analytics");
        super(swingLayerProperties2, analytics, GraphicsApi.DIRECT3D);
        this.renderDelegate = renderDelegate;
        long l2 = l = InternalDirectXApi.INSTANCE.chooseAdapter(swingLayerProperties2.getAdapterPriority());
        Direct3DSwingRedrawer direct3DSwingRedrawer = this;
        boolean bl = false;
        this.onDeviceChosen("DirectX12");
        direct3DSwingRedrawer.adapter = l;
        this.device = InternalDirectXApi.INSTANCE.createDirectXOffscreenDevice(this.adapter);
        this.painter = new SoftwareSwingPainter(swingLayerProperties2);
        if (this.device == 0L) {
            throw new RenderException("Failed to create DirectX12 device.", null, 2, null);
        }
        this.context = new DirectContext(InternalDirectXApi.INSTANCE.makeDirectXContext(this.device));
        this.bytesToDraw = new byte[0];
        this.onContextInit();
    }

    @Override
    public void dispose() {
        this.bytesToDraw = new byte[0];
        this.context.close();
        InternalDirectXApi.INSTANCE.disposeDirectXTexture(this.texturePtr);
        InternalDirectXApi.INSTANCE.disposeDevice(this.device);
        this.painter.dispose();
        super.dispose();
    }

    @Override
    protected void onRender(@NotNull Graphics2D g, int width2, int height2, long nanoTime) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        ResourceUtilsKt.autoCloseScope((Function1<? super CloseScope, Unit>)((Function1)new Function1<CloseScope, Unit>(width2, this, height2, nanoTime, g){
            final /* synthetic */ int $width;
            final /* synthetic */ Direct3DSwingRedrawer this$0;
            final /* synthetic */ int $height;
            final /* synthetic */ long $nanoTime;
            final /* synthetic */ Graphics2D $g;
            {
                this.$width = $width;
                this.this$0 = $receiver;
                this.$height = $height;
                this.$nanoTime = $nanoTime;
                this.$g = $g;
                super(1);
            }

            public final void invoke(@NotNull CloseScope $this$autoCloseScope) {
                Surface surface;
                Intrinsics.checkNotNullParameter((Object)$this$autoCloseScope, (String)"$this$autoCloseScope");
                int alignedWidth = InternalDirectXApi.INSTANCE.alignedTextureWidth(this.$width);
                Direct3DSwingRedrawer.access$setTexturePtr$p(this.this$0, InternalDirectXApi.INSTANCE.makeDirectXTexture(Direct3DSwingRedrawer.access$getDevice$p(this.this$0), Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0), alignedWidth, this.$height));
                if (Direct3DSwingRedrawer.access$getTexturePtr$p(this.this$0) == 0L) {
                    throw new RenderException("Can't allocate DirectX resources", null, 2, null);
                }
                BackendRenderTarget renderTarget = (BackendRenderTarget)$this$autoCloseScope.autoClose((AutoCloseable)Direct3DSwingRedrawer.access$makeRenderTarget(this.this$0));
                Surface surface2 = Surface.Companion.makeFromBackendRenderTarget(Direct3DSwingRedrawer.access$getContext$p(this.this$0), renderTarget, SurfaceOrigin.TOP_LEFT, SurfaceColorFormat.BGRA_8888, ColorSpace.Companion.getSRGB(), new SurfaceProps(false, PixelGeometry.UNKNOWN, 1, null));
                if (surface2 == null || (surface = (Surface)$this$autoCloseScope.autoClose((AutoCloseable)surface2)) == null) {
                    throw new RenderException("Cannot create surface", null, 2, null);
                }
                Surface surface3 = surface;
                Canvas canvas = surface3.getCanvas();
                canvas.clear(0);
                Direct3DSwingRedrawer.access$getRenderDelegate$p(this.this$0).onRender(canvas, this.$width, this.$height, this.$nanoTime);
                this.this$0.flush(surface3, this.$g);
            }
        }));
    }

    public final void flush(@NotNull Surface surface, @NotNull Graphics2D g) {
        Intrinsics.checkNotNullParameter((Object)surface, (String)"surface");
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        surface.flushAndSubmit(false);
        InternalDirectXApi.INSTANCE.waitForCompletion(this.device, this.texturePtr);
        this.painter.paint(g, surface, this.texturePtr);
    }

    private final BackendRenderTarget makeRenderTarget() {
        return new BackendRenderTarget(InternalDirectXApi.INSTANCE.makeDirectXRenderTargetOffScreen(this.texturePtr));
    }

    public static final /* synthetic */ void access$setTexturePtr$p(Direct3DSwingRedrawer $this, long l) {
        $this.texturePtr = l;
    }

    public static final /* synthetic */ long access$getDevice$p(Direct3DSwingRedrawer $this) {
        return $this.device;
    }

    public static final /* synthetic */ long access$getTexturePtr$p(Direct3DSwingRedrawer $this) {
        return $this.texturePtr;
    }

    public static final /* synthetic */ BackendRenderTarget access$makeRenderTarget(Direct3DSwingRedrawer $this) {
        return $this.makeRenderTarget();
    }

    public static final /* synthetic */ DirectContext access$getContext$p(Direct3DSwingRedrawer $this) {
        return $this.context;
    }

    public static final /* synthetic */ SkikoRenderDelegate access$getRenderDelegate$p(Direct3DSwingRedrawer $this) {
        return $this.renderDelegate;
    }

    static {
        Library.INSTANCE.load();
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0003"}, d2={"Lorg/jetbrains/skiko/swing/Direct3DSwingRedrawer$Companion;", "", "()V", "skiko"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

