/*
 * Decompiled with CFR 0.152.
 */
package io.sanghun.compose.video.sample;

import androidx.media3.common.C;
import androidx.media3.common.MediaItem;
import androidx.media3.common.MediaMetadata;
import io.sanghun.compose.video.uri.VideoPlayerMediaItem;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=2, xi=48, d1={"\u0000\u0016\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0086T\u00a2\u0006\u0002\n\u0000\"\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"MIME_TYPE_DASH", "", "MIME_TYPE_HLS", "MIME_TYPE_VIDEO_MP4", "samplePlayList", "", "Lio/sanghun/compose/video/uri/VideoPlayerMediaItem;", "getSamplePlayList", "()Ljava/util/List;", "sample_debug"})
public final class PlayListKt {
    @NotNull
    public static final String MIME_TYPE_DASH = "application/dash+xml";
    @NotNull
    public static final String MIME_TYPE_HLS = "application/x-mpegURL";
    @NotNull
    public static final String MIME_TYPE_VIDEO_MP4 = "video/mp4";
    @NotNull
    private static final List<VideoPlayerMediaItem> samplePlayList;

    @NotNull
    public static final List<VideoPlayerMediaItem> getSamplePlayList() {
        return samplePlayList;
    }

    static {
        Object[] objectArray = new VideoPlayerMediaItem[7];
        MediaMetadata mediaMetadata = new MediaMetadata.Builder().setTitle((CharSequence)"Clear DASH: Tears").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata, (String)"Builder().setTitle(\"Clear DASH: Tears\").build()");
        objectArray[0] = new VideoPlayerMediaItem.NetworkMediaItem("https://storage.googleapis.com/wvmedia/clear/h264/tears/tears.mpd", mediaMetadata, MIME_TYPE_DASH, null, 8, null);
        objectArray[1] = new VideoPlayerMediaItem.RawResourceMediaItem(2131492864, null, null, 6, null);
        MediaMetadata mediaMetadata2 = new MediaMetadata.Builder().setTitle((CharSequence)"Clear HLS: Angel one").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata2, (String)"Builder().setTitle(\"Clear HLS: Angel one\").build()");
        objectArray[2] = new VideoPlayerMediaItem.NetworkMediaItem("https://storage.googleapis.com/shaka-demo-assets/angel-one-hls/hls.m3u8", mediaMetadata2, MIME_TYPE_HLS, null, 8, null);
        MediaMetadata mediaMetadata3 = new MediaMetadata.Builder().setTitle((CharSequence)"Clear MP4: Dizzy").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata3, (String)"Builder().setTitle(\"Clear MP4: Dizzy\").build()");
        objectArray[3] = new VideoPlayerMediaItem.NetworkMediaItem("https://html5demos.com/assets/dizzy.mp4", mediaMetadata3, MIME_TYPE_VIDEO_MP4, null, 8, null);
        MediaMetadata mediaMetadata4 = new MediaMetadata.Builder().setTitle((CharSequence)"Widevine DASH cenc: Tears").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata4, (String)"Builder().setTitle(\"Wide\u2026ASH cenc: Tears\").build()");
        objectArray[4] = new VideoPlayerMediaItem.NetworkMediaItem("https://storage.googleapis.com/wvmedia/cenc/h264/tears/tears.mpd", mediaMetadata4, MIME_TYPE_DASH, new MediaItem.DrmConfiguration.Builder(C.WIDEVINE_UUID).setLicenseUri("https://proxy.uat.widevine.com/proxy?provider=widevine_test").build());
        MediaMetadata mediaMetadata5 = new MediaMetadata.Builder().setTitle((CharSequence)"Widevine DASH cbc1: Tears").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata5, (String)"Builder().setTitle(\"Wide\u2026ASH cbc1: Tears\").build()");
        objectArray[5] = new VideoPlayerMediaItem.NetworkMediaItem("https://storage.googleapis.com/wvmedia/cbc1/h264/tears/tears_aes_cbc1.mpd", mediaMetadata5, MIME_TYPE_DASH, new MediaItem.DrmConfiguration.Builder(C.WIDEVINE_UUID).setLicenseUri("https://proxy.uat.widevine.com/proxy?provider=widevine_test").build());
        MediaMetadata mediaMetadata6 = new MediaMetadata.Builder().setTitle((CharSequence)"Widevine DASH cbcs: Tears").build();
        Intrinsics.checkNotNullExpressionValue((Object)mediaMetadata6, (String)"Builder().setTitle(\"Wide\u2026ASH cbcs: Tears\").build()");
        objectArray[6] = new VideoPlayerMediaItem.NetworkMediaItem("https://storage.googleapis.com/wvmedia/cbcs/h264/tears/tears_aes_cbcs.mpd", mediaMetadata6, MIME_TYPE_DASH, new MediaItem.DrmConfiguration.Builder(C.WIDEVINE_UUID).setLicenseUri("https://proxy.uat.widevine.com/proxy?provider=widevine_test").build());
        samplePlayList = CollectionsKt.listOf((Object[])objectArray);
    }
}

