/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.BaseJsonValidator;
import com.networknt.schema.DiscriminatorContext;
import com.networknt.schema.ExecutionContext;
import com.networknt.schema.JsonNodePath;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonSchemaException;
import com.networknt.schema.JsonType;
import com.networknt.schema.JsonValidator;
import com.networknt.schema.MessageSourceValidationMessage;
import com.networknt.schema.SchemaLocation;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.TypeValidator;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.ValidationMessage;
import com.networknt.schema.ValidatorTypeCode;
import com.networknt.schema.utils.SetView;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnyOfValidator
extends BaseJsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(AnyOfValidator.class);
    private static final String DISCRIMINATOR_REMARK = "and the discriminator-selected candidate schema didn't pass validation";
    private final List<JsonSchema> schemas;
    private Boolean canShortCircuit = null;

    public AnyOfValidator(SchemaLocation schemaLocation, JsonNodePath evaluationPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaLocation, evaluationPath, schemaNode, parentSchema, ValidatorTypeCode.ANY_OF, validationContext);
        if (!schemaNode.isArray()) {
            JsonType nodeType = TypeFactory.getValueNodeType(schemaNode, this.validationContext.getConfig());
            throw new JsonSchemaException(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(schemaNode)).instanceLocation(schemaLocation.getFragment())).messageKey("type")).arguments(nodeType.toString(), "array")).build());
        }
        int size2 = schemaNode.size();
        this.schemas = new ArrayList<JsonSchema>(size2);
        for (int i2 = 0; i2 < size2; ++i2) {
            this.schemas.add(validationContext.newSchema(schemaLocation.append(i2), evaluationPath.append(i2), schemaNode.get(i2), parentSchema));
        }
    }

    @Override
    public Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation) {
        return this.validate(executionContext, node2, rootNode, instanceLocation, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected Set<ValidationMessage> validate(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean walk) {
        Set<ValidationMessage> set2;
        AnyOfValidator.debug(logger, executionContext, node2, rootNode, instanceLocation);
        if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
            executionContext.enterDiscriminatorContext(new DiscriminatorContext(), instanceLocation);
        }
        Set<ValidationMessage> allErrors = null;
        int numberOfValidSubSchemas = 0;
        try {
            boolean failFast = executionContext.isFailFast();
            try {
                executionContext.setFailFast(false);
                for (JsonSchema schema : this.schemas) {
                    DiscriminatorContext currentDiscriminatorContext;
                    Set<Object> errors = Collections.emptySet();
                    TypeValidator typeValidator = schema.getTypeValidator();
                    if (typeValidator != null && typeValidator.getSchemaType() != JsonType.UNION && !typeValidator.equalsToSchemaType(node2)) {
                        if (allErrors == null) {
                            allErrors = new SetView<ValidationMessage>();
                        }
                        ((SetView)allErrors).union(typeValidator.validate(executionContext, node2, rootNode, instanceLocation));
                        continue;
                    }
                    errors = !walk ? schema.validate(executionContext, node2, rootNode, instanceLocation) : schema.walk(executionContext, node2, rootNode, instanceLocation, true);
                    if (errors.isEmpty()) {
                        ++numberOfValidSubSchemas;
                    }
                    if (errors.isEmpty() && !this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && this.canShortCircuit() && this.canShortCircuit(executionContext)) {
                        allErrors = null;
                        Set<Object> set3 = errors;
                        return set3;
                    }
                    if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && ((currentDiscriminatorContext = executionContext.getCurrentDiscriminatorContext()).isDiscriminatorMatchFound() || currentDiscriminatorContext.isDiscriminatorIgnore())) {
                        if (!errors.isEmpty()) {
                            if (allErrors == null) {
                                allErrors = new SetView<ValidationMessage>();
                            }
                            ((SetView)allErrors).union(Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).failFast(executionContext.isFailFast())).arguments(DISCRIMINATOR_REMARK)).build()));
                        } else {
                            allErrors = null;
                        }
                        Set<Object> set4 = errors;
                        return set4;
                    }
                    if (allErrors == null) {
                        allErrors = new SetView<ValidationMessage>();
                    }
                    ((SetView)allErrors).union(errors);
                }
            }
            finally {
                executionContext.setFailFast(failFast);
            }
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled() && executionContext.getCurrentDiscriminatorContext().isActive() && !executionContext.getCurrentDiscriminatorContext().isDiscriminatorIgnore()) {
                Set<ValidationMessage> set5 = Collections.singleton(((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)((MessageSourceValidationMessage.Builder)this.message().instanceNode(node2)).instanceLocation(instanceLocation)).locale(executionContext.getExecutionConfig().getLocale())).arguments("based on the provided discriminator. No alternative could be chosen based on the discriminator property")).build());
                return set5;
            }
        }
        finally {
            if (this.validationContext.getConfig().isDiscriminatorKeywordEnabled()) {
                executionContext.leaveDiscriminatorContextImmediately(instanceLocation);
            }
        }
        if (numberOfValidSubSchemas >= 1) {
            return Collections.emptySet();
        }
        if (allErrors != null) {
            set2 = allErrors;
            return set2;
        }
        set2 = Collections.emptySet();
        return set2;
    }

    @Override
    public Set<ValidationMessage> walk(ExecutionContext executionContext, JsonNode node2, JsonNode rootNode, JsonNodePath instanceLocation, boolean shouldValidateSchema) {
        if (shouldValidateSchema && node2 != null) {
            return this.validate(executionContext, node2, rootNode, instanceLocation, true);
        }
        for (JsonSchema schema : this.schemas) {
            schema.walk(executionContext, node2, rootNode, instanceLocation, false);
        }
        return Collections.emptySet();
    }

    protected boolean canShortCircuit(ExecutionContext executionContext) {
        return !executionContext.getExecutionConfig().isAnnotationCollectionEnabled();
    }

    protected boolean canShortCircuit() {
        if (this.canShortCircuit == null) {
            boolean canShortCircuit = true;
            for (JsonValidator validator : this.getEvaluationParentSchema().getValidators()) {
                if (!"unevaluatedProperties".equals(validator.getKeyword()) && !"unevaluatedItems".equals(validator.getKeyword())) continue;
                canShortCircuit = false;
            }
            this.canShortCircuit = canShortCircuit;
        }
        return this.canShortCircuit;
    }

    @Override
    public void preloadJsonSchema() {
        this.preloadJsonSchemas(this.schemas);
        this.canShortCircuit();
    }
}

