/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.converter.jackson.deserializer.cbor;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import com.fasterxml.jackson.databind.exc.InvalidFormatException;
import com.webauthn4j.data.attestation.statement.TPMGenerated;
import com.webauthn4j.data.attestation.statement.TPMIAlgHash;
import com.webauthn4j.data.attestation.statement.TPMISTAttest;
import com.webauthn4j.data.attestation.statement.TPMSAttest;
import com.webauthn4j.data.attestation.statement.TPMSCertifyInfo;
import com.webauthn4j.data.attestation.statement.TPMSClockInfo;
import com.webauthn4j.data.attestation.statement.TPMTHA;
import com.webauthn4j.data.attestation.statement.TPMTPublic;
import com.webauthn4j.data.attestation.statement.TPMUAttest;
import com.webauthn4j.util.UnsignedNumberUtil;
import com.webauthn4j.util.exception.NotImplementedException;
import java.io.IOException;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import org.jetbrains.annotations.NotNull;

public class TPMSAttestDeserializer
extends StdDeserializer<TPMSAttest> {
    public TPMSAttestDeserializer() {
        super(TPMSAttest.class);
    }

    @Override
    @NotNull
    public TPMSAttest deserialize(@NotNull JsonParser p2, @NotNull DeserializationContext ctxt) throws IOException {
        byte[] value = p2.getBinaryValue();
        ByteBuffer buffer = ByteBuffer.wrap(value);
        byte[] magicBytes = new byte[4];
        buffer.get(magicBytes);
        TPMGenerated magic = TPMGenerated.create(magicBytes);
        byte[] typeBytes = new byte[2];
        buffer.get(typeBytes);
        TPMISTAttest type2 = TPMISTAttest.create(typeBytes);
        int qualifiedSignerSize = UnsignedNumberUtil.getUnsignedShort(buffer);
        byte[] qualifiedSigner = new byte[qualifiedSignerSize];
        buffer.get(qualifiedSigner);
        int extraDataSize = UnsignedNumberUtil.getUnsignedShort(buffer);
        byte[] extraData = new byte[extraDataSize];
        buffer.get(extraData);
        TPMSClockInfo clock = this.extractClockInfo(buffer);
        BigInteger firmwareVersion = UnsignedNumberUtil.getUnsignedLong(buffer);
        TPMUAttest attested = this.extractTPMUAttest(type2, buffer);
        if (buffer.remaining() > 0) {
            throw new InvalidFormatException(p2, "input byte array contains surplus data", (Object)value, TPMTPublic.class);
        }
        return new TPMSAttest(magic, type2, qualifiedSigner, extraData, clock, firmwareVersion, attested);
    }

    @NotNull
    private TPMSClockInfo extractClockInfo(@NotNull ByteBuffer buffer) {
        BigInteger clock = UnsignedNumberUtil.getUnsignedLong(buffer);
        long resetCount = UnsignedNumberUtil.getUnsignedInt(buffer);
        long restartCount = UnsignedNumberUtil.getUnsignedInt(buffer);
        boolean safe = buffer.get() != 0;
        return new TPMSClockInfo(clock, resetCount, restartCount, safe);
    }

    @NotNull
    private TPMUAttest extractTPMUAttest(@NotNull TPMISTAttest type2, @NotNull ByteBuffer buffer) {
        if (type2 != TPMISTAttest.TPM_ST_ATTEST_CERTIFY) {
            throw new NotImplementedException();
        }
        int nameSize = UnsignedNumberUtil.getUnsignedShort(buffer);
        TPMTHA name = this.extractTPMTHA(buffer, nameSize - 2);
        int qualifiedNameSize = UnsignedNumberUtil.getUnsignedShort(buffer);
        TPMTHA qualifiedName = this.extractTPMTHA(buffer, qualifiedNameSize - 2);
        return new TPMSCertifyInfo(name, qualifiedName);
    }

    @NotNull
    private TPMTHA extractTPMTHA(@NotNull ByteBuffer buffer, int digestLength) {
        TPMIAlgHash hashAlg = TPMIAlgHash.create(UnsignedNumberUtil.getUnsignedShort(buffer));
        byte[] digest = new byte[digestLength];
        buffer.get(digest);
        return new TPMTHA(hashAlg, digest);
    }
}

