/*
 * Decompiled with CFR 0.152.
 */
package kotlinx.datetime;

import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.time.DateTimeException;
import java.time.format.DateTimeParseException;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.PublishedApi;
import kotlin.ReplaceWith;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.datetime.ConvertersKt;
import kotlinx.datetime.DateTimeFormatException;
import kotlinx.datetime.DayOfWeek;
import kotlinx.datetime.LocalDate;
import kotlinx.datetime.LocalDateTimeKt;
import kotlinx.datetime.LocalTime;
import kotlinx.datetime.Month;
import kotlinx.datetime.MonthKt;
import kotlinx.datetime.Ser;
import kotlinx.datetime.format.DateTimeFormat;
import kotlinx.datetime.format.DateTimeFormatBuilder;
import kotlinx.datetime.format.LocalDateTimeFormat;
import kotlinx.datetime.format.LocalDateTimeFormatKt;
import kotlinx.datetime.internal.UtilKt;
import kotlinx.datetime.serializers.LocalDateTimeSerializer;
import kotlinx.serialization.KSerializer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@kotlinx.serialization.Serializable(with=LocalDateTimeSerializer.class)
@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0007\u0018\u0000 C2\b\u0012\u0004\u0012\u00020\u00000\u00012\u00020\u0002:\u0002CDB\u0011\b\u0000\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006BE\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u000fBE\b\u0016\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0010\u0012\u0006\u0010\n\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u0011B\u0019\b\u0016\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u00a2\u0006\u0004\b\u0005\u0010\u0016BE\b\u0017\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\u0017\u0012\u0006\u0010\u0018\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\b\u0012\u0006\u0010\f\u001a\u00020\b\u0012\b\b\u0002\u0010\r\u001a\u00020\b\u0012\b\b\u0002\u0010\u000e\u001a\u00020\b\u00a2\u0006\u0004\b\u0005\u0010\u0019J\b\u0010\"\u001a\u00020\u0017H\u0001J\b\u0010)\u001a\u00020+H\u0001J\u0013\u00106\u001a\u0002072\b\u00108\u001a\u0004\u0018\u000109H\u0096\u0002J\b\u0010:\u001a\u00020\bH\u0016J\b\u0010;\u001a\u00020<H\u0016J\u0011\u0010=\u001a\u00020\b2\u0006\u00108\u001a\u00020\u0000H\u0096\u0002J\u0010\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020AH\u0002J\b\u0010B\u001a\u000209H\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u001a\u0010\u001e\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b\u001f\u0010 \u001a\u0004\b!\u0010\u001dR\u0011\u0010\t\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u001a\u0010\u0018\u001a\u00020\b8FX\u0087\u0004\u00a2\u0006\f\u0012\u0004\b$\u0010 \u001a\u0004\b%\u0010\u001dR\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\u001dR\u0011\u0010'\u001a\u00020(8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0011\u0010,\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b-\u0010\u001dR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001dR\u0011\u0010\f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001dR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b0\u0010\u001dR\u0011\u0010\u000e\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b1\u0010\u001dR\u0011\u0010\u0012\u001a\u00020\u00138F\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0011\u0010\u0014\u001a\u00020\u00158F\u00a2\u0006\u0006\u001a\u0004\b4\u00105\u00a8\u0006E"}, d2={"Lkotlinx/datetime/LocalDateTime;", "", "Ljava/io/Serializable;", "value", "Ljava/time/LocalDateTime;", "<init>", "(Ljava/time/LocalDateTime;)V", "year", "", "month", "day", "hour", "minute", "second", "nanosecond", "(IIIIIII)V", "Lkotlinx/datetime/Month;", "(ILkotlinx/datetime/Month;IIIII)V", "date", "Lkotlinx/datetime/LocalDate;", "time", "Lkotlinx/datetime/LocalTime;", "(Lkotlinx/datetime/LocalDate;Lkotlinx/datetime/LocalTime;)V", "Ljava/time/Month;", "dayOfMonth", "(ILjava/time/Month;IIIII)V", "getValue$kotlinx_datetime", "()Ljava/time/LocalDateTime;", "getYear", "()I", "monthNumber", "getMonthNumber$annotations", "()V", "getMonthNumber", "getMonth", "()Lkotlinx/datetime/Month;", "getDayOfMonth$annotations", "getDayOfMonth", "getDay", "dayOfWeek", "Lkotlinx/datetime/DayOfWeek;", "getDayOfWeek", "()Lkotlinx/datetime/DayOfWeek;", "Ljava/time/DayOfWeek;", "dayOfYear", "getDayOfYear", "getHour", "getMinute", "getSecond", "getNanosecond", "getDate", "()Lkotlinx/datetime/LocalDate;", "getTime", "()Lkotlinx/datetime/LocalTime;", "equals", "", "other", "", "hashCode", "toString", "", "compareTo", "readObject", "", "ois", "Ljava/io/ObjectInputStream;", "writeReplace", "Companion", "Formats", "kotlinx-datetime"})
public final class LocalDateTime
implements Comparable<LocalDateTime>,
Serializable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final java.time.LocalDateTime value;
    @NotNull
    private static final LocalDateTime MIN;
    @NotNull
    private static final LocalDateTime MAX;
    private static final long serialVersionUID = 0L;

    public LocalDateTime(@NotNull java.time.LocalDateTime value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        this.value = value;
    }

    @NotNull
    public final java.time.LocalDateTime getValue$kotlinx_datetime() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    public LocalDateTime(int year2, int month2, int day2, int hour2, int minute2, int second2, int nanosecond) {
        java.time.LocalDateTime localDateTime;
        LocalDateTime localDateTime2;
        LocalDateTime localDateTime3 = this;
        try {
            localDateTime2 = localDateTime3;
            localDateTime = java.time.LocalDateTime.of(year2, month2, day2, hour2, minute2, second2, nanosecond);
        }
        catch (DateTimeException dateTimeException) {
            void e;
            LocalDateTime localDateTime4 = localDateTime3;
            throw new IllegalArgumentException((Throwable)e);
        }
        java.time.LocalDateTime localDateTime5 = localDateTime;
        Intrinsics.checkNotNull((Object)localDateTime5);
        localDateTime2(localDateTime5);
    }

    public /* synthetic */ LocalDateTime(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n8 & 0x20) != 0) {
            n6 = 0;
        }
        if ((n8 & 0x40) != 0) {
            n7 = 0;
        }
        this(n, n2, n3, n4, n5, n6, n7);
    }

    public LocalDateTime(int year2, @NotNull Month month2, int day2, int hour2, int minute2, int second2, int nanosecond) {
        Intrinsics.checkNotNullParameter((Object)((Object)month2), (String)"month");
        this(year2, MonthKt.getNumber(month2), day2, hour2, minute2, second2, nanosecond);
    }

    public /* synthetic */ LocalDateTime(int n, Month month2, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x20) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x40) != 0) {
            n6 = 0;
        }
        this(n, month2, n2, n3, n4, n5, n6);
    }

    public LocalDateTime(@NotNull LocalDate date, @NotNull LocalTime time) {
        Intrinsics.checkNotNullParameter((Object)date, (String)"date");
        Intrinsics.checkNotNullParameter((Object)time, (String)"time");
        java.time.LocalDateTime localDateTime = java.time.LocalDateTime.of(date.getValue$kotlinx_datetime(), time.getValue$kotlinx_datetime());
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"of(...)");
        this(localDateTime);
    }

    @Deprecated(message="Use kotlinx.datetime.Month", replaceWith=@ReplaceWith(expression="LocalDateTime(year, month.toKotlinMonth(), dayOfMonth, hour, minute, second, nanosecond)", imports={}))
    public LocalDateTime(int year2, @NotNull java.time.Month month2, int dayOfMonth2, int hour2, int minute2, int second2, int nanosecond) {
        Intrinsics.checkNotNullParameter((Object)month2, (String)"month");
        this(year2, ConvertersKt.toKotlinMonth(month2), dayOfMonth2, hour2, minute2, second2, nanosecond);
    }

    public /* synthetic */ LocalDateTime(int n, java.time.Month month2, int n2, int n3, int n4, int n5, int n6, int n7, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n7 & 0x20) != 0) {
            n5 = 0;
        }
        if ((n7 & 0x40) != 0) {
            n6 = 0;
        }
        this(n, month2, n2, n3, n4, n5, n6);
    }

    public final int getYear() {
        return this.value.getYear();
    }

    public final int getMonthNumber() {
        return this.value.getMonthValue();
    }

    @Deprecated(message="Use the 'month' property instead", replaceWith=@ReplaceWith(expression="this.month.number", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getMonthNumber$annotations() {
    }

    @NotNull
    public final Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return ConvertersKt.toKotlinMonth(month2);
    }

    @PublishedApi
    @NotNull
    public final java.time.Month getMonth() {
        java.time.Month month2 = this.value.getMonth();
        Intrinsics.checkNotNullExpressionValue((Object)month2, (String)"getMonth(...)");
        return month2;
    }

    public final int getDayOfMonth() {
        return this.value.getDayOfMonth();
    }

    @Deprecated(message="Use the 'day' property instead", replaceWith=@ReplaceWith(expression="this.day", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getDayOfMonth$annotations() {
    }

    public final int getDay() {
        return this.value.getDayOfMonth();
    }

    @NotNull
    public final DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return ConvertersKt.toKotlinDayOfWeek(dayOfWeek);
    }

    @PublishedApi
    @NotNull
    public final java.time.DayOfWeek getDayOfWeek() {
        java.time.DayOfWeek dayOfWeek = this.value.getDayOfWeek();
        Intrinsics.checkNotNullExpressionValue((Object)dayOfWeek, (String)"getDayOfWeek(...)");
        return dayOfWeek;
    }

    public final int getDayOfYear() {
        return this.value.getDayOfYear();
    }

    public final int getHour() {
        return this.value.getHour();
    }

    public final int getMinute() {
        return this.value.getMinute();
    }

    public final int getSecond() {
        return this.value.getSecond();
    }

    public final int getNanosecond() {
        return this.value.getNano();
    }

    @NotNull
    public final LocalDate getDate() {
        java.time.LocalDate localDate = this.value.toLocalDate();
        Intrinsics.checkNotNullExpressionValue((Object)localDate, (String)"toLocalDate(...)");
        return new LocalDate(localDate);
    }

    @NotNull
    public final LocalTime getTime() {
        java.time.LocalTime localTime = this.value.toLocalTime();
        Intrinsics.checkNotNullExpressionValue((Object)localTime, (String)"toLocalTime(...)");
        return new LocalTime(localTime);
    }

    public boolean equals(@Nullable Object other) {
        return this == other || other instanceof LocalDateTime && Intrinsics.areEqual((Object)this.value, (Object)((LocalDateTime)other).value);
    }

    public int hashCode() {
        return this.value.hashCode();
    }

    @NotNull
    public String toString() {
        String string = this.value.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @Override
    public int compareTo(@NotNull LocalDateTime other) {
        Intrinsics.checkNotNullParameter((Object)other, (String)"other");
        return this.value.compareTo(other.value);
    }

    private final void readObject(ObjectInputStream ois) {
        throw new InvalidObjectException("kotlinx.datetime.LocalDateTime must be deserialized via kotlinx.datetime.Ser");
    }

    private final Object writeReplace() {
        return new Ser(4, this);
    }

    static {
        java.time.LocalDateTime localDateTime = java.time.LocalDateTime.MIN;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime, (String)"MIN");
        MIN = new LocalDateTime(localDateTime);
        java.time.LocalDateTime localDateTime2 = java.time.LocalDateTime.MAX;
        Intrinsics.checkNotNullExpressionValue((Object)localDateTime2, (String)"MAX");
        MAX = new LocalDateTime(localDateTime2);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00050\tJ\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u000bH\u0007J%\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\u00050\t2\u0017\u0010\u0012\u001a\u0013\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00150\u0013\u00a2\u0006\u0002\b\u0016J\f\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u00050\u001aR\u0014\u0010\f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000eR\u000e\u0010\u0017\u001a\u00020\u0018X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lkotlinx/datetime/LocalDateTime$Companion;", "", "<init>", "()V", "parse", "Lkotlinx/datetime/LocalDateTime;", "input", "", "format", "Lkotlinx/datetime/format/DateTimeFormat;", "isoString", "", "MIN", "getMIN$kotlinx_datetime", "()Lkotlinx/datetime/LocalDateTime;", "MAX", "getMAX$kotlinx_datetime", "Format", "builder", "Lkotlin/Function1;", "Lkotlinx/datetime/format/DateTimeFormatBuilder$WithDateTime;", "", "Lkotlin/ExtensionFunctionType;", "serialVersionUID", "", "serializer", "Lkotlinx/serialization/KSerializer;", "kotlinx-datetime"})
    @SourceDebugExtension(value={"SMAP\nLocalDateTimeJvm.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LocalDateTimeJvm.kt\nkotlinx/datetime/LocalDateTime$Companion\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,148:1\n1#2:149\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LocalDateTime parse(@NotNull CharSequence input, @NotNull DateTimeFormat<LocalDateTime> format) {
            LocalDateTime localDateTime;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            Intrinsics.checkNotNullParameter(format, (String)"format");
            if (format == Formats.INSTANCE.getISO()) {
                LocalDateTime localDateTime2;
                try {
                    String sanitizedInput = UtilKt.removeLeadingZerosFromLongYearFormLocalDateTime(((Object)input).toString());
                    java.time.LocalDateTime p0 = java.time.LocalDateTime.parse(sanitizedInput);
                    boolean bl = false;
                    localDateTime2 = new LocalDateTime(p0);
                }
                catch (DateTimeParseException e) {
                    throw new DateTimeFormatException(e);
                }
                localDateTime = localDateTime2;
            } else {
                localDateTime = format.parse(input);
            }
            return localDateTime;
        }

        public static /* synthetic */ LocalDateTime parse$default(Companion companion, CharSequence charSequence, DateTimeFormat dateTimeFormat, int n, Object object) {
            if ((n & 2) != 0) {
                dateTimeFormat = LocalDateTimeKt.getIsoDateTimeFormat();
            }
            return companion.parse(charSequence, dateTimeFormat);
        }

        @Deprecated(message="This overload is only kept for binary compatibility", level=DeprecationLevel.HIDDEN)
        public final /* synthetic */ LocalDateTime parse(String isoString) {
            Intrinsics.checkNotNullParameter((Object)isoString, (String)"isoString");
            return kotlinx.datetime.LocalDateTime$Companion.parse$default(this, isoString, null, 2, null);
        }

        @NotNull
        public final LocalDateTime getMIN$kotlinx_datetime() {
            return MIN;
        }

        @NotNull
        public final LocalDateTime getMAX$kotlinx_datetime() {
            return MAX;
        }

        @NotNull
        public final DateTimeFormat<LocalDateTime> Format(@NotNull Function1<? super DateTimeFormatBuilder.WithDateTime, Unit> builder) {
            Intrinsics.checkNotNullParameter(builder, (String)"builder");
            return LocalDateTimeFormat.Companion.build(builder);
        }

        @NotNull
        public final KSerializer<LocalDateTime> serializer() {
            return LocalDateTimeSerializer.INSTANCE;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lkotlinx/datetime/LocalDateTime$Formats;", "", "<init>", "()V", "ISO", "Lkotlinx/datetime/format/DateTimeFormat;", "Lkotlinx/datetime/LocalDateTime;", "getISO", "()Lkotlinx/datetime/format/DateTimeFormat;", "kotlinx-datetime"})
    public static final class Formats {
        @NotNull
        public static final Formats INSTANCE = new Formats();
        @NotNull
        private static final DateTimeFormat<LocalDateTime> ISO = LocalDateTimeFormatKt.getISO_DATETIME();

        private Formats() {
        }

        @NotNull
        public final DateTimeFormat<LocalDateTime> getISO() {
            return ISO;
        }
    }
}

