/*
 * Decompiled with CFR 0.152.
 */
package world.respect.shared.domain.account.setpassword;

import androidx.compose.runtime.internal.StabilityInferred;
import io.ktor.util.Base64Kt;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.time.Clock;
import kotlin.time.Instant;
import org.jetbrains.annotations.NotNull;
import world.respect.datalayer.school.model.PersonPassword;
import world.respect.shared.domain.account.setpassword.EncryptPersonPasswordUseCase;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u0000 \b2\u00020\u0001:\u0001\bB\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0011\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0096\u0002\u00a8\u0006\t"}, d2={"Lworld/respect/shared/domain/account/setpassword/EncryptPersonPasswordUseCaseImpl;", "Lworld/respect/shared/domain/account/setpassword/EncryptPersonPasswordUseCase;", "<init>", "()V", "invoke", "Lworld/respect/datalayer/school/model/PersonPassword;", "request", "Lworld/respect/shared/domain/account/setpassword/EncryptPersonPasswordUseCase$Request;", "Companion", "respect-lib-shared_debug"})
@StabilityInferred(parameters=1)
public final class EncryptPersonPasswordUseCaseImpl
implements EncryptPersonPasswordUseCase {
    @NotNull
    public static final Companion Companion = new Companion(null);
    public static final int $stable;
    public static final int DEFAULT_SALT_LEN = 16;
    public static final int DEFAULT_ITERATIONS = 10000;
    public static final int DEFAULT_KEY_LEN = 512;
    @NotNull
    public static final String KEY_ALGO = "PBKDF2WithHmacSHA1";

    @Override
    @NotNull
    public PersonPassword invoke(@NotNull EncryptPersonPasswordUseCase.Request request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        char[] cArray = request.getPassword().toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        String string2 = request.getSalt();
        byte[] byArray = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
        PBEKeySpec keySpec = new PBEKeySpec(cArray, byArray, 10000, 512);
        SecretKeyFactory keyFactory = SecretKeyFactory.getInstance(KEY_ALGO);
        Instant now = Clock.System.INSTANCE.now();
        String string3 = request.getPersonGuid();
        byte[] byArray2 = keyFactory.generateSecret(keySpec).getEncoded();
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"getEncoded(...)");
        String string4 = Base64Kt.encodeBase64((byte[])byArray2);
        String string5 = request.getSalt();
        return new PersonPassword(string3, now, now, KEY_ALGO, string4, string5, 10000, 512);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lworld/respect/shared/domain/account/setpassword/EncryptPersonPasswordUseCaseImpl$Companion;", "", "<init>", "()V", "DEFAULT_SALT_LEN", "", "DEFAULT_ITERATIONS", "DEFAULT_KEY_LEN", "KEY_ALGO", "", "respect-lib-shared_debug"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

