/*
 * Decompiled with CFR 0.152.
 */
package com.webauthn4j.data.extension;

import com.webauthn4j.util.ArrayUtil;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class HMACGetSecretOutput {
    private final byte[] output1;
    private final byte[] output2;

    public HMACGetSecretOutput(@NotNull byte[] output1, @Nullable byte[] output2) {
        this.output1 = ArrayUtil.clone(output1);
        this.output2 = ArrayUtil.clone(output2);
    }

    public HMACGetSecretOutput(@NotNull byte[] output1) {
        this.output1 = ArrayUtil.clone(output1);
        this.output2 = null;
    }

    @NotNull
    public byte[] getOutput1() {
        return ArrayUtil.clone(this.output1);
    }

    @Nullable
    public byte[] getOutput2() {
        return ArrayUtil.clone(this.output2);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HMACGetSecretOutput that = (HMACGetSecretOutput)o;
        return Arrays.equals(this.output1, that.output1) && Arrays.equals(this.output2, that.output2);
    }

    public int hashCode() {
        int result2 = Arrays.hashCode(this.output1);
        result2 = 31 * result2 + Arrays.hashCode(this.output2);
        return result2;
    }
}

