/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3;

import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractBigIntegerParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.AbstractNumberParser;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastDoubleSwar;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.FastIntegerMath;
import com.fasterxml.jackson.core.internal.shaded.fdp.v2_18_3.ParseDigitsTaskCharSequence;
import java.math.BigInteger;
import java.util.NavigableMap;

class JavaBigIntegerFromCharSequence
extends AbstractBigIntegerParser {
    JavaBigIntegerFromCharSequence() {
    }

    public BigInteger parseBigIntegerString(CharSequence str2, int offset, int length, int radix) throws NumberFormatException {
        try {
            boolean isNegative2;
            int size2 = str2.length();
            int endIndex = AbstractNumberParser.checkBounds(size2, offset, length);
            int index2 = offset;
            char ch = str2.charAt(index2);
            boolean bl = isNegative2 = ch == '-';
            if ((isNegative2 || ch == '+') && (ch = JavaBigIntegerFromCharSequence.charAt(str2, ++index2, endIndex)) == '\u0000') {
                throw new NumberFormatException("illegal syntax");
            }
            switch (radix) {
                case 10: {
                    return this.parseDecDigits(str2, index2, endIndex, isNegative2);
                }
                case 16: {
                    return this.parseHexDigits(str2, index2, endIndex, isNegative2);
                }
            }
            return new BigInteger(str2.subSequence(offset, length).toString(), radix);
        }
        catch (ArithmeticException e) {
            NumberFormatException nfe = new NumberFormatException("value exceeds limits");
            nfe.initCause(e);
            throw nfe;
        }
    }

    private BigInteger parseDecDigits(CharSequence str2, int from, int to, boolean isNegative2) {
        int numDigits = to - from;
        if (JavaBigIntegerFromCharSequence.hasManyDigits(numDigits)) {
            return this.parseManyDecDigits(str2, from, to, isNegative2);
        }
        int preroll = from + (numDigits & 7);
        long significand = FastDoubleSwar.tryToParseUpTo7Digits(str2, from, preroll);
        boolean success = significand >= 0L;
        for (from = preroll; from < to; from += 8) {
            int addend = FastDoubleSwar.tryToParseEightDigits(str2, from);
            success &= addend >= 0;
            significand = significand * 100000000L + (long)addend;
        }
        if (!success) {
            throw new NumberFormatException("illegal syntax");
        }
        return BigInteger.valueOf(isNegative2 ? -significand : significand);
    }

    private BigInteger parseHexDigits(CharSequence str2, int from, int to, boolean isNegative2) {
        int numDigits = to - (from = this.skipZeroes(str2, from, to));
        if (numDigits <= 0) {
            return BigInteger.ZERO;
        }
        JavaBigIntegerFromCharSequence.checkHexBigIntegerBounds(numDigits);
        byte[] bytes = new byte[(numDigits + 1 >> 1) + 1];
        int index2 = 1;
        boolean illegalDigits = false;
        if ((numDigits & 1) != 0) {
            char chLow = str2.charAt(from++);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes[index2++] = (byte)valueLow;
            illegalDigits = valueLow < 0;
        }
        int prerollLimit = from + (to - from & 7);
        while (from < prerollLimit) {
            char chHigh = str2.charAt(from);
            char chLow = str2.charAt(from + 1);
            int valueHigh = JavaBigIntegerFromCharSequence.lookupHex(chHigh);
            int valueLow = JavaBigIntegerFromCharSequence.lookupHex(chLow);
            bytes[index2++] = (byte)(valueHigh << 4 | valueLow);
            illegalDigits |= valueLow < 0 || valueHigh < 0;
            from += 2;
        }
        while (from < to) {
            long value = FastDoubleSwar.tryToParseEightHexDigits(str2, from);
            FastDoubleSwar.writeIntBE(bytes, index2, (int)value);
            illegalDigits |= value < 0L;
            from += 8;
            index2 += 4;
        }
        if (illegalDigits) {
            throw new NumberFormatException("illegal syntax");
        }
        BigInteger result2 = new BigInteger(bytes);
        return isNegative2 ? result2.negate() : result2;
    }

    private BigInteger parseManyDecDigits(CharSequence str2, int from, int to, boolean isNegative2) {
        from = this.skipZeroes(str2, from, to);
        int numDigits = to - from;
        JavaBigIntegerFromCharSequence.checkDecBigIntegerBounds(numDigits);
        NavigableMap<Integer, BigInteger> powersOfTen = FastIntegerMath.fillPowersOf10Floor16(from, to);
        BigInteger result2 = ParseDigitsTaskCharSequence.parseDigitsRecursive(str2, from, to, powersOfTen, 400);
        return isNegative2 ? result2.negate() : result2;
    }

    private int skipZeroes(CharSequence str2, int from, int to) {
        while (from < to && str2.charAt(from) == '0') {
            ++from;
        }
        return from;
    }
}

