/*
 * Decompiled with CFR 0.152.
 */
package com.networknt.schema.utils;

import com.fasterxml.jackson.databind.JsonNode;
import com.networknt.schema.JsonSchema;
import com.networknt.schema.JsonType;
import com.networknt.schema.PathType;
import com.networknt.schema.SchemaValidatorsConfig;
import com.networknt.schema.SpecVersion;
import com.networknt.schema.TypeFactory;
import com.networknt.schema.ValidationContext;
import com.networknt.schema.utils.StringChecker;
import java.util.ArrayList;
import java.util.Collection;

public class JsonNodeUtil {
    private static final long V6_VALUE = SpecVersion.VersionFlag.V6.getVersionFlagValue();
    private static final String TYPE = "type";
    private static final String ENUM = "enum";
    private static final String REF = "$ref";
    private static final String NULLABLE = "nullable";

    public static Collection<String> allPaths(PathType pathType, String root, JsonNode node2) {
        ArrayList<String> collector2 = new ArrayList<String>();
        JsonNodeUtil.visitNode(pathType, root, node2, collector2);
        return collector2;
    }

    private static void visitNode(PathType pathType, String root, JsonNode node2, Collection<String> collector2) {
        if (node2.isObject()) {
            JsonNodeUtil.visitObject(pathType, root, node2, collector2);
        } else if (node2.isArray()) {
            JsonNodeUtil.visitArray(pathType, root, node2, collector2);
        }
    }

    private static void visitArray(PathType pathType, String root, JsonNode node2, Collection<String> collector2) {
        int size2 = node2.size();
        for (int i2 = 0; i2 < size2; ++i2) {
            String path = pathType.append(root, i2);
            collector2.add(path);
            JsonNodeUtil.visitNode(pathType, path, node2.get(i2), collector2);
        }
    }

    private static void visitObject(PathType pathType, String root, JsonNode node2, Collection<String> collector2) {
        node2.fields().forEachRemaining(entry -> {
            String path = pathType.append(root, (String)entry.getKey());
            collector2.add(path);
            JsonNodeUtil.visitNode(pathType, path, (JsonNode)entry.getValue(), collector2);
        });
    }

    public static boolean isNodeNullable(JsonNode schema) {
        JsonNode nullable = schema.get(NULLABLE);
        return nullable != null && nullable.asBoolean();
    }

    public static boolean isNodeNullable(JsonNode schema, SchemaValidatorsConfig config2) {
        if (config2.isNullableKeywordEnabled()) {
            return JsonNodeUtil.isNodeNullable(schema);
        }
        return false;
    }

    public static boolean equalsToSchemaType(JsonNode node2, JsonType schemaType, JsonSchema parentSchema, ValidationContext validationContext) {
        SchemaValidatorsConfig config2 = validationContext.getConfig();
        JsonType nodeType = TypeFactory.getValueNodeType(node2, config2);
        if (nodeType != schemaType) {
            JsonSchema grandParentSchema;
            if (schemaType == JsonType.ANY) {
                return true;
            }
            if (schemaType == JsonType.NUMBER && nodeType == JsonType.INTEGER) {
                return true;
            }
            if (schemaType == JsonType.INTEGER && nodeType == JsonType.NUMBER && node2.canConvertToExactIntegral() && V6_VALUE <= JsonNodeUtil.detectVersion(validationContext)) {
                return true;
            }
            if (nodeType == JsonType.NULL && parentSchema != null && config2.isNullableKeywordEnabled() && ((grandParentSchema = parentSchema.getParentSchema()) != null && JsonNodeUtil.isNodeNullable(grandParentSchema.getSchemaNode()) || JsonNodeUtil.isNodeNullable(parentSchema.getSchemaNode()))) {
                return true;
            }
            if (JsonNodeUtil.isEnumObjectSchema(parentSchema)) {
                return true;
            }
            if (config2 != null && config2.isTypeLoose()) {
                if (schemaType == JsonType.ARRAY) {
                    return true;
                }
                if (nodeType == JsonType.STRING) {
                    if (schemaType == JsonType.INTEGER) {
                        return StringChecker.isInteger(node2.textValue());
                    }
                    if (schemaType == JsonType.BOOLEAN) {
                        return StringChecker.isBoolean(node2.textValue());
                    }
                    if (schemaType == JsonType.NUMBER) {
                        return StringChecker.isNumeric(node2.textValue());
                    }
                }
            }
            return false;
        }
        return true;
    }

    private static long detectVersion(ValidationContext validationContext) {
        return validationContext.activeDialect().orElse(SpecVersion.VersionFlag.V4).getVersionFlagValue();
    }

    public static boolean isNumber(JsonNode node2, SchemaValidatorsConfig config2) {
        if (node2.isNumber()) {
            return true;
        }
        if (config2.isTypeLoose() && TypeFactory.getValueNodeType(node2, config2) == JsonType.STRING) {
            return StringChecker.isNumeric(node2.textValue());
        }
        return false;
    }

    private static boolean isEnumObjectSchema(JsonSchema jsonSchema) {
        JsonNode typeNode = null;
        JsonNode enumNode = null;
        boolean refNode = false;
        if (jsonSchema != null) {
            if (jsonSchema.getSchemaNode() != null) {
                typeNode = jsonSchema.getSchemaNode().get(TYPE);
                enumNode = jsonSchema.getSchemaNode().get(ENUM);
            }
            refNode = REF.equals(jsonSchema.getEvaluationPath().getElement(-1));
        }
        if (typeNode != null && enumNode != null && refNode) {
            return TypeFactory.getSchemaNodeType(typeNode) == JsonType.OBJECT && enumNode.isArray();
        }
        return false;
    }
}

