package world.respect.datalayer.db

import androidx.room.InvalidationTracker
import androidx.room.RoomOpenDelegate
import androidx.room.migration.AutoMigrationSpec
import androidx.room.migration.Migration
import androidx.room.util.TableInfo
import androidx.room.util.TableInfo.Companion.read
import androidx.room.util.dropFtsSyncTriggers
import androidx.sqlite.SQLiteConnection
import androidx.sqlite.execSQL
import javax.`annotation`.processing.Generated
import kotlin.Lazy
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.collections.MutableList
import kotlin.collections.MutableMap
import kotlin.collections.MutableSet
import kotlin.collections.Set
import kotlin.collections.mutableListOf
import kotlin.collections.mutableMapOf
import kotlin.collections.mutableSetOf
import kotlin.reflect.KClass
import world.respect.datalayer.db.opds.daos.PersonPasskeyEntityDao
import world.respect.datalayer.db.opds.daos.PersonPasskeyEntityDao_Impl
import world.respect.datalayer.db.school.daos.AuthTokenEntityDao
import world.respect.datalayer.db.school.daos.AuthTokenEntityDao_Impl
import world.respect.datalayer.db.school.daos.ClassEntityDao
import world.respect.datalayer.db.school.daos.ClassEntityDao_Impl
import world.respect.datalayer.db.school.daos.EnrollmentEntityDao
import world.respect.datalayer.db.school.daos.EnrollmentEntityDao_Impl
import world.respect.datalayer.db.school.daos.IndicatorEntityDao
import world.respect.datalayer.db.school.daos.IndicatorEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonEntityDao
import world.respect.datalayer.db.school.daos.PersonEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonPasswordEntityDao
import world.respect.datalayer.db.school.daos.PersonPasswordEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonRelatedPersonEntityDao
import world.respect.datalayer.db.school.daos.PersonRelatedPersonEntityDao_Impl
import world.respect.datalayer.db.school.daos.PersonRoleEntityDao
import world.respect.datalayer.db.school.daos.PersonRoleEntityDao_Impl
import world.respect.datalayer.db.school.daos.ReportEntityDao
import world.respect.datalayer.db.school.daos.ReportEntityDao_Impl
import world.respect.datalayer.db.school.daos.WriteQueueItemEntityDao
import world.respect.datalayer.db.school.daos.WriteQueueItemEntityDao_Impl

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RespectSchoolDatabase_Impl : RespectSchoolDatabase() {
  private val _personEntityDao: Lazy<PersonEntityDao> = lazy {
    PersonEntityDao_Impl(this)
  }

  private val _personPasswordEntityDao: Lazy<PersonPasswordEntityDao> = lazy {
    PersonPasswordEntityDao_Impl(this)
  }

  private val _personPasskeyEntityDao: Lazy<PersonPasskeyEntityDao> = lazy {
    PersonPasskeyEntityDao_Impl(this)
  }

  private val _authTokenEntityDao: Lazy<AuthTokenEntityDao> = lazy {
    AuthTokenEntityDao_Impl(this)
  }

  private val _personRoleEntityDao: Lazy<PersonRoleEntityDao> = lazy {
    PersonRoleEntityDao_Impl(this)
  }

  private val _personRelatedPersonEntityDao: Lazy<PersonRelatedPersonEntityDao> = lazy {
    PersonRelatedPersonEntityDao_Impl(this)
  }

  private val _reportEntityDao: Lazy<ReportEntityDao> = lazy {
    ReportEntityDao_Impl(this)
  }

  private val _indicatorEntityDao: Lazy<IndicatorEntityDao> = lazy {
    IndicatorEntityDao_Impl(this)
  }

  private val _classEntityDao: Lazy<ClassEntityDao> = lazy {
    ClassEntityDao_Impl(this)
  }

  private val _enrollmentEntityDao: Lazy<EnrollmentEntityDao> = lazy {
    EnrollmentEntityDao_Impl(this)
  }

  private val _writeQueueItemEntityDao: Lazy<WriteQueueItemEntityDao> = lazy {
    WriteQueueItemEntityDao_Impl(this)
  }

  protected override fun createOpenDelegate(): RoomOpenDelegate {
    val _openDelegate: RoomOpenDelegate = object : RoomOpenDelegate(7, "6688352037d3b2db69c1360823385f8a", "bf72ebe4bcd67cc2f438e93c1f7a8d78") {
      public override fun createAllTables(connection: SQLiteConnection) {
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonEntity` (`pGuid` TEXT NOT NULL, `pGuidHash` INTEGER NOT NULL, `pActive` INTEGER NOT NULL, `pStatus` INTEGER NOT NULL, `pLastModified` INTEGER NOT NULL, `pStored` INTEGER NOT NULL, `pMetadata` TEXT, `pUsername` TEXT, `pGivenName` TEXT NOT NULL, `pFamilyName` TEXT NOT NULL, `pMiddleName` TEXT, `pGender` INTEGER NOT NULL, `pDateOfBirth` INTEGER, PRIMARY KEY(`pGuidHash`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonRoleEntity` (`prUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `prPersonGuidHash` INTEGER NOT NULL, `prIsPrimaryRole` INTEGER NOT NULL, `prRoleEnum` INTEGER NOT NULL, `prBeginDate` INTEGER, `prEndDate` INTEGER)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonRelatedPersonEntity` (`prpUid` INTEGER NOT NULL, `prpPersonUidNum` INTEGER NOT NULL, `prpOtherPersonUid` TEXT NOT NULL, `prpOtherPersonUidNum` INTEGER NOT NULL, PRIMARY KEY(`prpUid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonPasswordEntity` (`pppGuid` INTEGER NOT NULL, `authAlgorithm` TEXT NOT NULL, `authEncoded` TEXT NOT NULL, `authSalt` TEXT NOT NULL, `authIterations` INTEGER NOT NULL, `authKeyLen` INTEGER NOT NULL, PRIMARY KEY(`pppGuid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `PersonPasskeyEntity` (`ppPersonUidNum` INTEGER NOT NULL, `ppCredentialId` TEXT NOT NULL, `ppLastModified` INTEGER NOT NULL, `ppStored` INTEGER NOT NULL, `ppAttestationObj` TEXT, `ppClientDataJson` TEXT, `ppOriginString` TEXT, `ppChallengeString` TEXT, `ppPublicKey` TEXT, `isRevoked` INTEGER NOT NULL, `ppDeviceName` TEXT NOT NULL DEFAULT '', `ppTimeCreated` INTEGER NOT NULL DEFAULT 0, `ppAaguid` TEXT NOT NULL DEFAULT '', `ppProviderName` TEXT NOT NULL DEFAULT '', `ppIconLight` TEXT NOT NULL DEFAULT '', `ppIconDark` TEXT NOT NULL DEFAULT '', PRIMARY KEY(`ppPersonUidNum`, `ppCredentialId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `AuthTokenEntity` (`atUid` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `atPGuidHash` INTEGER NOT NULL, `atPGuid` TEXT NOT NULL, `atCode` TEXT, `atToken` TEXT NOT NULL, `atTimeCreated` INTEGER NOT NULL, `atTtl` INTEGER NOT NULL, `atPlatform` TEXT, `atAndroidSdkInt` INTEGER, `atVersion` TEXT, `atManufacturer` TEXT, `atModel` TEXT, `atRam` INTEGER)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ReportEntity` (`rGuid` TEXT NOT NULL, `rOwnerGuid` TEXT NOT NULL, `rTitle` TEXT NOT NULL, `rOptions` TEXT NOT NULL, `rIsTemplate` INTEGER NOT NULL, `rActive` INTEGER NOT NULL, `rLastModified` INTEGER NOT NULL, `rStored` INTEGER NOT NULL, PRIMARY KEY(`rGuid`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `IndicatorEntity` (`indicatorId` TEXT NOT NULL, `name` TEXT NOT NULL, `description` TEXT NOT NULL, `type` TEXT NOT NULL, `sql` TEXT NOT NULL, PRIMARY KEY(`indicatorId`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `ClassEntity` (`cGuid` TEXT NOT NULL, `cGuidHash` INTEGER NOT NULL, `cTitle` TEXT NOT NULL, `cStatus` INTEGER NOT NULL, `cDescription` TEXT, `cLastModified` INTEGER NOT NULL, `cStored` INTEGER NOT NULL, `cTeacherInviteCode` TEXT, `cStudentInviteCode` TEXT, PRIMARY KEY(`cGuidHash`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `EnrollmentEntity` (`eUid` TEXT NOT NULL, `eUidNum` INTEGER NOT NULL, `eStatus` INTEGER NOT NULL, `eLastModified` INTEGER NOT NULL, `eStored` INTEGER NOT NULL, `eMetadata` TEXT, `eClassUidNum` INTEGER NOT NULL, `ePersonUidNum` INTEGER NOT NULL, `eRole` INTEGER NOT NULL, `eBeginDate` INTEGER, `eEndDate` INTEGER, `eInviteCode` TEXT, `eApprovedByPersonUidNum` INTEGER NOT NULL, `eApprovedByPersonUid` TEXT, PRIMARY KEY(`eUidNum`))")
        connection.execSQL("CREATE TABLE IF NOT EXISTS `WriteQueueItemEntity` (`wqiQueueItemId` INTEGER PRIMARY KEY AUTOINCREMENT NOT NULL, `wqiModel` INTEGER NOT NULL, `wqiUid` TEXT NOT NULL, `wqiTimeQueued` INTEGER NOT NULL, `wqiAttemptCount` INTEGER NOT NULL, `wqiTimeWritten` INTEGER NOT NULL, `wqiAccountGuid` TEXT NOT NULL)")
        connection.execSQL("CREATE TABLE IF NOT EXISTS room_master_table (id INTEGER PRIMARY KEY,identity_hash TEXT)")
        connection.execSQL("INSERT OR REPLACE INTO room_master_table (id,identity_hash) VALUES(42, '6688352037d3b2db69c1360823385f8a')")
      }

      public override fun dropAllTables(connection: SQLiteConnection) {
        connection.execSQL("DROP TABLE IF EXISTS `PersonEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonRoleEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonRelatedPersonEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonPasswordEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `PersonPasskeyEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `AuthTokenEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ReportEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `IndicatorEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `ClassEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `EnrollmentEntity`")
        connection.execSQL("DROP TABLE IF EXISTS `WriteQueueItemEntity`")
      }

      public override fun onCreate(connection: SQLiteConnection) {
      }

      public override fun onOpen(connection: SQLiteConnection) {
        internalInitInvalidationTracker(connection)
      }

      public override fun onPreMigrate(connection: SQLiteConnection) {
        dropFtsSyncTriggers(connection)
      }

      public override fun onPostMigrate(connection: SQLiteConnection) {
      }

      public override fun onValidateSchema(connection: SQLiteConnection): RoomOpenDelegate.ValidationResult {
        val _columnsPersonEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonEntity.put("pGuid", TableInfo.Column("pGuid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pGuidHash", TableInfo.Column("pGuidHash", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pActive", TableInfo.Column("pActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pStatus", TableInfo.Column("pStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pLastModified", TableInfo.Column("pLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pStored", TableInfo.Column("pStored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pMetadata", TableInfo.Column("pMetadata", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pUsername", TableInfo.Column("pUsername", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pGivenName", TableInfo.Column("pGivenName", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pFamilyName", TableInfo.Column("pFamilyName", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pMiddleName", TableInfo.Column("pMiddleName", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pGender", TableInfo.Column("pGender", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonEntity.put("pDateOfBirth", TableInfo.Column("pDateOfBirth", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonEntity: TableInfo = TableInfo("PersonEntity", _columnsPersonEntity, _foreignKeysPersonEntity, _indicesPersonEntity)
        val _existingPersonEntity: TableInfo = read(connection, "PersonEntity")
        if (!_infoPersonEntity.equals(_existingPersonEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonEntity(world.respect.datalayer.db.school.entities.PersonEntity).
              | Expected:
              |""".trimMargin() + _infoPersonEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonEntity)
        }
        val _columnsPersonRoleEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonRoleEntity.put("prUid", TableInfo.Column("prUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prPersonGuidHash", TableInfo.Column("prPersonGuidHash", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prIsPrimaryRole", TableInfo.Column("prIsPrimaryRole", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prRoleEnum", TableInfo.Column("prRoleEnum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prBeginDate", TableInfo.Column("prBeginDate", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRoleEntity.put("prEndDate", TableInfo.Column("prEndDate", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonRoleEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonRoleEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonRoleEntity: TableInfo = TableInfo("PersonRoleEntity", _columnsPersonRoleEntity, _foreignKeysPersonRoleEntity, _indicesPersonRoleEntity)
        val _existingPersonRoleEntity: TableInfo = read(connection, "PersonRoleEntity")
        if (!_infoPersonRoleEntity.equals(_existingPersonRoleEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonRoleEntity(world.respect.datalayer.db.school.entities.PersonRoleEntity).
              | Expected:
              |""".trimMargin() + _infoPersonRoleEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonRoleEntity)
        }
        val _columnsPersonRelatedPersonEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonRelatedPersonEntity.put("prpUid", TableInfo.Column("prpUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRelatedPersonEntity.put("prpPersonUidNum", TableInfo.Column("prpPersonUidNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRelatedPersonEntity.put("prpOtherPersonUid", TableInfo.Column("prpOtherPersonUid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonRelatedPersonEntity.put("prpOtherPersonUidNum", TableInfo.Column("prpOtherPersonUidNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonRelatedPersonEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonRelatedPersonEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonRelatedPersonEntity: TableInfo = TableInfo("PersonRelatedPersonEntity", _columnsPersonRelatedPersonEntity, _foreignKeysPersonRelatedPersonEntity, _indicesPersonRelatedPersonEntity)
        val _existingPersonRelatedPersonEntity: TableInfo = read(connection, "PersonRelatedPersonEntity")
        if (!_infoPersonRelatedPersonEntity.equals(_existingPersonRelatedPersonEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonRelatedPersonEntity(world.respect.datalayer.db.school.entities.PersonRelatedPersonEntity).
              | Expected:
              |""".trimMargin() + _infoPersonRelatedPersonEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonRelatedPersonEntity)
        }
        val _columnsPersonPasswordEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonPasswordEntity.put("pppGuid", TableInfo.Column("pppGuid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authAlgorithm", TableInfo.Column("authAlgorithm", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authEncoded", TableInfo.Column("authEncoded", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authSalt", TableInfo.Column("authSalt", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authIterations", TableInfo.Column("authIterations", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasswordEntity.put("authKeyLen", TableInfo.Column("authKeyLen", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonPasswordEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonPasswordEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonPasswordEntity: TableInfo = TableInfo("PersonPasswordEntity", _columnsPersonPasswordEntity, _foreignKeysPersonPasswordEntity, _indicesPersonPasswordEntity)
        val _existingPersonPasswordEntity: TableInfo = read(connection, "PersonPasswordEntity")
        if (!_infoPersonPasswordEntity.equals(_existingPersonPasswordEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonPasswordEntity(world.respect.datalayer.db.school.entities.PersonPasswordEntity).
              | Expected:
              |""".trimMargin() + _infoPersonPasswordEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonPasswordEntity)
        }
        val _columnsPersonPasskeyEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsPersonPasskeyEntity.put("ppPersonUidNum", TableInfo.Column("ppPersonUidNum", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppCredentialId", TableInfo.Column("ppCredentialId", "TEXT", true, 2, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppLastModified", TableInfo.Column("ppLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppStored", TableInfo.Column("ppStored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppAttestationObj", TableInfo.Column("ppAttestationObj", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppClientDataJson", TableInfo.Column("ppClientDataJson", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppOriginString", TableInfo.Column("ppOriginString", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppChallengeString", TableInfo.Column("ppChallengeString", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppPublicKey", TableInfo.Column("ppPublicKey", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("isRevoked", TableInfo.Column("isRevoked", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppDeviceName", TableInfo.Column("ppDeviceName", "TEXT", true, 0, "''", TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppTimeCreated", TableInfo.Column("ppTimeCreated", "INTEGER", true, 0, "0", TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppAaguid", TableInfo.Column("ppAaguid", "TEXT", true, 0, "''", TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppProviderName", TableInfo.Column("ppProviderName", "TEXT", true, 0, "''", TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppIconLight", TableInfo.Column("ppIconLight", "TEXT", true, 0, "''", TableInfo.CREATED_FROM_ENTITY))
        _columnsPersonPasskeyEntity.put("ppIconDark", TableInfo.Column("ppIconDark", "TEXT", true, 0, "''", TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysPersonPasskeyEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesPersonPasskeyEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoPersonPasskeyEntity: TableInfo = TableInfo("PersonPasskeyEntity", _columnsPersonPasskeyEntity, _foreignKeysPersonPasskeyEntity, _indicesPersonPasskeyEntity)
        val _existingPersonPasskeyEntity: TableInfo = read(connection, "PersonPasskeyEntity")
        if (!_infoPersonPasskeyEntity.equals(_existingPersonPasskeyEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |PersonPasskeyEntity(world.respect.datalayer.db.school.entities.PersonPasskeyEntity).
              | Expected:
              |""".trimMargin() + _infoPersonPasskeyEntity + """
              |
              | Found:
              |""".trimMargin() + _existingPersonPasskeyEntity)
        }
        val _columnsAuthTokenEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsAuthTokenEntity.put("atUid", TableInfo.Column("atUid", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atPGuidHash", TableInfo.Column("atPGuidHash", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atPGuid", TableInfo.Column("atPGuid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atCode", TableInfo.Column("atCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atToken", TableInfo.Column("atToken", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atTimeCreated", TableInfo.Column("atTimeCreated", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atTtl", TableInfo.Column("atTtl", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atPlatform", TableInfo.Column("atPlatform", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atAndroidSdkInt", TableInfo.Column("atAndroidSdkInt", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atVersion", TableInfo.Column("atVersion", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atManufacturer", TableInfo.Column("atManufacturer", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atModel", TableInfo.Column("atModel", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsAuthTokenEntity.put("atRam", TableInfo.Column("atRam", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysAuthTokenEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesAuthTokenEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoAuthTokenEntity: TableInfo = TableInfo("AuthTokenEntity", _columnsAuthTokenEntity, _foreignKeysAuthTokenEntity, _indicesAuthTokenEntity)
        val _existingAuthTokenEntity: TableInfo = read(connection, "AuthTokenEntity")
        if (!_infoAuthTokenEntity.equals(_existingAuthTokenEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |AuthTokenEntity(world.respect.datalayer.db.school.entities.AuthTokenEntity).
              | Expected:
              |""".trimMargin() + _infoAuthTokenEntity + """
              |
              | Found:
              |""".trimMargin() + _existingAuthTokenEntity)
        }
        val _columnsReportEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsReportEntity.put("rGuid", TableInfo.Column("rGuid", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rOwnerGuid", TableInfo.Column("rOwnerGuid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rTitle", TableInfo.Column("rTitle", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rOptions", TableInfo.Column("rOptions", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rIsTemplate", TableInfo.Column("rIsTemplate", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rActive", TableInfo.Column("rActive", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rLastModified", TableInfo.Column("rLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsReportEntity.put("rStored", TableInfo.Column("rStored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysReportEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesReportEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoReportEntity: TableInfo = TableInfo("ReportEntity", _columnsReportEntity, _foreignKeysReportEntity, _indicesReportEntity)
        val _existingReportEntity: TableInfo = read(connection, "ReportEntity")
        if (!_infoReportEntity.equals(_existingReportEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ReportEntity(world.respect.datalayer.db.school.entities.ReportEntity).
              | Expected:
              |""".trimMargin() + _infoReportEntity + """
              |
              | Found:
              |""".trimMargin() + _existingReportEntity)
        }
        val _columnsIndicatorEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsIndicatorEntity.put("indicatorId", TableInfo.Column("indicatorId", "TEXT", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("name", TableInfo.Column("name", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("description", TableInfo.Column("description", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("type", TableInfo.Column("type", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsIndicatorEntity.put("sql", TableInfo.Column("sql", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysIndicatorEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesIndicatorEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoIndicatorEntity: TableInfo = TableInfo("IndicatorEntity", _columnsIndicatorEntity, _foreignKeysIndicatorEntity, _indicesIndicatorEntity)
        val _existingIndicatorEntity: TableInfo = read(connection, "IndicatorEntity")
        if (!_infoIndicatorEntity.equals(_existingIndicatorEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |IndicatorEntity(world.respect.datalayer.db.realm.entities.IndicatorEntity).
              | Expected:
              |""".trimMargin() + _infoIndicatorEntity + """
              |
              | Found:
              |""".trimMargin() + _existingIndicatorEntity)
        }
        val _columnsClassEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsClassEntity.put("cGuid", TableInfo.Column("cGuid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cGuidHash", TableInfo.Column("cGuidHash", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cTitle", TableInfo.Column("cTitle", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStatus", TableInfo.Column("cStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cDescription", TableInfo.Column("cDescription", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cLastModified", TableInfo.Column("cLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStored", TableInfo.Column("cStored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cTeacherInviteCode", TableInfo.Column("cTeacherInviteCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsClassEntity.put("cStudentInviteCode", TableInfo.Column("cStudentInviteCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysClassEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesClassEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoClassEntity: TableInfo = TableInfo("ClassEntity", _columnsClassEntity, _foreignKeysClassEntity, _indicesClassEntity)
        val _existingClassEntity: TableInfo = read(connection, "ClassEntity")
        if (!_infoClassEntity.equals(_existingClassEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |ClassEntity(world.respect.datalayer.db.school.entities.ClassEntity).
              | Expected:
              |""".trimMargin() + _infoClassEntity + """
              |
              | Found:
              |""".trimMargin() + _existingClassEntity)
        }
        val _columnsEnrollmentEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsEnrollmentEntity.put("eUid", TableInfo.Column("eUid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eUidNum", TableInfo.Column("eUidNum", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eStatus", TableInfo.Column("eStatus", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eLastModified", TableInfo.Column("eLastModified", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eStored", TableInfo.Column("eStored", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eMetadata", TableInfo.Column("eMetadata", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eClassUidNum", TableInfo.Column("eClassUidNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("ePersonUidNum", TableInfo.Column("ePersonUidNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eRole", TableInfo.Column("eRole", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eBeginDate", TableInfo.Column("eBeginDate", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eEndDate", TableInfo.Column("eEndDate", "INTEGER", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eInviteCode", TableInfo.Column("eInviteCode", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eApprovedByPersonUidNum", TableInfo.Column("eApprovedByPersonUidNum", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsEnrollmentEntity.put("eApprovedByPersonUid", TableInfo.Column("eApprovedByPersonUid", "TEXT", false, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysEnrollmentEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesEnrollmentEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoEnrollmentEntity: TableInfo = TableInfo("EnrollmentEntity", _columnsEnrollmentEntity, _foreignKeysEnrollmentEntity, _indicesEnrollmentEntity)
        val _existingEnrollmentEntity: TableInfo = read(connection, "EnrollmentEntity")
        if (!_infoEnrollmentEntity.equals(_existingEnrollmentEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |EnrollmentEntity(world.respect.datalayer.db.school.entities.EnrollmentEntity).
              | Expected:
              |""".trimMargin() + _infoEnrollmentEntity + """
              |
              | Found:
              |""".trimMargin() + _existingEnrollmentEntity)
        }
        val _columnsWriteQueueItemEntity: MutableMap<String, TableInfo.Column> = mutableMapOf()
        _columnsWriteQueueItemEntity.put("wqiQueueItemId", TableInfo.Column("wqiQueueItemId", "INTEGER", true, 1, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiModel", TableInfo.Column("wqiModel", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiUid", TableInfo.Column("wqiUid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiTimeQueued", TableInfo.Column("wqiTimeQueued", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiAttemptCount", TableInfo.Column("wqiAttemptCount", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiTimeWritten", TableInfo.Column("wqiTimeWritten", "INTEGER", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        _columnsWriteQueueItemEntity.put("wqiAccountGuid", TableInfo.Column("wqiAccountGuid", "TEXT", true, 0, null, TableInfo.CREATED_FROM_ENTITY))
        val _foreignKeysWriteQueueItemEntity: MutableSet<TableInfo.ForeignKey> = mutableSetOf()
        val _indicesWriteQueueItemEntity: MutableSet<TableInfo.Index> = mutableSetOf()
        val _infoWriteQueueItemEntity: TableInfo = TableInfo("WriteQueueItemEntity", _columnsWriteQueueItemEntity, _foreignKeysWriteQueueItemEntity, _indicesWriteQueueItemEntity)
        val _existingWriteQueueItemEntity: TableInfo = read(connection, "WriteQueueItemEntity")
        if (!_infoWriteQueueItemEntity.equals(_existingWriteQueueItemEntity)) {
          return RoomOpenDelegate.ValidationResult(false, """
              |WriteQueueItemEntity(world.respect.datalayer.db.school.entities.WriteQueueItemEntity).
              | Expected:
              |""".trimMargin() + _infoWriteQueueItemEntity + """
              |
              | Found:
              |""".trimMargin() + _existingWriteQueueItemEntity)
        }
        return RoomOpenDelegate.ValidationResult(true, null)
      }
    }
    return _openDelegate
  }

  protected override fun createInvalidationTracker(): InvalidationTracker {
    val _shadowTablesMap: MutableMap<String, String> = mutableMapOf()
    val _viewTables: MutableMap<String, Set<String>> = mutableMapOf()
    return InvalidationTracker(this, _shadowTablesMap, _viewTables, "PersonEntity", "PersonRoleEntity", "PersonRelatedPersonEntity", "PersonPasswordEntity", "PersonPasskeyEntity", "AuthTokenEntity", "ReportEntity", "IndicatorEntity", "ClassEntity", "EnrollmentEntity", "WriteQueueItemEntity")
  }

  protected override fun getRequiredTypeConverterClasses(): Map<KClass<*>, List<KClass<*>>> {
    val _typeConvertersMap: MutableMap<KClass<*>, List<KClass<*>>> = mutableMapOf()
    _typeConvertersMap.put(PersonEntityDao::class, PersonEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonPasswordEntityDao::class, PersonPasswordEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonPasskeyEntityDao::class, PersonPasskeyEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(AuthTokenEntityDao::class, AuthTokenEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonRoleEntityDao::class, PersonRoleEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(PersonRelatedPersonEntityDao::class, PersonRelatedPersonEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ReportEntityDao::class, ReportEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(IndicatorEntityDao::class, IndicatorEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(ClassEntityDao::class, ClassEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(EnrollmentEntityDao::class, EnrollmentEntityDao_Impl.getRequiredConverters())
    _typeConvertersMap.put(WriteQueueItemEntityDao::class, WriteQueueItemEntityDao_Impl.getRequiredConverters())
    return _typeConvertersMap
  }

  public override fun getRequiredAutoMigrationSpecClasses(): Set<KClass<out AutoMigrationSpec>> {
    val _autoMigrationSpecsSet: MutableSet<KClass<out AutoMigrationSpec>> = mutableSetOf()
    return _autoMigrationSpecsSet
  }

  public override fun createAutoMigrations(autoMigrationSpecs: Map<KClass<out AutoMigrationSpec>, AutoMigrationSpec>): List<Migration> {
    val _autoMigrations: MutableList<Migration> = mutableListOf()
    return _autoMigrations
  }

  public override fun getPersonEntityDao(): PersonEntityDao = _personEntityDao.value

  public override fun getPersonPasswordEntityDao(): PersonPasswordEntityDao = _personPasswordEntityDao.value

  public override fun getPersonPasskeyEntityDao(): PersonPasskeyEntityDao = _personPasskeyEntityDao.value

  public override fun getAuthTokenEntityDao(): AuthTokenEntityDao = _authTokenEntityDao.value

  public override fun getPersonRoleEntityDao(): PersonRoleEntityDao = _personRoleEntityDao.value

  public override fun getPersonRelatedPersonEntityDao(): PersonRelatedPersonEntityDao = _personRelatedPersonEntityDao.value

  public override fun getReportEntityDao(): ReportEntityDao = _reportEntityDao.value

  public override fun getIndicatorEntityDao(): IndicatorEntityDao = _indicatorEntityDao.value

  public override fun getClassEntityDao(): ClassEntityDao = _classEntityDao.value

  public override fun getEnrollmentEntityDao(): EnrollmentEntityDao = _enrollmentEntityDao.value

  public override fun getWriteQueueItemEntityDao(): WriteQueueItemEntityDao = _writeQueueItemEntityDao.value
}
