package com.ustadmobile.libcache.db.dao

import androidx.room.EntityDeleteOrUpdateAdapter
import androidx.room.EntityInsertAdapter
import androidx.room.RoomDatabase
import androidx.room.util.getColumnIndexOrThrow
import androidx.room.util.performSuspending
import androidx.sqlite.SQLiteStatement
import com.ustadmobile.libcache.db.entities.RetentionLock
import javax.`annotation`.processing.Generated
import kotlin.Int
import kotlin.Long
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.MutableList
import kotlin.collections.mutableListOf
import kotlin.reflect.KClass

@Generated(value = ["androidx.room.RoomProcessor"])
@Suppress(names = ["UNCHECKED_CAST", "DEPRECATION", "REDUNDANT_PROJECTION", "REMOVAL"])
public class RetentionLockDao_Impl(
  __db: RoomDatabase,
) : RetentionLockDao() {
  private val __db: RoomDatabase

  private val __insertAdapterOfRetentionLock: EntityInsertAdapter<RetentionLock>

  private val __insertAdapterOfRetentionLock_1: EntityInsertAdapter<RetentionLock>

  private val __deleteAdapterOfRetentionLock: EntityDeleteOrUpdateAdapter<RetentionLock>
  init {
    this.__db = __db
    this.__insertAdapterOfRetentionLock = object : EntityInsertAdapter<RetentionLock>() {
      protected override fun createQuery(): String = "INSERT OR ABORT INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RetentionLock) {
        statement.bindLong(1, entity.lockId)
        statement.bindText(2, entity.lockKey)
        statement.bindText(3, entity.lockRemark)
      }
    }
    this.__insertAdapterOfRetentionLock_1 = object : EntityInsertAdapter<RetentionLock>() {
      protected override fun createQuery(): String = "INSERT OR REPLACE INTO `RetentionLock` (`lockId`,`lockKey`,`lockRemark`) VALUES (nullif(?, 0),?,?)"

      protected override fun bind(statement: SQLiteStatement, entity: RetentionLock) {
        statement.bindLong(1, entity.lockId)
        statement.bindText(2, entity.lockKey)
        statement.bindText(3, entity.lockRemark)
      }
    }
    this.__deleteAdapterOfRetentionLock = object : EntityDeleteOrUpdateAdapter<RetentionLock>() {
      protected override fun createQuery(): String = "DELETE FROM `RetentionLock` WHERE `lockId` = ?"

      protected override fun bind(statement: SQLiteStatement, entity: RetentionLock) {
        statement.bindLong(1, entity.lockId)
      }
    }
  }

  public override suspend fun insert(retentionLock: RetentionLock): Long = performSuspending(__db, false, true) { _connection ->
    val _result: Long = __insertAdapterOfRetentionLock.insertAndReturnId(_connection, retentionLock)
    _result
  }

  public override suspend fun upsertList(retentionLocks: List<RetentionLock>): Unit = performSuspending(__db, false, true) { _connection ->
    __insertAdapterOfRetentionLock_1.insert(_connection, retentionLocks)
  }

  public override suspend fun delete(retentionLocks: List<RetentionLock>): Unit = performSuspending(__db, false, true) { _connection ->
    __deleteAdapterOfRetentionLock.handleMultiple(_connection, retentionLocks)
  }

  public override suspend fun findByBatchId(batchId: Int): List<RetentionLock> {
    val _sql: String = """
        |
        |        SELECT RetentionLock.*
        |          FROM RetentionLock
        |         WHERE RetentionLock.lockKey IN 
        |               (SELECT RequestedEntry.requestedKey
        |                  FROM RequestedEntry
        |                 WHERE RequestedEntry.batchId = ?)
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindLong(_argIndex, batchId.toLong())
        val _columnIndexOfLockId: Int = getColumnIndexOrThrow(_stmt, "lockId")
        val _columnIndexOfLockKey: Int = getColumnIndexOrThrow(_stmt, "lockKey")
        val _columnIndexOfLockRemark: Int = getColumnIndexOrThrow(_stmt, "lockRemark")
        val _result: MutableList<RetentionLock> = mutableListOf()
        while (_stmt.step()) {
          val _item: RetentionLock
          val _tmpLockId: Long
          _tmpLockId = _stmt.getLong(_columnIndexOfLockId)
          val _tmpLockKey: String
          _tmpLockKey = _stmt.getText(_columnIndexOfLockKey)
          val _tmpLockRemark: String
          _tmpLockRemark = _stmt.getText(_columnIndexOfLockRemark)
          _item = RetentionLock(_tmpLockId,_tmpLockKey,_tmpLockRemark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public override suspend fun findByKey(urlKey: String): List<RetentionLock> {
    val _sql: String = """
        |
        |        SELECT RetentionLock.*
        |          FROM RetentionLock
        |         WHERE RetentionLock.lockKey = ? 
        |    
        """.trimMargin()
    return performSuspending(__db, true, false) { _connection ->
      val _stmt: SQLiteStatement = _connection.prepare(_sql)
      try {
        var _argIndex: Int = 1
        _stmt.bindText(_argIndex, urlKey)
        val _columnIndexOfLockId: Int = getColumnIndexOrThrow(_stmt, "lockId")
        val _columnIndexOfLockKey: Int = getColumnIndexOrThrow(_stmt, "lockKey")
        val _columnIndexOfLockRemark: Int = getColumnIndexOrThrow(_stmt, "lockRemark")
        val _result: MutableList<RetentionLock> = mutableListOf()
        while (_stmt.step()) {
          val _item: RetentionLock
          val _tmpLockId: Long
          _tmpLockId = _stmt.getLong(_columnIndexOfLockId)
          val _tmpLockKey: String
          _tmpLockKey = _stmt.getText(_columnIndexOfLockKey)
          val _tmpLockRemark: String
          _tmpLockRemark = _stmt.getText(_columnIndexOfLockRemark)
          _item = RetentionLock(_tmpLockId,_tmpLockKey,_tmpLockRemark)
          _result.add(_item)
        }
        _result
      } finally {
        _stmt.close()
      }
    }
  }

  public companion object {
    public fun getRequiredConverters(): List<KClass<*>> = emptyList()
  }
}
